/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.Account;
import com.nuomi.data.AccountAll;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.ListBox;
import com.nuomi.usercontrol.MoreTopButton;
import com.nuomi.usercontrol.account.AccountListBoxItem;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class BalancePage
extends BasePage {
    private static BalancePage _BalancePage = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private ListBox accountsListBox = null;
    private MoreTopButton moreTopButton = null;
    private boolean userChanged = true;
    private boolean showByHideMessageBox = false;
    private DataDownload refreshDataDownload = null;
    private DataDownload moreDataDownload = null;

    public static void Show(BasePage parentPage) {
        if (_BalancePage == null) {
            _BalancePage = new BalancePage();
        }
        _BalancePage.setParent(parentPage);
        if (BasePage.clientInfo.getAccounts() == null) {
            BalancePage._BalancePage.accountsListBox.removeAll();
            _BalancePage.removeListMoreTopButton();
        }
        _BalancePage.show();
    }

    private BalancePage() {
        this.setTitle("\u4ea4\u6613\u8bb0\u5f55");
        this.sendListenerWhenHidden = true;
        this.mainContainer.setLayout(new BoxLayout(2));
        int scrollWidth = UserInterface.DISPLAY_WIDTH;
        int scrollHeight = UserInterface.DISPLAY_HEIGHT;
        this.scrollContainer = new Container(new CoordinateLayout(scrollWidth, scrollHeight));
        Label logoLabel = UserInterface.createNuomiLogoLabel();
        this.scrollContainer.addComponent(logoLabel);
        logoLabel.setX((scrollWidth - logoLabel.getPreferredW()) / 2);
        logoLabel.setY((scrollHeight - logoLabel.getPreferredH()) / 2);
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setPreferredW(scrollWidth);
        this.scrollContainer.setPreferredH(scrollHeight);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.setX(0);
        this.innerContainer.setY(0);
        this.accountsListBox = new ListBox();
        this.innerContainer.addComponent(this.accountsListBox);
        if (BasePage.clientInfo.getAccounts() != null) {
            this.showAccounts(BasePage.clientInfo.getAccounts());
        }
    }

    protected void onShowCompleted() {
        if (!this.showByHideMessageBox) {
            if (this.userChanged) {
                this.onRefresh();
            }
            this.userChanged = false;
        }
        this.showByHideMessageBox = false;
        super.onShowCompleted();
    }

    protected void onRefreshClicked() {
        this.onRefresh();
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        this.userChanged = true;
        this.accountsListBox.removeAll();
        this.removeListMoreTopButton();
    }

    private void onRefresh() {
        if (this.refreshDataDownload == null) {
            this.refreshDataDownload = new DataDownload();
            this.refreshDataDownload.addDownloadListener(new DataDownloadListener(){

                public void onDownloadStart(Object tag) {
                    BalancePage.this.startRefresh();
                    if (BalancePage.this.moreTopButton != null) {
                        BalancePage.this.moreTopButton.setIsLoading(true);
                    }
                }

                public void onDownloadCompleted(int result, Object data, int type, Object tag) {
                    String hintText = DataDownload.ResultStrings[result];
                    boolean showHint = true;
                    if (result == 2 && type == 35 && data instanceof AccountAll) {
                        AccountAll accountAll = (AccountAll)data;
                        if (accountAll.resultInfo.isSucceed()) {
                            BasePage.clientInfo.setAccounts(accountAll, true);
                            BalancePage.this.showAccounts(BasePage.clientInfo.getAccounts());
                        } else if (accountAll.resultInfo.isLogExpired() && Display.getInstance().getCurrent() == BalancePage.this.self && BalancePage.this.getCurrentForm() == BalancePage.this.self && !MessageBox.isShow) {
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(BalancePage.this.self, true);
                            } else {
                                BalancePage.this.showByHideMessageBox = true;
                                BalancePage.this.userChanged = true;
                                showHint = false;
                            }
                        }
                    }
                    if (showHint) {
                        BalancePage.this.showHint(hintText);
                    }
                    if (BalancePage.this.moreTopButton != null) {
                        BalancePage.this.moreTopButton.setIsLoading(false);
                    }
                    BalancePage.this.endRefresh();
                }
            });
        }
        if (!this.refreshDataDownload.isDownloading() && BasePage.clientInfo.getUserInfo() != null) {
            this.refreshDataDownload.accountAll(BasePage.clientInfo.getUserInfo().userId, BasePage.clientInfo.getUserInfo().ticket, 0, 20);
        }
    }

    private void showAccounts(Vector accounts) {
        if (accounts == null) {
            return;
        }
        this.removeListMoreTopButton();
        this.accountsListBox.removeAll();
        int length = accounts.size();
        int i = 0;
        while (i < Math.min(10, length)) {
            AccountListBoxItem item = new AccountListBoxItem((Account)accounts.elementAt(i));
            this.accountsListBox.addItem(item);
            ++i;
        }
        if (this.accountsListBox.getCount() <= 0) {
            this.accountsListBox.showHint("\u60a8\u6682\u65f6\u6ca1\u6709\u6d88\u8d39\u8bb0\u5f55");
        }
        this.addListMoreTopButton();
        this.scrollContainer.setScrollY(0);
        this.scrollContainer.setScrollableY(this.scrollContainer.getScrollDimension().getHeight() > this.scrollContainer.getPreferredH());
        this.repaint();
    }

    private void onMore() {
        Vector accounts = BasePage.clientInfo.getAccounts();
        if (accounts != null) {
            int listCount;
            int count = accounts.size();
            if (count > (listCount = this.accountsListBox.getCount())) {
                this.moreAccounts(accounts);
            } else {
                if (this.moreDataDownload == null) {
                    this.moreDataDownload = new DataDownload();
                    this.moreDataDownload.addDownloadListener(new DataDownloadListener(){

                        public void onDownloadStart(Object tag) {
                            BalancePage.this.startRefresh();
                            if (BalancePage.this.moreTopButton != null) {
                                BalancePage.this.moreTopButton.setIsLoading(true);
                            }
                        }

                        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
                            String hintText = DataDownload.ResultStrings[result];
                            boolean showHint = true;
                            if (result == 2 && type == 35 && data instanceof AccountAll) {
                                AccountAll accountAll = (AccountAll)data;
                                if (accountAll.resultInfo.isSucceed()) {
                                    BasePage.clientInfo.addAccounts(accountAll);
                                    BalancePage.this.moreAccounts(BasePage.clientInfo.getAccounts());
                                } else if (accountAll.resultInfo.isLogExpired() && Display.getInstance().getCurrent() == BalancePage.this.self && BalancePage.this.getCurrentForm() == BalancePage.this.self && !MessageBox.isShow) {
                                    if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                        LogPage.Show(BalancePage.this.self, true);
                                    } else {
                                        BalancePage.this.showByHideMessageBox = true;
                                        BalancePage.this.userChanged = true;
                                        showHint = false;
                                    }
                                }
                            }
                            if (showHint) {
                                BalancePage.this.showHint(hintText);
                            }
                            if (BalancePage.this.moreTopButton != null) {
                                BalancePage.this.moreTopButton.setIsLoading(false);
                            }
                            BalancePage.this.endRefresh();
                        }
                    });
                }
                if (!this.moreDataDownload.isDownloading() && BasePage.clientInfo.getUserInfo() != null) {
                    this.moreDataDownload.accountAll(BasePage.clientInfo.getUserInfo().userId, BasePage.clientInfo.getUserInfo().ticket, count, 10);
                }
            }
        }
    }

    private void moreAccounts(Vector accounts) {
        int start;
        if (accounts == null) {
            return;
        }
        this.removeListMoreTopButton();
        int length = accounts.size();
        int i = start = this.accountsListBox.getCount();
        while (i < Math.min(start + 10, length)) {
            AccountListBoxItem item = new AccountListBoxItem((Account)accounts.elementAt(i));
            this.accountsListBox.addItem(item);
            ++i;
        }
        this.addListMoreTopButton();
        this.scrollContainer.setScrollableY(this.scrollContainer.getScrollDimension().getHeight() > this.scrollContainer.getPreferredH());
        this.repaint();
    }

    private void removeListMoreTopButton() {
        this.scrollContainer.setScrollSize(null);
        if (this.moreTopButton != null && this.innerContainer.contains(this.moreTopButton)) {
            this.innerContainer.removeComponent(this.moreTopButton);
        }
    }

    private void addListMoreTopButton() {
        int listCount;
        if (this.moreTopButton == null) {
            this.moreTopButton = new MoreTopButton();
            if (this.refreshDataDownload != null && this.refreshDataDownload.isDownloading()) {
                this.moreTopButton.setIsLoading(true);
            }
            this.moreTopButton.addTopListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    BalancePage.this.scrollContainer.setScrollY(0);
                }
            });
            this.moreTopButton.addMoreListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    BalancePage.this.onMore();
                }
            });
        }
        boolean needAddTop = false;
        boolean needAddMore = false;
        if (this.scrollContainer.getScrollDimension().getHeight() > this.scrollContainer.getPreferredH()) {
            needAddTop = true;
        }
        if ((listCount = this.accountsListBox.getCount()) < BasePage.clientInfo.getAccountCount()) {
            needAddMore = true;
        }
        if (needAddTop || needAddMore) {
            if (!this.innerContainer.contains(this.moreTopButton)) {
                int scrollAbledH = this.scrollContainer.getScrollDimension().getHeight();
                Dimension d = new Dimension(UserInterface.DISPLAY_WIDTH, scrollAbledH + this.moreTopButton.getPreferredH());
                this.innerContainer.addComponent(this.moreTopButton);
                this.scrollContainer.setScrollSize(d);
            }
            this.moreTopButton.showButton(needAddTop, needAddMore);
        }
        this.scrollContainer.setScrollSize(null);
    }
}

