/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.Main;
import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.data.City;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.CityChangedListener;
import com.nuomi.listener.UserInfoChangedListener;
import com.nuomi.usercontrol.Button;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.midlet.MIDlet;

public abstract class BasePage
extends Form {
    protected MIDlet mainMiDlet = null;
    protected static ClientInfo clientInfo = null;
    protected BasePage self = null;
    protected BasePage parentPage = null;
    protected final int One_Page_Count;
    protected final int Refresh_Download_Count;
    protected static BasePage MainPage = null;
    private Container titleContainer = null;
    protected Container mainContainer = null;
    private Button backButton = null;
    private Button refreshButton = null;
    private Button titleButton = null;
    private Image refreshNormalIcon = UserImages.NUOMI_REFRESH_IMAGE;
    private Image refreshPressedIcon = UserImages.NUOMI_REFRESH_PRESSED_IMAGE;
    protected boolean isRefreshing = false;
    private Label hintLabel = null;
    private Timer autoHideHintTimer = null;
    private final int autoHideHintTimerDelay;
    protected boolean sendListenerWhenHidden = false;
    private UserInfoChangedListener userInfoChangedListener = new UserInfoChangedListener(){

        public void onChanged(UserInfo userInfo) {
            BasePage.this.onUserInfoChanged(userInfo);
        }
    };
    private CityChangedListener cityChangedListener = new CityChangedListener(){

        public void onChanged(City newCity) {
            BasePage.this.onCityChanged(newCity);
        }
    };

    protected BasePage() {
        this.One_Page_Count = 10;
        this.Refresh_Download_Count = 20;
        this.autoHideHintTimerDelay = 3000;
        this.mainMiDlet = Main.mainMIDlet;
        clientInfo = Main.clientInfo;
        this.self = this;
        this.self.setScrollableY(false);
        this.self.setLayout(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, UserInterface.DISPLAY_HEIGHT));
        this.titleContainer = this.getTitleArea();
        this.titleContainer.setLayout(new BorderLayout());
        this.titleContainer.setX(0);
        this.titleContainer.setY(0);
        this.titleContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        this.titleContainer.setPreferredH(UserImages.NUOMI_TITLEBAR_BG_IMAGE.getHeight());
        this.titleContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
        this.backButton = UserInterface.createIconOnlyButton(null, null);
        this.titleContainer.addComponent("West", (Component)this.backButton);
        this.backButton.setPreferredW(UserImages.NUOMI_BACK_IMAGE.getWidth());
        this.backButton.setPreferredH(UserImages.NUOMI_BACK_IMAGE.getHeight());
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasePage.this.onBack();
            }
        });
        this.refreshButton = UserInterface.createIconOnlyButton(this.refreshNormalIcon, this.refreshPressedIcon);
        this.titleContainer.addComponent("East", (Component)this.refreshButton);
        this.refreshButton.setPreferredW(this.refreshNormalIcon.getWidth());
        this.refreshButton.setPreferredH(this.refreshNormalIcon.getHeight());
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasePage.this.onRefreshClicked();
            }
        });
        this.titleButton = new Button();
        this.titleButton.setTextPosition(1);
        this.titleButton.setTickerEnabled(false);
        this.titleContainer.addComponent("Center", (Component)this.titleButton);
        Style[] styles = UserInterface.getComponentStyles(this.titleButton);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setFgColor(0xFFFFFF);
            style.setAlignment(4);
            style.setBgTransparency(0);
            style.setBorder(null);
            style.setFont(UserInterface.FONT_STATIC_WORD);
            ++i;
        }
        this.titleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BasePage.this.onTitleClicked();
            }
        });
        this.mainContainer = new Container();
        this.self.addComponent(this.mainContainer);
        this.mainContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        this.mainContainer.setPreferredH(UserInterface.DISPLAY_HEIGHT - this.titleContainer.getPreferredH());
        this.mainContainer.setX(0);
        this.mainContainer.setY(0);
    }

    public void setParent(BasePage page) {
        this.parentPage = page;
        if (page != null) {
            this.setBackButtonBackIcon();
        } else {
            this.setBackButtonExitIcon();
        }
    }

    protected void addUserInfoChangedListener() {
        clientInfo.addUserInfoChangedListener(this.userInfoChangedListener);
    }

    protected void removeUserInfoChangedListener() {
        clientInfo.removeUserInfoChangedListener(this.userInfoChangedListener);
    }

    protected void addCityChangedListener() {
        clientInfo.addCityChangedListener(this.cityChangedListener);
    }

    protected void removeCityChangedListener() {
        clientInfo.removeCityChangedListener(this.cityChangedListener);
    }

    protected void setBackButtonBackIcon() {
        this.backButton.setIcon(UserImages.NUOMI_BACK_IMAGE);
        this.backButton.setPressedIcon(UserImages.NUOMI_BACK_PRESSED_IMAGE);
    }

    protected void setBackButtonExitIcon() {
        this.backButton.setIcon(UserImages.NUOMI_EXIT_IMAGE);
        this.backButton.setPressedIcon(UserImages.NUOMI_EXIT_PRESSED_IMAGE);
    }

    protected void onShow() {
        this.addUserInfoChangedListener();
        this.addCityChangedListener();
        super.onShow();
    }

    protected void onBack() {
        if (!this.sendListenerWhenHidden) {
            this.removeUserInfoChangedListener();
            this.removeCityChangedListener();
        }
        if (this.parentPage != null) {
            this.parentPage.show();
            this.hideHint();
            this.parentPage.repaint();
        } else {
            this.onExit();
        }
    }

    protected void onExit() {
        if (!MessageBox.isShow && MessageBox.Show("\u786e\u5b9a\u9000\u51fa\u7cef\u7c73\u7f51?", "\u786e\u5b9a", "\u53d6\u6d88") == MessageBox.OK) {
            this.mainMiDlet.notifyDestroyed();
        }
    }

    protected void onCityChanged(City newCity) {
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
    }

    public void setTitle(String title, boolean canClick) {
        int maxLength;
        int n = maxLength = canClick ? 6 : 7;
        if (title != null && title.length() > maxLength) {
            title = title.substring(0, maxLength);
        }
        this.titleButton.setText(title == null ? "" : title);
        this.titleButton.setIcon(canClick ? UserImages.NUOMI_DOWN_CLICK_LIGHT_IMAGE : null);
        this.titleButton.setEnabled(canClick);
    }

    public void setTitle(String title) {
        this.self.setTitle(title == null ? "" : title, false);
    }

    public String getTitle() {
        return this.titleButton.getText();
    }

    public void setTitleFont(Font font) {
        Style[] styles = UserInterface.getComponentStyles(this.titleButton);
        int i = 0;
        while (i < styles.length) {
            styles[i].setFont(font);
            ++i;
        }
    }

    protected void onTitleClicked() {
    }

    protected void onRefreshClicked() {
    }

    public void showHint(String hint) {
        if (this.hintLabel == null) {
            this.hintLabel = new Label();
            this.hintLabel.getStyle().setBgColor(7641018);
            this.hintLabel.getStyle().setFgColor(0xFFFFFF);
            this.self.addComponent(this.hintLabel);
            this.hintLabel.setPreferredW(UserInterface.DISPLAY_WIDTH);
            this.hintLabel.setPreferredH(this.hintLabel.getStyle().getFont().getHeight() + 10);
            this.hintLabel.setX(0);
            this.hintLabel.setY(0);
        }
        this.hintLabel.setText(hint);
        this.hintLabel.getStyle().setBgTransparency(200);
        this.repaint(0, this.getTitleArea().getPreferredH(), this.hintLabel.getPreferredW(), this.hintLabel.getPreferredH());
        if (this.autoHideHintTimer != null) {
            this.autoHideHintTimer.cancel();
            this.autoHideHintTimer = null;
        }
        this.autoHideHintTimer = new Timer();
        this.autoHideHintTimer.schedule(new TimerTask(){

            public void run() {
                BasePage.this.hideHint();
            }
        }, 3000L);
    }

    public void hideHint() {
        if (this.hintLabel != null) {
            this.hintLabel.setText("");
            this.hintLabel.getStyle().setBgTransparency(0);
            this.repaint(0, this.getTitleArea().getPreferredH(), this.hintLabel.getPreferredW(), this.hintLabel.getPreferredH());
        }
    }

    protected void clear() {
        this.self.removeAll();
    }

    public boolean isShowing() {
        Form showingForm = Display.getInstance().getCurrent();
        return showingForm == this.self;
    }

    protected void showRefreshIcon() {
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(true);
            this.refreshButton.setVisible(true);
        }
    }

    protected void hideRefreshIcon() {
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(false);
            this.refreshButton.setVisible(false);
        }
    }

    protected void setRefreshIcon(Image normalImage, Image pressedImage) {
        this.refreshNormalIcon = normalImage;
        this.refreshPressedIcon = pressedImage;
        if (this.refreshButton != null) {
            this.refreshButton.setIcon(this.refreshNormalIcon);
            this.refreshButton.setPressedIcon(this.refreshPressedIcon);
        }
    }

    protected void hideBackIcon() {
        if (this.backButton != null) {
            this.backButton.setEnabled(false);
            this.backButton.setVisible(false);
        }
    }

    protected void showBackIcon() {
        if (this.backButton != null) {
            this.backButton.setEnabled(true);
            this.backButton.setVisible(true);
        }
    }

    protected Form getCurrentForm() {
        return Display.getInstance().getCurrent();
    }

    protected void setRefresh(boolean isStart) {
        if (isStart != this.isRefreshing) {
            this.isRefreshing = isStart;
            this.refreshButton.setEnabled(!isStart);
            this.refreshButton.setIcon(isStart ? UserImages.NUOMI_LOADING_IMAGE : this.refreshNormalIcon);
            this.refreshButton.setPressedIcon(isStart ? null : this.refreshPressedIcon);
        }
    }

    protected void startRefresh() {
        this.setRefresh(true);
    }

    protected void endRefresh() {
        this.setRefresh(false);
    }
}

