/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.ResultInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Timer;
import java.util.TimerTask;

public class BindingPhonePage
extends BasePage {
    private static BindingPhonePage _BindingPhonePage = null;
    private final int TOP_MARGIN;
    private boolean canEditPhone = true;
    private TextBox phoneTextBox = null;
    private Button resendCodeButton = null;
    private Label hintLabel = null;
    private TextBox codeTextBox = null;
    private Button bindingButton = null;
    private final int MAX_REMAIN_TIME;
    private DataDownload resendDownload = null;
    private DataDownload bindingDownload = null;
    private DataDownloadListener resendCodeListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            BindingPhonePage.this.setConnecting(true);
            BindingPhonePage.this.startRefresh();
            BindingPhonePage.this.showRefreshIcon();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof ResultInfo) {
                ResultInfo resultInfo = (ResultInfo)data;
                if (resultInfo.isSucceed()) {
                    BindingPhonePage.this.hintLabel.setText("20\u79d2\u540e\u53ef\u91cd\u65b0\u83b7\u53d6");
                    BindingPhonePage.this.hintLabel.setVisible(true);
                    BindingPhonePage.this.repaint();
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            BindingPhonePage.access$1(1.access$0(this.this$1)).setVisible(false);
                            if (!1.access$0(this.this$1).isRefreshing) {
                                BindingPhonePage.access$2(1.access$0(this.this$1)).setEnabled(true);
                            }
                            1.access$0(this.this$1).repaint();
                        }
                    }, 20000L);
                    hintString = "\u9a8c\u8bc1\u7801\u83b7\u53d6\u6210\u529f\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536";
                } else if (resultInfo.isLogExpired()) {
                    if (BindingPhonePage.this.getCurrentForm() == BindingPhonePage.this.self && !MessageBox.isShow) {
                        if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                            LogPage.Show(BindingPhonePage.this.self, true);
                        }
                        showHint = false;
                    }
                } else {
                    hintString = resultInfo.msg;
                }
            }
            if (BindingPhonePage.this.bindingDownload == null || !BindingPhonePage.this.bindingDownload.isDownloading()) {
                BindingPhonePage.this.hideRefreshIcon();
                BindingPhonePage.this.endRefresh();
            }
            if (showHint) {
                BindingPhonePage.this.showHint(hintString);
            }
            BindingPhonePage.this.setConnecting(false);
            BindingPhonePage.this.repaint();
        }

        static /* synthetic */ BindingPhonePage access$0(1 var0) {
            return var0.BindingPhonePage.this;
        }
    };
    private DataDownloadListener bindingListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            BindingPhonePage.this.setConnecting(true);
            BindingPhonePage.this.startRefresh();
            BindingPhonePage.this.showRefreshIcon();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof ResultInfo) {
                ResultInfo resultInfo = (ResultInfo)data;
                if (resultInfo.isSucceed()) {
                    UserInfo userInfo = UserInfo.copy(BasePage.clientInfo.getUserInfo());
                    if (userInfo != null) {
                        userInfo.phone = BindingPhonePage.this.phoneTextBox.getText();
                    }
                    BasePage.clientInfo.setUserInfo(userInfo);
                    BindingPhonePage.this.onBack();
                } else if (resultInfo.isLogExpired()) {
                    if (BindingPhonePage.this.getCurrentForm() == BindingPhonePage.this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                        LogPage.Show(BindingPhonePage.this.self, true);
                    }
                    showHint = false;
                } else {
                    hintString = resultInfo.msg;
                }
            }
            if (BindingPhonePage.this.resendDownload == null || !BindingPhonePage.this.resendDownload.isDownloading()) {
                BindingPhonePage.this.hideRefreshIcon();
                BindingPhonePage.this.endRefresh();
            }
            if (showHint) {
                BindingPhonePage.this.showHint(hintString);
            }
            BindingPhonePage.this.setConnecting(false);
            BindingPhonePage.this.repaint();
        }
    };

    public static void Show(BasePage parentPage, String phone) {
        if (_BindingPhonePage == null) {
            _BindingPhonePage = new BindingPhonePage();
        }
        _BindingPhonePage.setParent(parentPage);
        BindingPhonePage._BindingPhonePage.phoneTextBox.setText(phone);
        BindingPhonePage._BindingPhonePage.canEditPhone = Methods.isNullOrWhitespace(phone);
        BindingPhonePage._BindingPhonePage.phoneTextBox.setEnabled(BindingPhonePage._BindingPhonePage.canEditPhone);
        BindingPhonePage._BindingPhonePage.codeTextBox.setText(null);
        _BindingPhonePage.show();
    }

    public static void Show(BasePage parentPage) {
        BindingPhonePage.Show(parentPage, null);
    }

    private BindingPhonePage() {
        this.TOP_MARGIN = 20;
        this.MAX_REMAIN_TIME = 20;
        this.setTitle("\u7ed1\u5b9a\u624b\u673a\u53f7");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new BoxLayout(2));
        Container content = new Container(new BoxLayout(2));
        Label label = new Label("\u6211\u4eec\u9700\u8981\u9a8c\u8bc1\u60a8\u7684\u624b\u673a\u4fe1\u606f");
        content.addComponent(label);
        label.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        label.getStyle().setFgColor(9084854);
        this.phoneTextBox = new TextBox(3);
        content.addComponent(this.phoneTextBox);
        this.phoneTextBox.getStyle().setMargin(0, 20);
        this.phoneTextBox.setHint("\u8f93\u5165\u624b\u673a\u53f7\u7801");
        Container resendContainer = new Container(new BoxLayout(1));
        content.addComponent(resendContainer);
        resendContainer.getStyle().setMargin(0, 20);
        this.resendCodeButton = UserInterface.createButton("\u83b7\u53d6\u9a8c\u8bc1\u7801");
        resendContainer.addComponent(this.resendCodeButton);
        this.resendCodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BindingPhonePage.this.onResendCode();
            }
        });
        this.hintLabel = new Label("20\u79d2\u540e\u53ef\u91cd\u65b0\u83b7\u53d6");
        resendContainer.addComponent(this.hintLabel);
        this.hintLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        this.hintLabel.setVisible(false);
        this.codeTextBox = new TextBox(2);
        content.addComponent(this.codeTextBox);
        this.codeTextBox.setHint("\u8f93\u5165\u9a8c\u8bc1\u7801");
        this.codeTextBox.getStyle().setMargin(0, 20);
        Container bindingContainer = new Container(new BoxLayout(1));
        content.addComponent(bindingContainer);
        bindingContainer.getStyle().setMargin(0, 20);
        this.bindingButton = UserInterface.createButton("\u7ed1\u5b9a");
        bindingContainer.addComponent(this.bindingButton);
        this.bindingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BindingPhonePage.this.onBinding();
            }
        });
        ContentContainer contentContainer = new ContentContainer(content, 0, 20);
        this.mainContainer.addComponent(contentContainer);
        contentContainer.getStyle().setMargin(0, 5);
    }

    private void onResendCode() {
        String phone = this.phoneTextBox.getText();
        if (Methods.isNullOrWhitespace(phone)) {
            this.showHint("\u8bf7\u8f93\u5165\u7535\u8bdd\u53f7\u7801");
            this.phoneTextBox.setFocus(true);
            return;
        }
        if (!PhoneFunction.isPhoneNumber(phone)) {
            this.showHint("\u7535\u8bdd\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
            this.phoneTextBox.setFocus(true);
            return;
        }
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null) {
            if (this.resendDownload == null) {
                this.resendDownload = new DataDownload();
                this.resendDownload.addDownloadListener(this.resendCodeListener);
            }
            this.resendDownload.bindPhoneCode(userInfo.userId, userInfo.ticket, phone);
        }
    }

    private void onBinding() {
        String phone = this.phoneTextBox.getText();
        if (Methods.isNullOrWhitespace(phone)) {
            this.showHint("\u8bf7\u8f93\u5165\u7535\u8bdd\u53f7\u7801");
            this.phoneTextBox.setFocus(true);
            return;
        }
        if (!PhoneFunction.isPhoneNumber(phone)) {
            this.showHint("\u7535\u8bdd\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
            this.phoneTextBox.setFocus(true);
            return;
        }
        String code = this.codeTextBox.getText().trim();
        if (Methods.isNullOrEmpty(code)) {
            this.showHint("\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            this.codeTextBox.setFocus(true);
            return;
        }
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null) {
            if (this.bindingDownload == null) {
                this.bindingDownload = new DataDownload();
                this.bindingDownload.addDownloadListener(this.bindingListener);
            }
            this.bindingDownload.bindPhone(userInfo.userId, userInfo.ticket, phone, code);
        }
    }

    private void setConnecting(boolean isConnecting) {
        this.phoneTextBox.setEnabled(!isConnecting && this.canEditPhone);
        if (!this.hintLabel.isVisible()) {
            this.resendCodeButton.setEnabled(!isConnecting);
        }
        this.codeTextBox.setEnabled(!isConnecting);
        this.bindingButton.setEnabled(!isConnecting);
    }

    static /* synthetic */ Button access$2(BindingPhonePage bindingPhonePage) {
        return bindingPhonePage.resendCodeButton;
    }
}

