/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.OrderCheckInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.BuyDealResult;
import com.nuomi.data.DealOption;
import com.nuomi.data.DealPreview;
import com.nuomi.data.GiftCard;
import com.nuomi.data.PostAddress;
import com.nuomi.data.ResultInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.CheckButtonCheckedListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.MoreListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.BindingPhonePage;
import com.nuomi.pages.BuyReviewPage;
import com.nuomi.pages.GiftCardPage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.CheckButton;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.usercontrol.ItemButtonGroup;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.ListPicker;
import com.nuomi.usercontrol.MultiRowButton;
import com.nuomi.usercontrol.MultiRowButtonGroup;
import com.nuomi.usercontrol.MultiRowCheckButton;
import com.nuomi.usercontrol.MultiRowRadioButton;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class BuyPage
extends BasePage {
    private static BuyPage _BuyPage = null;
    private DealPreview _dealPreview = null;
    private BuyDealResult _BuyDealResult = null;
    private ContentContainer contentContainer = null;
    private Container content = null;
    private Container optionsContainer = null;
    private Container detailContainer = null;
    private Button nextButton = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private DataDownload dataDownload = null;
    private Vector numberTextBoxVector = null;
    private MultiRowButtonGroup optionsButtonGroup = null;
    private MultiRowButtonGroup addressesButtonGroup = null;
    private MultiRowButtonGroup deliveryTypeButtonGroup = null;
    private TextBox descriptionTextBox = null;
    private CheckButton invoiceCheckButton = null;
    private TextBox invoiceTitleTextBox = null;
    private ListPicker invoiceTypeListPicker = null;
    private ListPicker deliveryTypeListPicker = null;
    private TextBox phoneTextBox = null;
    private Container invoiceContent = null;
    private Container invoiceContainer = null;
    private ContentContainer invoiceContentContainer = null;
    private ItemButton giftItemButton = null;
    private GiftCard selectedGiftCard = null;
    private ButtonClickedListener giftcardClickedListener = new ButtonClickedListener(){

        public void onClicked(Object sender) {
            GiftCardPage.Show(BuyPage.this.self);
        }
    };
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            BuyPage.this.startRefresh();
            BuyPage.this.showRefreshIcon();
            BuyPage.this.nextButton.setEnabled(false);
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof BuyDealResult) {
                ResultInfo resultInfo = ((BuyDealResult)data).result;
                if (resultInfo.isSucceed()) {
                    BuyPage.this.showDetail((BuyDealResult)data);
                    BuyPage.this.nextButton.setEnabled(true);
                } else if (resultInfo.isLogExpired()) {
                    if (BuyPage.this.getCurrentForm() == BuyPage.this.self && !MessageBox.isShow) {
                        if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                            LogPage.Show(BuyPage.this.self, true);
                        }
                        showHint = false;
                    }
                } else if (BuyPage.this.getCurrentForm() == BuyPage.this.self && !MessageBox.isShow) {
                    MessageBox.Show(resultInfo.msg, "\u786e\u5b9a", null, UserInterface.FONT_NORMAL);
                    BuyPage.this.onBack();
                }
            }
            BuyPage.this.hideRefreshIcon();
            BuyPage.this.endRefresh();
            if (showHint) {
                BuyPage.this.showHint(hintString);
            }
            BuyPage.this.repaint();
        }
    };
    private MoreListener optionMoreListener = new MoreListener(){

        public void onMore(Object sender) {
            BuyPage.this.contentContainer.setCenterHeight(BuyPage.this.content.getPreferredH());
        }
    };

    public static void Show(BasePage parentPage, DealPreview dealPreview) {
        if (_BuyPage == null) {
            _BuyPage = new BuyPage();
        }
        BuyPage._BuyPage.selectedGiftCard = null;
        _BuyPage.setContent(dealPreview);
        _BuyPage.setParent(parentPage);
        _BuyPage.show();
    }

    private BuyPage() {
        this.setTitle("\u8d2d\u4e70");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.nextButton = UserInterface.createBigButton("\u4e0b\u4e00\u6b65");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BuyPage.this.onNext();
            }
        });
        Container nextContainer = new Container();
        this.nextButton.setEnabled(false);
        this.mainContainer.addComponent(nextContainer);
        nextContainer.setPreferredW(this.mainContainer.getPreferredW());
        nextContainer.setPreferredH(this.nextButton.getPreferredH() + 10);
        nextContainer.setLayout(new CoordinateLayout(nextContainer.getPreferredW(), nextContainer.getPreferredH()));
        nextContainer.addComponent(this.nextButton);
        nextContainer.setX(0);
        nextContainer.setY(this.mainContainer.getPreferredH() - nextContainer.getPreferredH());
        nextContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
        this.nextButton.setX((nextContainer.getPreferredW() - this.nextButton.getPreferredW()) / 2);
        this.nextButton.setY(5);
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - nextContainer.getPreferredH());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 5);
    }

    private void setContent(DealPreview dealPreview) {
        this.nextButton.setEnabled(false);
        this._dealPreview = dealPreview;
        if (this._dealPreview == null) {
            return;
        }
        this.scrollContainer.setScrollY(0);
        this.innerContainer.removeAll();
        this.content = new Container(new BoxLayout(2));
        if (dealPreview.middleTitle != null) {
            Vector middleTitleVector = Methods.splitString(dealPreview.middleTitle, UserInterface.FONT_NORMAL, 0, 325);
            LabelGroup middleTitleGroup = new LabelGroup(middleTitleVector, UserInterface.FONT_NORMAL, 6453130, 330, 25);
            this.content.addComponent(middleTitleGroup);
            middleTitleGroup.getStyle().setMargin(1, 10);
            Label spLabel = new Label();
            this.content.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
        }
        this.optionsContainer = new Container(new BoxLayout(2));
        this.content.addComponent(this.optionsContainer);
        this.optionsContainer.getStyle().setMargin(1, 5);
        this.contentContainer = new ContentContainer(this.content, 0, 0);
        this.innerContainer.addComponent(this.contentContainer);
        this.contentContainer.getStyle().setMargin(0, 5);
        this.detailContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.detailContainer);
        this.onRefresh();
    }

    private void showDetail(BuyDealResult buyDealResult) {
        this._BuyDealResult = buyDealResult;
        if (buyDealResult == null) {
            return;
        }
        if (this.numberTextBoxVector == null) {
            this.numberTextBoxVector = new Vector();
        }
        this.numberTextBoxVector.removeAllElements();
        int hintLeft = UserInterface.FONT_OPTION.stringWidth("\u5355\u4ef7:");
        Container phoneContainer = new Container(new BorderLayout());
        phoneContainer.getStyle().setMargin(5, 0, 5, 5);
        Label phoneLabel = new Label("\u624b\u673a\u53f7\u7801:*");
        phoneContainer.addComponent("West", (Component)phoneLabel);
        phoneLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        this.phoneTextBox = new TextBox(3);
        if (userInfo != null) {
            this.phoneTextBox.setText(userInfo.phone);
            this.phoneTextBox.setEnabled(Methods.isNullOrWhitespace(this.phoneTextBox.getText()) || !PhoneFunction.isPhoneNumber(userInfo.userName));
        }
        phoneContainer.addComponent("Center", (Component)this.phoneTextBox);
        phoneContainer.setPreferredH(phoneContainer.getPreferredH());
        phoneContainer.setPreferredW(330);
        ContentContainer phoneContentContainer = new ContentContainer(phoneContainer, 0, 0);
        this.innerContainer.addComponent(phoneContentContainer);
        phoneContentContainer.getStyle().setMargin(0, 5);
        this.repaint();
        if (buyDealResult.hasOption == null || !buyDealResult.hasOption.booleanValue()) {
            DealOption dealOption = null;
            if (buyDealResult.options != null && (dealOption = (DealOption)buyDealResult.options.firstElement()) != null) {
                Label priceLabel = new Label("\u5355\u4ef7:\uffe5" + Methods.formatPrice(dealOption.optionPrice));
                this.optionsContainer.addComponent(priceLabel);
                priceLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                if (dealOption.ship != null && dealOption.ship > 0.0) {
                    Label shipLabel = new Label("\u8fd0\u8d39:\uffe5" + Methods.formatPrice(dealOption.ship));
                    this.optionsContainer.addComponent(shipLabel);
                    shipLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                    this.repaint();
                    if (dealOption.shipFreeStart != null && dealOption.shipFreeStart > 0) {
                        Label shipFreeStartLabel = new Label("(\u8d2d\u4e70" + dealOption.shipFreeStart + "\u4ef6\u4ee5\u4e0a\u514d\u8fd0\u8d39)");
                        this.optionsContainer.addComponent(shipFreeStartLabel);
                        shipFreeStartLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                        shipFreeStartLabel.getStyle().setFgColor(9084854);
                        shipFreeStartLabel.getStyle().setMargin(1, hintLeft);
                        this.repaint();
                    }
                    if (dealOption.freeShopCost != null && dealOption.freeShopCost > 0.0) {
                        Label freeShopCostLabel = new Label("(\u8d2d\u4e70" + Methods.formatPrice(dealOption.freeShopCost) + "\u5143\u4ee5\u4e0a\u514d\u8fd0\u8d39)");
                        this.optionsContainer.addComponent(freeShopCostLabel);
                        freeShopCostLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                        freeShopCostLabel.getStyle().setFgColor(9084854);
                        freeShopCostLabel.getStyle().setMargin(1, hintLeft);
                        this.repaint();
                    }
                }
                Container numberContainer = new Container(new BoxLayout(1));
                this.optionsContainer.addComponent(numberContainer);
                Label numberTitleLabel = new Label("\u6570\u91cf:");
                numberContainer.addComponent(numberTitleLabel);
                numberTitleLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                TextBox numberTextBox = new TextBox(true);
                numberContainer.addComponent(numberTextBox);
                this.numberTextBoxVector.addElement(numberTextBox);
                if (dealOption.soldout != null && dealOption.soldout.booleanValue()) {
                    numberTextBox.setEnabled(false);
                    numberTextBox.setHint("\u5df2\u5356\u5149");
                } else {
                    numberTextBox.setConstraint(2);
                    int lowLimit = dealOption.lowLimit == null ? 1 : dealOption.lowLimit;
                    int limit = dealOption.limit == null ? 0 : dealOption.limit;
                    numberTextBox.setText(String.valueOf(lowLimit));
                    String limitHint = "";
                    if (lowLimit > 1) {
                        limitHint = String.valueOf(limitHint) + lowLimit + "\u4ef6\u8d77\u8d2d";
                    }
                    if (limit > 0) {
                        limitHint = String.valueOf(limitHint) + (Methods.isNullOrEmpty(limitHint) ? "" : ",") + limit + "\u4ef6\u5c01\u9876";
                    }
                    if (!Methods.isNullOrEmpty(limitHint)) {
                        Label limitHintLabel = new Label(limitHint);
                        this.optionsContainer.addComponent(limitHintLabel);
                        limitHintLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                        limitHintLabel.getStyle().setFgColor(9084854);
                        limitHintLabel.getStyle().setMargin(1, hintLeft);
                    }
                }
                this.repaint();
            }
        } else if (buyDealResult.options != null) {
            boolean isMultiOption = buyDealResult.multiOption != null && buyDealResult.multiOption != false;
            MultiRowButton[] multiRowButtons = null;
            int count = buyDealResult.options.size();
            multiRowButtons = isMultiOption ? new MultiRowCheckButton[count] : new MultiRowRadioButton[count];
            DealOption firstOption = (DealOption)buyDealResult.options.firstElement();
            if (firstOption != null) {
                if (firstOption.ship != null && firstOption.ship > 0.0) {
                    Label shipLabel = new Label("\u8fd0\u8d39:\uffe5" + Methods.formatPrice(firstOption.ship));
                    this.optionsContainer.addComponent(shipLabel);
                    shipLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                    if (firstOption.shipFreeStart != null && firstOption.shipFreeStart > 0) {
                        Label shipFressStartLabel = new Label("(\u8d2d\u4e70" + firstOption.shipFreeStart + "\u4ef6\u4ee5\u4e0a\u514d\u8fd0\u8d39)");
                        this.optionsContainer.addComponent(shipFressStartLabel);
                        shipFressStartLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                        shipFressStartLabel.getStyle().setFgColor(9084854);
                        shipFressStartLabel.getStyle().setMargin(1, hintLeft);
                    }
                    if (firstOption.freeShopCost != null && firstOption.freeShopCost > 0.0) {
                        Label freeShopCostLabel = new Label("(\u8d2d\u4e70" + Methods.formatPrice(firstOption.freeShopCost) + "\u5143\u4ee5\u4e0a\u514d\u8fd0\u8d39)");
                        this.optionsContainer.addComponent(freeShopCostLabel);
                        freeShopCostLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                        freeShopCostLabel.getStyle().setFgColor(9084854);
                        freeShopCostLabel.getStyle().setMargin(1, hintLeft);
                    }
                }
                this.repaint();
            }
            int i = 0;
            while (i < count) {
                DealOption dealOption = (DealOption)buyDealResult.options.elementAt(i);
                boolean buttonEnabled = dealOption.soldout == null || dealOption.soldout == false;
                Container dealOptionContent = new Container(new BoxLayout(2));
                Container priceNumberContainer = new Container(new BoxLayout(1));
                dealOptionContent.addComponent(priceNumberContainer);
                TextBox numberTextBox = new TextBox(true);
                numberTextBox.getStyle().setMargin(1, 5);
                Label priceLabel = new Label("\uffe5" + Methods.formatPrice(dealOption.optionPrice));
                priceNumberContainer.addComponent(priceLabel);
                priceLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                priceNumberContainer.addComponent(numberTextBox);
                this.numberTextBoxVector.addElement(numberTextBox);
                if (!buttonEnabled) {
                    numberTextBox.setEnabled(false);
                    numberTextBox.setHint("\u5df2\u5356\u5149");
                } else {
                    numberTextBox.setConstraint(2);
                    int lowLimit = dealOption.lowLimit == null ? 1 : dealOption.lowLimit;
                    int limit = dealOption.limit == null ? 0 : dealOption.limit;
                    numberTextBox.setText(String.valueOf(lowLimit));
                    String limitHint = "";
                    if (lowLimit > 1) {
                        limitHint = String.valueOf(limitHint) + lowLimit + "\u4ef6\u8d77\u8d2d";
                    }
                    if (limit > 0) {
                        limitHint = String.valueOf(limitHint) + (Methods.isNullOrEmpty(limitHint) ? "" : ",") + limit + "\u4ef6\u5c01\u9876";
                    }
                    if (!Methods.isNullOrEmpty(limitHint)) {
                        Label limitHintLabel = new Label(limitHint);
                        dealOptionContent.addComponent(limitHintLabel);
                        limitHintLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                        limitHintLabel.getStyle().setFgColor(9084854);
                    }
                }
                multiRowButtons[i] = isMultiOption ? new MultiRowCheckButton(dealOption.optionName, dealOptionContent) : new MultiRowRadioButton(dealOption.optionName, dealOptionContent);
                multiRowButtons[i].setEnabled(buttonEnabled);
                ++i;
            }
            this.optionsButtonGroup = new MultiRowButtonGroup(multiRowButtons, true);
            this.optionsButtonGroup.addMoreListener(this.optionMoreListener);
            this.optionsContainer.addComponent(this.optionsButtonGroup);
            this.repaint();
        }
        this.contentContainer.setCenterHeight(this.content.getPreferredH());
        this.repaint();
        this.giftItemButton = new ItemButton(3, "\u4f7f\u7528\u4ee3\u91d1\u5238", null, true, " ");
        this.giftItemButton.addClickedListener(this.giftcardClickedListener);
        ItemButton[] itemButtons = new ItemButton[]{this.giftItemButton};
        ItemButtonGroup itemButtonGroup = new ItemButtonGroup(itemButtons);
        this.detailContainer.addComponent(itemButtonGroup);
        itemButtonGroup.getStyle().setMargin(0, 5);
        if (buyDealResult.delivery != null && buyDealResult.delivery.booleanValue()) {
            int addressCount;
            Container deliveryContent = new Container(new BoxLayout(2));
            deliveryContent.getStyle().setMargin(1, 5);
            Label deliveryTitleLabel = new Label("\u914d\u9001\u4fe1\u606f");
            deliveryContent.addComponent(deliveryTitleLabel);
            deliveryTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            deliveryTitleLabel.getStyle().setMargin(1, 5);
            Label spLabel = new Label();
            deliveryContent.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
            if (buyDealResult.addresses != null && (addressCount = buyDealResult.addresses.size()) > 0) {
                MultiRowButton[] addressButtons = new MultiRowRadioButton[addressCount];
                int j = 0;
                while (j < addressCount) {
                    PostAddress address = (PostAddress)buyDealResult.addresses.elementAt(j);
                    String title = String.valueOf(address.title == null ? "" : String.valueOf(address.title) + "\r\n") + (address.name == null ? "" : String.valueOf(address.name) + " ") + (address.area == null ? "" : String.valueOf(address.area) + " ") + (address.address == null ? "" : String.valueOf(address.address) + "\r\n") + (address.postcode == null ? "" : String.valueOf(address.postcode) + " ") + (address.phone == null ? "" : String.valueOf(address.phone) + " ");
                    addressButtons[j] = new MultiRowRadioButton(title, null);
                    ++j;
                }
                this.addressesButtonGroup = new MultiRowButtonGroup(addressButtons);
                deliveryContent.addComponent(this.addressesButtonGroup);
                this.addressesButtonGroup.getStyle().setMargin(1, 5);
                this.addressesButtonGroup.setSelectedIndex(0);
            } else {
                Label addressHint = new Label("\u8bf7\u5148\u5230\u7f51\u7ad9\u4e0a\u65b0\u5efa\u5730\u5740");
                deliveryContent.addComponent(addressHint);
                addressHint.getStyle().setAlignment(4);
                addressHint.getStyle().setFgColor(15492920);
                addressHint.getStyle().setFont(UserInterface.FONT_OPTION);
            }
            ContentContainer deliveryContentContainer = new ContentContainer(deliveryContent, 0, 0);
            this.detailContainer.addComponent(deliveryContentContainer);
            deliveryContentContainer.getStyle().setMargin(0, 5);
            this.repaint();
            Container deliveryTypeContent = new Container(new BoxLayout(2));
            deliveryTypeContent.getStyle().setMargin(1, 5);
            Label deliveryTypeTitleLabel = new Label("\u9001\u8d27\u65f6\u95f4");
            deliveryTypeContent.addComponent(deliveryTypeTitleLabel);
            deliveryTypeTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            deliveryTypeTitleLabel.getStyle().setMargin(1, 5);
            Label spLabel2 = new Label();
            deliveryTypeContent.addComponent(spLabel2);
            spLabel2.getStyle().setBgColor(0x919191);
            spLabel2.getStyle().setBgTransparency(128);
            spLabel2.getStyle().setMargin(2, 15);
            spLabel2.setPreferredW(348);
            spLabel2.setPreferredH(1);
            MultiRowButton[] deliveryTypeButtons = new MultiRowRadioButton[ClientInfo.deliveryTypeStrings.length];
            int i = 0;
            while (i < deliveryTypeButtons.length) {
                deliveryTypeButtons[i] = new MultiRowRadioButton(ClientInfo.deliveryTypeStrings[i], null);
                ++i;
            }
            this.deliveryTypeButtonGroup = new MultiRowButtonGroup(deliveryTypeButtons);
            deliveryTypeContent.addComponent(this.deliveryTypeButtonGroup);
            this.deliveryTypeButtonGroup.getStyle().setMargin(1, 5);
            this.deliveryTypeButtonGroup.setSelectedIndex(0);
            ContentContainer deliveryTypeContentContainer = new ContentContainer(deliveryTypeContent, 0, 0);
            this.detailContainer.addComponent(deliveryTypeContentContainer);
            deliveryTypeContentContainer.getStyle().setMargin(0, 5);
            this.repaint();
            Container otherContent = new Container(new BoxLayout(2));
            otherContent.getStyle().setMargin(1, 5);
            Label otherTitleLabel = new Label("\u914d\u9001\u5176\u4ed6\u8bf4\u660e");
            otherContent.addComponent(otherTitleLabel);
            otherTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            otherTitleLabel.getStyle().setMargin(1, 5);
            this.descriptionTextBox = new TextBox();
            otherContent.addComponent(this.descriptionTextBox);
            this.descriptionTextBox.getStyle().setMargin(1, 5);
            this.descriptionTextBox.getStyle().setMargin(3, 5);
            ContentContainer otherContentContainer = new ContentContainer(otherContent, 0, 0);
            this.detailContainer.addComponent(otherContentContainer);
            otherContentContainer.getStyle().setMargin(0, 5);
            this.repaint();
        }
        if (buyDealResult.elong != null && buyDealResult.elong.booleanValue()) {
            int addressCount;
            this.invoiceContent = new Container(new BoxLayout(2));
            this.invoiceContent.getStyle().setMargin(1, 5);
            Container invoiceCheckButtonContainer = new Container(new BorderLayout());
            this.invoiceContent.addComponent(invoiceCheckButtonContainer);
            invoiceCheckButtonContainer.getStyle().setMargin(1, 5);
            this.invoiceCheckButton = new CheckButton("\u9700\u8981\u53d1\u7968");
            invoiceCheckButtonContainer.addComponent("West", (Component)this.invoiceCheckButton);
            this.invoiceCheckButton.addCheckedListener(new CheckButtonCheckedListener(){

                public void onChanged(boolean isChecked) {
                    if (isChecked) {
                        if (!BuyPage.this.invoiceContent.contains(BuyPage.this.invoiceContainer)) {
                            BuyPage.this.invoiceContent.addComponent(BuyPage.this.invoiceContainer);
                        }
                    } else if (BuyPage.this.invoiceContent.contains(BuyPage.this.invoiceContainer)) {
                        BuyPage.this.invoiceContent.removeComponent(BuyPage.this.invoiceContainer);
                    }
                    BuyPage.this.invoiceContentContainer.setCenterHeight(BuyPage.this.invoiceContent.getPreferredH());
                    BuyPage.this.self.repaint();
                }
            });
            Label invoiceHintLabel = new Label("(\u914d\u9001\u8d39:\uffe510)");
            invoiceCheckButtonContainer.addComponent("Center", (Component)invoiceHintLabel);
            invoiceHintLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            invoiceHintLabel.setPreferredH(invoiceHintLabel.getPreferredH());
            invoiceHintLabel.setPreferredW(340 - this.invoiceCheckButton.getPreferredW());
            this.invoiceContainer = new Container(new BoxLayout(2));
            Label spLabel = new Label();
            this.invoiceContainer.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
            Container invoiceTitleContainer = new Container(new BorderLayout());
            this.invoiceContainer.addComponent(invoiceTitleContainer);
            invoiceTitleContainer.getStyle().setMargin(1, 5);
            invoiceTitleContainer.getStyle().setMargin(3, 5);
            Label invoiceTitleLabel = new Label("\u53d1\u7968\u62ac\u5934:*");
            invoiceTitleContainer.addComponent("West", (Component)invoiceTitleLabel);
            invoiceTitleLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            this.invoiceTitleTextBox = new TextBox();
            invoiceTitleContainer.addComponent("Center", (Component)this.invoiceTitleTextBox);
            invoiceTitleContainer.setPreferredH(invoiceTitleContainer.getPreferredH());
            invoiceTitleContainer.setPreferredW(330);
            Container invoiceTypeContainer = new Container(new BoxLayout(1));
            this.invoiceContainer.addComponent(invoiceTypeContainer);
            invoiceTypeContainer.getStyle().setMargin(1, 5);
            invoiceTypeContainer.getStyle().setMargin(0, 5);
            Label invoiceTypeLabel = new Label("\u53d1\u7968\u7c7b\u578b:*");
            invoiceTypeContainer.addComponent(invoiceTypeLabel);
            invoiceTypeLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            this.invoiceTypeListPicker = new ListPicker("\u53d1\u7968\u7c7b\u578b", ClientInfo.invoiceTypeStrings, true);
            invoiceTypeContainer.addComponent(this.invoiceTypeListPicker);
            Container deliveryTypeContainer = new Container(new BorderLayout());
            this.invoiceContainer.addComponent(deliveryTypeContainer);
            deliveryTypeContainer.getStyle().setMargin(5, 0, 5, 5);
            Label deliveryTypeLabel = new Label("\u914d\u9001\u65f6\u95f4:*");
            deliveryTypeContainer.addComponent("West", (Component)deliveryTypeLabel);
            deliveryTypeLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            this.deliveryTypeListPicker = new ListPicker("\u914d\u9001\u65f6\u95f4", BuyReviewPage.deliveryTypeStrings);
            deliveryTypeContainer.addComponent("Center", (Component)this.deliveryTypeListPicker);
            this.deliveryTypeListPicker.setSelectedIndex(0);
            deliveryTypeContainer.setPreferredH(deliveryTypeContainer.getPreferredH());
            deliveryTypeContainer.setPreferredW(330);
            this.deliveryTypeListPicker.resetWidth(deliveryTypeContainer.getPreferredW() - deliveryTypeLabel.getPreferredW() - 4);
            if (buyDealResult.addresses != null && (addressCount = buyDealResult.addresses.size()) > 0) {
                MultiRowButton[] addressButtons = new MultiRowRadioButton[addressCount];
                int j = 0;
                while (j < addressCount) {
                    PostAddress address = (PostAddress)buyDealResult.addresses.elementAt(j);
                    String title = String.valueOf(address.title == null ? "" : String.valueOf(address.title) + "\r\n") + (address.name == null ? "" : String.valueOf(address.name) + " ") + (address.area == null ? "" : String.valueOf(address.area) + " ") + (address.address == null ? "" : String.valueOf(address.address) + "\r\n") + (address.postcode == null ? "" : String.valueOf(address.postcode) + " ") + (address.phone == null ? "" : String.valueOf(address.phone) + " ");
                    addressButtons[j] = new MultiRowRadioButton(title, null);
                    ++j;
                }
                this.addressesButtonGroup = new MultiRowButtonGroup(addressButtons);
                this.invoiceContainer.addComponent(this.addressesButtonGroup);
                this.addressesButtonGroup.getStyle().setMargin(1, 5);
                this.addressesButtonGroup.setSelectedIndex(0);
            } else {
                Label addressHint = new Label("\u8bf7\u5148\u5230\u7f51\u7ad9\u4e0a\u65b0\u5efa\u5730\u5740");
                this.invoiceContainer.addComponent(addressHint);
                addressHint.getStyle().setAlignment(4);
                addressHint.getStyle().setFgColor(15492920);
                addressHint.getStyle().setFont(UserInterface.FONT_OPTION);
            }
            Container invoiceDescriptionContainer = new Container(new BorderLayout());
            this.invoiceContainer.addComponent(invoiceDescriptionContainer);
            invoiceDescriptionContainer.getStyle().setMargin(5, 0, 5, 5);
            Label invoiceDescriptionLabel = new Label("\u5907\u6ce8:");
            invoiceDescriptionContainer.addComponent("West", (Component)invoiceDescriptionLabel);
            invoiceDescriptionLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            this.descriptionTextBox = new TextBox();
            invoiceDescriptionContainer.addComponent("Center", (Component)this.descriptionTextBox);
            invoiceDescriptionContainer.setPreferredH(invoiceDescriptionContainer.getPreferredH());
            invoiceDescriptionContainer.setPreferredW(330);
            this.invoiceContentContainer = new ContentContainer(this.invoiceContent, 0, 0);
            this.detailContainer.addComponent(this.invoiceContentContainer);
            this.invoiceContentContainer.getStyle().setMargin(0, 5);
            this.repaint();
        }
        this.repaint();
    }

    protected void onBack() {
        if (this.dataDownload != null && this.dataDownload.isDownloading()) {
            this.dataDownload.cancel();
        }
        this.innerContainer.removeAll();
        this.content = null;
        this.optionsContainer = null;
        this.contentContainer = null;
        this.detailContainer = null;
        if (this.giftItemButton != null) {
            this.giftItemButton.clearClickedListener();
        }
        this.giftItemButton = null;
        this.selectedGiftCard = null;
        if (this.numberTextBoxVector != null) {
            this.numberTextBoxVector.removeAllElements();
        }
        this.phoneTextBox = null;
        if (this.optionsButtonGroup != null) {
            this.optionsButtonGroup.removeAll();
            this.optionsButtonGroup.clearMoreListener();
        }
        this.optionsButtonGroup = null;
        if (this.deliveryTypeButtonGroup != null) {
            this.deliveryTypeButtonGroup.removeAll();
        }
        this.deliveryTypeButtonGroup = null;
        this.descriptionTextBox = null;
        this.invoiceContent = null;
        this.invoiceCheckButton = null;
        this.invoiceContainer = null;
        this.deliveryTypeListPicker = null;
        if (this.addressesButtonGroup != null) {
            this.addressesButtonGroup.removeAll();
        }
        this.addressesButtonGroup = null;
        this.descriptionTextBox = null;
        this.invoiceContentContainer = null;
        System.gc();
        super.onBack();
    }

    private void onRefresh() {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null && this._dealPreview != null) {
            if (this.dataDownload == null) {
                this.dataDownload = new DataDownload();
                this.dataDownload.addDownloadListener(this.listener);
            }
            this.dataDownload.buy(userInfo.userId, userInfo.ticket, this._dealPreview.dealId);
        }
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        this.onRefresh();
    }

    private void onNext() {
        String phoneText;
        if (this._BuyDealResult == null || this._dealPreview == null) {
            return;
        }
        this.hideHint();
        OrderCheckInfo orderCheckInfo = new OrderCheckInfo();
        orderCheckInfo.isDelivery = this._BuyDealResult.delivery;
        orderCheckInfo.isElong = this._BuyDealResult.elong;
        if (this._BuyDealResult.hasOption == null || !this._BuyDealResult.hasOption.booleanValue()) {
            TextBox numberTextBox;
            DealOption dealOption = null;
            if (this._BuyDealResult.options != null && (dealOption = (DealOption)this._BuyDealResult.options.firstElement()) != null && this.numberTextBoxVector != null && (numberTextBox = (TextBox)this.numberTextBoxVector.firstElement()) != null) {
                try {
                    int number = Integer.parseInt(numberTextBox.getText());
                    if (number <= 0) {
                        this.showHint("\u8bf7\u8f93\u5165\u8d2d\u4e70\u6570\u91cf");
                        numberTextBox.setFocus(true);
                        this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                        return;
                    }
                    if (dealOption.lowLimit != null && number < dealOption.lowLimit) {
                        this.showHint("\u8d2d\u4e70\u6570\u91cf\u4f4e\u4e8e\u8d77\u8d2d\u6570\u91cf");
                        numberTextBox.setFocus(true);
                        this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                        return;
                    }
                    if (dealOption.limit != null && number > dealOption.limit) {
                        this.showHint("\u8d2d\u4e70\u6570\u91cf\u8d85\u8fc7\u5c01\u9876\u6570\u91cf");
                        numberTextBox.setFocus(true);
                        this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                        return;
                    }
                    OrderCheckInfo.SelectedOption selectedOption = new OrderCheckInfo.SelectedOption(orderCheckInfo);
                    selectedOption.dealOptionName = null;
                    selectedOption.dealOptionId = dealOption.dealOptionId;
                    selectedOption.price = dealOption.optionPrice;
                    selectedOption.count = new Integer(number);
                    orderCheckInfo.selectedOptions = new Vector();
                    orderCheckInfo.selectedOptions.addElement(selectedOption);
                }
                catch (Exception e) {
                    this.showHint("\u8bf7\u8f93\u5165\u8d2d\u4e70\u6570\u91cf");
                    numberTextBox.setFocus(true);
                    this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                    return;
                }
            }
        } else {
            boolean isMultiOption = this._BuyDealResult.multiOption != null && this._BuyDealResult.multiOption != false;
            int count = this._BuyDealResult.options.size();
            if (isMultiOption) {
                int limit;
                boolean[] checkedState = this.optionsButtonGroup.getCheckedState();
                boolean hadSelectedOption = false;
                int selectedCount = 0;
                int i = 0;
                while (i < count) {
                    if (checkedState[i]) {
                        hadSelectedOption = true;
                        DealOption dealOption = (DealOption)this._BuyDealResult.options.elementAt(i);
                        TextBox numberTextBox = (TextBox)this.numberTextBoxVector.elementAt(i);
                        if (dealOption != null && numberTextBox != null) {
                            try {
                                int number = Integer.parseInt(numberTextBox.getText());
                                if (number <= 0) {
                                    this.showHint("\u8bf7\u8f93\u5165\u8d2d\u4e70\u6570\u91cf");
                                    numberTextBox.setFocus(true);
                                    this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                                    return;
                                }
                                if (dealOption.lowLimit != null && dealOption.lowLimit > 0 && number < dealOption.lowLimit) {
                                    this.showHint("\u8d2d\u4e70\u6570\u91cf\u4f4e\u4e8e\u8d77\u8d2d\u6570\u91cf");
                                    numberTextBox.setFocus(true);
                                    this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                                    return;
                                }
                                if (dealOption.limit != null && dealOption.limit > 0 && number > dealOption.limit) {
                                    this.showHint("\u8d2d\u4e70\u6570\u91cf\u8d85\u8fc7\u5c01\u9876\u6570\u91cf");
                                    numberTextBox.setFocus(true);
                                    this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                                    return;
                                }
                                selectedCount += number;
                                OrderCheckInfo.SelectedOption selectedOption = new OrderCheckInfo.SelectedOption(orderCheckInfo);
                                selectedOption.dealOptionName = dealOption.optionName;
                                selectedOption.dealOptionId = dealOption.dealOptionId;
                                selectedOption.price = dealOption.optionPrice;
                                selectedOption.count = new Integer(number);
                                if (orderCheckInfo.selectedOptions == null) {
                                    orderCheckInfo.selectedOptions = new Vector();
                                }
                                orderCheckInfo.selectedOptions.addElement(selectedOption);
                            }
                            catch (Exception e) {
                                this.showHint("\u8bf7\u8f93\u5165\u8d2d\u4e70\u6570\u91cf");
                                numberTextBox.setFocus(true);
                                this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                                return;
                            }
                        }
                    }
                    ++i;
                }
                if (!hadSelectedOption) {
                    this.showHint("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5957\u9910");
                    return;
                }
                int lowLimit = this._BuyDealResult.lowLimit == null ? 0 : this._BuyDealResult.lowLimit;
                int n = limit = this._BuyDealResult.limit == null ? 0 : this._BuyDealResult.limit;
                if (lowLimit > 0 && selectedCount < lowLimit) {
                    this.showHint("\u8d2d\u4e70\u603b\u6570\u91cf\u4f4e\u4e8e\u8d77\u8d2d\u6570\u91cf" + lowLimit);
                    return;
                }
                if (limit > 0 && selectedCount > limit) {
                    this.showHint("\u8d2d\u4e70\u603b\u6570\u91cf\u8d85\u8fc7\u5c01\u9876\u6570\u91cf" + limit);
                    return;
                }
            } else {
                int selectedIndex = this.optionsButtonGroup.getSelectedIndex();
                if (selectedIndex == -1) {
                    this.showHint("\u8bf7\u9009\u62e9\u4e00\u4e2a\u5957\u9910");
                    return;
                }
                DealOption dealOption = (DealOption)this._BuyDealResult.options.elementAt(selectedIndex);
                TextBox numberTextBox = (TextBox)this.numberTextBoxVector.elementAt(selectedIndex);
                if (dealOption != null && numberTextBox != null) {
                    try {
                        int number = Integer.parseInt(numberTextBox.getText());
                        if (number <= 0) {
                            this.showHint("\u8bf7\u8f93\u5165\u8d2d\u4e70\u6570\u91cf");
                            numberTextBox.setFocus(true);
                            this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                            return;
                        }
                        if (dealOption.lowLimit != null && number < dealOption.lowLimit) {
                            this.showHint("\u8d2d\u4e70\u6570\u91cf\u4f4e\u4e8e\u8d77\u8d2d\u6570\u91cf");
                            numberTextBox.setFocus(true);
                            this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                            return;
                        }
                        if (dealOption.limit != null && number > dealOption.limit) {
                            this.showHint("\u8d2d\u4e70\u6570\u91cf\u8d85\u8fc7\u5c01\u9876\u6570\u91cf");
                            numberTextBox.setFocus(true);
                            this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                            return;
                        }
                        OrderCheckInfo.SelectedOption selectedOption = new OrderCheckInfo.SelectedOption(orderCheckInfo);
                        selectedOption.dealOptionName = dealOption.optionName;
                        selectedOption.dealOptionId = dealOption.dealOptionId;
                        selectedOption.price = dealOption.optionPrice;
                        selectedOption.count = new Integer(number);
                        orderCheckInfo.selectedOptions = new Vector();
                        orderCheckInfo.selectedOptions.addElement(selectedOption);
                    }
                    catch (Exception e) {
                        this.showHint("\u8bf7\u8f93\u5165\u8d2d\u4e70\u6570\u91cf");
                        numberTextBox.setFocus(true);
                        this.scrollContainer.scrollRectToVisible(0, 0, 0, 0, numberTextBox);
                        return;
                    }
                }
            }
        }
        if (this.invoiceCheckButton != null && this.invoiceCheckButton.isChecked()) {
            if (Methods.isNullOrWhitespace(this.invoiceTitleTextBox.getText())) {
                this.showHint("\u8bf7\u586b\u5199\u53d1\u7968\u62ac\u5934");
                this.invoiceTitleTextBox.setFocus(true);
                return;
            }
            if (this.invoiceTypeListPicker.getSelectedIndex() == -1) {
                this.showHint("\u8bf7\u9009\u62e9\u53d1\u7968\u7c7b\u578b");
                this.invoiceTypeListPicker.setFocus(true);
                return;
            }
        }
        boolean hadAddress = false;
        if (this._BuyDealResult.delivery != null && this._BuyDealResult.delivery.booleanValue() || this._BuyDealResult.elong != null && this._BuyDealResult.elong.booleanValue() && this.invoiceCheckButton != null && this.invoiceCheckButton.isChecked()) {
            hadAddress = true;
            if (this.addressesButtonGroup == null && this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u60a8\u9700\u8981\u5148\u5230\u7f51\u7ad9\u6dfb\u52a0\u5730\u5740", "\u786e\u5b9a", null);
                return;
            }
        }
        if (BasePage.clientInfo.getUserInfo() != null) {
            orderCheckInfo.userId = BasePage.clientInfo.getUserInfo().userId;
            orderCheckInfo.ticket = BasePage.clientInfo.getUserInfo().ticket;
        }
        if (this._dealPreview != null) {
            orderCheckInfo.dealid = this._dealPreview.dealId;
        }
        if (BasePage.clientInfo.getCity() != null) {
            orderCheckInfo.cityid = BasePage.clientInfo.getCity().cityId;
        }
        if (hadAddress) {
            PostAddress address = (PostAddress)this._BuyDealResult.addresses.elementAt(this.addressesButtonGroup.getSelectedIndex());
            orderCheckInfo.addressid = address.addressId;
            orderCheckInfo.name = address.name;
            orderCheckInfo.area = address.area;
            orderCheckInfo.areaCode = address.areaCode;
            orderCheckInfo.address = address.address;
            orderCheckInfo.other = this.descriptionTextBox == null ? null : this.descriptionTextBox.getText();
            orderCheckInfo.postcode = address.postcode;
            orderCheckInfo.phone = address.phone;
        }
        if (this._BuyDealResult.delivery != null && this._BuyDealResult.delivery.booleanValue()) {
            orderCheckInfo.deliverytype = new Integer(this.deliveryTypeButtonGroup.getSelectedIndex());
            DealOption firstOption = (DealOption)this._BuyDealResult.options.firstElement();
            if (firstOption != null) {
                orderCheckInfo.ship = firstOption.ship;
                orderCheckInfo.shipFreeStart = firstOption.shipFreeStart;
                orderCheckInfo.freeShopCost = firstOption.freeShopCost;
            }
        }
        if (this._BuyDealResult.elong != null && this._BuyDealResult.elong.booleanValue() && this.invoiceCheckButton != null && this.invoiceCheckButton.isChecked()) {
            orderCheckInfo.needinvoice = new Boolean(true);
            orderCheckInfo.invoicetitle = this.invoiceTitleTextBox.getText();
            orderCheckInfo.invoicetype = new Integer(this.invoiceTypeListPicker.getSelectedIndex());
            orderCheckInfo.deliverytype = new Integer(this.deliveryTypeListPicker.getSelectedIndex());
        }
        String string = phoneText = this.phoneTextBox == null ? null : this.phoneTextBox.getText();
        if (Methods.isNullOrWhitespace(phoneText)) {
            this.showHint("\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
            this.phoneTextBox.setFocus(true);
            this.innerContainer.scrollRectToVisible(0, 0, 0, 0, this.phoneTextBox);
            return;
        }
        if (!PhoneFunction.isPhoneNumber(phoneText)) {
            this.showHint("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            this.phoneTextBox.setFocus(true);
            this.innerContainer.scrollRectToVisible(0, 0, 0, 0, this.phoneTextBox);
            return;
        }
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null && !Methods.equals(userInfo.phone, phoneText)) {
            BindingPhonePage.Show(this.self, phoneText);
            return;
        }
        orderCheckInfo.giftcard = this.selectedGiftCard;
        BuyReviewPage.Show(this.self, this._dealPreview, orderCheckInfo);
    }

    public void setGiftCard(GiftCard card) {
        this.selectedGiftCard = card;
        if (this.giftItemButton != null) {
            if (this.selectedGiftCard == null) {
                this.giftItemButton.setHintText(null);
            } else {
                this.giftItemButton.setHintText("(\u672c\u6b21\u4f7f\u7528\uffe5" + Methods.formatPrice(this.selectedGiftCard.worth) + ")");
            }
        }
    }
}

