/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.OrderCheckInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.DealPreview;
import com.nuomi.data.PayCheckResult;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.OrderCheckPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class BuyReviewPage
extends BasePage {
    private static BuyReviewPage _BuyReviewPage = null;
    public static final String[] deliveryTypeStrings = new String[]{"\u53ea\u5de5\u4f5c\u65e5\u9001\u8d27", "\u53ea\u53cc\u4f11\u65e5/\u5047\u65e5\u9001\u8d27", "\u5de5\u4f5c\u65e5/\u53cc\u4f11\u65e5/\u5047\u65e5\u5747\u53ef\u9001\u8d27"};
    private DealPreview _dealPreview = null;
    private OrderCheckInfo _orderCheckInfo = null;
    private Button nextButton = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private TextBox validateTextBox;
    private Button validateButton = null;
    private DataDownload dataDownload2 = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            BuyReviewPage.this.startRefresh();
            BuyReviewPage.this.showRefreshIcon();
            BuyReviewPage.this.nextButton.setEnabled(false);
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            boolean needCheck = false;
            if (data != null && data instanceof PayCheckResult) {
                PayCheckResult payCheckResult = (PayCheckResult)data;
                if (payCheckResult.needCheck == 1) {
                    needCheck = true;
                }
            }
            ((BuyReviewPage)BuyReviewPage.this)._orderCheckInfo.needCheck = needCheck;
            BuyReviewPage.this.addValidateView();
            BuyReviewPage.this.nextButton.setEnabled(true);
            BuyReviewPage.this.hideRefreshIcon();
            BuyReviewPage.this.endRefresh();
        }
    };
    private DataDownloadListener listener2 = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            BuyReviewPage.this.startRefresh();
            BuyReviewPage.this.showRefreshIcon();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            BuyReviewPage.this.hideRefreshIcon();
            BuyReviewPage.this.endRefresh();
            BuyReviewPage.this.showHint("\u9a8c\u8bc1\u7801\u5df2\u7ecf\u4e0b\u53d1");
            BuyReviewPage.this.repaint();
        }
    };

    public static void Show(BasePage parentPage, DealPreview dealPreview, OrderCheckInfo orderCheckInfo) {
        if (_BuyReviewPage == null) {
            _BuyReviewPage = new BuyReviewPage();
        }
        _BuyReviewPage.setParent(parentPage);
        _BuyReviewPage.setContent(dealPreview, orderCheckInfo);
        _BuyReviewPage.show();
    }

    private BuyReviewPage() {
        this.setTitle("\u8d2d\u4e70");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.nextButton = UserInterface.createBigButton("\u786e\u5b9a\u8d2d\u4e70");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BuyReviewPage.this.onNext();
            }
        });
        Container nextContainer = new Container();
        this.mainContainer.addComponent(nextContainer);
        nextContainer.setPreferredW(this.mainContainer.getPreferredW());
        nextContainer.setPreferredH(this.nextButton.getPreferredH() + 10);
        nextContainer.setLayout(new CoordinateLayout(nextContainer.getPreferredW(), nextContainer.getPreferredH()));
        nextContainer.addComponent(this.nextButton);
        nextContainer.setX(0);
        nextContainer.setY(this.mainContainer.getPreferredH() - nextContainer.getPreferredH());
        nextContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
        this.nextButton.setX((nextContainer.getPreferredW() - this.nextButton.getPreferredW()) / 2);
        this.nextButton.setY(5);
        Label chooseLabel = new Label("\u60a8\u9009\u62e9\u4e86");
        this.mainContainer.addComponent(chooseLabel);
        chooseLabel.getStyle().setFont(UserInterface.FONT_BUTTONTEXT);
        chooseLabel.getStyle().setBgImage(UserImages.FINDCITYSPAGE_ALLCITY_BG_IMAGE);
        chooseLabel.setPreferredW(UserImages.FINDCITYSPAGE_ALLCITY_BG_IMAGE.getWidth());
        chooseLabel.setPreferredH(UserImages.FINDCITYSPAGE_ALLCITY_BG_IMAGE.getHeight());
        chooseLabel.getStyle().setAlignment(4);
        chooseLabel.getStyle().setFgColor(0xFFFFFF);
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - chooseLabel.getPreferredH() - nextContainer.getPreferredH());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.scrollContainer.setX(0);
        this.scrollContainer.setY(chooseLabel.getPreferredH());
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 5);
    }

    private void setContent(DealPreview dealPreview, OrderCheckInfo orderCheckInfo) {
        Label spLabel;
        int optionsCount;
        this._dealPreview = dealPreview;
        this._orderCheckInfo = orderCheckInfo;
        if (this._dealPreview == null || this._orderCheckInfo == null) {
            return;
        }
        this.scrollContainer.setScrollY(0);
        this.innerContainer.removeAll();
        int hintLeft = UserInterface.FONT_OPTION.stringWidth("\u5355\u4ef7:");
        Container optionsContent = new Container(new BoxLayout(2));
        if (dealPreview.middleTitle != null) {
            Vector middleTitleVector = Methods.splitString(dealPreview.middleTitle, UserInterface.FONT_NORMAL, 0, 325);
            LabelGroup middleTitleGroup = new LabelGroup(middleTitleVector, UserInterface.FONT_NORMAL, 6453130, 330, 25);
            optionsContent.addComponent(middleTitleGroup);
            middleTitleGroup.getStyle().setMargin(1, 5);
            Label spLabel2 = new Label();
            optionsContent.addComponent(spLabel2);
            spLabel2.getStyle().setBgColor(0x919191);
            spLabel2.getStyle().setBgTransparency(128);
            spLabel2.getStyle().setMargin(2, 15);
            spLabel2.setPreferredW(348);
            spLabel2.setPreferredH(1);
        }
        Container optionContainer = new Container(new BoxLayout(2));
        optionsContent.addComponent(optionContainer);
        optionContainer.getStyle().setMargin(1, 10);
        if (orderCheckInfo.ship != null && orderCheckInfo.ship > 0.0) {
            Container shipContainer = new Container(new BoxLayout(2));
            optionContainer.addComponent(shipContainer);
            Label shipLabel = new Label("\u8fd0\u8d39:\uffe5" + Methods.formatPrice(orderCheckInfo.ship));
            shipContainer.addComponent(shipLabel);
            shipLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            if (orderCheckInfo.shipFreeStart != null && orderCheckInfo.shipFreeStart > 0) {
                Label shipFreeStartLabel = new Label("(\u8d2d\u4e70" + orderCheckInfo.shipFreeStart + "\u4ef6\u4ee5\u4e0a\u514d\u8fd0\u8d39)");
                shipContainer.addComponent(shipFreeStartLabel);
                shipFreeStartLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                shipFreeStartLabel.getStyle().setFgColor(9084854);
                shipFreeStartLabel.getStyle().setMargin(1, hintLeft);
            }
            if (orderCheckInfo.freeShopCost != null && orderCheckInfo.freeShopCost > 0.0) {
                Label freeShopCostLabel = new Label("(\u8d2d\u4e70" + Methods.formatPrice(orderCheckInfo.freeShopCost) + "\u5143\u4ee5\u4e0a\u514d\u8fd0\u8d39)");
                shipContainer.addComponent(freeShopCostLabel);
                freeShopCostLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                freeShopCostLabel.getStyle().setFgColor(9084854);
                freeShopCostLabel.getStyle().setMargin(1, hintLeft);
            }
        }
        if (orderCheckInfo.selectedOptions != null && (optionsCount = orderCheckInfo.selectedOptions.size()) > 0) {
            int i = 0;
            while (i < optionsCount) {
                OrderCheckInfo.SelectedOption selectedOption = (OrderCheckInfo.SelectedOption)orderCheckInfo.selectedOptions.elementAt(i);
                int priceLeftMargin = 0;
                if (selectedOption.dealOptionName != null) {
                    Container nameContainer = new Container(new BoxLayout(1));
                    optionContainer.addComponent(nameContainer);
                    nameContainer.getStyle().setMargin(0, 5);
                    Label nameTitleLabel = new Label(UserImages.ICON_POINT_IMAGE);
                    nameContainer.addComponent(nameTitleLabel);
                    nameTitleLabel.setPreferredW(nameTitleLabel.getPreferredW());
                    nameTitleLabel.setPreferredH(25);
                    Vector dealOptionNameVector = Methods.splitString(selectedOption.dealOptionName, UserInterface.FONT_NORMAL, 0, 340 - hintLeft);
                    LabelGroup dealOptionNameGroup = new LabelGroup(dealOptionNameVector, UserInterface.FONT_NORMAL, 6453130, 340 - hintLeft, 25);
                    nameContainer.addComponent(dealOptionNameGroup);
                    priceLeftMargin = nameTitleLabel.getPreferredW();
                }
                if (selectedOption.price != null) {
                    Container priceContainer = new Container(new BoxLayout(1));
                    optionContainer.addComponent(priceContainer);
                    priceContainer.getStyle().setMargin(1, priceLeftMargin);
                    Label priceLabel = new Label("\u5355\u4ef7:\uffe5" + Methods.formatPrice(selectedOption.price));
                    priceContainer.addComponent(priceLabel);
                    priceLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                }
                if (selectedOption.count != null) {
                    Container numberContainer = new Container(new BoxLayout(1));
                    optionContainer.addComponent(numberContainer);
                    numberContainer.getStyle().setMargin(1, priceLeftMargin);
                    Label numberLabel = new Label("\u6570\u91cf:" + selectedOption.count);
                    numberContainer.addComponent(numberLabel);
                    numberLabel.getStyle().setFont(UserInterface.FONT_OPTION);
                }
                ++i;
            }
        }
        ContentContainer optionsContentContainer = new ContentContainer(optionsContent, 0, 0);
        this.innerContainer.addComponent(optionsContentContainer);
        optionsContentContainer.getStyle().setMargin(0, 5);
        if (orderCheckInfo.giftcard != null) {
            Container giftCardContent = new Container(new BoxLayout(2));
            Label deliveryTitleLabel = new Label("\u4f7f\u7528\u4ee3\u91d1\u5238");
            giftCardContent.addComponent(deliveryTitleLabel);
            deliveryTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            deliveryTitleLabel.getStyle().setMargin(1, 5);
            spLabel = new Label();
            giftCardContent.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
            String giftCardString = orderCheckInfo.giftcard.toString();
            Vector giftCardVector = Methods.splitString(giftCardString, UserInterface.FONT_SMALL, 0, 330, "\r\n");
            LabelGroup giftCardGroup = new LabelGroup(giftCardVector, UserInterface.FONT_NORMAL, 6453130, 25);
            giftCardContent.addComponent(giftCardGroup);
            giftCardGroup.getStyle().setMargin(1, 10);
            ContentContainer giftCardContentContainer = new ContentContainer(giftCardContent, 0, 0);
            this.innerContainer.addComponent(giftCardContentContainer);
            giftCardContentContainer.getStyle().setMargin(0, 5);
        }
        if (orderCheckInfo.deliverytype != null && orderCheckInfo.isDelivery != null && orderCheckInfo.isDelivery.booleanValue()) {
            Container deliveryContent = new Container(new BoxLayout(2));
            Label deliveryTitleLabel = new Label("\u914d\u9001\u4fe1\u606f");
            deliveryContent.addComponent(deliveryTitleLabel);
            deliveryTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            deliveryTitleLabel.getStyle().setMargin(1, 5);
            spLabel = new Label();
            deliveryContent.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
            String addresses = "\u914d\u9001\u5730\u5740: " + orderCheckInfo.name + ", " + orderCheckInfo.area + orderCheckInfo.address + "\r\n" + (Methods.isNullOrWhitespace(orderCheckInfo.postcode) ? "" : "\u90ae\u7f16: " + orderCheckInfo.postcode + "\r\n") + (Methods.isNullOrWhitespace(orderCheckInfo.phone) ? "" : "\u7535\u8bdd: " + orderCheckInfo.phone);
            Vector addressedVector = Methods.splitString(addresses, UserInterface.FONT_NORMAL, 0, 330, "\r\n");
            LabelGroup addressedGroup = new LabelGroup(addressedVector, UserInterface.FONT_NORMAL, 6453130, 25);
            deliveryContent.addComponent(addressedGroup);
            addressedGroup.getStyle().setMargin(1, 10);
            String type = "\u53d1\u8d27\u65f6\u95f4: " + deliveryTypeStrings[orderCheckInfo.deliverytype];
            Vector typeVector = Methods.splitString(type, UserInterface.FONT_NORMAL, 0, 330, "\r\n");
            LabelGroup typeGroup = new LabelGroup(typeVector, UserInterface.FONT_NORMAL, 6453130, 25);
            deliveryContent.addComponent(typeGroup);
            typeGroup.getStyle().setMargin(1, 10);
            typeGroup.getStyle().setMargin(0, 10);
            if (!Methods.isNullOrWhitespace(orderCheckInfo.other)) {
                String other = "\u914d\u9001\u5176\u4ed6\u8bf4\u660e: " + orderCheckInfo.other;
                Vector otherVector = Methods.splitString(other, UserInterface.FONT_NORMAL, 0, 330, "\r\n");
                LabelGroup otherGroup = new LabelGroup(otherVector, UserInterface.FONT_NORMAL, 6453130, 25);
                deliveryContent.addComponent(otherGroup);
                otherGroup.getStyle().setMargin(1, 10);
                otherGroup.getStyle().setMargin(0, 10);
            }
            ContentContainer diliveryContentContainer = new ContentContainer(deliveryContent, 0, 0);
            this.innerContainer.addComponent(diliveryContentContainer);
            diliveryContentContainer.getStyle().setMargin(0, 5);
        }
        if (orderCheckInfo.isElong != null && orderCheckInfo.isElong.booleanValue() && orderCheckInfo.needinvoice != null && orderCheckInfo.needinvoice.booleanValue()) {
            Container invoiceContent = new Container(new BoxLayout(2));
            Label invoiceTitleLabel = new Label("\u914d\u9001\u53d1\u7968");
            invoiceContent.addComponent(invoiceTitleLabel);
            invoiceTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            invoiceTitleLabel.getStyle().setMargin(1, 5);
            spLabel = new Label();
            invoiceContent.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
            String title = "\u53d1\u7968\u62ac\u5934: " + orderCheckInfo.invoicetitle;
            Vector titleVector = Methods.splitString(title, UserInterface.FONT_NORMAL, 0, 330, "\r\n");
            LabelGroup titleGroup = new LabelGroup(titleVector, UserInterface.FONT_NORMAL, 6453130, 25);
            invoiceContent.addComponent(titleGroup);
            titleGroup.getStyle().setMargin(1, 10);
            Label typeLabel = new Label("\u53d1\u7968\u7c7b\u578b: " + ClientInfo.invoiceTypeStrings[orderCheckInfo.invoicetype]);
            invoiceContent.addComponent(typeLabel);
            typeLabel.getStyle().setMargin(1, 10);
            String addresses = "\u914d\u9001\u5730\u5740: " + orderCheckInfo.name + ", " + orderCheckInfo.area + orderCheckInfo.address + "\r\n" + (Methods.isNullOrWhitespace(orderCheckInfo.postcode) ? "" : "\u90ae\u7f16: " + orderCheckInfo.postcode + "\r\n") + (Methods.isNullOrWhitespace(orderCheckInfo.phone) ? "" : "\u7535\u8bdd: " + orderCheckInfo.phone);
            Vector addressedVector = Methods.splitString(addresses, UserInterface.FONT_NORMAL, 0, 330, "\r\n");
            LabelGroup addressedGroup = new LabelGroup(addressedVector, UserInterface.FONT_NORMAL, 6453130, 25);
            invoiceContent.addComponent(addressedGroup);
            addressedGroup.getStyle().setMargin(1, 10);
            addressedGroup.getStyle().setMargin(0, 10);
            String type = "\u914d\u9001\u65f6\u95f4: " + deliveryTypeStrings[orderCheckInfo.deliverytype];
            Vector typeVector = Methods.splitString(type, UserInterface.FONT_NORMAL, 0, 330, "\r\n");
            LabelGroup typeGroup = new LabelGroup(typeVector, UserInterface.FONT_NORMAL, 6453130, 25);
            invoiceContent.addComponent(typeGroup);
            typeGroup.getStyle().setMargin(1, 10);
            typeGroup.getStyle().setMargin(0, 10);
            if (!Methods.isNullOrWhitespace(orderCheckInfo.other)) {
                String other = "\u5907\u6ce8: " + orderCheckInfo.other;
                Vector otherVector = Methods.splitString(other, UserInterface.FONT_NORMAL, 0, 330, "\r\n");
                LabelGroup otherGroup = new LabelGroup(otherVector, UserInterface.FONT_NORMAL, 6453130, 25);
                invoiceContent.addComponent(otherGroup);
                otherGroup.getStyle().setMargin(1, 10);
                otherGroup.getStyle().setMargin(0, 10);
            }
            ContentContainer invoiceContentContainer = new ContentContainer(invoiceContent, 0, 0);
            this.innerContainer.addComponent(invoiceContentContainer);
            invoiceContentContainer.getStyle().setMargin(0, 5);
        }
        this.checkValidateCode();
    }

    protected void onBack() {
        this.innerContainer.removeAll();
        System.gc();
        super.onBack();
    }

    private void onNext() {
        if (this._orderCheckInfo != null && this._dealPreview != null) {
            if (this._orderCheckInfo.needCheck) {
                this._orderCheckInfo.checkCode = this.validateTextBox.getText();
                if (this._orderCheckInfo.checkCode == null || this._orderCheckInfo.checkCode.length() == 0) {
                    this.showHint("\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
                    return;
                }
            }
            OrderCheckPage.Show(this.self, this._dealPreview, this._orderCheckInfo);
        }
    }

    private void checkValidateCode() {
        double price = 0.0;
        int shipCount = 0;
        Vector vector = this._orderCheckInfo.selectedOptions;
        if (vector != null && vector.size() > 0) {
            int i = 0;
            while (i < vector.size()) {
                OrderCheckInfo.SelectedOption option = (OrderCheckInfo.SelectedOption)vector.elementAt(i);
                price += option.price * (double)option.count.intValue();
                shipCount += option.count.intValue();
                ++i;
            }
        }
        if (this._orderCheckInfo.ship != null && this._orderCheckInfo.ship > 0.0) {
            price += this._orderCheckInfo.ship.doubleValue();
            if (this._orderCheckInfo.shipFreeStart != null && this._orderCheckInfo.shipFreeStart > 0) {
                if (shipCount > this._orderCheckInfo.shipFreeStart) {
                    price -= this._orderCheckInfo.ship.doubleValue();
                }
            } else if (this._orderCheckInfo.freeShopCost != null && this._orderCheckInfo.freeShopCost > 0.0 && price > this._orderCheckInfo.freeShopCost) {
                price -= this._orderCheckInfo.ship.doubleValue();
            }
        }
        DataDownload dataDownload = new DataDownload();
        dataDownload.addDownloadListener(this.listener);
        dataDownload.payCheck(this._orderCheckInfo, new Double(price));
    }

    private void addValidateView() {
        if (this._orderCheckInfo.needCheck) {
            Container validateContent = new Container(new BoxLayout(2));
            Label resultTitleLabel = new Label("\u9a8c\u8bc1\u7801");
            validateContent.addComponent(resultTitleLabel);
            resultTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            resultTitleLabel.getStyle().setMargin(1, 5);
            Label spLabel = new Label();
            validateContent.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
            Container validateContainer = new Container(new BoxLayout(1));
            validateContainer.getStyle().setMargin(1, 10);
            this.validateTextBox = new TextBox(true);
            validateContainer.addComponent(this.validateTextBox);
            this.validateButton = UserInterface.createButton("\u83b7\u53d6\u9a8c\u8bc1\u7801");
            this.validateButton.getStyle().setMargin(1, 10);
            this.validateButton.setPreferredH(48);
            this.validateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    BuyReviewPage.this.getValidateCode();
                }
            });
            validateContainer.addComponent(this.validateButton);
            validateContent.addComponent(validateContainer);
            ContentContainer validateContentContainer = new ContentContainer(validateContent, 0, 0);
            this.innerContainer.addComponent(validateContentContainer);
            validateContentContainer.getStyle().setMargin(0, 5);
            this.repaint();
        }
    }

    private void getValidateCode() {
        new ValidateThread().start();
        if (this.dataDownload2 == null) {
            this.dataDownload2 = new DataDownload();
            this.dataDownload2.addDownloadListener(this.listener2);
        }
        this.dataDownload2.payCheckPost(this._orderCheckInfo);
    }

    private class ValidateThread
    extends Thread {
        private ValidateThread() {
        }

        public void run() {
            BuyReviewPage.this.validateButton.setEnabled(false);
            int i = 30;
            while (i >= 0) {
                String s = String.valueOf(String.valueOf(i)) + "\u79d2";
                BuyReviewPage.this.validateButton.setText(s);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                --i;
            }
            BuyReviewPage.this.validateButton.setText("\u83b7\u53d6\u9a8c\u8bc1\u7801");
            BuyReviewPage.this.validateButton.setEnabled(true);
        }
    }
}

