/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.GiftCardCheck;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.MyGiftcardPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;

public class CheckGiftcardPage
extends BasePage {
    private static CheckGiftcardPage _CheckGiftcardPage = null;
    private TextBox checkCodeTextBox = null;
    private Button checkButton = null;
    private DataDownload checkDownload = null;

    public static void Show(BasePage parentPage) {
        if (_CheckGiftcardPage == null) {
            _CheckGiftcardPage = new CheckGiftcardPage();
        }
        _CheckGiftcardPage.setParent(parentPage);
        _CheckGiftcardPage.show();
    }

    private CheckGiftcardPage() {
        this.setTitle("\u4f18\u60e0\u7801\u8f6c\u6362");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new BoxLayout(2));
        Container checkContent = new Container(new BoxLayout(2));
        String[] checkHintStrings = new String[]{"\u63d0\u793a\uff1a\u8f93\u5165\u7cef\u7c73\u4f18\u60e0\u7801\u540e", "\u5c06\u8f6c\u6362\u4e3a\u4ee3\u91d1\u5238"};
        int i = 0;
        while (i < checkHintStrings.length) {
            Label label = new Label(checkHintStrings[i]);
            checkContent.addComponent(label);
            label.setPreferredW(340);
            label.setPreferredH(25);
            label.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            label.getStyle().setFgColor(0x919191);
            label.getStyle().setAlignment(4);
            ++i;
        }
        this.checkCodeTextBox = new TextBox(0);
        checkContent.addComponent(this.checkCodeTextBox);
        this.checkCodeTextBox.setHint("\u8bf7\u8f93\u5165\u7cef\u7c73\u4f18\u60e0\u7801");
        this.checkCodeTextBox.getStyle().setMargin(1, 15);
        this.checkCodeTextBox.getStyle().setMargin(3, 15);
        this.checkCodeTextBox.getStyle().setMargin(0, 10);
        Container buttonContainer = new Container(new BoxLayout(1));
        checkContent.addComponent(buttonContainer);
        buttonContainer.getStyle().setMargin(0, 10);
        this.checkButton = UserInterface.createBigButton("\u786e\u5b9a");
        buttonContainer.addComponent(this.checkButton);
        buttonContainer.getStyle().setMargin(1, (checkContent.getPreferredW() - this.checkButton.getPreferredW()) / 2);
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CheckGiftcardPage.this.checkGiftCard();
            }
        });
        ContentContainer checkContentContainer = new ContentContainer(checkContent, 0, 0);
        this.mainContainer.addComponent(checkContentContainer);
        checkContentContainer.getStyle().setMargin(0, 5);
        checkContentContainer.getStyle().setMargin(1, 0);
    }

    protected void onBack() {
        this.checkCodeTextBox.setText(null);
        if (this.checkDownload != null && this.checkDownload.isDownloading()) {
            this.checkDownload.cancel();
        }
        super.onBack();
    }

    protected void checkGiftCard() {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u672a\u767b\u5f55\u8d26\u53f7", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                LogPage.Show(this.self);
            }
        } else {
            String code = this.checkCodeTextBox.getText().trim();
            if (Methods.isNullOrEmpty(code)) {
                this.showHint("\u8bf7\u8f93\u5165\u7cef\u7c73\u4f18\u60e0\u7801");
                this.checkCodeTextBox.setFocus(true);
                return;
            }
            if (this.checkDownload == null) {
                this.checkDownload = new DataDownload();
                this.checkDownload.addDownloadListener(new DataDownloadListener(){

                    public void onDownloadStart(Object tag) {
                        CheckGiftcardPage.this.checkButton.setEnabled(false);
                        CheckGiftcardPage.this.startRefresh();
                    }

                    public void onDownloadCompleted(int result, Object data, int type, Object tag) {
                        String hintString = DataDownload.ResultStrings[result];
                        boolean showHint = true;
                        if (result == 2 && data instanceof GiftCardCheck) {
                            GiftCardCheck check = (GiftCardCheck)data;
                            if (check.result.isSucceed()) {
                                if (CheckGiftcardPage.this.parentPage != null && CheckGiftcardPage.this.parentPage instanceof MyGiftcardPage) {
                                    ((MyGiftcardPage)CheckGiftcardPage.this.parentPage).refreshGiftcard(check.giftcard);
                                }
                                CheckGiftcardPage.this.onBack();
                            } else if (check.result.isLogExpired() && CheckGiftcardPage.this.getCurrentForm() == CheckGiftcardPage.this.self && !MessageBox.isShow) {
                                if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                    LogPage.Show(CheckGiftcardPage.this.self, true);
                                }
                                showHint = false;
                            }
                            hintString = check.result.msg;
                        }
                        if (showHint) {
                            CheckGiftcardPage.this.showHint(hintString);
                        }
                        CheckGiftcardPage.this.checkButton.setEnabled(true);
                        CheckGiftcardPage.this.endRefresh();
                        CheckGiftcardPage.this.repaint();
                    }
                });
            }
            this.checkDownload.giftcardCheck(userInfo.userId, userInfo.ticket, code);
        }
    }
}

