/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.Coupon;
import com.nuomi.data.Deal;
import com.nuomi.data.ResultInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.AddressListPage;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.PhoneListPage;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.DetailTitleContainer;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.usercontrol.ItemButtonGroup;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TabControl;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class CouponDetailPage
extends BasePage {
    private static CouponDetailPage _CouponDetailPage = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private Coupon _coupon = null;
    private Deal _deal = null;
    private DetailTitleContainer titleContainer = null;
    private Label currentPriceLabel = null;
    private Label discountLabel = null;
    private Label marketPriceLabel = null;
    private Label endTimeLabel = null;
    private Label saleCountLabel = null;
    private Container sampleContainer = null;
    private Container detailContainer = null;
    private DataDownload dealDownload = null;
    private DataDownload qrcodeDownload = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            CouponDetailPage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof Deal) {
                BasePage.clientInfo.setDealDetail(((CouponDetailPage)CouponDetailPage.this)._coupon.dealId, data);
                CouponDetailPage.this.showDeal((Deal)data);
                try {
                    Thread.sleep(800L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CouponDetailPage.this.self.repaint();
            }
            if (result != 3) {
                CouponDetailPage.this.showHint(hintString);
                CouponDetailPage.this.endRefresh();
            }
        }
    };
    private DataDownloadListener qrCodeListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            CouponDetailPage.this.showHint("\u8bf7\u7a0d\u5019...");
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof ResultInfo) {
                ResultInfo resultInfo = (ResultInfo)data;
                if (resultInfo.isLogExpired()) {
                    if (CouponDetailPage.this.getCurrentForm() == CouponDetailPage.this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                        LogPage.Show(CouponDetailPage.this.self, true);
                    }
                    showHint = false;
                } else {
                    hintString = resultInfo.msg;
                }
            }
            if (result != 3 && showHint) {
                CouponDetailPage.this.showHint(hintString);
                CouponDetailPage.this.endRefresh();
            }
        }
    };

    public static void Show(BasePage parentPage, Coupon coupon, boolean hadUsed) {
        if (_CouponDetailPage == null) {
            _CouponDetailPage = new CouponDetailPage();
        }
        _CouponDetailPage.setContent(coupon, hadUsed);
        _CouponDetailPage.setParent(parentPage);
        _CouponDetailPage.show();
    }

    private CouponDetailPage() {
        this.setTitle("\u6211\u7684\u7cef\u7c73\u5238");
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        TabControl tabControl = new TabControl(UserImages.DETAIL_TAB_BG_IMAGE, UserImages.DETAIL_TABS_IMAGES, false);
        tabControl.setX(0);
        tabControl.setY(this.mainContainer.getPreferredH() - tabControl.getPreferredH());
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - tabControl.getClickHeight());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 10);
        this.sampleContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.sampleContainer);
        this.detailContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.detailContainer);
        ItemButton serviceButton = new ItemButton(3, "\u7cef\u7c73\u5ba2\u670d:4006-888-887", UserImages.ICON_PHONE_IMAGE, false);
        serviceButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                PhoneFunction.callNuomiServicePhone();
            }
        });
        ItemButton[] itemButtons = new ItemButton[]{serviceButton};
        ItemButtonGroup serviceContainer = new ItemButtonGroup(itemButtons);
        this.innerContainer.addComponent(serviceContainer);
        serviceContainer.getStyle().setMargin(0, 5);
        this.mainContainer.addComponent(tabControl);
        tabControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                switch (index) {
                    case 0: {
                        CouponDetailPage.this.onPhoneClicked();
                        break;
                    }
                    case 1: {
                        CouponDetailPage.this.onAddressClicked();
                        break;
                    }
                    case 2: {
                        CouponDetailPage.this.onShareClicked();
                        break;
                    }
                }
            }
        });
    }

    private void setContent(Coupon coupon, boolean hadUsed) {
        this.scrollContainer.setScrollY(0);
        this._coupon = coupon;
        if (coupon == null) {
            return;
        }
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        Container previewContainer = new Container(new BoxLayout(2));
        previewContainer.getStyle().setPadding(1, 10);
        previewContainer.getStyle().setPadding(3, 10);
        boolean canClick = coupon.isNuomiPassword != null && coupon.isNuomiPassword == false || coupon.isQRCode != null && coupon.isQRCode != false;
        String clickHint = coupon.isQRCode != null && coupon.isQRCode != false ? coupon.password : "\u663e\u793a\u8be6\u7ec6";
        this.titleContainer = new DetailTitleContainer("\u6d88\u8d39\u7801", coupon.password, hadUsed ? 9084854 : 15492920, hadUsed ? "\u5df2\u4f7f\u7528" : "\u672a\u4f7f\u7528", canClick, clickHint);
        previewContainer.addComponent(this.titleContainer);
        this.titleContainer.getStyle().setMargin(1, 5);
        this.titleContainer.getStyle().setMargin(3, 5);
        this.titleContainer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (CouponDetailPage.this.getCurrentForm() == CouponDetailPage.this.self && !MessageBox.isShow) {
                    if (((CouponDetailPage)CouponDetailPage.this)._coupon.isQRCode != null && ((CouponDetailPage)CouponDetailPage.this)._coupon.isQRCode.booleanValue()) {
                        if (CouponDetailPage.this.qrcodeDownload == null) {
                            CouponDetailPage.this.qrcodeDownload = new DataDownload();
                            CouponDetailPage.this.qrcodeDownload.addDownloadListener(CouponDetailPage.this.qrCodeListener);
                        }
                        if (!CouponDetailPage.this.qrcodeDownload.isDownloading()) {
                            UserInfo userInfo = BasePage.clientInfo.getUserInfo();
                            if (userInfo != null) {
                                CouponDetailPage.this.qrcodeDownload.getQRCode(userInfo.userId, userInfo.ticket, ((CouponDetailPage)CouponDetailPage.this)._coupon.couponId, userInfo.phone);
                            }
                        } else {
                            CouponDetailPage.this.showHint("\u8bf7\u7a0d\u5019...");
                        }
                    } else {
                        MessageBox.Show(((CouponDetailPage)CouponDetailPage.this)._coupon.password, "\u786e\u5b9a", null, UserInterface.FONT_NORMAL);
                    }
                    CouponDetailPage.this.self.repaint();
                }
            }
        });
        if (coupon.middleTitle != null) {
            Vector middleTitleVector = Methods.splitString(coupon.middleTitle, UserInterface.FONT_NORMAL, 0, 330);
            LabelGroup middleTitleGroup = new LabelGroup(middleTitleVector, UserInterface.FONT_NORMAL, 6453130, 330, 25);
            previewContainer.addComponent(middleTitleGroup);
            middleTitleGroup.getStyle().setMargin(1, 10);
            middleTitleGroup.getStyle().setMargin(0, 10);
        }
        int imagePriceWidth = 340;
        int imagePriceHeight = 99;
        Container imagePriceContainer = new Container(new CoordinateLayout(imagePriceWidth, imagePriceHeight));
        imagePriceContainer.setPreferredW(imagePriceWidth);
        imagePriceContainer.setPreferredH(imagePriceHeight);
        previewContainer.addComponent(imagePriceContainer);
        imagePriceContainer.getStyle().setMargin(0, 5);
        imagePriceContainer.getStyle().setMargin(1, 10);
        ImageControl image = new ImageControl(165, imagePriceHeight);
        imagePriceContainer.addComponent(image);
        image.setX(0);
        image.setY(0);
        image.setImage(coupon.image, true);
        Container priceContainer = new Container(new CoordinateLayout(imagePriceWidth - image.getPreferredW() - 5, imagePriceHeight));
        priceContainer.setPreferredW(imagePriceWidth - image.getPreferredW() - 5);
        priceContainer.setPreferredH(imagePriceHeight);
        imagePriceContainer.addComponent(priceContainer);
        priceContainer.setX(image.getPreferredW() + 20);
        priceContainer.setY(0);
        this.currentPriceLabel = new Label();
        this.currentPriceLabel.setText("\uffe5");
        this.currentPriceLabel.getStyle().setFont(UserInterface.FONT_LARGE);
        priceContainer.addComponent(this.currentPriceLabel);
        this.currentPriceLabel.setX(0);
        this.currentPriceLabel.setY(0);
        this.currentPriceLabel.setEndsWith3Points(false);
        this.discountLabel = new Label();
        this.discountLabel.setText("\u6298\u6263:");
        this.discountLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(this.discountLabel);
        this.discountLabel.setX(0);
        this.discountLabel.setY(priceContainer.getPreferredH() - this.discountLabel.getPreferredH());
        this.discountLabel.setEndsWith3Points(false);
        this.marketPriceLabel = new Label();
        this.marketPriceLabel.setText("\u539f\u4ef7:\uffe5");
        this.marketPriceLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(this.marketPriceLabel);
        this.marketPriceLabel.setX(0);
        this.marketPriceLabel.setY(priceContainer.getPreferredH() - this.discountLabel.getPreferredH() - this.marketPriceLabel.getPreferredH());
        this.marketPriceLabel.setEndsWith3Points(false);
        Container saleCountContainer = new Container();
        previewContainer.addComponent(saleCountContainer);
        saleCountContainer.setPreferredW(350);
        saleCountContainer.setPreferredH(30);
        saleCountContainer.setLayout(new CoordinateLayout(saleCountContainer.getPreferredW(), saleCountContainer.getPreferredH()));
        saleCountContainer.getStyle().setMargin(0, 5);
        this.saleCountLabel = new Label(" ");
        this.saleCountLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        saleCountContainer.addComponent(this.saleCountLabel);
        this.saleCountLabel.setX((saleCountContainer.getPreferredW() - this.saleCountLabel.getPreferredW()) / 2);
        this.saleCountLabel.setY((saleCountContainer.getPreferredH() - this.saleCountLabel.getPreferredH()) / 2);
        this.saleCountLabel.setEndsWith3Points(false);
        if (!hadUsed) {
            Container endTimeContainer = new Container();
            previewContainer.addComponent(endTimeContainer);
            endTimeContainer.setPreferredW(350);
            endTimeContainer.setPreferredH(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getHeight());
            endTimeContainer.setLayout(new CoordinateLayout(endTimeContainer.getPreferredW(), endTimeContainer.getPreferredH()));
            endTimeContainer.getStyle().setMargin(0, 5);
            this.endTimeLabel = new Label("\u5230\u671f\u65f6\u95f4:" + CalendarFormat.toYMD(coupon.expireTimeCalendar));
            endTimeContainer.addComponent(this.endTimeLabel);
            this.endTimeLabel.getStyle().setAlignment(4);
            this.endTimeLabel.getStyle().setFont(UserInterface.FONT_SMALL);
            this.endTimeLabel.getStyle().setFgColor(0xFFFFFF);
            this.endTimeLabel.setPreferredW(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getWidth());
            this.endTimeLabel.setPreferredH(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getHeight());
            this.endTimeLabel.getStyle().setBgImage(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE);
            this.endTimeLabel.setX((endTimeContainer.getPreferredW() - this.endTimeLabel.getPreferredW()) / 2);
            this.endTimeLabel.setY(0);
        }
        ContentContainer previewContentContainer = new ContentContainer(previewContainer, UserImages.USERCONTAINER_PREVIEW_BOTTOM_IMAGE, 0, 15);
        this.sampleContainer.addComponent(previewContentContainer);
        previewContentContainer.getStyle().setMargin(0, 5);
        Deal deal = BasePage.clientInfo.getDealDetail(coupon.dealId);
        if (deal != null) {
            this.showDeal(deal);
        }
        this.onRefresh();
    }

    protected void onRefreshClicked() {
        this.onRefresh();
    }

    private void onRefresh() {
        if (this._coupon != null && this._coupon.dealId != null) {
            if (this.dealDownload == null) {
                this.dealDownload = new DataDownload();
                this.dealDownload.addDownloadListener(this.listener);
            } else {
                this.dealDownload.cancel();
            }
            this.dealDownload.couponDetail(this._coupon.dealId);
        }
    }

    protected void onBack() {
        if (this.dealDownload != null) {
            this.dealDownload.cancel();
        }
        this.endRefresh();
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        if (this.titleContainer != null) {
            this.titleContainer.clearActionListener();
        }
        this.titleContainer = null;
        this.currentPriceLabel = null;
        this.discountLabel = null;
        this.marketPriceLabel = null;
        this.saleCountLabel = null;
        this.endTimeLabel = null;
        if (this.qrcodeDownload != null && this.qrcodeDownload.isDownloading()) {
            this.qrcodeDownload.cancel();
        }
        System.gc();
        super.onBack();
    }

    private void showDeal(Deal deal) {
        if (deal == null) {
            return;
        }
        try {
            this._deal = deal;
            if (deal.currentPrice != null) {
                this.currentPriceLabel.setText("\uffe5" + Methods.formatPrice(deal.currentPrice));
            }
            if (deal.discount != null) {
                this.discountLabel.setText("\u6298\u6263:" + deal.discount + "\u6298");
            }
            if (deal.marketPrice != null) {
                this.marketPriceLabel.setText("\u539f\u4ef7:\uffe5" + Methods.formatPrice(deal.marketPrice));
            }
            if (deal.saleCount != null) {
                this.saleCountLabel.setText(deal.saleCount + "\u4eba\u5df2\u8d2d\u4e70");
                Container saleCountContainer = this.saleCountLabel.getParent();
                if (saleCountContainer != null) {
                    this.saleCountLabel.setX((saleCountContainer.getPreferredW() - this.saleCountLabel.getPreferredW()) / 2);
                }
            }
            this.repaint();
            this.detailContainer.removeAll();
            if (!Methods.isNullOrWhitespace(deal.setMeal)) {
                ContentContainer setMealContainer = new ContentContainer("\u5957\u9910\u5185\u5bb9", deal.setMeal);
                this.detailContainer.addComponent(setMealContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.highlights)) {
                ContentContainer highlightsContainer = new ContentContainer("\u7279\u8272\u4eae\u70b9", deal.highlights);
                this.detailContainer.addComponent(highlightsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.consumerTips)) {
                ContentContainer consumerTipsContainer = new ContentContainer("\u6d88\u8d39\u63d0\u793a", deal.consumerTips);
                this.detailContainer.addComponent(consumerTipsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.businessInfo)) {
                ContentContainer businessContainer = new ContentContainer("\u5546\u5bb6\u4fe1\u606f", deal.businessInfo);
                this.detailContainer.addComponent(businessContainer);
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onPhoneClicked() {
        if (this._deal == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else if (this._deal.business == null || this._deal.business.size() <= 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u7535\u8bdd\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            PhoneListPage.Show(this.self, this._deal.business);
        }
    }

    private void onAddressClicked() {
        if (this._deal == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else if (this._deal.business == null || this._deal.business.size() <= 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u5730\u5740\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            AddressListPage.Show(this.self, this._deal.business);
        }
    }

    private void onShareClicked() {
        if (this._coupon != null && !Methods.isNullOrWhitespace(this._coupon.share)) {
            PhoneFunction.callSendSMS(this._coupon.share);
        }
    }
}

