/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.Coupon;
import com.nuomi.data.FindMyNuomiInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.ListBoxClickedListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.CouponDetailPage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.CatalogSelectorControl;
import com.nuomi.usercontrol.ListBox;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.usercontrol.MoreTopButton;
import com.nuomi.usercontrol.couponlistpage.UnusedCouponListBoxItem;
import com.nuomi.usercontrol.couponlistpage.UsedCouponListBoxItem;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class CouponListPage
extends BasePage {
    private static CouponListPage _CouponListPage = null;
    private Container nousedContainer = null;
    private Container[] scrollContainers = null;
    private Container[] innerContainers = null;
    private ListBox[] listBoxs = null;
    private boolean[] userChanged = null;
    private boolean[] downloading = null;
    private Label[] nuomiLogoLabels = null;
    private MoreTopButton[] moreTopButtons = null;
    private CatalogSelectorControl useSelectorControl = null;
    private CatalogSelectorControl nousedStateSelectorControl = null;
    private boolean showByHideMessageBox = false;
    private DataDownloadListener refreshDownloadListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            CouponListPage.this.startRefresh();
            if (tag != null && tag instanceof Integer) {
                int index = (Integer)tag;
                try {
                    ((CouponListPage)CouponListPage.this).downloading[index] = true;
                    ((CouponListPage)CouponListPage.this).userChanged[index] = false;
                    CouponListPage.this.moreTopButtons[index].setIsLoading(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            int index = -1;
            String hintText = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (tag != null && tag instanceof Integer) {
                index = (Integer)tag;
                ((CouponListPage)CouponListPage.this).downloading[index] = false;
                if (result == 2 && data instanceof FindMyNuomiInfo) {
                    FindMyNuomiInfo info = (FindMyNuomiInfo)data;
                    if (info.result.isSucceed()) {
                        BasePage.clientInfo.setCouponInfo(info, index);
                        CouponListPage.this.showRefresh(BasePage.clientInfo.getCouponInfo(index), index);
                    } else if (info.result.isLogExpired()) {
                        if (CouponListPage.this.getCurrentForm() == CouponListPage.this.self && !MessageBox.isShow) {
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(CouponListPage.this.self, true);
                            } else {
                                CouponListPage.this.showByHideMessageBox = true;
                                ((CouponListPage)CouponListPage.this).userChanged[index] = true;
                                showHint = false;
                            }
                        }
                    } else {
                        hintText = info.result.msg;
                    }
                }
                if (showHint && result != 3) {
                    CouponListPage.this.showHint(String.valueOf(hintText) + "(" + ClientInfo.Coupon_AllCatalogNames[index] + "\u7cef\u7c73\u5238)");
                }
                if (CouponListPage.this.moreTopButtons[index] != null) {
                    CouponListPage.this.moreTopButtons[index].setIsLoading(false);
                }
                if (CouponListPage.this.getCurrentShownList() == index) {
                    CouponListPage.this.endRefresh();
                }
                CouponListPage.this.repaint();
            }
        }
    };
    private DataDownloadListener moreDownloadListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            CouponListPage.this.startRefresh();
            if (tag != null && tag instanceof Integer) {
                int index = (Integer)tag;
                try {
                    ((CouponListPage)CouponListPage.this).downloading[index] = true;
                    CouponListPage.this.moreTopButtons[index].setIsLoading(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            int index = -1;
            String hintText = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (tag != null && tag instanceof Integer) {
                index = (Integer)tag;
                ((CouponListPage)CouponListPage.this).downloading[index] = false;
                if (result == 2 && data instanceof FindMyNuomiInfo) {
                    FindMyNuomiInfo info = (FindMyNuomiInfo)data;
                    if (info.result.isSucceed()) {
                        BasePage.clientInfo.addCouponInfo(info, index);
                        CouponListPage.this.showMore(BasePage.clientInfo.getCouponInfo(index), index);
                    } else if (info.result.isLogExpired()) {
                        if (CouponListPage.this.getCurrentForm() == CouponListPage.this.self && !MessageBox.isShow) {
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(CouponListPage.this.self, true);
                            } else {
                                showHint = false;
                            }
                        }
                    } else {
                        hintText = info.result.msg;
                    }
                }
                if (showHint && result != 3) {
                    CouponListPage.this.showHint(String.valueOf(hintText) + "(" + ClientInfo.Coupon_AllCatalogNames[index] + ")");
                }
                if (CouponListPage.this.moreTopButtons[index] != null) {
                    CouponListPage.this.moreTopButtons[index].setIsLoading(false);
                }
                if (CouponListPage.this.getCurrentShownList() == index) {
                    CouponListPage.this.endRefresh();
                }
                CouponListPage.this.repaint();
            }
        }
    };

    public static void Show(BasePage parentPage, int selectedIndex, boolean needRefresh) {
        if (_CouponListPage == null) {
            _CouponListPage = new CouponListPage();
        }
        _CouponListPage.setParent(parentPage);
        if (needRefresh) {
            int i = 0;
            while (i < CouponListPage._CouponListPage.userChanged.length) {
                CouponListPage._CouponListPage.userChanged[i] = true;
                ++i;
            }
        }
        switch (selectedIndex) {
            case 0: 
            case 1: {
                CouponListPage._CouponListPage.useSelectorControl.setSelectedIndex(0);
                CouponListPage._CouponListPage.nousedStateSelectorControl.setSelectedIndex(selectedIndex);
                break;
            }
            case 2: {
                CouponListPage._CouponListPage.useSelectorControl.setSelectedIndex(1);
                break;
            }
        }
        _CouponListPage.show();
    }

    public static void Show(BasePage parentPage) {
        CouponListPage.Show(parentPage, 0, false);
    }

    private CouponListPage() {
        this.self.setTitle("\u6211\u7684\u7cef\u7c73\u5238");
        this.sendListenerWhenHidden = true;
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.scrollContainers = new Container[ClientInfo.Coupon_All_Index.length];
        this.innerContainers = new Container[ClientInfo.Coupon_All_Index.length];
        this.listBoxs = new ListBox[ClientInfo.Coupon_All_Index.length];
        this.userChanged = new boolean[ClientInfo.Coupon_All_Index.length];
        this.downloading = new boolean[ClientInfo.Coupon_All_Index.length];
        this.nuomiLogoLabels = new Label[ClientInfo.Coupon_All_Index.length];
        this.moreTopButtons = new MoreTopButton[ClientInfo.Coupon_All_Index.length];
        int i = 0;
        while (i < ClientInfo.Coupon_All_Index.length) {
            this.downloading[i] = false;
            this.userChanged[i] = false;
            ++i;
        }
        String[] catalogNames = new String[]{"\u672a\u4f7f\u7528", ClientInfo.Coupon_AllCatalogNames[3]};
        this.useSelectorControl = new CatalogSelectorControl(catalogNames, 4);
        this.mainContainer.addComponent(this.useSelectorControl);
        this.useSelectorControl.setX(0);
        this.useSelectorControl.setY(0);
        this.useSelectorControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                CouponListPage.this.onUseCatalogSelectChanged(index);
            }
        });
    }

    protected void onShowCompleted() {
        if (!this.showByHideMessageBox) {
            try {
                int index = this.getCurrentShownList();
                if (this.userChanged[index]) {
                    this.onRefresh(index);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.showByHideMessageBox = false;
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        int i = 0;
        while (i < this.userChanged.length) {
            this.userChanged[i] = true;
            if (this.listBoxs[i] != null) {
                this.listBoxs[i].removeAll();
            }
            ++i;
        }
        System.gc();
    }

    protected void onRefreshClicked() {
        try {
            this.dataDownloadRefresh(this.getCurrentShownList());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void selectedCoupon(Coupon coupon, boolean hadUsed) {
        CouponDetailPage.Show(this.self, coupon, hadUsed);
    }

    private int getCurrentShownList() {
        switch (this.useSelectorControl.getSelectedIndex()) {
            case 0: {
                return this.nousedStateSelectorControl.getSelectedIndex();
            }
            case 1: {
                return 3;
            }
        }
        return -1;
    }

    private void onUseCatalogSelectChanged(int index) {
        switch (index) {
            case 0: {
                if (this.nousedContainer == null) {
                    int nousedWidth = this.mainContainer.getPreferredW();
                    int nousedHeight = this.mainContainer.getPreferredH() - this.useSelectorControl.getPreferredH();
                    this.nousedContainer = new Container(new CoordinateLayout(nousedWidth, nousedHeight));
                    this.nousedContainer.setPreferredW(nousedWidth);
                    this.nousedContainer.setPreferredH(nousedHeight);
                    this.nousedContainer.setX(0);
                    this.nousedContainer.setY(this.useSelectorControl.getPreferredH());
                    Image usedStateSelectorBgImage = UserImages.NUOMI_LISTBOXITEM_BG_IMAGE.scaled(UserInterface.DISPLAY_WIDTH, 50);
                    String[] catalogNames = new String[]{ClientInfo.Coupon_AllCatalogNames[0], ClientInfo.Coupon_AllCatalogNames[1]};
                    this.nousedStateSelectorControl = new CatalogSelectorControl(catalogNames, 3, usedStateSelectorBgImage, UserImages.CATALOG_SECONDLEVEL_SELECTOR_FOCUS_IMAGE);
                    this.nousedContainer.addComponent(this.nousedStateSelectorControl);
                    this.nousedStateSelectorControl.setX(0);
                    this.nousedStateSelectorControl.setY(0);
                    this.nousedStateSelectorControl.addChangedListener(new SelectionChangedListener(){

                        public void onChanged(int index) {
                            CouponListPage.this.onNouseStateSelectChanged(index);
                        }
                    });
                }
                if (this.scrollContainers[3] != null && this.mainContainer.contains(this.scrollContainers[3])) {
                    this.mainContainer.removeComponent(this.scrollContainers[3]);
                }
                if (this.mainContainer.contains(this.nousedContainer)) break;
                this.mainContainer.addComponent(this.nousedContainer);
                break;
            }
            case 1: {
                if (this.downloading[3]) {
                    this.startRefresh();
                }
                if (this.scrollContainers[3] == null) {
                    int usedWidth = this.mainContainer.getPreferredW();
                    int usedHeight = this.mainContainer.getPreferredH() - this.useSelectorControl.getPreferredH();
                    this.scrollContainers[3] = new Container(new CoordinateLayout(usedWidth, usedHeight));
                    this.scrollContainers[3].setPreferredW(usedWidth);
                    this.scrollContainers[3].setPreferredH(usedHeight);
                    this.scrollContainers[3].setX(0);
                    this.scrollContainers[3].setY(this.useSelectorControl.getPreferredH());
                    this.scrollContainers[3].setScrollableY(true);
                    this.nuomiLogoLabels[3] = UserInterface.createNuomiLogoLabel();
                    this.scrollContainers[3].addComponent(this.nuomiLogoLabels[3]);
                    this.nuomiLogoLabels[3].setX((UserInterface.DISPLAY_WIDTH - this.nuomiLogoLabels[3].getPreferredW()) / 2);
                    this.nuomiLogoLabels[3].setY(200);
                    if (this.innerContainers[3] == null) {
                        this.innerContainers[3] = new Container(new BoxLayout(2));
                        this.innerContainers[3].setX(0);
                        this.innerContainers[3].setY(0);
                        this.scrollContainers[3].addComponent(this.innerContainers[3]);
                        this.listBoxs[3] = new ListBox();
                        this.innerContainers[3].addComponent(this.listBoxs[3]);
                        this.listBoxs[3].addClickedListener(new ListBoxClickedListener(){

                            public void onClicked(Object itemObject) {
                                if (itemObject instanceof Coupon) {
                                    CouponListPage.this.selectedCoupon((Coupon)itemObject, true);
                                }
                            }
                        });
                    }
                    this.onRefresh(3);
                }
                if (this.nousedContainer != null && this.mainContainer.contains(this.nousedContainer)) {
                    this.mainContainer.removeComponent(this.nousedContainer);
                }
                if (!this.mainContainer.contains(this.scrollContainers[3])) {
                    this.mainContainer.addComponent(this.scrollContainers[3]);
                }
                if (!this.userChanged[3]) break;
                this.onRefresh(3);
                break;
            }
        }
        this.repaint();
    }

    private void onNouseStateSelectChanged(int index) {
        switch (index) {
            case 0: {
                if (this.downloading[0]) {
                    this.startRefresh();
                }
                if (this.scrollContainers[0] == null) {
                    int scrollWidth = this.nousedContainer.getPreferredW();
                    int scrollHeight = this.nousedContainer.getPreferredH() - this.nousedStateSelectorControl.getPreferredH();
                    this.scrollContainers[0] = new Container(new CoordinateLayout(scrollWidth, scrollHeight));
                    this.scrollContainers[0].setPreferredW(scrollWidth);
                    this.scrollContainers[0].setPreferredH(scrollHeight);
                    this.scrollContainers[0].setX(0);
                    this.scrollContainers[0].setY(this.nousedStateSelectorControl.getPreferredH());
                    this.scrollContainers[0].setScrollableY(true);
                    this.nuomiLogoLabels[0] = UserInterface.createNuomiLogoLabel();
                    this.scrollContainers[0].addComponent(this.nuomiLogoLabels[0]);
                    this.nuomiLogoLabels[0].setX((UserInterface.DISPLAY_WIDTH - this.nuomiLogoLabels[0].getPreferredW()) / 2);
                    this.nuomiLogoLabels[0].setY(200 - this.nousedStateSelectorControl.getPreferredH());
                    if (this.innerContainers[0] == null) {
                        this.innerContainers[0] = new Container(new BoxLayout(2));
                        this.innerContainers[0].setX(0);
                        this.innerContainers[0].setY(0);
                        this.scrollContainers[0].addComponent(this.innerContainers[0]);
                        this.listBoxs[0] = new ListBox();
                        this.innerContainers[0].addComponent(this.listBoxs[0]);
                        this.listBoxs[0].addClickedListener(new ListBoxClickedListener(){

                            public void onClicked(Object itemObject) {
                                if (itemObject instanceof Coupon) {
                                    CouponListPage.this.selectedCoupon((Coupon)itemObject, false);
                                }
                            }
                        });
                    }
                    this.onRefresh(0);
                }
                if (this.scrollContainers[1] != null && this.nousedContainer.contains(this.scrollContainers[1])) {
                    this.nousedContainer.removeComponent(this.scrollContainers[1]);
                }
                if (!this.nousedContainer.contains(this.scrollContainers[0])) {
                    this.nousedContainer.addComponent(this.scrollContainers[0]);
                }
                if (!this.userChanged[0]) break;
                this.onRefresh(0);
                break;
            }
            case 1: {
                if (this.downloading[1]) {
                    this.startRefresh();
                }
                if (this.scrollContainers[1] == null) {
                    int scrollWidth = this.nousedContainer.getPreferredW();
                    int scrollHeight = this.nousedContainer.getPreferredH() - this.nousedStateSelectorControl.getPreferredH();
                    this.scrollContainers[1] = new Container(new CoordinateLayout(scrollWidth, scrollHeight));
                    this.scrollContainers[1].setPreferredW(scrollWidth);
                    this.scrollContainers[1].setPreferredH(scrollHeight);
                    this.scrollContainers[1].setX(0);
                    this.scrollContainers[1].setY(this.nousedStateSelectorControl.getPreferredH());
                    this.scrollContainers[1].setScrollableY(true);
                    this.nuomiLogoLabels[1] = UserInterface.createNuomiLogoLabel();
                    this.scrollContainers[1].addComponent(this.nuomiLogoLabels[1]);
                    this.nuomiLogoLabels[1].setX((UserInterface.DISPLAY_WIDTH - this.nuomiLogoLabels[1].getPreferredW()) / 2);
                    this.nuomiLogoLabels[1].setY(200 - this.nousedStateSelectorControl.getPreferredH());
                    if (this.innerContainers[1] == null) {
                        this.innerContainers[1] = new Container(new BoxLayout(2));
                        this.innerContainers[1].setX(0);
                        this.innerContainers[1].setY(0);
                        this.scrollContainers[1].addComponent(this.innerContainers[1]);
                        this.listBoxs[1] = new ListBox();
                        this.innerContainers[1].addComponent(this.listBoxs[1]);
                        this.listBoxs[1].addClickedListener(new ListBoxClickedListener(){

                            public void onClicked(Object itemObject) {
                                if (itemObject instanceof Coupon) {
                                    CouponListPage.this.selectedCoupon((Coupon)itemObject, false);
                                }
                            }
                        });
                    }
                    this.onRefresh(1);
                }
                if (this.scrollContainers[0] != null && this.nousedContainer.contains(this.scrollContainers[0])) {
                    this.nousedContainer.removeComponent(this.scrollContainers[0]);
                }
                if (!this.nousedContainer.contains(this.scrollContainers[1])) {
                    this.nousedContainer.addComponent(this.scrollContainers[1]);
                }
                if (!this.userChanged[1]) break;
                this.onRefresh(1);
                break;
            }
        }
    }

    private void onRefresh(int index) {
        this.listBoxs[index].removeAll();
        Vector coupons = BasePage.clientInfo.getCouponInfo(index);
        if (coupons != null) {
            this.nuomiLogoLabels[index].setVisible(false);
            this.repaint();
            this.showRefresh(coupons, index);
        } else {
            this.removeMoreTopButton(index);
            this.scrollContainers[index].setScrollableY(false);
            this.nuomiLogoLabels[index].setVisible(true);
            this.repaint();
        }
        this.dataDownloadRefresh(index);
    }

    private void onMore(int index) {
        Vector coupons = BasePage.clientInfo.getCouponInfo(index);
        if (coupons != null) {
            int listCount;
            int count = coupons.size();
            if (count > (listCount = this.listBoxs[index].getCount())) {
                this.showMore(coupons, index);
            } else {
                this.dataDownloadMore(index, count, 10);
            }
        }
    }

    private void showRefresh(Vector couponList, int index) {
        if (couponList == null || index <= -1 || index >= ClientInfo.Coupon_All_Index.length) {
            return;
        }
        this.removeMoreTopButton(index);
        this.nuomiLogoLabels[index].setVisible(false);
        this.listBoxs[index].removeAll();
        int length = couponList.size();
        int i = 0;
        while (i < Math.min(10, length)) {
            Coupon coupon = (Coupon)couponList.elementAt(i);
            ListBoxItem item = null;
            if (index == 1) {
                item = new UnusedCouponListBoxItem(coupon, 1);
            } else if (index == 0) {
                item = new UnusedCouponListBoxItem(coupon, 0);
            } else if (index == 3) {
                item = new UsedCouponListBoxItem(coupon);
            }
            if (item != null) {
                this.listBoxs[index].addItem(item);
            }
            ++i;
        }
        this.scrollContainers[index].setScrollY(0);
        if (this.listBoxs[index].getCount() == 0) {
            String hintString = null;
            if (index == 1 || index == 0) {
                hintString = "\u6ca1\u6709\u672a\u4f7f\u7528\u7684\u7cef\u7c73\u5238";
            } else if (index == 3) {
                hintString = "\u6ca1\u6709\u5df2\u4f7f\u7528\u7684\u7cef\u7c73\u5238";
            }
            this.listBoxs[index].showHint(hintString);
            this.scrollContainers[index].setScrollableY(false);
        } else {
            this.scrollContainers[index].setScrollableY(true);
        }
        this.scrollContainers[index].setScrollSize(null);
        this.addMoreTopButton(index);
        this.repaint();
    }

    private void showMore(Vector couponList, int index) {
        int start;
        if (couponList == null || index <= -1 || index >= ClientInfo.Coupon_All_Index.length) {
            return;
        }
        this.removeMoreTopButton(index);
        int length = couponList.size();
        int i = start = this.listBoxs[index].getCount();
        while (i < Math.min(length, start + 10)) {
            Coupon coupon = (Coupon)couponList.elementAt(i);
            ListBoxItem item = null;
            if (index == 1) {
                item = new UnusedCouponListBoxItem(coupon, 1);
            } else if (index == 0) {
                item = new UnusedCouponListBoxItem(coupon, 0);
            } else if (index == 3) {
                item = new UsedCouponListBoxItem(coupon);
            }
            if (item != null) {
                this.listBoxs[index].addItem(item);
            }
            ++i;
        }
        this.scrollContainers[index].setScrollSize(null);
        this.addMoreTopButton(index);
        this.repaint();
    }

    private void dataDownloadRefresh(int index) {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                if (MessageBox.Show("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                    LogPage.Show(this.self);
                } else {
                    this.repaint();
                }
            }
        } else {
            DataDownload dataDownload = new DataDownload();
            dataDownload.addDownloadListener(this.refreshDownloadListener);
            dataDownload.couponAll(userInfo.userId, userInfo.ticket, 0, 20, index);
        }
    }

    private void dataDownloadMore(int index, int start, int offset) {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                if (MessageBox.Show("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                    LogPage.Show(this.self);
                } else {
                    this.repaint();
                }
            }
        } else {
            DataDownload dataDownload = new DataDownload();
            dataDownload.addDownloadListener(this.moreDownloadListener);
            dataDownload.couponAll(userInfo.userId, userInfo.ticket, start, offset, index);
        }
    }

    private void removeMoreTopButton(int index) {
        this.scrollContainers[index].setScrollSize(null);
        if (this.moreTopButtons[index] != null && this.innerContainers[index].contains(this.moreTopButtons[index])) {
            this.innerContainers[index].removeComponent(this.moreTopButtons[index]);
        }
    }

    private void addMoreTopButton(final int index) {
        if (this.moreTopButtons[index] == null) {
            this.moreTopButtons[index] = new MoreTopButton();
            if (this.downloading[index]) {
                this.moreTopButtons[index].setIsLoading(true);
            }
            this.moreTopButtons[index].addTopListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CouponListPage.this.scrollContainers[index].setScrollY(0);
                }
            });
            this.moreTopButtons[index].addMoreListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CouponListPage.this.onMore(index);
                }
            });
        }
        boolean needAddTop = false;
        boolean needAddMore = false;
        if (this.scrollContainers[index].getScrollDimension().getHeight() > this.scrollContainers[index].getPreferredH()) {
            needAddTop = true;
        }
        if (BasePage.clientInfo.getCouponCount(index) > this.listBoxs[index].getCount()) {
            needAddMore = true;
        }
        if (needAddMore || needAddTop) {
            if (!this.innerContainers[index].contains(this.moreTopButtons[index])) {
                int scrollAbledH = this.scrollContainers[index].getScrollDimension().getHeight();
                Dimension d = new Dimension(UserInterface.DISPLAY_WIDTH, scrollAbledH + this.moreTopButtons[index].getPreferredH());
                this.innerContainers[index].addComponent(this.moreTopButtons[index]);
                this.scrollContainers[index].setScrollSize(d);
            }
            this.moreTopButtons[index].showButton(needAddTop, needAddMore);
        }
        this.scrollContainers[index].setScrollSize(null);
    }
}

