/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.City;
import com.nuomi.data.Deal;
import com.nuomi.data.DealEndTime;
import com.nuomi.data.DealPreview;
import com.nuomi.data.LotteryDeal;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.CountDownEndListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.ActivePage;
import com.nuomi.pages.AddressListPage;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.BuyPage;
import com.nuomi.pages.JoinLotteryPage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.PhoneListPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.usercontrol.ItemButtonGroup;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TabControl;
import com.nuomi.usercontrol.dealdetail.CountDownLabel;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class DealDetailPage
extends BasePage {
    private static DealDetailPage _DealDetailPage = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private DealPreview _dealPreview = null;
    private CountDownLabel countDownLabel = null;
    private Button buyButton = null;
    private Label saleCountLabel = null;
    private ContentContainer previewContentContainer = null;
    private Container previewContainer = null;
    private Container blueContainer = null;
    private Container sampleContainer = null;
    private Container detailContainer = null;
    private DataDownload dealDownload = null;
    private ActionListener buyActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            UserInfo userInfo = BasePage.clientInfo.getUserInfo();
            if (userInfo == null) {
                if (DealDetailPage.this.getCurrentForm() == DealDetailPage.this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u672a\u767b\u5f55\u8d26\u53f7", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                    LogPage.Show(DealDetailPage.this.self);
                }
            } else if (userInfo.actived != null && userInfo.actived.booleanValue()) {
                if (DealDetailPage.this._dealPreview != null) {
                    if (((DealDetailPage)DealDetailPage.this)._dealPreview.isLottery == null || !((DealDetailPage)DealDetailPage.this)._dealPreview.isLottery.booleanValue()) {
                        BuyPage.Show(DealDetailPage.this.self, DealDetailPage.this._dealPreview);
                    } else {
                        JoinLotteryPage.Show(DealDetailPage.this.self, DealDetailPage.this._dealPreview);
                    }
                }
            } else if (DealDetailPage.this.getCurrentForm() == DealDetailPage.this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u672a\u6fc0\u6d3b\u8d26\u53f7", "\u7acb\u5373\u6fc0\u6d3b", "\u53d6\u6d88") == MessageBox.OK) {
                ActivePage.Show(DealDetailPage.this.self);
            }
        }
    };
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            DealDetailPage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2) {
                BasePage.clientInfo.setDealDetail(((DealDetailPage)DealDetailPage.this)._dealPreview.dealId, data);
                if (data instanceof Deal) {
                    DealDetailPage.this.showDeal((Deal)data);
                }
                if (data instanceof LotteryDeal) {
                    DealDetailPage.this.showLotteryDeal((LotteryDeal)data);
                }
                if (data instanceof DealEndTime) {
                    if (((DealDetailPage)DealDetailPage.this)._dealPreview.soldOut != null && ((DealDetailPage)DealDetailPage.this)._dealPreview.soldOut.booleanValue()) {
                        DealDetailPage.this.countDownLabel.setText(null);
                    } else {
                        DealDetailPage.this.countDownLabel.setText(((DealEndTime)data).endTime);
                    }
                }
                DealDetailPage.this.self.repaint();
            }
            if (result != 3) {
                DealDetailPage.this.showHint(hintString);
                DealDetailPage.this.endRefresh();
            }
        }
    };

    public static void Show(BasePage parentPage, DealPreview dealPreview) {
        if (_DealDetailPage == null) {
            _DealDetailPage = new DealDetailPage();
        }
        _DealDetailPage.setContent(dealPreview);
        _DealDetailPage.setParent(parentPage);
        _DealDetailPage.show();
    }

    private DealDetailPage() {
        this.setTitleFont(UserInterface.FONT_TITLEBAR);
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        TabControl tabControl = new TabControl(UserImages.DETAIL_TAB_BG_IMAGE, UserImages.DETAIL_TABS_IMAGES, false);
        tabControl.setX(0);
        tabControl.setY(this.mainContainer.getPreferredH() - tabControl.getPreferredH());
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - tabControl.getClickHeight());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 10);
        this.sampleContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.sampleContainer);
        this.detailContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.detailContainer);
        ItemButton serviceButton = new ItemButton(3, "\u7cef\u7c73\u5ba2\u670d:4006-888-887", UserImages.ICON_PHONE_IMAGE, false);
        serviceButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                PhoneFunction.callNuomiServicePhone();
            }
        });
        ItemButton[] itemButtons = new ItemButton[]{serviceButton};
        ItemButtonGroup serviceContainer = new ItemButtonGroup(itemButtons);
        this.innerContainer.addComponent(serviceContainer);
        serviceContainer.getStyle().setMargin(0, 5);
        this.mainContainer.addComponent(tabControl);
        tabControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                switch (index) {
                    case 0: {
                        DealDetailPage.this.onPhoneClicked();
                        break;
                    }
                    case 1: {
                        DealDetailPage.this.onAddressClicked();
                        break;
                    }
                    case 2: {
                        DealDetailPage.this.onShareClicked();
                        break;
                    }
                }
            }
        });
    }

    protected void onCityChanged(City newCity) {
        if (newCity != null) {
            this.setTitle(newCity.shortName);
        }
    }

    protected void onRefreshClicked() {
        this.onRefresh();
    }

    private void setContent(DealPreview dealPreview) {
        City city = BasePage.clientInfo.getCity();
        if (city != null) {
            this.self.setTitle(city.shortName);
        }
        this.scrollContainer.setScrollY(0);
        this._dealPreview = dealPreview;
        if (dealPreview == null) {
            return;
        }
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        this.previewContainer = new Container(new BoxLayout(2));
        this.previewContainer.getStyle().setPadding(1, 10);
        this.previewContainer.getStyle().setPadding(3, 10);
        if (dealPreview.middleTitle != null) {
            Vector middleTitleVector = Methods.splitString(dealPreview.middleTitle, UserInterface.FONT_NORMAL, 0, 325);
            LabelGroup middleTitleGroup = new LabelGroup(middleTitleVector, UserInterface.FONT_NORMAL, 6453130, 330, 25);
            this.previewContainer.addComponent(middleTitleGroup);
            middleTitleGroup.getStyle().setMargin(1, 10);
        }
        int imagePriceWidth = 340;
        int imagePriceHeight = 99;
        Container imagePriceContainer = new Container(new CoordinateLayout(imagePriceWidth, imagePriceHeight));
        imagePriceContainer.setPreferredW(imagePriceWidth);
        imagePriceContainer.setPreferredH(imagePriceHeight);
        this.previewContainer.addComponent(imagePriceContainer);
        imagePriceContainer.getStyle().setMargin(0, 5);
        imagePriceContainer.getStyle().setMargin(1, 10);
        ImageControl image = new ImageControl(165, imagePriceHeight);
        imagePriceContainer.addComponent(image);
        image.setX(0);
        image.setY(0);
        image.setImage(dealPreview.image, true);
        Container priceContainer = new Container(new CoordinateLayout(imagePriceWidth - image.getPreferredW() - 5, imagePriceHeight));
        priceContainer.setPreferredW(imagePriceWidth - image.getPreferredW() - 5);
        priceContainer.setPreferredH(imagePriceHeight);
        imagePriceContainer.addComponent(priceContainer);
        priceContainer.setX(image.getPreferredW() + 20);
        priceContainer.setY(0);
        Label currentPriceLabel = new Label();
        currentPriceLabel.setText("\uffe5" + Methods.formatPrice(dealPreview.currentPrice));
        currentPriceLabel.getStyle().setFont(UserInterface.FONT_LARGE);
        priceContainer.addComponent(currentPriceLabel);
        currentPriceLabel.setX(0);
        currentPriceLabel.setY(0);
        Label discountLabel = new Label();
        discountLabel.setText("\u6298\u6263:" + dealPreview.discount + "\u6298");
        discountLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(discountLabel);
        discountLabel.setX(0);
        discountLabel.setY(priceContainer.getPreferredH() - discountLabel.getPreferredH());
        Label marketPriceLabel = new Label();
        marketPriceLabel.setText("\u539f\u4ef7:\uffe5" + Methods.formatPrice(dealPreview.marketPrice));
        marketPriceLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(marketPriceLabel);
        marketPriceLabel.setX(0);
        marketPriceLabel.setY(priceContainer.getPreferredH() - discountLabel.getPreferredH() - marketPriceLabel.getPreferredH());
        int blueWidth = UserImages.USERCONTAINER_LIGHTBLUE_IMAGE.getWidth();
        this.blueContainer = new Container(new BoxLayout(2));
        this.previewContainer.addComponent(this.blueContainer);
        this.blueContainer.getStyle().setMargin(0, 5);
        this.blueContainer.getStyle().setMargin(1, 5);
        this.blueContainer.getStyle().setMargin(3, 5);
        this.blueContainer.getStyle().setPadding(0, 5);
        this.blueContainer.getStyle().setPadding(2, 5);
        this.blueContainer.getStyle().setBgImage(UserImages.USERCONTAINER_LIGHTBLUE_IMAGE);
        Container countDownContainer = new Container(new BorderLayout());
        this.blueContainer.addComponent(countDownContainer);
        this.countDownLabel = new CountDownLabel();
        countDownContainer.addComponent("West", (Component)this.countDownLabel);
        countDownContainer.getStyle().setMargin(1, Math.max(0, (blueWidth - this.countDownLabel.getPreferredW()) / 2));
        this.countDownLabel.addEndListener(new CountDownEndListener(){

            public void onStart() {
                if (DealDetailPage.this.buyButton != null && !DealDetailPage.this.buyButton.isEnabled()) {
                    if (DealDetailPage.this._dealPreview != null && ((DealDetailPage)DealDetailPage.this)._dealPreview.isLottery != null && ((DealDetailPage)DealDetailPage.this)._dealPreview.isLottery.booleanValue()) {
                        DealDetailPage.this.buyButton.setIcon(UserImages.DEALDETAIL_LOTTERY_NORMAL_IMAGE);
                        DealDetailPage.this.buyButton.setPressedIcon(UserImages.DEALDETAIL_LOTTERY_PRESSED_IMAGE);
                    } else {
                        DealDetailPage.this.buyButton.setIcon(UserImages.DEALDETAIL_BUY_NORMAL_IMAGE);
                        DealDetailPage.this.buyButton.setPressedIcon(UserImages.DEALDETAIL_BUY_PRESSED_IMAGE);
                    }
                    DealDetailPage.this.buyButton.setEnabled(true);
                }
            }

            public void onEnd(boolean isTimeEnd) {
                if (DealDetailPage.this.buyButton != null) {
                    DealDetailPage.this.buyButton.setEnabled(false);
                    DealDetailPage.this.buyButton.setPressedIcon(null);
                    if (((DealDetailPage)DealDetailPage.this)._dealPreview.isLottery != null && ((DealDetailPage)DealDetailPage.this)._dealPreview.isLottery.booleanValue()) {
                        DealDetailPage.this.buyButton.setIcon(UserImages.DEALDETAIL_LOTTERY_END_IMAGE);
                    } else {
                        long currentTime = System.currentTimeMillis() + ClientInfo.timeRelativeError;
                        if (currentTime > ((DealDetailPage)DealDetailPage.this)._dealPreview.endTime) {
                            DealDetailPage.this.buyButton.setIcon(UserImages.DEALDETAIL_BUY_END_IMAGE);
                        } else {
                            DealDetailPage.this.buyButton.setIcon(UserImages.DEALDETAIL_SOLD_OUT_IMAGE);
                        }
                    }
                }
                if (isTimeEnd) {
                    DealDetailPage.this.onRefreshEndTime();
                }
            }
        });
        this.buyButton = dealPreview.isLottery == null || dealPreview.isLottery == false ? UserInterface.createIconOnlyButton(UserImages.DEALDETAIL_BUY_NORMAL_IMAGE, UserImages.DEALDETAIL_BUY_PRESSED_IMAGE) : UserInterface.createIconOnlyButton(UserImages.DEALDETAIL_LOTTERY_NORMAL_IMAGE, UserImages.DEALDETAIL_LOTTERY_PRESSED_IMAGE);
        this.blueContainer.addComponent(this.buyButton);
        this.buyButton.addActionListener(this.buyActionListener);
        this.saleCountLabel = new Label();
        this.saleCountLabel.setText(dealPreview.saleCount + "\u4eba\u5df2\u8d2d\u4e70");
        this.saleCountLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.blueContainer.addComponent(this.saleCountLabel);
        this.saleCountLabel.setPreferredH(this.saleCountLabel.getPreferredH());
        this.saleCountLabel.setPreferredW(blueWidth);
        this.saleCountLabel.getStyle().setAlignment(4);
        this.previewContentContainer = new ContentContainer(this.previewContainer, UserImages.USERCONTAINER_PREVIEW_BOTTOM_IMAGE, 0, 0);
        this.sampleContainer.addComponent(this.previewContentContainer);
        this.previewContentContainer.getStyle().setMargin(0, 5);
        if (dealPreview.soldOut != null && dealPreview.soldOut.booleanValue()) {
            this.countDownLabel.setText(null);
        } else {
            this.countDownLabel.setText(dealPreview.endTime);
        }
        if (dealPreview.isLottery == null || !dealPreview.isLottery.booleanValue()) {
            Deal deal = BasePage.clientInfo.getDealDetail(dealPreview.dealId);
            if (deal != null) {
                this.showDeal(deal);
            } else {
                this.onRefresh();
            }
        } else {
            LotteryDeal lotteryDeal = BasePage.clientInfo.getLotteryDealDetail(dealPreview.dealId);
            if (lotteryDeal != null) {
                this.showLotteryDeal(lotteryDeal);
            } else {
                this.onRefresh();
            }
        }
    }

    private void onRefresh() {
        if (this.dealDownload == null) {
            this.dealDownload = new DataDownload();
            this.dealDownload.addDownloadListener(this.listener);
        } else {
            this.dealDownload.cancel();
        }
        if (this._dealPreview.isLottery == null || !this._dealPreview.isLottery.booleanValue()) {
            this.dealDownload.dealDetail(this._dealPreview.dealId);
        } else {
            this.dealDownload.lotteryDetail(this._dealPreview.dealId);
        }
    }

    private void onRefreshEndTime() {
        if (this.dealDownload == null) {
            this.dealDownload = new DataDownload();
            this.dealDownload.addDownloadListener(this.listener);
        }
        if (!(this.dealDownload.isDownloading() || this._dealPreview.isLottery != null && this._dealPreview.isLottery.booleanValue())) {
            this.dealDownload.dealEndTime(this._dealPreview.dealId);
        }
    }

    protected void onBack() {
        if (this.dealDownload != null) {
            this.dealDownload.cancel();
        }
        this.endRefresh();
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        if (this.countDownLabel != null) {
            this.countDownLabel.clear();
            this.countDownLabel.clearEndListener();
        }
        this.countDownLabel = null;
        if (this.buyButton != null) {
            this.buyButton.removeActionListener(this.buyActionListener);
        }
        this.buyButton = null;
        this.saleCountLabel = null;
        this.previewContentContainer = null;
        this.previewContainer = null;
        this.blueContainer = null;
        System.gc();
        super.onBack();
    }

    private void showDeal(Deal deal) {
        if (deal == null) {
            return;
        }
        try {
            String saleCountText = this.saleCountLabel.getText();
            if (Integer.parseInt(saleCountText.substring(0, saleCountText.length() - 4)) < deal.saleCount) {
                this.saleCountLabel.setText(deal.saleCount + "\u4eba\u5df2\u8d2d\u4e70");
            }
            this.repaint();
            if (deal.endTime != null && this.countDownLabel != null) {
                if (this._dealPreview.soldOut != null && this._dealPreview.soldOut.booleanValue()) {
                    this.countDownLabel.setText(null);
                } else {
                    this.countDownLabel.setText(deal.endTime);
                }
            }
            if (this.blueContainer.getComponentCount() <= 3) {
                if (deal.daysRefund != null) {
                    Container daysRefundContainer = UserInterface.createRefundContainer(true, deal.daysRefund);
                    this.blueContainer.addComponent(daysRefundContainer);
                    daysRefundContainer.getStyle().setMargin(0, 5);
                    daysRefundContainer.getStyle().setMargin(1, Math.max(0, (this.blueContainer.getPreferredW() - daysRefundContainer.getPreferredW()) / 2));
                }
                if (deal.expiredRefund != null) {
                    Container expiredRefundContainer = UserInterface.createRefundContainer(false, deal.expiredRefund);
                    this.blueContainer.addComponent(expiredRefundContainer);
                    expiredRefundContainer.getStyle().setMargin(0, 5);
                    expiredRefundContainer.getStyle().setMargin(1, Math.max(0, (this.blueContainer.getPreferredW() - expiredRefundContainer.getPreferredW()) / 2));
                }
                this.previewContentContainer.setCenterHeight(this.previewContainer.getPreferredH());
            }
            this.detailContainer.removeAll();
            if (!Methods.isNullOrWhitespace(deal.setMeal)) {
                ContentContainer setMealContainer = new ContentContainer("\u5957\u9910\u5185\u5bb9", deal.setMeal);
                this.detailContainer.addComponent(setMealContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.highlights)) {
                ContentContainer highlightsContainer = new ContentContainer("\u7279\u8272\u4eae\u70b9", deal.highlights);
                this.detailContainer.addComponent(highlightsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.consumerTips)) {
                ContentContainer consumerTipsContainer = new ContentContainer("\u6d88\u8d39\u63d0\u793a", deal.consumerTips);
                this.detailContainer.addComponent(consumerTipsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.businessInfo)) {
                ContentContainer businessContainer = new ContentContainer("\u5546\u5bb6\u4fe1\u606f", deal.businessInfo);
                this.detailContainer.addComponent(businessContainer);
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showLotteryDeal(LotteryDeal lotteryDeal) {
        if (lotteryDeal == null) {
            return;
        }
        try {
            String saleCountText = this.saleCountLabel.getText();
            if (Integer.parseInt(saleCountText.substring(0, saleCountText.length() - 4)) < lotteryDeal.saleCount) {
                this.saleCountLabel.setText(lotteryDeal.saleCount + "\u4eba\u5df2\u8d2d\u4e70");
            }
            this.repaint();
            this.detailContainer.removeAll();
            if (!Methods.isNullOrWhitespace(lotteryDeal.gameDetail)) {
                ContentContainer gameDetailContainer = new ContentContainer("\u6d3b\u52a8\u8be6\u60c5", lotteryDeal.gameDetail);
                this.detailContainer.addComponent(gameDetailContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(lotteryDeal.highlights)) {
                ContentContainer highlightsContainer = new ContentContainer("\u7279\u8272\u4eae\u70b9", lotteryDeal.highlights);
                this.detailContainer.addComponent(highlightsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(lotteryDeal.rule)) {
                ContentContainer ruleContainer = new ContentContainer("\u62bd\u5956\u89c4\u5219", lotteryDeal.rule);
                this.detailContainer.addComponent(ruleContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(lotteryDeal.businessInfo)) {
                ContentContainer businessContainer = new ContentContainer("\u5546\u5bb6\u4fe1\u606f", lotteryDeal.businessInfo);
                this.detailContainer.addComponent(businessContainer);
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onPhoneClicked() {
        if (this._dealPreview.business == null || this._dealPreview.business.size() == 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u7535\u8bdd\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            PhoneListPage.Show(this.self, this._dealPreview.business);
        }
    }

    private void onAddressClicked() {
        if (this._dealPreview.business == null || this._dealPreview.business.size() == 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u5730\u5740\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            AddressListPage.Show(this.self, this._dealPreview.business);
        }
    }

    private void onShareClicked() {
        if (this._dealPreview != null && !Methods.isNullOrWhitespace(this._dealPreview.share)) {
            PhoneFunction.callSendSMS(this._dealPreview.share);
        }
    }
}

