/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.connect.DataDownload;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;

public class FeedbackPage
extends BasePage {
    private static FeedbackPage _FeedbackPage = null;
    private final int Label_Height;
    private final String[] hintStrings = new String[]{"\u8c22\u8c22\u60a8\u53cd\u9988\u7684\u610f\u89c1\u3001\u5efa\u8bae(500\u5b57\u5185)"};
    private final String[] yourEmailStrings = new String[]{"\u60a8\u7684\u90ae\u7bb1\uff08\u9009\u586b\uff09"};
    private final String[] otherStrings = new String[]{"\u60a8\u4e5f\u53ef\u4ee5\u901a\u8fc7\u5982\u4e0b\u65b9\u5f0f\u5411\u6211\u4eec\u53cd\u9988", "\u4fe1\u606f:", "\u7cef\u7c73\u7fa4:170188028", "\u7cef\u7c73\u5fae\u535a:", "http://weibo.com/nuomiwang", "\u7cef\u7c73\u90ae\u7bb1:help@nuomi.com"};
    private TextArea suggestionTextArea = null;
    private TextArea emailTextArea = null;
    private Button submitButton = null;
    private DataDownload submitDownload = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            FeedbackPage.this.startRefresh();
            FeedbackPage.this.showRefreshIcon();
            FeedbackPage.this.submitButton.setEnabled(false);
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            if (type == 9) {
                if (result == 2) {
                    FeedbackPage.this.showHint("\u53cd\u9988\u6210\u529f\uff0c\u8c22\u8c22\u60a8\u7684\u5b9d\u8d35\u610f\u89c1");
                    FeedbackPage.this.submitButton.setEnabled(true);
                } else if (result != 3) {
                    FeedbackPage.this.showHint(DataDownload.ResultStrings[result]);
                    FeedbackPage.this.submitButton.setEnabled(true);
                }
            } else {
                FeedbackPage.this.onBack();
                FeedbackPage.this.submitButton.setEnabled(true);
            }
            FeedbackPage.this.hideRefreshIcon();
            FeedbackPage.this.endRefresh();
        }
    };

    public static void Show(BasePage parentPage) {
        if (_FeedbackPage == null) {
            _FeedbackPage = new FeedbackPage();
        }
        _FeedbackPage.setParent(parentPage);
        _FeedbackPage.show();
    }

    private FeedbackPage() {
        this.Label_Height = 30;
        this.self.setTitle("\u53cd\u9988");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new BoxLayout(2));
        Container hintContainer = new Container(new BoxLayout(2));
        this.mainContainer.addComponent(hintContainer);
        hintContainer.getStyle().setMargin(0, 10);
        hintContainer.addComponent(new LabelGroup(this.hintStrings, UserInterface.FONT_FEEDBACK, 6059405, 30));
        this.suggestionTextArea = new TextArea();
        this.suggestionTextArea.setPreferredW(344);
        this.suggestionTextArea.setPreferredH(155);
        this.suggestionTextArea.setMaxSize(500);
        this.suggestionTextArea.setWrapBySpace(false);
        Style[] styles = UserInterface.getComponentStyles(this.suggestionTextArea);
        int i = 0;
        while (i < styles.length) {
            styles[i].setFgColor(6453130);
            styles[i].setFont(UserInterface.FONT_NORMAL);
            styles[i].setBorder(null);
            styles[i].setBgTransparency(0);
            ++i;
        }
        ContentContainer suggestionContainer = new ContentContainer(this.suggestionTextArea, 0, 0);
        hintContainer.addComponent(suggestionContainer);
        suggestionContainer.getStyle().setMargin(0, 5);
        Container yourEmailContainer = new Container(new BoxLayout(2));
        this.mainContainer.addComponent(yourEmailContainer);
        yourEmailContainer.getStyle().setMargin(0, 10);
        yourEmailContainer.addComponent(new LabelGroup(this.yourEmailStrings, UserInterface.FONT_FEEDBACK, 6059405, 30));
        this.emailTextArea = UserInterface.createTextArea();
        this.emailTextArea.setPreferredW(344);
        ContentContainer emailContainer = new ContentContainer(this.emailTextArea, 0, 0);
        yourEmailContainer.addComponent(emailContainer);
        emailContainer.getStyle().setMargin(0, 5);
        this.submitButton = UserInterface.createBigButton("\u63d0\u4ea4");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FeedbackPage.this.onSubmit();
            }
        });
        Container submitContainer = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, this.submitButton.getPreferredH()));
        submitContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        submitContainer.setPreferredH(this.submitButton.getPreferredH());
        submitContainer.addComponent(this.submitButton);
        this.submitButton.setX((submitContainer.getPreferredW() - this.submitButton.getPreferredW()) / 2);
        this.submitButton.setY(0);
        submitContainer.getStyle().setMargin(0, 10);
        submitContainer.getStyle().setMargin(2, 10);
        this.mainContainer.addComponent(submitContainer);
        this.mainContainer.addComponent(new LabelGroup(this.otherStrings, UserInterface.FONT_FEEDBACK, 6059405, 30));
    }

    private void onSubmit() {
        if (Methods.isNullOrEmpty(this.suggestionTextArea.getText())) {
            this.showHint("\u610f\u89c1\u3001\u5efa\u8bae\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.submitDownload == null) {
            this.submitDownload = new DataDownload();
            this.submitDownload.addDownloadListener(this.listener);
        }
        String userId = null;
        if (BasePage.clientInfo.getUserInfo() != null) {
            userId = BasePage.clientInfo.getUserInfo().userId.toString();
        }
        this.submitDownload.feedback(this.suggestionTextArea.getText(), this.emailTextArea.getText(), userId);
    }

    protected void onBack() {
        this.suggestionTextArea.setText(null);
        this.emailTextArea.setText(null);
        super.onBack();
    }
}

