/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.connect.DataDownload;
import com.nuomi.data.City;
import com.nuomi.data.FindCitys;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.ListBoxClickedListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.HomePage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ListBox;
import com.nuomi.usercontrol.findcityspage.CityListBoxItem;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class FindCitysPage
extends BasePage {
    private static FindCitysPage s_FindCitysPage = null;
    private Container searchContainer = null;
    private int searchBgWidth = UserInterface.DISPLAY_WIDTH;
    private int searchBgHeight = UserImages.NUOMI_TITLEBAR_BG_IMAGE.getHeight();
    private TextArea searchTextArea = null;
    private String lastSearchKey = null;
    private Label allCityTitleLabel = null;
    private Label nuomiLogoLabel = null;
    private Container citysContainer = null;
    private ListBox cityListBox = null;
    private Vector citys = null;
    private DataDownloadListener downloadListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            FindCitysPage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintText = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof FindCitys && type == 4) {
                BasePage.clientInfo.setFindCitys((FindCitys)data);
                FindCitysPage.this.citys = ((FindCitys)data).citys;
                FindCitysPage.this.showCityList(null);
                FindCitysPage.this.citysContainer.setScrollY(0);
            }
            FindCitysPage.this.self.endRefresh();
            if (hintText != null) {
                FindCitysPage.this.self.showHint(hintText);
            }
        }
    };

    public static void Show(BasePage parentPage) {
        if (s_FindCitysPage == null) {
            s_FindCitysPage = new FindCitysPage();
        }
        s_FindCitysPage.setParent(parentPage);
        s_FindCitysPage.show();
    }

    private FindCitysPage() {
        this.setTitle("\u9009\u62e9\u57ce\u5e02");
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        Container searchBgContainer = new Container(new CoordinateLayout(this.searchBgWidth, this.searchBgHeight));
        this.mainContainer.addComponent(searchBgContainer);
        searchBgContainer.setPreferredW(this.searchBgWidth);
        searchBgContainer.setPreferredH(this.searchBgHeight);
        searchBgContainer.setX(0);
        searchBgContainer.setY(0);
        searchBgContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
        this.searchContainer = new Container(new CoordinateLayout(this.searchBgWidth - 20, this.searchBgHeight - 10));
        searchBgContainer.addComponent(this.searchContainer);
        this.searchContainer.setPreferredW(this.searchBgWidth - 20);
        this.searchContainer.setPreferredH(this.searchBgHeight - 10);
        this.searchContainer.setX(10);
        this.searchContainer.setY(5);
        this.searchContainer.getStyle().setBgImage(UserImages.FINDCITYSPAGE_SEARCHBOX_BG_IMAGE);
        Button searchButton = UserInterface.createIconOnlyButton(UserImages.FINDCITYSPAGE_SEARCH_ICON_IMAGE, null);
        this.searchContainer.addComponent(searchButton);
        searchButton.setPreferredW(this.searchContainer.getPreferredH());
        searchButton.setPreferredH(this.searchContainer.getPreferredH());
        searchButton.setX(this.searchContainer.getPreferredW() - searchButton.getPreferredW() - 10);
        searchButton.setY(0);
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String keyString = FindCitysPage.this.searchTextArea.getText();
                if (!Methods.equals(keyString, FindCitysPage.this.lastSearchKey)) {
                    FindCitysPage.this.lastSearchKey = keyString;
                    FindCitysPage.this.showCityList(keyString);
                    FindCitysPage.this.citysContainer.setScrollY(0);
                }
            }
        });
        this.searchTextArea = UserInterface.createTextArea();
        this.searchContainer.addComponent(this.searchTextArea);
        this.searchTextArea.setMaxSize(20);
        this.searchTextArea.setPreferredW(searchButton.getX() - 5);
        this.searchTextArea.setX(5);
        this.searchTextArea.setY((this.searchContainer.getPreferredH() - this.searchTextArea.getPreferredH()) / 2);
        this.searchTextArea.setHint("\u57ce\u5e02\u540d\u79f0\u6216\u62fc\u97f3");
        this.allCityTitleLabel = new Label("\u5168\u90e8\u57ce\u5e02");
        this.mainContainer.addComponent(this.allCityTitleLabel);
        this.allCityTitleLabel.getStyle().setPadding(1, 20);
        this.allCityTitleLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.allCityTitleLabel.getStyle().setBgImage(UserImages.FINDCITYSPAGE_ALLCITY_BG_IMAGE);
        this.allCityTitleLabel.getStyle().setFgColor(0xFFFFFF);
        this.allCityTitleLabel.setPreferredW(UserInterface.DISPLAY_WIDTH);
        this.allCityTitleLabel.setPreferredH(UserImages.FINDCITYSPAGE_ALLCITY_BG_IMAGE.getHeight());
        this.allCityTitleLabel.setX(0);
        this.allCityTitleLabel.setY(this.searchBgHeight);
        this.nuomiLogoLabel = UserInterface.createNuomiLogoLabel();
        this.mainContainer.addComponent(this.nuomiLogoLabel);
        this.nuomiLogoLabel.setX((UserInterface.DISPLAY_WIDTH - this.nuomiLogoLabel.getPreferredW()) / 2);
        this.nuomiLogoLabel.setY(this.searchBgHeight + (UserInterface.DISPLAY_HEIGHT - this.searchBgHeight - this.allCityTitleLabel.getPreferredH() - this.nuomiLogoLabel.getPreferredH()) / 2);
        this.citysContainer = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, UserInterface.DISPLAY_HEIGHT - this.searchBgHeight - this.allCityTitleLabel.getPreferredH()));
        this.mainContainer.addComponent(this.citysContainer);
        this.citysContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        this.citysContainer.setPreferredH(this.mainContainer.getPreferredH() - this.searchBgHeight - this.allCityTitleLabel.getPreferredH());
        this.citysContainer.setX(0);
        this.citysContainer.setY(this.searchBgHeight + this.allCityTitleLabel.getPreferredH());
        this.citysContainer.setScrollableY(true);
        this.cityListBox = new ListBox();
        this.citysContainer.addComponent(this.cityListBox);
        this.cityListBox.setX(0);
        this.cityListBox.setY(0);
        this.cityListBox.addClickedListener(new ListBoxClickedListener(){

            public void onClicked(Object itemObject) {
                if (itemObject instanceof City) {
                    FindCitysPage.this.selectedCity((City)itemObject);
                }
            }
        });
        this.citys = BasePage.clientInfo.getCitys();
        if (this.citys != null) {
            this.showCityList(null);
        } else {
            this.onRefreshCitys();
        }
    }

    protected void onRefreshClicked() {
        this.onRefreshCitys();
    }

    private void onRefreshCitys() {
        DataDownload dataDownload = new DataDownload();
        dataDownload.addDownloadListener(this.downloadListener);
        dataDownload.cityAll();
    }

    private void selectedCity(City city) {
        BasePage.clientInfo.setCity(city);
        if (this.parentPage == null) {
            HomePage.Show();
        } else {
            this.parentPage.show();
        }
    }

    private void showCityList(String key) {
        int size;
        this.cityListBox.removeAll();
        if (this.citys != null && (size = this.citys.size()) > 0) {
            int i = 0;
            while (i < size) {
                City city = (City)this.citys.elementAt(i);
                if (Methods.isNullOrEmpty(key) || city.cityName != null && city.cityName.indexOf(key) > -1 || city.cityUrl != null && city.cityUrl.indexOf(key) > -1 || city.shortName != null && city.shortName.indexOf(key) > -1) {
                    CityListBoxItem item = new CityListBoxItem(city);
                    this.cityListBox.addItem(item);
                }
                ++i;
            }
        }
        if (this.cityListBox.getCount() == 0) {
            this.nuomiLogoLabel.setVisible(true);
            this.allCityTitleLabel.setText(Methods.isNullOrEmpty(key) ? "\u6ca1\u6709\u57ce\u5e02" : "\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u57ce\u5e02");
        } else {
            this.nuomiLogoLabel.setVisible(false);
            this.allCityTitleLabel.setText(Methods.isNullOrEmpty(key) ? "\u5168\u90e8\u57ce\u5e02" : "\u5168\u90e8\u7b26\u5408\u6761\u4ef6\u7684\u57ce\u5e02");
        }
        this.repaint();
    }
}

