/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.GiftCard;
import com.nuomi.data.GiftCardCheck;
import com.nuomi.data.GiftCards;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.BuyPage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.MultiRowButton;
import com.nuomi.usercontrol.MultiRowButtonGroup;
import com.nuomi.usercontrol.MultiRowRadioButton;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class GiftCardPage
extends BasePage {
    private static GiftCardPage _GiftCardPage = null;
    private TextBox checkCodeTextBox = null;
    private Button checkButton = null;
    private ContentContainer listContentContainer = null;
    private Container innerContainer = null;
    private MultiRowButtonGroup giftcardButtonGroup = null;
    private Button selectedButton = null;
    private Vector giftCardVector = null;
    private DataDownload checkDownload = null;
    private DataDownload listDownload = null;

    public static void Show(BasePage parentPage) {
        if (_GiftCardPage == null) {
            _GiftCardPage = new GiftCardPage();
        }
        _GiftCardPage.setParent(parentPage);
        _GiftCardPage.show();
        _GiftCardPage.getListGiftCard();
    }

    public GiftCardPage() {
        this.setTitle("\u4f7f\u7528\u4ee3\u91d1\u5238");
        this.mainContainer.setLayout(new BoxLayout(2));
        Container checkContent = new Container(new BoxLayout(2));
        String[] checkHintStrings = new String[]{"\u63d0\u793a\uff1a\u8f93\u5165\u7cef\u7c73\u4f18\u60e0\u7801\u540e", "\u5c06\u8f6c\u6362\u4e3a\u4ee3\u91d1\u5238"};
        int i = 0;
        while (i < checkHintStrings.length) {
            Label label = new Label(checkHintStrings[i]);
            checkContent.addComponent(label);
            label.setPreferredW(340);
            label.setPreferredH(25);
            label.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            label.getStyle().setFgColor(0x919191);
            label.getStyle().setAlignment(4);
            ++i;
        }
        this.checkCodeTextBox = new TextBox(0);
        checkContent.addComponent(this.checkCodeTextBox);
        this.checkCodeTextBox.setHint("\u8bf7\u8f93\u5165\u7cef\u7c73\u4f18\u60e0\u7801");
        this.checkCodeTextBox.getStyle().setMargin(1, 15);
        this.checkCodeTextBox.getStyle().setMargin(3, 15);
        this.checkCodeTextBox.getStyle().setMargin(0, 10);
        Container buttonContainer = new Container(new BoxLayout(1));
        checkContent.addComponent(buttonContainer);
        buttonContainer.getStyle().setMargin(0, 10);
        this.checkButton = UserInterface.createBigButton("\u786e\u5b9a");
        buttonContainer.addComponent(this.checkButton);
        buttonContainer.getStyle().setMargin(1, (checkContent.getPreferredW() - this.checkButton.getPreferredW()) / 2);
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GiftCardPage.this.checkGiftCard();
            }
        });
        ContentContainer checkContentContainer = new ContentContainer(checkContent, 0, 0);
        this.mainContainer.addComponent(checkContentContainer);
        checkContentContainer.getStyle().setMargin(0, 5);
        checkContentContainer.getStyle().setMargin(1, 0);
        Container listContent = new Container(new BoxLayout(2));
        Label listTitleLabel = new Label("\u9009\u62e9\u4ee3\u91d1\u5238");
        listContent.addComponent(listTitleLabel);
        listTitleLabel.setPreferredW(340);
        listTitleLabel.setPreferredH(25);
        listTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        listTitleLabel.getStyle().setFgColor(6453130);
        listTitleLabel.getStyle().setAlignment(4);
        Label listHintLabel = new Label("(\u4ee3\u91d1\u5238\u4e0d\u627e\u96f6,\u53ea\u80fd\u4e00\u6b21\u6027\u6d88\u8d39)");
        listContent.addComponent(listHintLabel);
        listHintLabel.setPreferredW(340);
        listHintLabel.setPreferredH(25);
        listHintLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        listHintLabel.getStyle().setFgColor(0x919191);
        listHintLabel.getStyle().setAlignment(4);
        Label spLabel = new Label();
        listContent.addComponent(spLabel);
        spLabel.getStyle().setBgColor(0x919191);
        spLabel.getStyle().setBgTransparency(128);
        spLabel.getStyle().setMargin(0, 15);
        spLabel.getStyle().setMargin(2, 15);
        spLabel.setPreferredW(348);
        spLabel.setPreferredH(1);
        int width = 335;
        int height = 193;
        Container scrollContainer = new Container(new CoordinateLayout(width, height));
        listContent.addComponent(scrollContainer);
        scrollContainer.setPreferredW(width);
        scrollContainer.setPreferredH(height);
        scrollContainer.setScrollableY(true);
        scrollContainer.getStyle().setMargin(3, 5);
        this.innerContainer = new Container(new BoxLayout(2));
        scrollContainer.addComponent(this.innerContainer);
        Container buttonContainer2 = new Container(new BoxLayout(1));
        listContent.addComponent(buttonContainer2);
        buttonContainer2.getStyle().setMargin(0, 10);
        this.selectedButton = UserInterface.createBigButton("\u786e\u5b9a");
        buttonContainer2.addComponent(this.selectedButton);
        buttonContainer2.getStyle().setMargin(1, (checkContent.getPreferredW() - this.selectedButton.getPreferredW()) / 2);
        this.selectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int selected = -1;
                if (GiftCardPage.this.giftcardButtonGroup != null && (selected = GiftCardPage.this.giftcardButtonGroup.getSelectedIndex()) != -1) {
                    GiftCard selectedCard = selected == 0 ? null : (GiftCard)GiftCardPage.this.giftCardVector.elementAt(selected - 1);
                    if (GiftCardPage.this.parentPage instanceof BuyPage) {
                        ((BuyPage)GiftCardPage.this.parentPage).setGiftCard(selectedCard);
                    }
                }
                GiftCardPage.this.onBack();
            }
        });
        this.listContentContainer = new ContentContainer(listContent, 0, 0);
        this.listContentContainer.getStyle().setMargin(0, 5);
        this.listContentContainer.getStyle().setMargin(1, 0);
    }

    protected void onBack() {
        this.checkCodeTextBox.setText(null);
        this.innerContainer.removeAll();
        this.giftcardButtonGroup = null;
        this.showListContentContainer(false);
        if (this.listDownload != null && this.listDownload.isDownloading()) {
            this.listDownload.cancel();
        }
        if (this.checkDownload != null && this.checkDownload.isDownloading()) {
            this.checkDownload.cancel();
        }
        super.onBack();
    }

    protected void onRefreshClicked() {
        this.getListGiftCard();
    }

    private void checkGiftCard() {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u672a\u767b\u5f55\u8d26\u53f7", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                LogPage.Show(this.self);
            }
        } else {
            String code = this.checkCodeTextBox.getText().trim();
            if (Methods.isNullOrEmpty(code)) {
                this.showHint("\u8bf7\u8f93\u5165\u7cef\u7c73\u4f18\u60e0\u7801");
                this.checkCodeTextBox.setFocus(true);
                return;
            }
            if (this.checkDownload == null) {
                this.checkDownload = new DataDownload();
                this.checkDownload.addDownloadListener(new DataDownloadListener(){

                    public void onDownloadStart(Object tag) {
                        GiftCardPage.this.checkButton.setEnabled(false);
                    }

                    public void onDownloadCompleted(int result, Object data, int type, Object tag) {
                        String hintString = DataDownload.ResultStrings[result];
                        boolean showHint = true;
                        if (result == 2 && data instanceof GiftCardCheck) {
                            GiftCardCheck check = (GiftCardCheck)data;
                            if (check.result.isSucceed()) {
                                if (GiftCardPage.this.giftCardVector == null) {
                                    GiftCardPage.this.giftCardVector = new Vector();
                                }
                                GiftCardPage.this.giftCardVector.insertElementAt(check.giftcard, 0);
                                GiftCardPage.this.showGiftCards(1);
                            } else if (check.result.isLogExpired() && GiftCardPage.this.getCurrentForm() == GiftCardPage.this.self && !MessageBox.isShow) {
                                if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                    LogPage.Show(GiftCardPage.this.self, true);
                                }
                                showHint = false;
                            }
                            hintString = check.result.msg;
                        }
                        if (showHint) {
                            GiftCardPage.this.showHint(hintString);
                        }
                        GiftCardPage.this.checkButton.setEnabled(true);
                        GiftCardPage.this.repaint();
                    }
                });
            }
            this.checkDownload.giftcardCheck(userInfo.userId, userInfo.ticket, code);
        }
    }

    private void getListGiftCard() {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u672a\u767b\u5f55\u8d26\u53f7", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                LogPage.Show(this.self);
            }
        } else {
            if (this.listDownload == null) {
                this.listDownload = new DataDownload();
                this.listDownload.addDownloadListener(new DataDownloadListener(){

                    public void onDownloadStart(Object tag) {
                        GiftCardPage.this.startRefresh();
                    }

                    public void onDownloadCompleted(int result, Object data, int type, Object tag) {
                        String hintString = DataDownload.ResultStrings[result];
                        boolean showHint = true;
                        if (result == 2 && data instanceof GiftCards) {
                            GiftCards giftCards = (GiftCards)data;
                            if (giftCards.result.isSucceed()) {
                                GiftCardPage.this.giftCardVector = null;
                                GiftCardPage.this.giftCardVector = giftCards.giftcards;
                                GiftCardPage.this.showGiftCards(0);
                            } else if (giftCards.result.isLogExpired()) {
                                if (GiftCardPage.this.getCurrentForm() == GiftCardPage.this.self && !MessageBox.isShow) {
                                    if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                        LogPage.Show(GiftCardPage.this.self, true);
                                    }
                                    showHint = false;
                                }
                            } else {
                                hintString = giftCards.result.msg;
                            }
                        }
                        if (showHint) {
                            GiftCardPage.this.showHint(hintString);
                        }
                        GiftCardPage.this.endRefresh();
                    }
                });
            }
            this.listDownload.giftcardAll(userInfo.userId, userInfo.ticket, 0, 100, 0);
        }
    }

    private void showGiftCards(int selectIndex) {
        if (this.giftCardVector == null) {
            return;
        }
        try {
            this.giftcardButtonGroup = null;
            this.innerContainer.removeAll();
            int length = this.giftCardVector.size();
            this.showListContentContainer(length > 0);
            if (length > 0) {
                MultiRowButton[] radioButtons = new MultiRowRadioButton[length + 1];
                radioButtons[0] = new MultiRowRadioButton("\u4e0d\u4f7f\u7528\u4ee3\u91d1\u5238", null);
                int i = 1;
                while (i < radioButtons.length) {
                    GiftCard card = (GiftCard)this.giftCardVector.elementAt(i - 1);
                    if (card != null) {
                        radioButtons[i] = new MultiRowRadioButton(String.valueOf(Methods.formatPrice(card.worth)) + "\u5143" + (card.expiredTimeCalendar == null ? "" : "|" + CalendarFormat.toYMD(card.expiredTimeCalendar) + "\u5230\u671f") + (Methods.isNullOrWhitespace(card.condition) ? "" : "|" + card.condition), null);
                    }
                    ++i;
                }
                this.giftcardButtonGroup = new MultiRowButtonGroup(radioButtons, true);
                this.giftcardButtonGroup.setSelectedIndex(selectIndex);
                this.innerContainer.addComponent(this.giftcardButtonGroup);
                this.repaint();
                System.gc();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showListContentContainer(boolean isShown) {
        if (this.listContentContainer != null) {
            if (isShown) {
                if (!this.mainContainer.contains(this.listContentContainer)) {
                    this.mainContainer.addComponent(this.listContentContainer);
                }
            } else if (this.mainContainer.contains(this.listContentContainer)) {
                this.mainContainer.removeComponent(this.listContentContainer);
            }
            this.repaint();
        }
    }
}

