/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.LoginInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.City;
import com.nuomi.data.DealList;
import com.nuomi.data.DealPreview;
import com.nuomi.data.FindVouchers;
import com.nuomi.data.GetVersion;
import com.nuomi.data.Login;
import com.nuomi.data.ResultInfo;
import com.nuomi.data.VoucherPreview;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.ListBoxClickedListener;
import com.nuomi.listener.LogStatusListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.AboutPage;
import com.nuomi.pages.ActivePage;
import com.nuomi.pages.AddressesPage;
import com.nuomi.pages.BalancePage;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.CouponListPage;
import com.nuomi.pages.DealDetailPage;
import com.nuomi.pages.FeedbackPage;
import com.nuomi.pages.FindCitysPage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.LotteryListPage;
import com.nuomi.pages.MyGiftcardPage;
import com.nuomi.pages.PostOrderListPage;
import com.nuomi.pages.RechargePage;
import com.nuomi.pages.RegisterPage;
import com.nuomi.pages.SettingsPage;
import com.nuomi.pages.VoucherDetailPage;
import com.nuomi.usercontrol.CatalogSelectorControl;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.usercontrol.ItemButtonGroup;
import com.nuomi.usercontrol.ListBox;
import com.nuomi.usercontrol.MoreTopButton;
import com.nuomi.usercontrol.TabControl;
import com.nuomi.usercontrol.homepage.DealListBoxItem;
import com.nuomi.usercontrol.homepage.VoucherListBoxItem;
import com.nuomi.utils.DownloadImageControlsImageThread;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class HomePage
extends BasePage {
    private static HomePage s_HomePage = null;
    private Container todayDealsContainer = null;
    private Container todayDealsScrollContainer = null;
    private Container todayDealsInnerContainer = null;
    private CatalogSelectorControl todayDealsCatalogSelectorControl = null;
    private ListBox todayDealsListBox = null;
    private MoreTopButton todayDealsMoreTopButton = null;
    private Label todayDealsNuomiLogoLabel = null;
    private Container vouchersContainer = null;
    private Container vouchersScrollContainer = null;
    private Container vouchersInnerContainer = null;
    private CatalogSelectorControl vouchersCatalogSelectorControl = null;
    private ListBox vouchersListBox = null;
    private Label vouchersNuomiLogoLabel = null;
    private MoreTopButton vouchersMoreTopButton = null;
    private Container mynuomiScrollContainer = null;
    private Container mynuomiInnerContainer = null;
    private Container logContainer = null;
    private Container unlogedContainer = null;
    private Container logedContainer = null;
    private ImageControl avatarImageControl = null;
    private Label emailLabel = null;
    private Label nickNameLabel = null;
    private Container activeContainer = null;
    private Container unactivedContainer = null;
    private Container activedContainer = null;
    private ItemButton couponButton = null;
    private ItemButton postOrderButton = null;
    private ItemButton lotteryButton = null;
    private ItemButton balanceButton = null;
    private Container otherContainer = null;
    private TabControl tabControl = null;
    private int Tab_Height = 0;
    private int Scroll_Height = 0;
    private DataDownload dealsDataDownload = null;
    private DataDownload dealsMoreDataDownload = null;
    private DataDownload vouchersDataDownload = null;
    private DataDownload vouchersMoreDataDownload = null;
    private DataDownload refreshUserInfoDataDownload = null;
    private DataDownload getVersionDownload = null;
    private final int CatalogAll_Show_Start;
    private boolean cityHadChanged_TodayDeals = true;
    private boolean cityHadChanged_Voucher = true;
    public boolean needRefreshUserInfo_MyNuomi = true;
    private boolean downloading_TodayDeals = false;
    private boolean downloading_Voucher = false;
    private boolean downloading_MyNuomi = false;
    private DataDownloadListener downloadTodayDealsRefreshListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            HomePage.this.downloading_TodayDeals = true;
            HomePage.this.self.startRefresh();
            if (HomePage.this.todayDealsMoreTopButton != null) {
                HomePage.this.todayDealsMoreTopButton.setIsLoading(true);
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            HomePage.this.downloading_TodayDeals = false;
            String hintText = DataDownload.ResultStrings[result];
            if (result == 2) {
                if (data instanceof DealList && type == 0) {
                    Integer catalogIndex = null;
                    if (tag != null && tag instanceof Integer) {
                        catalogIndex = (Integer)tag;
                        BasePage.clientInfo.setTodayDeals(catalogIndex, (DealList)data);
                        Vector deals = BasePage.clientInfo.getTodayDeals(catalogIndex);
                        if (deals != null && deals.size() > 0) {
                            HomePage.this.showRefreshDeals(deals, catalogIndex);
                        }
                    }
                }
                BasePage.clientInfo.onStart();
            }
            if (HomePage.this.mainContainer.contains(HomePage.this.todayDealsContainer)) {
                HomePage.this.self.endRefresh();
            }
            if (HomePage.this.todayDealsMoreTopButton != null) {
                HomePage.this.todayDealsMoreTopButton.setIsLoading(false);
            }
            if (hintText != null) {
                HomePage.this.self.showHint(String.valueOf(hintText) + "(\u4eca\u65e5\u56e2\u8d2d)");
            }
        }
    };
    private DataDownloadListener downloadTodayDealsMoreListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            HomePage.this.downloading_TodayDeals = true;
            HomePage.this.self.startRefresh();
            if (HomePage.this.todayDealsMoreTopButton != null) {
                HomePage.this.todayDealsMoreTopButton.setIsLoading(true);
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            HomePage.this.downloading_TodayDeals = false;
            String hintText = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof DealList && type == 1) {
                Integer catalogIndex = null;
                if (tag != null && tag instanceof Integer) {
                    catalogIndex = (Integer)tag;
                    BasePage.clientInfo.addTodayDeals(catalogIndex, (DealList)data);
                    Vector deals = BasePage.clientInfo.getTodayDeals(catalogIndex);
                    if (deals != null && deals.size() > 0) {
                        HomePage.this.showMoreDeals(deals, catalogIndex);
                    }
                }
            }
            if (HomePage.this.mainContainer.contains(HomePage.this.todayDealsContainer)) {
                HomePage.this.self.endRefresh();
            }
            if (HomePage.this.todayDealsMoreTopButton != null) {
                HomePage.this.todayDealsMoreTopButton.setIsLoading(false);
            }
            if (hintText != null) {
                HomePage.this.self.showHint(String.valueOf(hintText) + "(\u4eca\u65e5\u56e2\u8d2d)");
            }
        }
    };
    private DataDownloadListener downloadVouchersRefreshListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            HomePage.this.downloading_Voucher = true;
            HomePage.this.self.startRefresh();
            if (HomePage.this.vouchersMoreTopButton != null) {
                HomePage.this.vouchersMoreTopButton.setIsLoading(true);
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            HomePage.this.downloading_Voucher = false;
            String hintText = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof FindVouchers && (type == 6 || type == 5)) {
                Integer catalogIndex = null;
                if (tag != null && tag instanceof Integer) {
                    catalogIndex = (Integer)tag;
                    BasePage.clientInfo.setVouchers(catalogIndex, (FindVouchers)data);
                    Vector vouchers = BasePage.clientInfo.getVouchers(catalogIndex);
                    HomePage.this.showRefreshVouchers(vouchers, catalogIndex);
                }
            }
            if (HomePage.this.mainContainer.contains(HomePage.this.vouchersContainer)) {
                HomePage.this.self.endRefresh();
            }
            if (HomePage.this.vouchersMoreTopButton != null) {
                HomePage.this.vouchersMoreTopButton.setIsLoading(false);
            }
            if (hintText != null) {
                HomePage.this.self.showHint(String.valueOf(hintText) + "(\u4f18\u60e0\u5238)");
            }
        }
    };
    private DataDownloadListener downloadVouchersMoreListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            HomePage.this.downloading_Voucher = true;
            HomePage.this.self.startRefresh();
            if (HomePage.this.vouchersMoreTopButton != null) {
                HomePage.this.vouchersMoreTopButton.setIsLoading(true);
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            HomePage.this.downloading_Voucher = false;
            String hintText = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof FindVouchers && (type == 6 || type == 5)) {
                Integer catalogIndex = null;
                if (tag != null && tag instanceof Integer) {
                    catalogIndex = (Integer)tag;
                    BasePage.clientInfo.addVouchers(catalogIndex, (FindVouchers)data);
                    Vector vouchers = BasePage.clientInfo.getVouchers(catalogIndex);
                    HomePage.this.showMoreVouchers(vouchers, catalogIndex);
                }
            }
            if (HomePage.this.mainContainer.contains(HomePage.this.vouchersContainer)) {
                HomePage.this.self.endRefresh();
            }
            if (HomePage.this.vouchersMoreTopButton != null) {
                HomePage.this.vouchersMoreTopButton.setIsLoading(false);
            }
            if (hintText != null) {
                HomePage.this.self.showHint(String.valueOf(hintText) + "(\u4f18\u60e0\u5238)");
            }
        }
    };
    private DataDownloadListener refreshUserInfoDataDownloadListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            HomePage.this.downloading_MyNuomi = true;
            HomePage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            HomePage.this.downloading_MyNuomi = false;
            String hintText = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof Login) {
                LoginInfo loginInfo;
                ResultInfo resultInfo = ((Login)data).result;
                if (resultInfo.isSucceed()) {
                    UserInfo newUserInfo = ((Login)data).userInfo;
                    UserInfo oldUserInfo = BasePage.clientInfo.getUserInfo();
                    if (newUserInfo != null && oldUserInfo != null) {
                        newUserInfo.userId = oldUserInfo.userId;
                        newUserInfo.ticket = oldUserInfo.ticket;
                        newUserInfo.userName = oldUserInfo.userName;
                    }
                    BasePage.clientInfo.setUserInfo(newUserInfo);
                } else if (resultInfo.isLogExpired() && (loginInfo = BasePage.clientInfo.getLoginInfo()) != null) {
                    BasePage.clientInfo.startLogin(loginInfo.userName, loginInfo.password, null);
                    HomePage.this.downloading_MyNuomi = true;
                }
            }
            if (HomePage.this.mainContainer.contains(HomePage.this.mynuomiScrollContainer) && !HomePage.this.downloading_MyNuomi) {
                HomePage.this.self.endRefresh();
            }
            if (hintText != null) {
                HomePage.this.self.showHint(String.valueOf(hintText) + "(\u6211\u7684\u7cef\u7c73)");
            }
        }
    };
    private LogStatusListener logStatusListener = new LogStatusListener(){

        public void onSucceed(UserInfo userInfo) {
            if (HomePage.this.self.contains(HomePage.this.mynuomiScrollContainer)) {
                HomePage.this.endRefresh();
            }
            HomePage.this.downloading_MyNuomi = false;
        }

        public void onFailed(String reason, String codeData) {
            if (HomePage.this.self.contains(HomePage.this.mynuomiScrollContainer)) {
                if (Display.getInstance().getCurrent() == HomePage.this.self) {
                    HomePage.this.showHint(String.valueOf(reason) + "(\u767b\u5f55)");
                }
                HomePage.this.endRefresh();
            }
            HomePage.this.downloading_MyNuomi = false;
        }

        public void onCancelled() {
            HomePage.this.downloading_MyNuomi = false;
        }
    };
    private ListBoxClickedListener todayDealsListBoxClickedListener = new ListBoxClickedListener(){

        public void onClicked(Object itemObject) {
            if (itemObject instanceof DealPreview) {
                HomePage.this.selectedDeal((DealPreview)itemObject);
            }
        }
    };
    private ListBoxClickedListener voucherListBoxClickedListener = new ListBoxClickedListener(){

        public void onClicked(Object itemObject) {
            if (itemObject instanceof VoucherPreview) {
                HomePage.this.selectedVoucher((VoucherPreview)itemObject);
            }
        }
    };
    private DataDownloadListener getVersionListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            HomePage.this.startRefresh();
            HomePage.this.showRefreshIcon();
            if (tag instanceof ItemButton) {
                ((ItemButton)tag).setEnabled(false);
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof GetVersion) {
                GetVersion getVersion = (GetVersion)data;
                hintString = PhoneFunction.checkVersion(getVersion);
            }
            if (!Methods.isNullOrWhitespace(hintString)) {
                HomePage.this.showHint(hintString);
            }
            HomePage.this.hideRefreshIcon();
            HomePage.this.endRefresh();
            if (tag instanceof ItemButton) {
                ((ItemButton)tag).setEnabled(true);
            }
        }
    };

    public static void Show() {
        if (s_HomePage == null) {
            s_HomePage = new HomePage();
            BasePage.MainPage = s_HomePage;
        }
        s_HomePage.setParent(null);
        s_HomePage.show();
    }

    private HomePage() {
        this.CatalogAll_Show_Start = 0;
        this.setTitleFont(UserInterface.FONT_TITLEBAR);
        City city = BasePage.clientInfo.getCity();
        if (city != null) {
            this.setTitle(city.shortName, true);
        }
        this.tabControl = new TabControl(UserImages.HOMEPAGE_TAB_BG_IMAGE, UserImages.HOMEPAGE_TABS_IMAGES, true);
        this.Tab_Height = this.tabControl.getClickHeight();
        this.tabControl.setX(0);
        this.tabControl.setY(UserInterface.DISPLAY_HEIGHT - this.tabControl.getPreferredH() - 8);
        this.mainContainer.setPreferredH(this.mainContainer.getPreferredH() - this.Tab_Height);
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.Scroll_Height = UserInterface.DISPLAY_HEIGHT - this.self.getTitleArea().getPreferredH() - this.Tab_Height;
        this.todayDealsContainer = this.createTabContainer(false);
        this.mainContainer.addComponent(this.todayDealsContainer);
        this.todayDealsNuomiLogoLabel = UserInterface.createNuomiLogoLabel();
        this.todayDealsContainer.addComponent(this.todayDealsNuomiLogoLabel);
        this.todayDealsNuomiLogoLabel.setX((UserInterface.DISPLAY_WIDTH - this.todayDealsNuomiLogoLabel.getPreferredW()) / 2);
        this.todayDealsCatalogSelectorControl = new CatalogSelectorControl(ClientInfo.TodayDeals_CatalogNames, 4);
        this.todayDealsContainer.addComponent(this.todayDealsCatalogSelectorControl);
        this.todayDealsCatalogSelectorControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                HomePage.this.selectedTodayDealsCatalog(index);
            }
        });
        int todayDealsHeight = this.Scroll_Height - this.todayDealsCatalogSelectorControl.getPreferredH();
        this.todayDealsScrollContainer = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, todayDealsHeight));
        this.todayDealsContainer.addComponent(this.todayDealsScrollContainer);
        this.todayDealsScrollContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        this.todayDealsScrollContainer.setPreferredH(todayDealsHeight);
        this.todayDealsScrollContainer.setX(0);
        this.todayDealsScrollContainer.setY(this.todayDealsCatalogSelectorControl.getPreferredH());
        this.todayDealsScrollContainer.setScrollableY(true);
        this.todayDealsInnerContainer = this.createInnerContainer();
        this.todayDealsScrollContainer.addComponent(this.todayDealsInnerContainer);
        this.todayDealsListBox = new ListBox();
        this.todayDealsInnerContainer.addComponent(this.todayDealsListBox);
        this.todayDealsListBox.addClickedListener(this.todayDealsListBoxClickedListener);
        int logoY = this.todayDealsCatalogSelectorControl.getPreferredH() + (this.Scroll_Height - this.todayDealsCatalogSelectorControl.getPreferredH() - this.todayDealsNuomiLogoLabel.getPreferredH()) / 2;
        this.todayDealsNuomiLogoLabel.setY(logoY);
        this.vouchersContainer = this.createTabContainer(false);
        this.vouchersCatalogSelectorControl = new CatalogSelectorControl(ClientInfo.Vouchers_CatalogNames, 4);
        this.vouchersContainer.addComponent(this.vouchersCatalogSelectorControl);
        this.vouchersCatalogSelectorControl.setX(0);
        this.vouchersCatalogSelectorControl.setY(0);
        this.vouchersCatalogSelectorControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                HomePage.this.selectedVouchersCatalog(index);
            }
        });
        this.vouchersNuomiLogoLabel = UserInterface.createNuomiLogoLabel();
        this.vouchersContainer.addComponent(this.vouchersNuomiLogoLabel);
        this.vouchersNuomiLogoLabel.setX((UserInterface.DISPLAY_WIDTH - this.vouchersNuomiLogoLabel.getPreferredW()) / 2);
        this.vouchersNuomiLogoLabel.setY((this.Scroll_Height - this.vouchersCatalogSelectorControl.getPreferredH()) / 2);
        int vouchersScrollHeight = this.Scroll_Height - this.vouchersCatalogSelectorControl.getPreferredH();
        this.vouchersScrollContainer = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, vouchersScrollHeight));
        this.vouchersContainer.addComponent(this.vouchersScrollContainer);
        this.vouchersScrollContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        this.vouchersScrollContainer.setPreferredH(vouchersScrollHeight);
        this.vouchersScrollContainer.setX(0);
        this.vouchersScrollContainer.setY(this.vouchersCatalogSelectorControl.getPreferredH());
        this.vouchersScrollContainer.setScrollableY(true);
        this.vouchersInnerContainer = this.createInnerContainer();
        this.vouchersScrollContainer.addComponent(this.vouchersInnerContainer);
        this.vouchersListBox = new ListBox();
        this.vouchersInnerContainer.addComponent(this.vouchersListBox);
        this.vouchersListBox.addClickedListener(this.voucherListBoxClickedListener);
        this.mynuomiScrollContainer = this.createTabContainer(true);
        this.mynuomiInnerContainer = this.createInnerContainer();
        this.mynuomiScrollContainer.addComponent(this.mynuomiInnerContainer);
        this.logContainer = new Container(new BoxLayout(2));
        this.mynuomiInnerContainer.addComponent(this.logContainer);
        ItemButton loginButton = new ItemButton(0, "\u767b\u5f55", UserImages.ICON_LOG_IMAGE, true);
        loginButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                LogPage.Show(HomePage.this.self);
            }
        });
        ItemButton registerButton = new ItemButton(2, "\u6ce8\u518c", UserImages.ICON_REGISTER_IMAGE, true);
        registerButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                RegisterPage.Show(HomePage.this.self);
            }
        });
        ItemButton[] itemButtons = new ItemButton[]{loginButton, registerButton};
        this.unlogedContainer = new ItemButtonGroup(itemButtons);
        this.unlogedContainer.getStyle().setMargin(0, 5);
        this.logContainer.addComponent(this.unlogedContainer);
        this.logedContainer = new Container(new BoxLayout(2));
        int margin = 7;
        Label nickNameTitleLabel = new Label("\u6635\u79f0:");
        nickNameTitleLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        Label emailTitleLabel = new Label("\u8d26\u53f7:");
        emailTitleLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        Container userContainer = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, nickNameTitleLabel.getPreferredH() + emailTitleLabel.getPreferredH()));
        this.logedContainer.addComponent(userContainer);
        userContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        userContainer.setPreferredH(nickNameTitleLabel.getPreferredH() + emailTitleLabel.getPreferredH());
        userContainer.getStyle().setBgImage(UserImages.NUOMI_USER_BG_IMAGE);
        this.avatarImageControl = new ImageControl(userContainer.getPreferredH() - 10, userContainer.getPreferredH() - 10, UserImages.NUOMI_AVATAR_DEFAULT_IMAGE);
        userContainer.addComponent(this.avatarImageControl);
        this.avatarImageControl.setX(margin);
        this.avatarImageControl.setY((userContainer.getPreferredH() - this.avatarImageControl.getPreferredH()) / 2);
        userContainer.addComponent(emailTitleLabel);
        emailTitleLabel.setX(this.avatarImageControl.getPreferredW() + margin * 2);
        emailTitleLabel.setY(0);
        userContainer.addComponent(nickNameTitleLabel);
        nickNameTitleLabel.setX(emailTitleLabel.getX());
        nickNameTitleLabel.setY(userContainer.getPreferredH() - nickNameTitleLabel.getPreferredH());
        this.emailLabel = new Label();
        userContainer.addComponent(this.emailLabel);
        this.emailLabel.setPreferredW(userContainer.getPreferredW() - this.avatarImageControl.getPreferredW() - emailTitleLabel.getPreferredW() - margin * 3);
        this.emailLabel.setPreferredH(emailTitleLabel.getPreferredH());
        this.emailLabel.setX(emailTitleLabel.getX() + emailTitleLabel.getPreferredW());
        this.emailLabel.setY(emailTitleLabel.getY());
        this.nickNameLabel = new Label();
        userContainer.addComponent(this.nickNameLabel);
        this.nickNameLabel.setPreferredW(userContainer.getPreferredW() - this.avatarImageControl.getPreferredW() - nickNameTitleLabel.getPreferredW() - margin * 3);
        this.nickNameLabel.setPreferredH(nickNameTitleLabel.getPreferredH());
        this.nickNameLabel.setX(nickNameTitleLabel.getX() + nickNameTitleLabel.getPreferredW());
        this.nickNameLabel.setY(nickNameTitleLabel.getY());
        this.activeContainer = new Container(new BoxLayout(2));
        this.logedContainer.addComponent(this.activeContainer);
        this.activeContainer.getStyle().setMargin(0, 5);
        ItemButton activeButton = new ItemButton(3, "\u6fc0\u6d3b", UserImages.ICON_ACTIVE_IMAGE, true);
        activeButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                ActivePage.Show(HomePage.this.self);
            }
        });
        ItemButton[] itemButtons2 = new ItemButton[]{activeButton};
        this.unactivedContainer = new ItemButtonGroup(itemButtons2);
        this.activeContainer.addComponent(this.unactivedContainer);
        this.activedContainer = new Container(new BoxLayout(2));
        this.couponButton = new ItemButton(0, "\u7cef\u7c73\u5238", null, true, "(\u672a\u4f7f\u7528)", "0");
        this.couponButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                CouponListPage.Show(HomePage.this.self);
            }
        });
        this.postOrderButton = new ItemButton(1, "\u90ae\u9012\u5355", null, true, "(\u672a\u53d1\u8d27)", "0");
        this.postOrderButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                PostOrderListPage.Show(HomePage.this.self);
            }
        });
        this.lotteryButton = new ItemButton(1, "\u62bd\u5956\u3000", null, true, "(\u672a\u7ed3\u675f)", "0");
        this.lotteryButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                LotteryListPage.Show(HomePage.this.self);
            }
        });
        this.balanceButton = new ItemButton(2, "\u4f59\u989d", null, true, null, " ");
        this.balanceButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                RechargePage.Show(HomePage.this.self);
            }
        });
        ItemButton[] itemButtons3 = new ItemButton[]{this.couponButton, this.postOrderButton, this.lotteryButton, this.balanceButton};
        ItemButtonGroup nuomiContainer = new ItemButtonGroup(itemButtons3);
        this.activedContainer.addComponent(nuomiContainer);
        ItemButton giftcardButton = new ItemButton(0, "\u6211\u7684\u4ee3\u91d1\u5238", null, true);
        giftcardButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                MyGiftcardPage.Show(HomePage.this.self);
            }
        });
        ItemButton addressButton = new ItemButton(1, "\u6211\u7684\u5730\u5740", null, true);
        addressButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                AddressesPage.Show(HomePage.this.self);
            }
        });
        ItemButton consumeRecordButton = new ItemButton(2, "\u4ea4\u6613\u8bb0\u5f55", null, true);
        consumeRecordButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                BalancePage.Show(HomePage.this.self);
            }
        });
        ItemButton[] itemButtons4 = new ItemButton[]{giftcardButton, addressButton, consumeRecordButton};
        ItemButtonGroup recordContainer = new ItemButtonGroup(itemButtons4);
        this.activedContainer.addComponent(recordContainer);
        recordContainer.getStyle().setMargin(0, 5);
        ItemButton logoutButton = new ItemButton(3, "\u9000\u51fa\u767b\u5f55", null, 4);
        logoutButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                if (HomePage.this.getCurrentForm() == HomePage.this.self && !MessageBox.isShow) {
                    if (MessageBox.Show("\u786e\u5b9a\u8981\u6ce8\u9500?", "\u786e\u5b9a", "\u53d6\u6d88") == MessageBox.OK) {
                        if (HomePage.this.refreshUserInfoDataDownload != null && HomePage.this.refreshUserInfoDataDownload.isDownloading()) {
                            HomePage.this.refreshUserInfoDataDownload.cancel();
                        }
                        BasePage.clientInfo.setUserInfo(null);
                        BasePage.clientInfo.setLoginInfo(new LoginInfo(BasePage.clientInfo.getLoginInfo().userName, null, false));
                    } else {
                        HomePage.this.self.repaint();
                    }
                }
            }
        });
        itemButtons2 = new ItemButton[]{logoutButton};
        ItemButtonGroup logoutContainer = new ItemButtonGroup(itemButtons2);
        this.logedContainer.addComponent(logoutContainer);
        logoutContainer.getStyle().setMargin(0, 5);
        ItemButton settingsButton = new ItemButton(0, "\u8bbe\u7f6e", UserImages.ICON_SETTINGS_IMAGE, true);
        settingsButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                SettingsPage.Show(HomePage.this.self);
            }
        });
        ItemButton feedbackButton = new ItemButton(1, "\u53cd\u9988", UserImages.ICON_FEEDBACK_IMAGE, true);
        feedbackButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                FeedbackPage.Show(HomePage.this.self);
            }
        });
        ItemButton getVersionButton = new ItemButton(1, "\u68c0\u67e5\u66f4\u65b0", UserImages.ICON_UPDATE_IMAGE, false, "(\u5f53\u524d\u7248\u672c:" + PhoneFunction.getVersion() + ")");
        getVersionButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                if (HomePage.this.getVersionDownload == null) {
                    HomePage.this.getVersionDownload = new DataDownload();
                    HomePage.this.getVersionDownload.addDownloadListener(HomePage.this.getVersionListener);
                }
                if (!HomePage.this.getVersionDownload.isDownloading()) {
                    HomePage.this.getVersionDownload.getVersion(sender);
                }
            }
        });
        ItemButton aboutButton = new ItemButton(1, "\u5173\u4e8e", UserImages.ICON_ABOUT_IMAGE, true);
        aboutButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                AboutPage.Show(HomePage.this.self);
            }
        });
        ItemButton serviceButton = new ItemButton(2, "\u7cef\u7c73\u5ba2\u670d:4006-888-887", UserImages.ICON_PHONE_IMAGE, false);
        serviceButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                PhoneFunction.callNuomiServicePhone();
            }
        });
        ItemButton[] itemButtons5 = new ItemButton[]{settingsButton, feedbackButton, getVersionButton, aboutButton, serviceButton};
        this.otherContainer = new ItemButtonGroup(itemButtons5);
        this.otherContainer.getStyle().setMargin(0, 5);
        this.otherContainer.getStyle().setMargin(2, 15);
        this.mynuomiInnerContainer.addComponent(this.otherContainer);
        this.self.addComponent(this.tabControl);
        this.tabControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                HomePage.this.onTabChanged(index);
            }
        });
        this.todayDealsCatalogSelectorControl.setSelectedIndex(0, false);
        this.vouchersCatalogSelectorControl.setSelectedIndex(0, false);
        this.onUserInfoChanged(BasePage.clientInfo.getUserInfo());
        this.needRefreshUserInfo_MyNuomi = BasePage.clientInfo.getLoginInfo() != null && BasePage.clientInfo.getLoginInfo().autoLogin != null && BasePage.clientInfo.getLoginInfo().autoLogin != false;
        BasePage.clientInfo.addLogStatusListener(this.logStatusListener);
    }

    private Container createTabContainer(boolean scrollableY) {
        Container container = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, this.Scroll_Height));
        container.setPreferredW(UserInterface.DISPLAY_WIDTH);
        container.setPreferredH(this.Scroll_Height);
        container.setX(0);
        container.setY(0);
        container.setScrollableY(scrollableY);
        return container;
    }

    private Container createInnerContainer() {
        Container container = new Container(new BoxLayout(2));
        container.setX(0);
        container.setY(0);
        return container;
    }

    protected void onShowCompleted() {
        if (this.cityHadChanged_TodayDeals && this.mainContainer.contains(this.todayDealsContainer)) {
            this.cityChanged_TodayDeal();
        }
        if (this.cityHadChanged_Voucher && this.mainContainer.contains(this.vouchersContainer)) {
            this.cityChanged_Vouchers();
        }
        if (this.needRefreshUserInfo_MyNuomi && this.mainContainer.contains(this.mynuomiScrollContainer)) {
            this.refreshedUserInfo_Mynuomi();
        }
    }

    protected void onTitleClicked() {
        FindCitysPage.Show(this.self);
    }

    protected void onRefreshClicked() {
        if (this.mainContainer.contains(this.todayDealsContainer)) {
            this.downloadRefreshDeals(this.todayDealsCatalogSelectorControl.getSelectedIndex());
            this.cityHadChanged_TodayDeals = false;
        }
        if (this.mainContainer.contains(this.vouchersContainer)) {
            this.downloadRefreshVouchers(this.vouchersCatalogSelectorControl.getSelectedIndex());
            this.cityHadChanged_Voucher = false;
        }
        if (this.mainContainer.contains(this.mynuomiScrollContainer)) {
            this.downloadRefreshUserInfo();
            this.needRefreshUserInfo_MyNuomi = false;
        }
    }

    protected void onCityChanged(City newCity) {
        if (newCity == null || newCity.cityId == null) {
            return;
        }
        this.setTitle(newCity.shortName, true);
        if (this.isShowing()) {
            if (this.mainContainer.contains(this.todayDealsContainer)) {
                this.cityChanged_TodayDeal();
            } else {
                this.cityHadChanged_Voucher = true;
            }
            if (this.mainContainer.contains(this.vouchersContainer)) {
                this.cityChanged_Vouchers();
            } else {
                this.cityHadChanged_TodayDeals = true;
            }
        } else {
            this.cityHadChanged_TodayDeals = true;
            this.cityHadChanged_Voucher = true;
        }
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        if (newUserInfo == null) {
            if (this.logContainer.contains(this.logedContainer)) {
                this.logContainer.removeComponent(this.logedContainer);
            }
            if (!this.logContainer.contains(this.unlogedContainer)) {
                this.logContainer.addComponent(this.unlogedContainer);
            }
        } else {
            if (this.logContainer.contains(this.unlogedContainer)) {
                this.logContainer.removeComponent(this.unlogedContainer);
            }
            if (!this.logContainer.contains(this.logedContainer)) {
                this.logContainer.addComponent(this.logedContainer);
            }
            this.avatarImageControl.setImage(newUserInfo.avatar, true);
            this.emailLabel.setText(newUserInfo.userName);
            this.nickNameLabel.setText(newUserInfo.name);
            if (newUserInfo.actived != null && newUserInfo.actived.booleanValue()) {
                if (this.activeContainer.contains(this.unactivedContainer)) {
                    this.activeContainer.removeComponent(this.unactivedContainer);
                }
                if (!this.activeContainer.contains(this.activedContainer)) {
                    this.activeContainer.addComponent(this.activedContainer);
                }
                this.couponButton.setValue(newUserInfo.couponCount.toString());
                this.postOrderButton.setValue(newUserInfo.postOrderCount.toString());
                this.lotteryButton.setValue(newUserInfo.lotteryCount.toString());
                this.balanceButton.setValue("\uffe5" + Methods.formatPrice(newUserInfo.balance));
            } else {
                if (this.activeContainer.contains(this.activedContainer)) {
                    this.activeContainer.removeComponent(this.activedContainer);
                }
                if (!this.activeContainer.contains(this.unactivedContainer)) {
                    this.activeContainer.addComponent(this.unactivedContainer);
                }
            }
        }
        if (this.mainContainer.contains(this.mynuomiScrollContainer)) {
            if (newUserInfo == null) {
                this.hideRefreshIcon();
            } else {
                this.showRefreshIcon();
            }
        }
        this.repaint();
    }

    private void onTabChanged(int tabIndex) {
        switch (tabIndex) {
            case 0: {
                this.setBackButtonExitIcon();
                this.showRefreshIcon();
                if (this.downloading_TodayDeals) {
                    this.self.startRefresh();
                } else {
                    this.self.endRefresh();
                }
                if (this.mainContainer.contains(this.vouchersContainer)) {
                    this.mainContainer.removeComponent(this.vouchersContainer);
                    if (this.vouchersListBox != null) {
                        this.vouchersListBox.removeAll();
                        this.removeVouchersListMoreTopButton();
                    }
                }
                if (this.mainContainer.contains(this.mynuomiScrollContainer)) {
                    this.mainContainer.removeComponent(this.mynuomiScrollContainer);
                }
                if (this.mainContainer.contains(this.todayDealsContainer)) break;
                this.mainContainer.addComponent(this.todayDealsContainer);
                if (this.cityHadChanged_TodayDeals) {
                    this.cityChanged_TodayDeal();
                    break;
                }
                int catalogIndex = this.todayDealsCatalogSelectorControl.getSelectedIndex();
                this.showRefreshDeals(BasePage.clientInfo.getTodayDeals(catalogIndex), new Integer(catalogIndex));
                break;
            }
            case 1: {
                this.setBackButtonBackIcon();
                this.showRefreshIcon();
                if (this.downloading_Voucher) {
                    this.self.startRefresh();
                } else {
                    this.self.endRefresh();
                }
                if (this.mainContainer.contains(this.todayDealsContainer)) {
                    this.mainContainer.removeComponent(this.todayDealsContainer);
                    if (this.todayDealsListBox != null) {
                        this.todayDealsListBox.removeAll();
                        this.removeTodayDealsListMoreTopButton();
                    }
                }
                if (this.mainContainer.contains(this.mynuomiScrollContainer)) {
                    this.mainContainer.removeComponent(this.mynuomiScrollContainer);
                }
                if (this.mainContainer.contains(this.vouchersContainer)) break;
                this.mainContainer.addComponent(this.vouchersContainer);
                if (this.cityHadChanged_Voucher) {
                    this.cityChanged_Vouchers();
                    break;
                }
                int voucherIndex = this.vouchersCatalogSelectorControl.getSelectedIndex();
                this.showRefreshVouchers(BasePage.clientInfo.getVouchers(voucherIndex), new Integer(voucherIndex));
                break;
            }
            case 2: {
                this.setBackButtonBackIcon();
                if (this.downloading_MyNuomi) {
                    this.startRefresh();
                } else {
                    this.endRefresh();
                }
                UserInfo userInfo = BasePage.clientInfo.getUserInfo();
                if (userInfo == null) {
                    this.hideRefreshIcon();
                }
                if (this.mainContainer.contains(this.todayDealsContainer)) {
                    this.mainContainer.removeComponent(this.todayDealsContainer);
                    if (this.todayDealsListBox != null) {
                        this.todayDealsListBox.removeAll();
                        this.removeTodayDealsListMoreTopButton();
                    }
                }
                if (this.mainContainer.contains(this.vouchersContainer)) {
                    this.mainContainer.removeComponent(this.vouchersContainer);
                    if (this.vouchersListBox != null) {
                        this.vouchersListBox.removeAll();
                        this.removeVouchersListMoreTopButton();
                    }
                }
                if (this.mainContainer.contains(this.mynuomiScrollContainer)) break;
                this.mainContainer.addComponent(this.mynuomiScrollContainer);
                if (!this.needRefreshUserInfo_MyNuomi) break;
                this.refreshedUserInfo_Mynuomi();
                break;
            }
        }
        this.repaint();
    }

    protected void onBack() {
        if (this.tabControl.getSelectedIndex() == 0) {
            super.onBack();
        } else {
            this.tabControl.setSelectedIndex(0);
        }
    }

    private void cityChanged_TodayDeal() {
        int catalogIndex = this.todayDealsCatalogSelectorControl.getSelectedIndex();
        this.showSavedDeals(catalogIndex);
        this.downloadRefreshDeals(catalogIndex);
        this.cityHadChanged_TodayDeals = false;
    }

    private void cityChanged_Vouchers() {
        int catalogIndex = this.vouchersCatalogSelectorControl.getSelectedIndex();
        this.showSavedVouchers(catalogIndex);
        this.downloadRefreshVouchers(catalogIndex);
        this.cityHadChanged_Voucher = false;
    }

    private void refreshedUserInfo_Mynuomi() {
        this.needRefreshUserInfo_MyNuomi = false;
        this.downloadRefreshUserInfo();
    }

    private void selectedDeal(DealPreview dealPreview) {
        DealDetailPage.Show(this.self, dealPreview);
        if (dealPreview != null && dealPreview.tag != null && dealPreview.tag instanceof DealListBoxItem) {
            ((DealListBoxItem)dealPreview.tag).showLookedLabel(true);
            BasePage.clientInfo.AddLookedDeal(dealPreview.dealId);
        }
    }

    private void selectedVoucher(VoucherPreview voucherPreview) {
        VoucherDetailPage.Show(this.self, voucherPreview);
    }

    private void selectedTodayDealsCatalog(int catalogIndex) {
        this.showSavedDeals(catalogIndex);
        if (!BasePage.clientInfo.hadRefreshedTodayDeals(catalogIndex)) {
            this.downloadRefreshDeals(catalogIndex);
        }
    }

    private void downloadRefreshDeals(int catalogIndex) {
        City city = BasePage.clientInfo.getCity();
        if (city != null && city.cityId != null) {
            if (this.dealsDataDownload == null) {
                this.dealsDataDownload = new DataDownload();
                this.dealsDataDownload.addDownloadListener(this.downloadTodayDealsRefreshListener);
            }
            this.dealsDataDownload.DealList(city.cityId, 0, 20, catalogIndex);
        }
    }

    private void showSavedDeals(int catalogIndex) {
        this.todayDealsListBox.removeAll();
        Vector deals = BasePage.clientInfo.getTodayDeals(catalogIndex);
        if (deals != null) {
            this.todayDealsNuomiLogoLabel.setVisible(false);
            this.repaint();
            this.showRefreshDeals(deals, new Integer(catalogIndex));
        } else {
            this.removeTodayDealsListMoreTopButton();
            this.todayDealsScrollContainer.setScrollableY(false);
            this.todayDealsNuomiLogoLabel.setVisible(true);
            this.repaint();
        }
    }

    private void showRefreshDeals(Vector deals, Integer catalogIndex) {
        if (catalogIndex == null || deals == null) {
            return;
        }
        this.removeTodayDealsListMoreTopButton();
        this.todayDealsNuomiLogoLabel.setVisible(false);
        this.todayDealsListBox.removeAll();
        int length = deals.size();
        Vector<ImageControl> imageControlVector = new Vector<ImageControl>();
        int i = catalogIndex == 0 ? 0 : 0;
        while (i < Math.min(10, length)) {
            DealPreview dealPreview = (DealPreview)deals.elementAt(i);
            DealListBoxItem item = new DealListBoxItem(dealPreview);
            dealPreview.tag = item;
            if (catalogIndex.intValue() != this.todayDealsCatalogSelectorControl.getSelectedIndex() || !this.mainContainer.contains(this.todayDealsScrollContainer)) {
                return;
            }
            this.todayDealsListBox.addItem(item);
            ImageControl imageControl = item.getImageControl();
            if (imageControl != null) {
                imageControlVector.addElement(imageControl);
            }
            ++i;
        }
        this.todayDealsScrollContainer.setScrollY(0);
        if (this.todayDealsListBox.getCount() == 0) {
            String catalogName = "";
            if (catalogIndex != 0) {
                catalogName = ClientInfo.TodayDeals_CatalogNames[catalogIndex];
            }
            this.todayDealsListBox.showHint("\u8be5\u57ce\u5e02\u6682\u65f6\u6ca1\u6709" + catalogName + "\u56e2\u8d2d\u4fe1\u606f");
            this.todayDealsScrollContainer.setScrollableY(false);
        } else {
            this.todayDealsScrollContainer.setScrollableY(true);
        }
        this.todayDealsScrollContainer.setScrollSize(null);
        if (BasePage.clientInfo.getAutoLoadImage()) {
            DownloadImageControlsImageThread thread = new DownloadImageControlsImageThread(imageControlVector);
            thread.start();
        }
        this.addTodayDealsListMoreTopButton();
        this.repaint();
    }

    private void onGetMoreDeals(int catalogIndex) {
        if (BasePage.clientInfo.hadRefreshedTodayDeals(catalogIndex)) {
            Vector deals = BasePage.clientInfo.getTodayDeals(catalogIndex);
            if (deals != null) {
                int shownCount;
                int count = deals.size();
                int listCount = this.todayDealsListBox.getCount();
                int n = shownCount = catalogIndex == 0 ? listCount + 0 : listCount;
                if (count > shownCount) {
                    this.showMoreDeals(deals, new Integer(catalogIndex));
                } else {
                    this.downloadMoreDeals(catalogIndex, count, 10);
                }
            }
        } else {
            this.downloadRefreshDeals(catalogIndex);
        }
    }

    private void downloadMoreDeals(int catalogIndex, int start, int offset) {
        City city = BasePage.clientInfo.getCity();
        if (city != null && city.cityId != null) {
            if (this.dealsMoreDataDownload == null) {
                this.dealsMoreDataDownload = new DataDownload();
                this.dealsMoreDataDownload.addDownloadListener(this.downloadTodayDealsMoreListener);
            }
            this.dealsMoreDataDownload.DealList(BasePage.clientInfo.getDealIds(start, offset, catalogIndex), catalogIndex);
        }
    }

    private void showMoreDeals(Vector deals, Integer catalogIndex) {
        if (catalogIndex == null || deals == null) {
            return;
        }
        this.removeTodayDealsListMoreTopButton();
        int length = deals.size();
        int start = this.todayDealsListBox.getCount();
        if (catalogIndex == 0) {
            start += 0;
        }
        int i = start;
        while (i < Math.min(start + 10, length)) {
            DealPreview dealPreview = (DealPreview)deals.elementAt(i);
            try {
                DealListBoxItem item = new DealListBoxItem(dealPreview);
                dealPreview.tag = item;
                if (catalogIndex.intValue() != this.todayDealsCatalogSelectorControl.getSelectedIndex() || !this.mainContainer.contains(this.todayDealsScrollContainer)) {
                    return;
                }
                this.todayDealsListBox.addItem(item);
                item = null;
            }
            catch (OutOfMemoryError e) {
                this.showHint("\u5185\u5b58\u4e0d\u8db3");
                break;
            }
            ++i;
        }
        this.todayDealsScrollContainer.setScrollSize(null);
        this.addTodayDealsListMoreTopButton();
        this.repaint();
        System.out.println(Runtime.getRuntime().totalMemory());
        System.out.println(Runtime.getRuntime().freeMemory());
    }

    private void removeTodayDealsListMoreTopButton() {
        this.todayDealsScrollContainer.setScrollSize(null);
        if (this.todayDealsMoreTopButton != null && this.todayDealsInnerContainer.contains(this.todayDealsMoreTopButton)) {
            this.todayDealsInnerContainer.removeComponent(this.todayDealsMoreTopButton);
        }
    }

    private void addTodayDealsListMoreTopButton() {
        int shownCount;
        if (this.todayDealsMoreTopButton == null) {
            this.todayDealsMoreTopButton = new MoreTopButton();
            if (this.downloading_TodayDeals) {
                this.todayDealsMoreTopButton.setIsLoading(true);
            }
            this.todayDealsMoreTopButton.addTopListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    HomePage.this.todayDealsScrollContainer.setScrollY(0);
                }
            });
            this.todayDealsMoreTopButton.addMoreListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    HomePage.this.onGetMoreDeals(HomePage.this.todayDealsCatalogSelectorControl.getSelectedIndex());
                }
            });
        }
        boolean needAddTop = false;
        boolean needAddMore = false;
        if (this.todayDealsScrollContainer.getScrollDimension().getHeight() > this.todayDealsScrollContainer.getPreferredH()) {
            needAddTop = true;
        }
        int catalogIndex = this.todayDealsCatalogSelectorControl.getSelectedIndex();
        int listCount = this.todayDealsListBox.getCount();
        int n = shownCount = catalogIndex == 0 ? listCount + 0 : listCount;
        if (shownCount < BasePage.clientInfo.getTodayDealsCount(catalogIndex)) {
            needAddMore = true;
        }
        if (needAddTop || needAddMore) {
            if (!this.todayDealsInnerContainer.contains(this.todayDealsMoreTopButton)) {
                int scrollAbledH = this.todayDealsScrollContainer.getScrollDimension().getHeight();
                Dimension d = new Dimension(UserInterface.DISPLAY_WIDTH, scrollAbledH + this.todayDealsMoreTopButton.getPreferredH());
                this.todayDealsInnerContainer.addComponent(this.todayDealsMoreTopButton);
                this.todayDealsScrollContainer.setScrollSize(d);
            }
            this.todayDealsMoreTopButton.showButton(needAddTop, needAddMore);
        }
        this.todayDealsScrollContainer.setScrollSize(null);
    }

    private void selectedVouchersCatalog(int catalogIndex) {
        this.showSavedVouchers(catalogIndex);
        if (BasePage.clientInfo.needRefreshVouchers(catalogIndex)) {
            this.downloadRefreshVouchers(catalogIndex);
        }
    }

    private void downloadRefreshVouchers(int catalogIndex) {
        City city = BasePage.clientInfo.getCity();
        if (city != null && city.cityId != null) {
            if (this.vouchersDataDownload == null) {
                this.vouchersDataDownload = new DataDownload();
                this.vouchersDataDownload.addDownloadListener(this.downloadVouchersRefreshListener);
            }
            switch (catalogIndex) {
                case 0: {
                    this.vouchersDataDownload.voucherHot(city.cityId, 0, 20);
                    break;
                }
                case 1: {
                    this.vouchersDataDownload.voucherAll(city.cityId, -1L, -1L, 0, 20);
                    break;
                }
            }
        }
    }

    private void showSavedVouchers(int catalogIndex) {
        this.vouchersListBox.removeAll();
        Vector vouchers = BasePage.clientInfo.getVouchers(catalogIndex);
        if (vouchers != null) {
            this.vouchersNuomiLogoLabel.setVisible(false);
            this.repaint();
            this.showRefreshVouchers(vouchers, new Integer(catalogIndex));
        } else {
            this.removeVouchersListMoreTopButton();
            this.vouchersScrollContainer.setScrollableY(false);
            this.vouchersNuomiLogoLabel.setVisible(true);
            this.repaint();
        }
    }

    private void showRefreshVouchers(Vector vouchers, Integer catalogIndex) {
        if (catalogIndex == null || vouchers == null) {
            return;
        }
        this.removeVouchersListMoreTopButton();
        this.vouchersNuomiLogoLabel.setVisible(false);
        this.vouchersListBox.removeAll();
        int length = vouchers.size();
        Vector<ImageControl> imageControlVector = new Vector<ImageControl>();
        int i = 0;
        while (i < Math.min(10, length)) {
            VoucherPreview voucherPreview = (VoucherPreview)vouchers.elementAt(i);
            VoucherListBoxItem item = new VoucherListBoxItem(voucherPreview);
            if (catalogIndex.intValue() != this.vouchersCatalogSelectorControl.getSelectedIndex() || !this.mainContainer.contains(this.vouchersScrollContainer)) {
                return;
            }
            this.vouchersListBox.addItem(item);
            ImageControl imageControl = item.getImageControl();
            if (imageControl != null) {
                imageControlVector.addElement(imageControl);
            }
            ++i;
        }
        this.vouchersScrollContainer.setScrollY(0);
        if (this.vouchersListBox.getCount() == 0) {
            this.vouchersListBox.showHint("\u8be5\u57ce\u5e02\u6682\u65f6\u6ca1\u6709" + ClientInfo.Vouchers_CatalogNames[catalogIndex] + "\u4f18\u60e0\u5238");
            this.vouchersScrollContainer.setScrollableY(false);
        } else {
            this.vouchersScrollContainer.setScrollableY(true);
        }
        this.vouchersScrollContainer.setScrollSize(null);
        if (BasePage.clientInfo.getAutoLoadImage()) {
            DownloadImageControlsImageThread thread = new DownloadImageControlsImageThread(imageControlVector);
            thread.start();
        }
        this.addVouchersListMoreTopButton();
        this.repaint();
    }

    private void onGetMoreVouchers(int catalogIndex) {
        Vector vouchers = BasePage.clientInfo.getVouchers(catalogIndex);
        if (vouchers != null) {
            int listCount;
            int count = vouchers.size();
            if (count > (listCount = this.vouchersListBox.getCount())) {
                this.showMoreVouchers(vouchers, new Integer(catalogIndex));
            } else {
                this.downloadMoreVouchers(catalogIndex, count, 10);
            }
        }
    }

    private void downloadMoreVouchers(int catalogIndex, int start, int offset) {
        City city = BasePage.clientInfo.getCity();
        if (city != null && city.cityId != null) {
            if (this.vouchersMoreDataDownload == null) {
                this.vouchersMoreDataDownload = new DataDownload();
                this.vouchersMoreDataDownload.addDownloadListener(this.downloadVouchersMoreListener);
            }
            switch (catalogIndex) {
                case 0: {
                    this.vouchersMoreDataDownload.voucherHot(city.cityId, start, offset);
                    break;
                }
                case 1: {
                    this.vouchersMoreDataDownload.voucherAll(city.cityId, -1L, -1L, start, offset);
                    break;
                }
            }
        }
    }

    private void showMoreVouchers(Vector vouchers, Integer catalogIndex) {
        int start;
        if (catalogIndex == null || vouchers == null) {
            return;
        }
        this.removeVouchersListMoreTopButton();
        int length = vouchers.size();
        int i = start = this.vouchersListBox.getCount();
        while (i < Math.min(start + 10, length)) {
            VoucherPreview voucherPreview = (VoucherPreview)vouchers.elementAt(i);
            try {
                VoucherListBoxItem item = new VoucherListBoxItem(voucherPreview);
                if (catalogIndex.intValue() != this.vouchersCatalogSelectorControl.getSelectedIndex() || !this.mainContainer.contains(this.vouchersScrollContainer)) {
                    return;
                }
                this.vouchersListBox.addItem(item);
                item = null;
            }
            catch (OutOfMemoryError e) {
                this.showHint("\u5185\u5b58\u4e0d\u8db3");
                break;
            }
            ++i;
        }
        this.vouchersScrollContainer.setScrollSize(null);
        this.addVouchersListMoreTopButton();
        this.repaint();
    }

    private void removeVouchersListMoreTopButton() {
        this.vouchersScrollContainer.setScrollSize(null);
        if (this.vouchersMoreTopButton != null && this.vouchersInnerContainer.contains(this.vouchersMoreTopButton)) {
            this.vouchersInnerContainer.removeComponent(this.vouchersMoreTopButton);
        }
    }

    private void addVouchersListMoreTopButton() {
        if (this.vouchersMoreTopButton == null) {
            this.vouchersMoreTopButton = new MoreTopButton();
            if (this.downloading_Voucher) {
                this.vouchersMoreTopButton.setIsLoading(true);
            }
            this.vouchersMoreTopButton.addTopListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    HomePage.this.vouchersScrollContainer.setScrollY(0);
                }
            });
            this.vouchersMoreTopButton.addMoreListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    HomePage.this.onGetMoreVouchers(HomePage.this.vouchersCatalogSelectorControl.getSelectedIndex());
                }
            });
        }
        boolean needAddTop = false;
        boolean needAddMore = false;
        if (this.vouchersScrollContainer.getScrollDimension().getHeight() > this.vouchersScrollContainer.getPreferredH()) {
            needAddTop = true;
        }
        int catalogIndex = this.vouchersCatalogSelectorControl.getSelectedIndex();
        int listCount = this.vouchersListBox.getCount();
        if (listCount < BasePage.clientInfo.getVouchersCount(catalogIndex)) {
            needAddMore = true;
        }
        if (needAddTop || needAddMore) {
            if (!this.vouchersInnerContainer.contains(this.vouchersMoreTopButton)) {
                int scrollAbledH = this.vouchersScrollContainer.getScrollDimension().getHeight();
                Dimension d = new Dimension(UserInterface.DISPLAY_WIDTH, scrollAbledH + this.vouchersMoreTopButton.getPreferredH());
                this.vouchersInnerContainer.addComponent(this.vouchersMoreTopButton);
                this.vouchersScrollContainer.setScrollSize(d);
            }
            this.vouchersMoreTopButton.showButton(needAddTop, needAddMore);
        }
        this.vouchersScrollContainer.setScrollSize(null);
    }

    private void downloadRefreshUserInfo() {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null) {
            if (this.refreshUserInfoDataDownload == null) {
                this.refreshUserInfoDataDownload = new DataDownload();
                this.refreshUserInfoDataDownload.addDownloadListener(this.refreshUserInfoDataDownloadListener);
            }
            this.refreshUserInfoDataDownload.nuomidata(userInfo.userId, userInfo.ticket);
        }
    }
}

