/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.DealPreview;
import com.nuomi.data.JoinLotteryResult;
import com.nuomi.data.ResultInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.BindingPhonePage;
import com.nuomi.pages.JoinLotterySucceedPage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class JoinLotteryPage
extends BasePage {
    private static JoinLotteryPage _JoinLotteryPage = null;
    private Container container = null;
    private TextBox phoneTextBox = null;
    private Container content = null;
    private ContentContainer contentContainer = null;
    private Button joinButton = null;
    private DealPreview _dealPreview = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            JoinLotteryPage.this.startRefresh();
            JoinLotteryPage.this.showRefreshIcon();
            JoinLotteryPage.this.joinButton.setEnabled(false);
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof JoinLotteryResult) {
                ResultInfo resultInfo = ((JoinLotteryResult)data).result;
                if (resultInfo.isSucceed()) {
                    JoinLotterySucceedPage.Show(JoinLotteryPage.this.parentPage, (JoinLotteryResult)data);
                } else if (resultInfo.isLogExpired()) {
                    if (JoinLotteryPage.this.getCurrentForm() == JoinLotteryPage.this.self && !MessageBox.isShow) {
                        if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                            LogPage.Show(JoinLotteryPage.this.self, true);
                        }
                        showHint = false;
                    }
                } else {
                    if (resultInfo.succ == -1) {
                        JoinLotterySucceedPage.Show(JoinLotteryPage.this.parentPage, (JoinLotteryResult)data);
                    }
                    hintString = resultInfo.msg;
                }
                JoinLotteryPage.this.joinButton.setEnabled(true);
            }
            JoinLotteryPage.this.hideRefreshIcon();
            JoinLotteryPage.this.endRefresh();
            if (showHint) {
                JoinLotteryPage.this.showHint(hintString);
            }
            JoinLotteryPage.this.repaint();
        }
    };

    public static void Show(BasePage parentPage, DealPreview dealPreview) {
        if (_JoinLotteryPage == null) {
            _JoinLotteryPage = new JoinLotteryPage();
        }
        _JoinLotteryPage.setContent(dealPreview);
        _JoinLotteryPage.setParent(parentPage);
        _JoinLotteryPage.show();
    }

    private JoinLotteryPage() {
        this.setTitle("\u62bd\u5956");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.container = new Container(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.mainContainer.addComponent(this.container);
        this.container.setPreferredW(this.mainContainer.getPreferredW());
        this.container.setPreferredH(this.mainContainer.getPreferredH());
        this.joinButton = UserInterface.createBigButton("\u53c2\u4e0e\u62bd\u5956");
        this.joinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoinLotteryPage.this.onJoinLottery();
            }
        });
        Container joinContainer = new Container();
        this.mainContainer.addComponent(joinContainer);
        joinContainer.setPreferredW(this.mainContainer.getPreferredW());
        joinContainer.setPreferredH(this.joinButton.getPreferredH() + 10);
        joinContainer.setLayout(new CoordinateLayout(joinContainer.getPreferredW(), joinContainer.getPreferredH()));
        joinContainer.addComponent(this.joinButton);
        joinContainer.setX(0);
        joinContainer.setY(this.mainContainer.getPreferredH() - joinContainer.getPreferredH());
        joinContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
        this.joinButton.setX((joinContainer.getPreferredW() - this.joinButton.getPreferredW()) / 2);
        this.joinButton.setY(5);
    }

    protected void onBack() {
        this.container.removeAll();
        this.phoneTextBox = null;
        this.content = null;
        this.contentContainer = null;
        System.gc();
        super.onBack();
    }

    private void setContent(DealPreview dealPreview) {
        this._dealPreview = dealPreview;
        if (dealPreview == null) {
            return;
        }
        this.content = new Container(new BoxLayout(2));
        if (!Methods.isNullOrWhitespace(dealPreview.middleTitle)) {
            Vector middleTitleVector = Methods.splitString(dealPreview.middleTitle, UserInterface.FONT_NORMAL, 0, 345);
            LabelGroup middleTitleGroup = new LabelGroup(middleTitleVector, UserInterface.FONT_NORMAL, 6453130, 30);
            this.content.addComponent(middleTitleGroup);
            Label spLabel = new Label();
            this.content.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(0, 15);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(middleTitleGroup.getPreferredW());
            spLabel.setPreferredH(1);
        }
        Container phoneContainer = new Container(new BorderLayout());
        phoneContainer.getStyle().setMargin(5, 0, 5, 5);
        Label phoneLabel = new Label("\u624b\u673a\u53f7\u7801:*");
        phoneContainer.addComponent("West", (Component)phoneLabel);
        phoneLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        this.phoneTextBox = new TextBox(3);
        if (userInfo != null) {
            this.phoneTextBox.setText(userInfo.phone);
            this.phoneTextBox.setEnabled(Methods.isNullOrWhitespace(this.phoneTextBox.getText()) || !PhoneFunction.isPhoneNumber(userInfo.userName));
        }
        phoneContainer.addComponent("Center", (Component)this.phoneTextBox);
        phoneContainer.setPreferredH(phoneContainer.getPreferredH());
        phoneContainer.setPreferredW(330);
        this.content.addComponent(phoneContainer);
        Label hintLabel = new Label("\u62bd\u4e2d\u5927\u5956\u540e\u901a\u8fc7\u624b\u673a\u53f7\u548c\u60a8\u8054\u7cfb");
        this.content.addComponent(hintLabel);
        hintLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        hintLabel.getStyle().setFgColor(9084854);
        this.contentContainer = new ContentContainer(this.content, 0, 15);
        this.container.addComponent(this.contentContainer);
        this.contentContainer.setY(5);
    }

    private void onJoinLottery() {
        String phoneText;
        String string = phoneText = this.phoneTextBox == null ? null : this.phoneTextBox.getText();
        if (Methods.isNullOrWhitespace(phoneText)) {
            this.showHint("\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
            this.phoneTextBox.setFocus(true);
            return;
        }
        if (!PhoneFunction.isPhoneNumber(phoneText)) {
            this.showHint("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            this.phoneTextBox.setFocus(true);
            return;
        }
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null && this._dealPreview != null) {
            if (!Methods.equals(userInfo.phone, phoneText)) {
                BindingPhonePage.Show(this.self, phoneText);
            } else {
                DataDownload dataDownload = new DataDownload();
                dataDownload.addDownloadListener(this.listener);
                dataDownload.joinLottery(userInfo.userId, userInfo.ticket, this._dealPreview.dealId);
            }
        }
    }
}

