/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.Main;
import com.nuomi.clientinfo.LoginInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.listener.LogStatusListener;
import com.nuomi.pages.ActivePage;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.RegisterPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.CheckButton;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Base64;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;

public class LogPage
extends BasePage {
    private static LogPage _LogPage = null;
    private final int TOP_MARGIN;
    private TextBox emailTextBox = null;
    private TextBox passwordTextBox = null;
    private CheckButton autoButton = null;
    private Button logButton = null;
    private Button registerButton = null;
    private ContentContainer contentContainer = null;
    private Container content = null;
    private Container codeLayoutContainer = null;
    private Container codeContainer = null;
    private TextBox codeTextBox = null;
    private Button codeButton = null;
    private boolean isLoging = true;
    private LoginInfo loginInfo = null;
    private LogStatusListener logStatusListener = new LogStatusListener(){

        public void onSucceed(UserInfo userInfo) {
            BasePage.clientInfo.setLoginInfo(LogPage.this.loginInfo);
            if (userInfo != null) {
                if (userInfo.actived != null && userInfo.actived.booleanValue()) {
                    ((LogPage)LogPage.this.self).onBack();
                } else {
                    ActivePage.Show(LogPage.this.self);
                }
            }
            ((LogPage)LogPage.this.self).setLoging(false);
        }

        public void onFailed(String reason, String codeData) {
            LogPage.this.self.showHint(reason);
            ((LogPage)LogPage.this.self).setLoging(false);
            if (!Methods.isNullOrWhitespace(codeData)) {
                LogPage.this.showCodeInput(codeData);
            }
        }

        public void onCancelled() {
            ((LogPage)LogPage.this.self).setLoging(false);
        }
    };

    public static void Show(BasePage parentPage) {
        LogPage.Show(parentPage, false);
    }

    public static void Show(BasePage parentPage, boolean showPassw) {
        if (_LogPage == null) {
            _LogPage = new LogPage();
        }
        _LogPage.setParent(parentPage);
        LoginInfo loginInfo = Main.clientInfo.getLoginInfo();
        if (loginInfo != null) {
            LogPage._LogPage.emailTextBox.setText(loginInfo.userName);
            if (showPassw) {
                LogPage._LogPage.passwordTextBox.setText(loginInfo.password);
            } else {
                LogPage._LogPage.passwordTextBox.setText("");
            }
        }
        LogPage._LogPage.autoButton.setChecked(true);
        _LogPage.setLoging(BasePage.clientInfo.isLoging());
        _LogPage.hideCodeInput();
        _LogPage.show();
        if (showPassw) {
            _LogPage.onLog();
        }
    }

    private LogPage() {
        this.TOP_MARGIN = 20;
        this.self.setTitle("\u767b\u5f55");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new BoxLayout(2));
        this.content = new Container(new BoxLayout(2));
        this.emailTextBox = new TextBox(1);
        this.content.addComponent(this.emailTextBox);
        this.emailTextBox.setHint("\u90ae\u7bb1/\u624b\u673a\u53f7");
        if (BasePage.clientInfo.getLoginInfo() != null) {
            this.emailTextBox.setText(BasePage.clientInfo.getLoginInfo().userName);
        }
        this.passwordTextBox = new TextBox(65536);
        this.content.addComponent(this.passwordTextBox);
        this.passwordTextBox.setHint("\u8bf7\u8f93\u5165\u5bc6\u7801");
        this.passwordTextBox.getStyle().setMargin(0, 20);
        this.codeLayoutContainer = new Container(new BoxLayout(2));
        this.content.addComponent(this.codeLayoutContainer);
        this.codeContainer = new Container(new BorderLayout());
        this.codeContainer.getStyle().setMargin(0, 20);
        this.codeTextBox = new TextBox(0);
        this.codeContainer.addComponent("Center", (Component)this.codeTextBox);
        this.codeTextBox.setHint("\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
        this.codeButton = UserInterface.createEmptyButton();
        this.codeButton.setPreferredW(105);
        this.codeButton.setPreferredH(40);
        this.codeContainer.addComponent("East", (Component)this.codeButton);
        this.codeContainer.setPreferredW(340);
        this.codeContainer.setPreferredH(this.codeTextBox.getPreferredH());
        Container autoContainer = new Container(new BorderLayout());
        this.content.addComponent(autoContainer);
        autoContainer.getStyle().setMargin(0, 10);
        this.autoButton = new CheckButton(true, "\u8bb0\u4f4f\u767b\u5f55\u72b6\u6001");
        autoContainer.addComponent("West", (Component)this.autoButton);
        this.logButton = UserInterface.createButton("\u767b\u5f55");
        this.logButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPage.this.onLog();
            }
        });
        this.registerButton = UserInterface.createButton("\u6ce8\u518c");
        this.registerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPage.this.onRegister();
            }
        });
        int margin = Math.max(0, (this.content.getPreferredW() - this.logButton.getPreferredW() - this.registerButton.getPreferredW()) / 3);
        int buttonContainerWidth = margin + this.logButton.getPreferredW() + this.registerButton.getPreferredW();
        int buttonContainerHeight = this.logButton.getPreferredH();
        Container buttonContainer = new Container(new CoordinateLayout(buttonContainerWidth, buttonContainerHeight));
        buttonContainer.setPreferredW(buttonContainerWidth);
        buttonContainer.setPreferredH(buttonContainerHeight);
        this.content.addComponent(buttonContainer);
        buttonContainer.addComponent(this.logButton);
        buttonContainer.addComponent(this.registerButton);
        this.logButton.setX(0);
        this.logButton.setY(0);
        this.registerButton.setX(this.logButton.getPreferredW() + margin);
        this.registerButton.setY(0);
        this.contentContainer = new ContentContainer(this.content, 20, 20);
        this.mainContainer.addComponent(this.contentContainer);
        this.contentContainer.getStyle().setMargin(0, 5);
        BasePage.clientInfo.addLogStatusListener(this.logStatusListener);
    }

    public void setLoging(boolean isLoging) {
        if (this.isLoging != isLoging) {
            this.isLoging = isLoging;
            this.emailTextBox.setEnabled(!isLoging);
            this.passwordTextBox.setEnabled(!isLoging);
            this.autoButton.setEnabled(!isLoging);
            this.logButton.setText(isLoging ? "\u53d6\u6d88" : "\u767b\u5f55");
            this.registerButton.setEnabled(!isLoging);
            if (isLoging) {
                this.showRefreshIcon();
            } else {
                this.hideRefreshIcon();
            }
            this.setRefresh(isLoging);
        }
        this.repaint();
    }

    public boolean isLoging() {
        return this.isLoging;
    }

    protected void onBack() {
        if (BasePage.clientInfo.isLoging()) {
            BasePage.clientInfo.cancelLogin();
        }
        super.onBack();
    }

    private void showCodeInput(String codeData) {
        byte[] code = Base64.decode(codeData);
        this.codeButton.setIcon(Image.createImage(code, 0, code.length));
        if (!this.codeLayoutContainer.contains(this.codeContainer)) {
            this.codeLayoutContainer.addComponent(this.codeContainer);
            this.contentContainer.setCenterHeight(this.content.getPreferredH());
        }
        this.repaint();
    }

    private void hideCodeInput() {
        if (this.codeLayoutContainer.contains(this.codeContainer)) {
            this.codeButton.setIcon(null);
            this.codeLayoutContainer.removeComponent(this.codeContainer);
            this.contentContainer.setCenterHeight(this.content.getPreferredH());
        }
    }

    private void onLog() {
        if (this.isLoging) {
            BasePage.clientInfo.cancelLogin();
        } else {
            String email = this.emailTextBox.getText();
            if (Methods.isNullOrWhitespace(email)) {
                this.showHint("\u90ae\u7bb1/\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                this.emailTextBox.setFocus(true);
                return;
            }
            String password = this.passwordTextBox.getText();
            if (Methods.isNullOrEmpty(password)) {
                this.showHint("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.passwordTextBox.setFocus(true);
                return;
            }
            String code = null;
            if (this.codeLayoutContainer.contains(this.codeContainer) && Methods.isNullOrEmpty(code = this.codeTextBox.getText().trim())) {
                this.showHint("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.codeTextBox.setFocus(true);
                return;
            }
            ((LogPage)this.self).setLoging(true);
            if (this.loginInfo == null) {
                this.loginInfo = new LoginInfo(this.emailTextBox.getText(), this.passwordTextBox.getText(), this.autoButton.isChecked());
            } else {
                this.loginInfo.userName = this.emailTextBox.getText();
                this.loginInfo.password = this.passwordTextBox.getText();
                this.loginInfo.autoLogin = new Boolean(this.autoButton.isChecked());
            }
            BasePage.clientInfo.startLogin(email, password, code);
        }
    }

    private void onRegister() {
        RegisterPage.Show(this.parentPage);
    }
}

