/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.connect.DataDownload;
import com.nuomi.data.Lottery;
import com.nuomi.data.LotteryDeal;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.TextPage;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.DetailTitleContainer;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.usercontrol.ItemButtonGroup;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TabControl;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class LotteryDetailPage
extends BasePage {
    private static LotteryDetailPage _LotteryDetailPage = null;
    private TabControl tabControl = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private Lottery _lottery = null;
    private LotteryDeal _lotteryDeal = null;
    private Label currentPriceLabel = null;
    private Label discountLabel = null;
    private Label marketPriceLabel = null;
    private Label endTimeLabel = null;
    private Label saleCountLabel = null;
    private ImageControl image = null;
    private Container sampleContainer = null;
    private Container detailContainer = null;
    private DataDownload dealDownload = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            LotteryDetailPage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof LotteryDeal) {
                BasePage.clientInfo.setDealDetail(((LotteryDetailPage)LotteryDetailPage.this)._lottery.dealId, data);
                LotteryDetailPage.this.showLotteryDeal((LotteryDeal)data);
                try {
                    Thread.sleep(800L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                LotteryDetailPage.this.self.repaint();
            }
            if (result != 3) {
                LotteryDetailPage.this.showHint(hintString);
                LotteryDetailPage.this.endRefresh();
            }
        }
    };

    public static void Show(BasePage parentPage, Lottery lottery, boolean hadEnded) {
        if (_LotteryDetailPage == null) {
            _LotteryDetailPage = new LotteryDetailPage();
        }
        _LotteryDetailPage.setContent(lottery, hadEnded);
        _LotteryDetailPage.setParent(parentPage);
        _LotteryDetailPage.show();
    }

    private LotteryDetailPage() {
        this.setTitle("\u6211\u7684\u62bd\u5956\u5355");
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.tabControl = new TabControl(UserImages.LOTTERYDETAILTAB_TAB_BG_IMAGE, UserImages.LOTTERYDETAILTAB_TABS_IMAGE, false);
        this.tabControl.setX(0);
        this.tabControl.setY(this.mainContainer.getPreferredH() - this.tabControl.getPreferredH());
        this.tabControl.setDisabledImage(0, UserImages.LOTTERYDETAILTAB_RESULT_DISABLED_BG_IMAGE);
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - this.tabControl.getClickHeight());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 10);
        this.sampleContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.sampleContainer);
        this.detailContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.detailContainer);
        ItemButton serviceButton = new ItemButton(3, "\u7cef\u7c73\u5ba2\u670d:4006-888-887", UserImages.ICON_PHONE_IMAGE, false);
        serviceButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                PhoneFunction.callNuomiServicePhone();
            }
        });
        ItemButton[] itemButtons = new ItemButton[]{serviceButton};
        ItemButtonGroup serviceContainer = new ItemButtonGroup(itemButtons);
        this.innerContainer.addComponent(serviceContainer);
        serviceContainer.getStyle().setMargin(0, 5);
        this.mainContainer.addComponent(this.tabControl);
        this.tabControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                switch (index) {
                    case 0: {
                        LotteryDetailPage.this.showResult();
                        break;
                    }
                    case 1: {
                        LotteryDetailPage.this.onShareClicked();
                        break;
                    }
                }
            }
        });
    }

    private void setContent(Lottery lottery, boolean hadEnded) {
        this.scrollContainer.setScrollY(0);
        this._lottery = lottery;
        if (lottery == null) {
            return;
        }
        if (this.tabControl != null) {
            this.tabControl.setTabEnabled(0, hadEnded);
        }
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        Container previewContainer = new Container(new BoxLayout(2));
        previewContainer.getStyle().setPadding(1, 10);
        previewContainer.getStyle().setPadding(3, 10);
        DetailTitleContainer titleContainer = new DetailTitleContainer("\u62bd\u5956\u53f7", lottery.password, hadEnded ? 9084854 : 15492920, hadEnded ? "\u5df2\u7ed3\u675f" : "\u672a\u7ed3\u675f", false, null);
        previewContainer.addComponent(titleContainer);
        titleContainer.getStyle().setMargin(1, 5);
        titleContainer.getStyle().setMargin(3, 5);
        if (lottery.middleTitle != null) {
            Vector middleTitleVector = Methods.splitString(lottery.middleTitle, UserInterface.FONT_NORMAL, 0, 330);
            LabelGroup middleTitleGroup = new LabelGroup(middleTitleVector, UserInterface.FONT_NORMAL, 6453130, 330, 25);
            previewContainer.addComponent(middleTitleGroup);
            middleTitleGroup.getStyle().setMargin(1, 10);
            middleTitleGroup.getStyle().setMargin(0, 10);
        }
        int imagePriceWidth = 340;
        int imagePriceHeight = 99;
        Container imagePriceContainer = new Container(new CoordinateLayout(imagePriceWidth, imagePriceHeight));
        imagePriceContainer.setPreferredW(imagePriceWidth);
        imagePriceContainer.setPreferredH(imagePriceHeight);
        previewContainer.addComponent(imagePriceContainer);
        imagePriceContainer.getStyle().setMargin(0, 5);
        imagePriceContainer.getStyle().setMargin(1, 10);
        this.image = new ImageControl(165, imagePriceHeight);
        imagePriceContainer.addComponent(this.image);
        this.image.setX(0);
        this.image.setY(0);
        this.image.setImage(lottery.image, true);
        Container priceContainer = new Container(new CoordinateLayout(imagePriceWidth - this.image.getPreferredW() - 5, imagePriceHeight));
        priceContainer.setPreferredW(imagePriceWidth - this.image.getPreferredW() - 5);
        priceContainer.setPreferredH(imagePriceHeight);
        imagePriceContainer.addComponent(priceContainer);
        priceContainer.setX(this.image.getPreferredW() + 20);
        priceContainer.setY(0);
        this.currentPriceLabel = new Label();
        this.currentPriceLabel.getStyle().setFont(UserInterface.FONT_LARGE);
        priceContainer.addComponent(this.currentPriceLabel);
        this.currentPriceLabel.setX(0);
        this.currentPriceLabel.setY(0);
        this.currentPriceLabel.setEndsWith3Points(false);
        this.discountLabel = new Label();
        this.discountLabel.setText("\u6298\u6263:");
        this.discountLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(this.discountLabel);
        this.discountLabel.setX(0);
        this.discountLabel.setY(priceContainer.getPreferredH() - this.discountLabel.getPreferredH());
        this.discountLabel.setEndsWith3Points(false);
        this.marketPriceLabel = new Label();
        this.marketPriceLabel.setText("\u539f\u4ef7:\uffe5");
        this.marketPriceLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(this.marketPriceLabel);
        this.marketPriceLabel.setX(0);
        this.marketPriceLabel.setY(priceContainer.getPreferredH() - this.discountLabel.getPreferredH() - this.marketPriceLabel.getPreferredH());
        this.marketPriceLabel.setEndsWith3Points(false);
        Container saleCountContainer = new Container();
        previewContainer.addComponent(saleCountContainer);
        saleCountContainer.setPreferredW(350);
        saleCountContainer.setPreferredH(30);
        saleCountContainer.setLayout(new CoordinateLayout(saleCountContainer.getPreferredW(), saleCountContainer.getPreferredH()));
        saleCountContainer.getStyle().setMargin(0, 5);
        this.saleCountLabel = new Label(" ");
        this.saleCountLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        saleCountContainer.addComponent(this.saleCountLabel);
        this.saleCountLabel.setX((saleCountContainer.getPreferredW() - this.saleCountLabel.getPreferredW()) / 2);
        this.saleCountLabel.setY((saleCountContainer.getPreferredH() - this.saleCountLabel.getPreferredH()) / 2);
        this.saleCountLabel.setEndsWith3Points(false);
        if (!hadEnded) {
            Container endTimeContainer = new Container();
            previewContainer.addComponent(endTimeContainer);
            endTimeContainer.setPreferredW(350);
            endTimeContainer.setPreferredH(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getHeight());
            endTimeContainer.setLayout(new CoordinateLayout(endTimeContainer.getPreferredW(), endTimeContainer.getPreferredH()));
            endTimeContainer.getStyle().setMargin(0, 5);
            this.endTimeLabel = new Label("\u7ed3\u675f\u65f6\u95f4:" + CalendarFormat.toYMD(lottery.endTimeCalendar));
            endTimeContainer.addComponent(this.endTimeLabel);
            this.endTimeLabel.getStyle().setAlignment(4);
            this.endTimeLabel.getStyle().setFont(UserInterface.FONT_SMALL);
            this.endTimeLabel.getStyle().setFgColor(0xFFFFFF);
            this.endTimeLabel.setPreferredW(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getWidth());
            this.endTimeLabel.setPreferredH(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getHeight());
            this.endTimeLabel.getStyle().setBgImage(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE);
            this.endTimeLabel.setX((endTimeContainer.getPreferredW() - this.endTimeLabel.getPreferredW()) / 2);
            this.endTimeLabel.setY(0);
        }
        ContentContainer previewContentContainer = new ContentContainer(previewContainer, UserImages.USERCONTAINER_PREVIEW_BOTTOM_IMAGE, 0, 15);
        this.sampleContainer.addComponent(previewContentContainer);
        previewContentContainer.getStyle().setMargin(0, 5);
        LotteryDeal lotteryDeal = BasePage.clientInfo.getLotteryDealDetail(lottery.dealId);
        if (lotteryDeal != null) {
            this.showLotteryDeal(lotteryDeal);
        }
        this.onRefresh();
    }

    protected void onRefreshClicked() {
        this.onRefresh();
    }

    private void onRefresh() {
        if (this._lottery != null && this._lottery.dealId != null) {
            if (this.dealDownload == null) {
                this.dealDownload = new DataDownload();
                this.dealDownload.addDownloadListener(this.listener);
            } else {
                this.dealDownload.cancel();
            }
            this.dealDownload.lotteryDetail(this._lottery.dealId);
        }
    }

    protected void onBack() {
        if (this.dealDownload != null) {
            this.dealDownload.cancel();
        }
        this.endRefresh();
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        if (this.image != null) {
            this.image.stop();
        }
        this.image = null;
        this.currentPriceLabel = null;
        this.discountLabel = null;
        this.marketPriceLabel = null;
        this.saleCountLabel = null;
        this.endTimeLabel = null;
        System.gc();
        super.onBack();
    }

    private void showLotteryDeal(LotteryDeal lotteryDeal) {
        if (lotteryDeal == null) {
            return;
        }
        try {
            this._lotteryDeal = lotteryDeal;
            this.image.setImage(lotteryDeal.image, true);
            if (!Methods.isNullOrWhitespace(lotteryDeal.result)) {
                this.tabControl.setTabEnabled(0, true);
            }
            if (lotteryDeal.currentPrice != null) {
                this.currentPriceLabel.setText("\uffe5" + Methods.formatPrice(lotteryDeal.currentPrice));
            }
            if (lotteryDeal.discount != null) {
                this.discountLabel.setText("\u6298\u6263:" + lotteryDeal.discount + "\u6298");
            }
            if (lotteryDeal.market != null) {
                this.marketPriceLabel.setText("\u539f\u4ef7:\uffe5" + Methods.formatPrice(lotteryDeal.market));
            }
            if (lotteryDeal.saleCount != null) {
                this.saleCountLabel.setText(lotteryDeal.saleCount + "\u4eba\u5df2\u8d2d\u4e70");
                Container saleCountContainer = this.saleCountLabel.getParent();
                if (saleCountContainer != null) {
                    this.saleCountLabel.setX((saleCountContainer.getPreferredW() - this.saleCountLabel.getPreferredW()) / 2);
                }
            }
            this.repaint();
            this.detailContainer.removeAll();
            if (!Methods.isNullOrWhitespace(lotteryDeal.gameDetail)) {
                ContentContainer gameDetailContainer = new ContentContainer("\u6d3b\u52a8\u8be6\u60c5", lotteryDeal.gameDetail);
                this.detailContainer.addComponent(gameDetailContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(lotteryDeal.highlights)) {
                ContentContainer highlightsContainer = new ContentContainer("\u7279\u8272\u4eae\u70b9", lotteryDeal.highlights);
                this.detailContainer.addComponent(highlightsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(lotteryDeal.rule)) {
                ContentContainer ruleContainer = new ContentContainer("\u62bd\u5956\u89c4\u5219", lotteryDeal.rule);
                this.detailContainer.addComponent(ruleContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(lotteryDeal.businessInfo)) {
                ContentContainer businessContainer = new ContentContainer("\u5546\u5bb6\u4fe1\u606f", lotteryDeal.businessInfo);
                this.detailContainer.addComponent(businessContainer);
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showResult() {
        if (this._lotteryDeal == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else {
            TextPage.Show(this.self, "\u62bd\u5956\u7ed3\u679c", this._lotteryDeal.result);
        }
    }

    private void onShareClicked() {
        if (this._lottery != null && !Methods.isNullOrWhitespace(this._lottery.share)) {
            PhoneFunction.callSendSMS(this._lottery.share);
        }
    }
}

