/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.FindMyNuomiInfo;
import com.nuomi.data.Lottery;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.ListBoxClickedListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.LotteryDetailPage;
import com.nuomi.usercontrol.CatalogSelectorControl;
import com.nuomi.usercontrol.ListBox;
import com.nuomi.usercontrol.MoreTopButton;
import com.nuomi.usercontrol.lotterylistpage.EndedLotteryListBoxItem;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class LotteryListPage
extends BasePage {
    private static LotteryListPage _LotteryListPage = null;
    private Container[] scrollContainers = null;
    private Container[] innerContainers = null;
    private ListBox[] listBoxs = null;
    private boolean[] userChanged = null;
    private boolean[] downloading = null;
    private Label[] nuomiLogoLabels = null;
    private MoreTopButton[] moreTopButtons = null;
    private CatalogSelectorControl endSelectorControl = null;
    private boolean showByHideMessageBox = false;
    private DataDownloadListener refreshDownloadListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            LotteryListPage.this.startRefresh();
            if (tag != null && tag instanceof Integer) {
                int index = (Integer)tag;
                try {
                    ((LotteryListPage)LotteryListPage.this).downloading[index] = true;
                    ((LotteryListPage)LotteryListPage.this).userChanged[index] = false;
                    LotteryListPage.this.moreTopButtons[index].setIsLoading(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            int index = -1;
            String hintText = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (tag != null && tag instanceof Integer) {
                index = (Integer)tag;
                ((LotteryListPage)LotteryListPage.this).downloading[index] = false;
                if (result == 2 && data instanceof FindMyNuomiInfo) {
                    FindMyNuomiInfo info = (FindMyNuomiInfo)data;
                    if (info.result.isSucceed()) {
                        BasePage.clientInfo.setLotteryInfo(info, index);
                        LotteryListPage.this.showRefresh(BasePage.clientInfo.getLotteryInfo(index), index);
                    } else if (info.result.isLogExpired()) {
                        if (LotteryListPage.this.getCurrentForm() == LotteryListPage.this.self && !MessageBox.isShow) {
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(LotteryListPage.this.self, true);
                            } else {
                                LotteryListPage.this.showByHideMessageBox = true;
                                ((LotteryListPage)LotteryListPage.this).userChanged[index] = true;
                                showHint = false;
                            }
                        }
                    } else {
                        hintText = info.result.msg;
                    }
                }
                if (showHint && result != 3) {
                    LotteryListPage.this.showHint(String.valueOf(hintText) + "(" + ClientInfo.Lottery_AllCatalogNames[index] + "\u62bd\u5956\u5355)");
                }
                if (LotteryListPage.this.moreTopButtons[index] != null) {
                    LotteryListPage.this.moreTopButtons[index].setIsLoading(false);
                }
                if (LotteryListPage.this.endSelectorControl.getSelectedIndex() == index) {
                    LotteryListPage.this.endRefresh();
                }
                LotteryListPage.this.repaint();
            }
        }
    };
    private DataDownloadListener moreDownloadListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            LotteryListPage.this.startRefresh();
            if (tag != null && tag instanceof Integer) {
                int index = (Integer)tag;
                try {
                    ((LotteryListPage)LotteryListPage.this).downloading[index] = true;
                    LotteryListPage.this.moreTopButtons[index].setIsLoading(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            int index = -1;
            String hintText = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (tag != null && tag instanceof Integer) {
                index = (Integer)tag;
                ((LotteryListPage)LotteryListPage.this).downloading[index] = false;
                if (result == 2 && data instanceof FindMyNuomiInfo) {
                    FindMyNuomiInfo info = (FindMyNuomiInfo)data;
                    if (info.result.isSucceed()) {
                        BasePage.clientInfo.addLotteryInfo(info, index);
                        LotteryListPage.this.showMore(BasePage.clientInfo.getLotteryInfo(index), index);
                    } else if (info.result.isLogExpired()) {
                        if (LotteryListPage.this.getCurrentForm() == LotteryListPage.this.self && !MessageBox.isShow) {
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(LotteryListPage.this.self, true);
                            } else {
                                showHint = false;
                            }
                        }
                    } else {
                        hintText = info.result.msg;
                    }
                }
                if (showHint && result != 3) {
                    LotteryListPage.this.showHint(String.valueOf(hintText) + "(" + ClientInfo.Lottery_AllCatalogNames[index] + ")");
                }
                if (LotteryListPage.this.moreTopButtons[index] != null) {
                    LotteryListPage.this.moreTopButtons[index].setIsLoading(false);
                }
                if (LotteryListPage.this.endSelectorControl.getSelectedIndex() == index) {
                    LotteryListPage.this.endRefresh();
                }
                LotteryListPage.this.repaint();
            }
        }
    };

    public static void Show(BasePage parentPage, int selectedIndex, boolean needRefresh) {
        if (_LotteryListPage == null) {
            _LotteryListPage = new LotteryListPage();
        }
        _LotteryListPage.setParent(parentPage);
        if (needRefresh) {
            int i = 0;
            while (i < LotteryListPage._LotteryListPage.userChanged.length) {
                LotteryListPage._LotteryListPage.userChanged[i] = true;
                ++i;
            }
        }
        if (selectedIndex >= 0 && selectedIndex < ClientInfo.Lottery_All_Index.length) {
            LotteryListPage._LotteryListPage.endSelectorControl.setSelectedIndex(selectedIndex);
        }
        _LotteryListPage.show();
    }

    public static void Show(BasePage parentPage) {
        LotteryListPage.Show(parentPage, 0, false);
    }

    private LotteryListPage() {
        this.self.setTitle("\u6211\u7684\u62bd\u5956\u5355");
        this.sendListenerWhenHidden = true;
        this.scrollContainers = new Container[ClientInfo.Lottery_All_Index.length];
        this.innerContainers = new Container[ClientInfo.Lottery_All_Index.length];
        this.listBoxs = new ListBox[ClientInfo.Lottery_All_Index.length];
        this.userChanged = new boolean[ClientInfo.Lottery_All_Index.length];
        this.downloading = new boolean[ClientInfo.Lottery_All_Index.length];
        this.nuomiLogoLabels = new Label[ClientInfo.Lottery_All_Index.length];
        this.moreTopButtons = new MoreTopButton[ClientInfo.Lottery_All_Index.length];
        int i = 0;
        while (i < ClientInfo.Lottery_All_Index.length) {
            this.downloading[i] = false;
            this.userChanged[i] = false;
            ++i;
        }
        this.endSelectorControl = new CatalogSelectorControl(ClientInfo.Lottery_AllCatalogNames, 4);
        this.mainContainer.addComponent(this.endSelectorControl);
        this.endSelectorControl.setX(0);
        this.endSelectorControl.setY(0);
        this.endSelectorControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                LotteryListPage.this.onEndCatalogSelectChanged(index);
            }
        });
    }

    protected void onShowCompleted() {
        if (!this.showByHideMessageBox) {
            try {
                int index = this.endSelectorControl.getSelectedIndex();
                if (this.userChanged[index]) {
                    this.onRefresh(index);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.showByHideMessageBox = false;
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        int i = 0;
        while (i < this.userChanged.length) {
            this.userChanged[i] = true;
            if (this.listBoxs[i] != null) {
                this.listBoxs[i].removeAll();
            }
            ++i;
        }
        System.gc();
    }

    protected void onRefreshClicked() {
        try {
            this.dataDownloadRefresh(this.endSelectorControl.getSelectedIndex());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void selectedLottery(Lottery lottery, boolean hadEnded) {
        LotteryDetailPage.Show(this.self, lottery, hadEnded);
    }

    private void onEndCatalogSelectChanged(final int index) {
        int otherIndex;
        int n = otherIndex = index == 0 ? 1 : 0;
        if (this.downloading[index]) {
            this.startRefresh();
        }
        if (this.scrollContainers[index] == null) {
            int usedWidth = this.mainContainer.getPreferredW();
            int usedHeight = this.mainContainer.getPreferredH() - this.endSelectorControl.getPreferredH();
            this.scrollContainers[index] = new Container(new CoordinateLayout(usedWidth, usedHeight));
            this.scrollContainers[index].setPreferredW(usedWidth);
            this.scrollContainers[index].setPreferredH(usedHeight);
            this.scrollContainers[index].setX(0);
            this.scrollContainers[index].setY(this.endSelectorControl.getPreferredH());
            this.scrollContainers[index].setScrollableY(true);
            this.nuomiLogoLabels[index] = UserInterface.createNuomiLogoLabel();
            this.scrollContainers[index].addComponent(this.nuomiLogoLabels[index]);
            this.nuomiLogoLabels[index].setX((UserInterface.DISPLAY_WIDTH - this.nuomiLogoLabels[index].getPreferredW()) / 2);
            this.nuomiLogoLabels[index].setY(200);
            if (this.innerContainers[index] == null) {
                this.innerContainers[index] = new Container(new BoxLayout(2));
                this.innerContainers[index].setX(0);
                this.innerContainers[index].setY(0);
                this.scrollContainers[index].addComponent(this.innerContainers[index]);
                this.listBoxs[index] = new ListBox();
                this.innerContainers[index].addComponent(this.listBoxs[index]);
                this.listBoxs[index].addClickedListener(new ListBoxClickedListener(){

                    public void onClicked(Object itemObject) {
                        if (itemObject instanceof Lottery) {
                            LotteryListPage.this.selectedLottery((Lottery)itemObject, index == 1);
                        }
                    }
                });
            }
            this.onRefresh(index);
        }
        if (this.scrollContainers[otherIndex] != null && this.mainContainer.contains(this.scrollContainers[otherIndex])) {
            this.mainContainer.removeComponent(this.scrollContainers[otherIndex]);
        }
        if (!this.mainContainer.contains(this.scrollContainers[index])) {
            this.mainContainer.addComponent(this.scrollContainers[index]);
        }
        if (this.userChanged[index]) {
            this.onRefresh(index);
        }
        this.repaint();
    }

    private void onRefresh(int index) {
        this.listBoxs[index].removeAll();
        Vector lotterys = BasePage.clientInfo.getLotteryInfo(index);
        if (lotterys != null) {
            this.nuomiLogoLabels[index].setVisible(false);
            this.repaint();
            this.showRefresh(lotterys, index);
        } else {
            this.removeMoreTopButton(index);
            this.scrollContainers[index].setScrollableY(false);
            this.nuomiLogoLabels[index].setVisible(true);
            this.repaint();
        }
        this.dataDownloadRefresh(index);
    }

    private void onMore(int index) {
        Vector lotterys = BasePage.clientInfo.getLotteryInfo(index);
        if (lotterys != null) {
            int listCount;
            int count = lotterys.size();
            if (count > (listCount = this.listBoxs[index].getCount())) {
                this.showMore(lotterys, index);
            } else {
                this.dataDownloadMore(index, count, 10);
            }
        }
    }

    private void showRefresh(Vector lotteryList, int index) {
        if (lotteryList == null || index <= -1 || index >= ClientInfo.Lottery_All_Index.length) {
            return;
        }
        this.removeMoreTopButton(index);
        this.nuomiLogoLabels[index].setVisible(false);
        this.listBoxs[index].removeAll();
        int length = lotteryList.size();
        int i = 0;
        while (i < Math.min(10, length)) {
            Lottery lottery = (Lottery)lotteryList.elementAt(i);
            EndedLotteryListBoxItem item = new EndedLotteryListBoxItem(lottery);
            this.listBoxs[index].addItem(item);
            ++i;
        }
        this.scrollContainers[index].setScrollY(0);
        if (this.listBoxs[index].getCount() == 0) {
            String hintString = null;
            if (index == 0) {
                hintString = "\u6ca1\u6709\u672a\u7ed3\u675f\u7684\u62bd\u5956\u5355";
            } else if (index == 1) {
                hintString = "\u6ca1\u6709\u5df2\u7ed3\u675f\u7684\u62bd\u5956\u5355";
            }
            this.listBoxs[index].showHint(hintString);
            this.scrollContainers[index].setScrollableY(false);
        } else {
            this.scrollContainers[index].setScrollableY(true);
        }
        this.scrollContainers[index].setScrollSize(null);
        this.addMoreTopButton(index);
        this.repaint();
    }

    private void showMore(Vector lotteryList, int index) {
        int start;
        if (lotteryList == null || index <= -1 || index >= ClientInfo.Lottery_All_Index.length) {
            return;
        }
        this.removeMoreTopButton(index);
        int length = lotteryList.size();
        int i = start = this.listBoxs[index].getCount();
        while (i < Math.min(length, start + 10)) {
            Lottery lottery = (Lottery)lotteryList.elementAt(i);
            EndedLotteryListBoxItem item = new EndedLotteryListBoxItem(lottery);
            this.listBoxs[index].addItem(item);
            ++i;
        }
        this.scrollContainers[index].setScrollSize(null);
        this.addMoreTopButton(index);
        this.repaint();
    }

    private void dataDownloadRefresh(int index) {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                if (MessageBox.Show("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                    LogPage.Show(this.self);
                } else {
                    this.repaint();
                }
            }
        } else {
            DataDownload dataDownload = new DataDownload();
            dataDownload.addDownloadListener(this.refreshDownloadListener);
            dataDownload.lotteryAll(userInfo.userId, userInfo.ticket, 0, 20, index);
        }
    }

    private void dataDownloadMore(int index, int start, int offset) {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                if (MessageBox.Show("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                    LogPage.Show(this.self);
                } else {
                    this.repaint();
                }
            }
        } else {
            DataDownload dataDownload = new DataDownload();
            dataDownload.addDownloadListener(this.moreDownloadListener);
            dataDownload.lotteryAll(userInfo.userId, userInfo.ticket, start, offset, index);
        }
    }

    private void removeMoreTopButton(int index) {
        this.scrollContainers[index].setScrollSize(null);
        if (this.moreTopButtons[index] != null && this.innerContainers[index].contains(this.moreTopButtons[index])) {
            this.innerContainers[index].removeComponent(this.moreTopButtons[index]);
        }
    }

    private void addMoreTopButton(final int index) {
        if (this.moreTopButtons[index] == null) {
            this.moreTopButtons[index] = new MoreTopButton();
            if (this.downloading[index]) {
                this.moreTopButtons[index].setIsLoading(true);
            }
            this.moreTopButtons[index].addTopListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    LotteryListPage.this.scrollContainers[index].setScrollY(0);
                }
            });
            this.moreTopButtons[index].addMoreListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    LotteryListPage.this.onMore(index);
                }
            });
        }
        boolean needAddTop = false;
        boolean needAddMore = false;
        if (this.scrollContainers[index].getScrollDimension().getHeight() > this.scrollContainers[index].getPreferredH()) {
            needAddTop = true;
        }
        if (BasePage.clientInfo.getLotteryCount(index) > this.listBoxs[index].getCount()) {
            needAddMore = true;
        }
        if (needAddMore || needAddTop) {
            if (!this.innerContainers[index].contains(this.moreTopButtons[index])) {
                int scrollAbledH = this.scrollContainers[index].getScrollDimension().getHeight();
                Dimension d = new Dimension(UserInterface.DISPLAY_WIDTH, scrollAbledH + this.moreTopButtons[index].getPreferredH());
                this.innerContainers[index].addComponent(this.moreTopButtons[index]);
                this.scrollContainers[index].setScrollSize(d);
            }
            this.moreTopButtons[index].showButton(needAddTop, needAddMore);
        }
        this.scrollContainers[index].setScrollSize(null);
    }
}

