/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.OrderCheckInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.DealPreview;
import com.nuomi.data.OrderCheckResult;
import com.nuomi.data.ResultInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.PayResultPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class OrderCheckPage
extends BasePage {
    private static OrderCheckPage _OrderCheckPage = null;
    private OrderCheckInfo _orderCheckInfo = null;
    private OrderCheckResult _orderCheckResult = null;
    private Button nextButton = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private Label nuomiLogoLabel = null;
    private DataDownload dataDownload = null;
    private double needPay = 0.0;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            OrderCheckPage.this.startRefresh();
            OrderCheckPage.this.showRefreshIcon();
            OrderCheckPage.this.nextButton.setEnabled(false);
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof OrderCheckResult) {
                ResultInfo resultInfo = ((OrderCheckResult)data).result;
                if (resultInfo.isSucceed()) {
                    OrderCheckPage.this.showDetail((OrderCheckResult)data);
                    hintString = resultInfo.msg;
                    OrderCheckPage.this.nextButton.setEnabled(true);
                } else if (resultInfo.isLogExpired()) {
                    if (OrderCheckPage.this.getCurrentForm() == OrderCheckPage.this.self && !MessageBox.isShow) {
                        if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                            LogPage.Show(OrderCheckPage.this.self, true);
                        }
                        showHint = false;
                    }
                } else if (OrderCheckPage.this.getCurrentForm() == OrderCheckPage.this.self && !MessageBox.isShow) {
                    MessageBox.Show(String.valueOf(resultInfo.msg) + ",\u4e0b\u5355\u5931\u8d25", "\u786e\u5b9a", null, UserInterface.FONT_NORMAL);
                    OrderCheckPage.this.onBack();
                }
            }
            OrderCheckPage.this.hideRefreshIcon();
            OrderCheckPage.this.endRefresh();
            if (showHint) {
                OrderCheckPage.this.showHint(hintString);
            }
            OrderCheckPage.this.repaint();
        }
    };

    public static void Show(BasePage parentPage, DealPreview dealPreview, OrderCheckInfo orderCheckInfo) {
        if (_OrderCheckPage == null) {
            _OrderCheckPage = new OrderCheckPage();
        }
        _OrderCheckPage.setParent(parentPage);
        _OrderCheckPage.setContent(dealPreview, orderCheckInfo);
        _OrderCheckPage.show();
    }

    private OrderCheckPage() {
        this.setTitle("\u8d2d\u4e70");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.nextButton = UserInterface.createBigButton("\u53bb\u4ed8\u6b3e");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrderCheckPage.this.onNext();
            }
        });
        this.nuomiLogoLabel = UserInterface.createNuomiLogoLabel();
        this.mainContainer.addComponent(this.nuomiLogoLabel);
        this.nuomiLogoLabel.setX((this.mainContainer.getPreferredW() - this.nuomiLogoLabel.getPreferredW()) / 2);
        this.nuomiLogoLabel.setY(150);
        Container nextContainer = new Container();
        this.nextButton.setEnabled(false);
        this.mainContainer.addComponent(nextContainer);
        nextContainer.setPreferredW(this.mainContainer.getPreferredW());
        nextContainer.setPreferredH(this.nextButton.getPreferredH() + 10);
        nextContainer.setLayout(new CoordinateLayout(nextContainer.getPreferredW(), nextContainer.getPreferredH()));
        nextContainer.addComponent(this.nextButton);
        nextContainer.setX(0);
        nextContainer.setY(this.mainContainer.getPreferredH() - nextContainer.getPreferredH());
        nextContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
        this.nextButton.setX((nextContainer.getPreferredW() - this.nextButton.getPreferredW()) / 2);
        this.nextButton.setY(5);
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - nextContainer.getPreferredH());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 5);
    }

    private void setContent(DealPreview dealPreview, OrderCheckInfo orderCheckInfo) {
        this._orderCheckInfo = orderCheckInfo;
        this.innerContainer.removeAll();
        if (!this.mainContainer.contains(this.nuomiLogoLabel)) {
            this.mainContainer.addComponent(this.nuomiLogoLabel);
        }
        this.nextButton.setVisible(false);
        this.needPay = 0.0;
        this.onRefresh();
    }

    private void showDetail(OrderCheckResult orderCheckResult) {
        this._orderCheckResult = orderCheckResult;
        if (orderCheckResult == null) {
            return;
        }
        this._orderCheckResult.tag = this._orderCheckInfo.isDelivery;
        if (this.mainContainer.contains(this.nuomiLogoLabel)) {
            this.mainContainer.removeComponent(this.nuomiLogoLabel);
        }
        this.needPay = Math.max(0.0, (orderCheckResult.neededpay == null ? 0.0 : orderCheckResult.neededpay * 1000.0) - (orderCheckResult.balance == null ? 0.0 : orderCheckResult.balance * 1000.0));
        this.needPay /= 1000.0;
        Container resultContent = new Container(new BoxLayout(2));
        Label resultTitleLabel = new Label("\u8ba2\u5355\u7ed3\u7b97");
        resultContent.addComponent(resultTitleLabel);
        resultTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        resultTitleLabel.getStyle().setMargin(1, 5);
        Label spLabel = new Label();
        resultContent.addComponent(spLabel);
        spLabel.getStyle().setBgColor(0x919191);
        spLabel.getStyle().setBgTransparency(128);
        spLabel.getStyle().setMargin(2, 15);
        spLabel.setPreferredW(348);
        spLabel.setPreferredH(1);
        if (orderCheckResult.totalPrice != null) {
            Label totalPriceLabel = new Label("\u5546\u54c1\u603b\u4ef7: \uffe5" + Methods.formatPrice(orderCheckResult.totalPrice));
            resultContent.addComponent(totalPriceLabel);
            totalPriceLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            totalPriceLabel.getStyle().setMargin(1, 10);
        }
        if (orderCheckResult.deliveryPrice != null && orderCheckResult.deliveryPrice > 0.0) {
            Label deliveryPriceLabel = new Label("\u8fd0\u8d39: \uffe5" + Methods.formatPrice(orderCheckResult.deliveryPrice));
            resultContent.addComponent(deliveryPriceLabel);
            deliveryPriceLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            deliveryPriceLabel.getStyle().setMargin(1, 10);
        }
        if (orderCheckResult.giftworth != null && orderCheckResult.giftworth > 0.0) {
            Label giftWorthLabel = new Label("\u4ee3\u91d1\u5238\u91d1\u989d: \uffe5" + Methods.formatPrice(orderCheckResult.giftworth));
            resultContent.addComponent(giftWorthLabel);
            giftWorthLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            giftWorthLabel.getStyle().setMargin(1, 10);
        }
        if (orderCheckResult.neededpay != null) {
            Label neededpayLabel = new Label("\u5171\u9700\u652f\u4ed8: \uffe5" + Methods.formatPrice(orderCheckResult.neededpay));
            resultContent.addComponent(neededpayLabel);
            neededpayLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            neededpayLabel.getStyle().setMargin(1, 10);
        }
        Label spLabel2 = new Label();
        resultContent.addComponent(spLabel2);
        spLabel2.getStyle().setBgColor(0x919191);
        spLabel2.getStyle().setBgTransparency(128);
        spLabel2.setPreferredW(348);
        spLabel2.setPreferredH(1);
        if (orderCheckResult.balance != null) {
            Label balanceLabel = new Label("\u8d26\u6237\u4f59\u989d: \uffe5" + Methods.formatPrice(orderCheckResult.balance));
            resultContent.addComponent(balanceLabel);
            balanceLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            balanceLabel.getStyle().setMargin(1, 10);
        }
        if (this.needPay > 0.0) {
            Container needPayContainer = new Container(new BoxLayout(1));
            resultContent.addComponent(needPayContainer);
            needPayContainer.getStyle().setMargin(1, 10);
            Label titleLabel = new Label("\u8fd8\u9700\u652f\u4ed8:");
            needPayContainer.addComponent(titleLabel);
            titleLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            Label valueLabel = new Label("\uffe5" + Methods.formatPrice(this.needPay));
            needPayContainer.addComponent(valueLabel);
            valueLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            valueLabel.getStyle().setFgColor(15492920);
        }
        ContentContainer resultContentContainer = new ContentContainer(resultContent, 0, 0);
        this.innerContainer.addComponent(resultContentContainer);
        resultContentContainer.getStyle().setMargin(0, 5);
        if (this.needPay > 0.0 || this._orderCheckInfo.needinvoice != null || this._orderCheckInfo.deliverytype == null) {
            Container hintContainer;
            Container payContent = new Container(new BoxLayout(2));
            Label payTitleLabel = new Label(this.needPay > 0.0 ? "\u652f\u4ed8\u5b9d\u624b\u673a\u4ed8\u6b3e" : "\u7cef\u7c73\u4f59\u989d\u4ed8\u6b3e");
            payContent.addComponent(payTitleLabel);
            payTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            payTitleLabel.getStyle().setMargin(1, 5);
            if (this.needPay > 0.0 || this._orderCheckInfo.deliverytype == null) {
                Label spLabel3 = new Label();
                payContent.addComponent(spLabel3);
                spLabel3.getStyle().setBgColor(0x919191);
                spLabel3.getStyle().setBgTransparency(128);
                spLabel3.getStyle().setMargin(2, 5);
                spLabel3.setPreferredW(348);
                spLabel3.setPreferredH(1);
            }
            if (this.needPay > 0.0) {
                hintContainer = new Container(new BoxLayout(1));
                payContent.addComponent(hintContainer);
                hintContainer.getStyle().setMargin(1, 5);
                hintContainer.getStyle().setMargin(0, 10);
                String[] hintStrings = new String[]{"\u6ce8:\u76ee\u524d\u624b\u673a\u7ad9\u4ec5\u652f\u6301\u652f\u4ed8\u5b9d\u4ed8\u6b3e"};
                LabelGroup hintGroup = new LabelGroup(hintStrings, UserInterface.FONT_OPTION, 9084854, 20);
                hintContainer.addComponent(hintGroup);
            }
            if (!(this._orderCheckInfo.isDelivery != null && this._orderCheckInfo.isDelivery.booleanValue() || BasePage.clientInfo.getUserInfo() == null)) {
                hintContainer = new Container(new BoxLayout(1));
                payContent.addComponent(hintContainer);
                hintContainer.getStyle().setMargin(1, 5);
                hintContainer.getStyle().setMargin(0, 10);
                String hintString = "\u56e2\u8d2d\u6210\u529f\u540e,\u7cef\u7c73\u5238\u5c06\u53d1\u9001\u5230\u624b\u673a: " + BasePage.clientInfo.getUserInfo().phone + ",\u8bf7\u6ce8\u610f\u67e5\u6536\u3002";
                Vector hintVector = Methods.splitString(hintString, UserInterface.FONT_OPTION, 0, 335);
                LabelGroup hintGroup = new LabelGroup(hintVector, UserInterface.FONT_OPTION, 6453130, 20);
                hintContainer.addComponent(hintGroup);
            }
            ContentContainer payContentContainer = new ContentContainer(payContent, 0, 15);
            this.innerContainer.addComponent(payContentContainer);
            payContentContainer.getStyle().setMargin(0, 5);
        }
        this.nextButton.setText(this.needPay > 0.0 ? "\u53bb\u4ed8\u6b3e" : "\u63d0\u4ea4");
        this.nextButton.setVisible(true);
    }

    protected void onBack() {
        if (this.dataDownload != null && this.dataDownload.isDownloading()) {
            this.dataDownload.cancel();
        }
        this.innerContainer.removeAll();
        System.gc();
        super.onBack();
    }

    private void onRefresh() {
        if (this._orderCheckInfo != null) {
            if (this.dataDownload == null) {
                this.dataDownload = new DataDownload();
                this.dataDownload.addDownloadListener(this.listener);
            }
            this.dataDownload.orderCheck(this._orderCheckInfo);
        }
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        this.onRefresh();
    }

    private void onNext() {
        if (this._orderCheckResult == null) {
            return;
        }
        PayResultPage.Show(this.self, this._orderCheckResult, this.needPay <= 0.0);
    }
}

