/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.OrderCheckResult;
import com.nuomi.data.PayByBlanceResult;
import com.nuomi.data.PayStatusResult;
import com.nuomi.data.ResultInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.CouponListPage;
import com.nuomi.pages.HomePage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.PostOrderListPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;

public class PayResultPage
extends BasePage {
    private static PayResultPage _PayResultPage = null;
    private OrderCheckResult _orderCheckResult = null;
    private boolean _isByBalance = false;
    private DataDownload payByBalanceDataDownload = null;
    private DataDownload payStatusDataDownload = null;
    private Container innerContainer = null;
    private Label payingLabel = null;
    private Container moreContainer = null;
    private boolean shownFromMessageBox = false;
    private Button payStatusButton = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            PayResultPage.this.startRefresh();
            PayResultPage.this.showRefreshIcon();
            if (PayResultPage.this.payStatusButton != null) {
                PayResultPage.this.payStatusButton.setEnabled(false);
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2) {
                if (data instanceof PayByBlanceResult && type == 27) {
                    ResultInfo resultInfo = ((PayByBlanceResult)data).result;
                    if (resultInfo.isSucceed()) {
                        PayResultPage.this.paySucceed((PayByBlanceResult)data);
                    } else if (resultInfo.isLogExpired()) {
                        if (PayResultPage.this.getCurrentForm() == PayResultPage.this.self && !MessageBox.isShow) {
                            PayResultPage.this.shownFromMessageBox = true;
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(PayResultPage.this.self, true);
                            } else {
                                PayResultPage.this.payFailed(null, type);
                            }
                        }
                    } else {
                        PayResultPage.this.payFailed(resultInfo, type);
                    }
                } else if (data instanceof PayStatusResult && type == 28) {
                    PayStatusResult payStatusResult = (PayStatusResult)data;
                    if (payStatusResult.result.isSucceed()) {
                        PayResultPage.this.paySucceed(null);
                    } else if (payStatusResult.result.isLogExpired()) {
                        if (PayResultPage.this.getCurrentForm() == PayResultPage.this.self && !MessageBox.isShow) {
                            PayResultPage.this.shownFromMessageBox = true;
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(PayResultPage.this.self, true);
                            } else {
                                PayResultPage.this.payFailed(null, type);
                            }
                        }
                    } else {
                        PayResultPage.this.payFailed(payStatusResult.result, type);
                    }
                }
            } else if (PayResultPage.this.getCurrentForm() == PayResultPage.this.self && !MessageBox.isShow) {
                PayResultPage.this.shownFromMessageBox = true;
                if (MessageBox.Show(hintString, "\u8fd4\u56de\u4e0a\u4e00\u9875", "\u66f4\u591a\u56e2\u8d2d") == MessageBox.OK) {
                    PayResultPage.this.onBack();
                } else {
                    BasePage.MainPage.show();
                }
            }
            if (PayResultPage.this.payStatusButton != null) {
                PayResultPage.this.payStatusButton.setEnabled(true);
            }
            PayResultPage.this.hideRefreshIcon();
            PayResultPage.this.endRefresh();
            PayResultPage.this.repaint();
        }
    };

    public static void Show(BasePage parentPage, OrderCheckResult orderCheckResult, boolean isByBalance) {
        if (_PayResultPage == null) {
            _PayResultPage = new PayResultPage();
        }
        PayResultPage._PayResultPage._isByBalance = isByBalance;
        _PayResultPage.setParent(parentPage);
        PayResultPage._PayResultPage._orderCheckResult = orderCheckResult;
        if (PayResultPage._PayResultPage.innerContainer != null) {
            PayResultPage._PayResultPage.innerContainer.removeAll();
        }
        PayResultPage._PayResultPage.payStatusButton = null;
        if (PayResultPage._PayResultPage.moreContainer != null) {
            PayResultPage._PayResultPage.moreContainer.setEnabled(false);
            PayResultPage._PayResultPage.moreContainer.setVisible(false);
        }
        PayResultPage._PayResultPage.shownFromMessageBox = false;
        _PayResultPage.show();
    }

    private PayResultPage() {
        this.setTitle("\u652f\u4ed8\u7ed3\u679c");
        this.hideRefreshIcon();
        this.hideBackIcon();
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        this.payingLabel = new Label();
        this.mainContainer.addComponent(this.payingLabel);
        this.payingLabel.setEnabled(false);
        this.payingLabel.getDisabledStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        this.payingLabel.setPreferredW(this.mainContainer.getPreferredW());
        this.payingLabel.setPreferredH(this.mainContainer.getPreferredH() / 3);
        this.payingLabel.getDisabledStyle().setAlignment(4);
        this.payingLabel.getDisabledStyle().setFgColor(15492920);
        this.payingLabel.getDisabledStyle().setBgTransparency(0);
        Button moreButton = UserInterface.createBigButton("\u8fd4\u56de\u56e2\u8d2d\u4e3b\u9875");
        moreButton.setPreferredW(176);
        moreButton.setPreferredH(55);
        moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (BasePage.MainPage != null) {
                    BasePage.MainPage.show();
                }
            }
        });
        Style[] moreButtonStyles = UserInterface.getComponentStyles(moreButton);
        int i = 0;
        while (i < moreButtonStyles.length) {
            moreButtonStyles[i].setMargin(0, 5);
            moreButtonStyles[i].setMargin(2, 5);
            ++i;
        }
        Button toMynuomiPageButton = UserInterface.createBigButton("\u67e5\u770b\u6211\u7684\u7cef\u7c73");
        toMynuomiPageButton.setPreferredW(176);
        toMynuomiPageButton.setPreferredH(55);
        toMynuomiPageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (PayResultPage.this._orderCheckResult != null && ((PayResultPage)PayResultPage.this)._orderCheckResult.tag != null && ((PayResultPage)PayResultPage.this)._orderCheckResult.tag instanceof Boolean && ((Boolean)((PayResultPage)PayResultPage.this)._orderCheckResult.tag).booleanValue()) {
                    PostOrderListPage.Show(BasePage.MainPage, 0, true);
                } else {
                    CouponListPage.Show(BasePage.MainPage, 0, true);
                }
            }
        });
        Style[] toMynuomiPageButtonStyles = UserInterface.getComponentStyles(toMynuomiPageButton);
        int i2 = 0;
        while (i2 < toMynuomiPageButtonStyles.length) {
            toMynuomiPageButtonStyles[i2].setMargin(0, 5);
            toMynuomiPageButtonStyles[i2].setMargin(2, 5);
            ++i2;
        }
        this.moreContainer = new Container(new BorderLayout());
        this.mainContainer.addComponent(this.moreContainer);
        this.moreContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.moreContainer.setPreferredH(moreButton.getPreferredH() + 10);
        this.moreContainer.addComponent("West", (Component)moreButton);
        this.moreContainer.addComponent("East", (Component)toMynuomiPageButton);
        this.moreContainer.setX(0);
        this.moreContainer.setY(this.mainContainer.getPreferredH() - this.moreContainer.getPreferredH());
        this.moreContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
    }

    protected void onShowCompleted() {
        if (!this.shownFromMessageBox) {
            if (this._isByBalance) {
                this.onPayByBalance();
            } else {
                this.onGetAlipayUrl();
            }
            this.shownFromMessageBox = false;
        }
    }

    protected void onBack() {
        if (this.payStatusButton != null && this.payStatusButton.getListenerVector() != null) {
            this.payStatusButton.getListenerVector().removeAllElements();
        }
        this.payStatusButton = null;
        super.onBack();
    }

    private void onPayByBalance() {
        UserInfo userInfo;
        this.payingLabel.setText("\u652f\u4ed8\u4e2d...");
        this.payingLabel.setVisible(true);
        if (!this.mainContainer.contains(this.payingLabel)) {
            this.mainContainer.addComponent(this.payingLabel);
        }
        if (this.payByBalanceDataDownload == null) {
            this.payByBalanceDataDownload = new DataDownload();
            this.payByBalanceDataDownload.addDownloadListener(this.listener);
        }
        if ((userInfo = BasePage.clientInfo.getUserInfo()) != null && this._orderCheckResult != null) {
            this.payByBalanceDataDownload.payByBalance(userInfo.userId, userInfo.ticket, this._orderCheckResult.orderId);
        }
    }

    private void onGetAlipayUrl() {
        UserInfo userInfo;
        this.payingLabel.setText("\u6b63\u5728\u8df3\u8f6c...");
        this.payingLabel.setVisible(true);
        if (!this.mainContainer.contains(this.payingLabel)) {
            this.mainContainer.addComponent(this.payingLabel);
        }
        if ((userInfo = BasePage.clientInfo.getUserInfo()) != null && this._orderCheckResult != null) {
            String url = DataDownload.makeAliayRoot(userInfo.userId, userInfo.ticket, this._orderCheckResult.orderId);
            System.out.println(url);
            PhoneFunction.callBrowser(url);
        }
        this.showCheckPayStatus();
    }

    private void showCheckPayStatus() {
        if (this.innerContainer == null) {
            this.innerContainer = new Container(new BoxLayout(2));
            this.mainContainer.addComponent(this.innerContainer);
            this.innerContainer.setX(0);
            this.innerContainer.setY(5);
        } else {
            this.innerContainer.removeAll();
        }
        this.payingLabel.setVisible(false);
        if (this.mainContainer.contains(this.payingLabel)) {
            this.mainContainer.removeComponent(this.payingLabel);
        }
        this.payStatusButton = UserInterface.createBigButton("\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c");
        Container payStatusContainer = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, this.payStatusButton.getPreferredH()));
        this.innerContainer.addComponent(payStatusContainer);
        payStatusContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        payStatusContainer.setPreferredH(this.payStatusButton.getPreferredH());
        payStatusContainer.getStyle().setMargin(0, 5);
        payStatusContainer.addComponent(this.payStatusButton);
        this.payStatusButton.setX((payStatusContainer.getPreferredW() - this.payStatusButton.getPreferredW()) / 2);
        this.payStatusButton.setY(0);
        this.payStatusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PayResultPage.this.onCheckPayStatus();
            }
        });
        this.moreContainer.setEnabled(true);
        this.moreContainer.setVisible(true);
        this.repaint();
    }

    private void onCheckPayStatus() {
        UserInfo userInfo;
        if (this.payStatusDataDownload == null) {
            this.payStatusDataDownload = new DataDownload();
            this.payStatusDataDownload.addDownloadListener(this.listener);
        }
        if ((userInfo = BasePage.clientInfo.getUserInfo()) != null && this._orderCheckResult != null) {
            this.payStatusDataDownload.payStatus(userInfo.userId, userInfo.ticket, this._orderCheckResult.orderId);
        }
    }

    private void paySucceed(PayByBlanceResult result) {
        if (BasePage.MainPage instanceof HomePage) {
            ((HomePage)BasePage.MainPage).needRefreshUserInfo_MyNuomi = true;
        }
        if (this.innerContainer == null) {
            this.innerContainer = new Container(new BoxLayout(2));
            this.mainContainer.addComponent(this.innerContainer);
            this.innerContainer.setX(0);
            this.innerContainer.setY(5);
        } else {
            this.innerContainer.removeAll();
        }
        this.payingLabel.setVisible(false);
        if (this.mainContainer.contains(this.payingLabel)) {
            this.mainContainer.removeComponent(this.payingLabel);
        }
        Container content = new Container(new BoxLayout(2));
        Label failedLabel = new Label("\u652f\u4ed8\u6210\u529f");
        content.addComponent(failedLabel);
        failedLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        failedLabel.getStyle().setFgColor(15492920);
        failedLabel.setPreferredW(350);
        failedLabel.setPreferredH(50);
        failedLabel.getStyle().setAlignment(4);
        Label spLabel1 = new Label();
        content.addComponent(spLabel1);
        spLabel1.getStyle().setBgColor(0x919191);
        spLabel1.getStyle().setBgTransparency(128);
        spLabel1.getStyle().setMargin(2, 15);
        spLabel1.setPreferredW(348);
        spLabel1.setPreferredH(1);
        if (result != null) {
            Label payedLabel = new Label("\u652f\u4ed8\u603b\u91d1\u989d: \uffe5" + Methods.formatPrice(result.price));
            payedLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            Label balanceLabel = new Label("\u8d26\u6237\u4f59\u989d: \uffe5" + Methods.formatPrice(result.balance));
            balanceLabel.getStyle().setFont(UserInterface.FONT_OPTION);
            Container resultContainer = new Container(new CoordinateLayout(340, payedLabel.getPreferredH() * 2));
            content.addComponent(resultContainer);
            resultContainer.setPreferredW(340);
            resultContainer.setPreferredH(payedLabel.getPreferredH() * 2);
            resultContainer.addComponent(payedLabel);
            payedLabel.setX((340 - payedLabel.getPreferredW()) / 2);
            payedLabel.setY(0);
            resultContainer.addComponent(balanceLabel);
            balanceLabel.setX(payedLabel.getX());
            balanceLabel.setY(payedLabel.getPreferredH());
            Label spLabe2 = new Label();
            content.addComponent(spLabe2);
            spLabe2.getStyle().setBgColor(0x919191);
            spLabe2.getStyle().setBgTransparency(128);
            spLabe2.getStyle().setMargin(0, 15);
            spLabe2.getStyle().setMargin(2, 15);
            spLabe2.setPreferredW(348);
            spLabe2.setPreferredH(1);
        }
        String[] strings = new String[]{"\u60a8\u53ef\u4ee5\u53bb \u6211\u7684\u7cef\u7c73 \u4e2d\u67e5\u8be2\u8d2d\u4e70", "\u4fe1\u606f"};
        LabelGroup group = new LabelGroup(strings, UserInterface.FONT_MESSAGEBOX, 9084854, 25);
        content.addComponent(group);
        group.getStyle().setMargin(1, 5);
        ContentContainer contentContainer = new ContentContainer(content, 0, 15);
        this.innerContainer.addComponent(contentContainer);
        this.moreContainer.setEnabled(true);
        this.moreContainer.setVisible(true);
        this.repaint();
    }

    private void payFailed(ResultInfo resultInfo, int downloadType) {
        if (this.innerContainer == null) {
            this.innerContainer = new Container(new BoxLayout(2));
            this.mainContainer.addComponent(this.innerContainer);
            this.innerContainer.setX(0);
            this.innerContainer.setY(5);
        } else if (resultInfo == null || downloadType == 28 && resultInfo.succ != -2) {
            this.innerContainer.removeAll();
        } else if (this.innerContainer.getComponentCount() > 1) {
            this.innerContainer.removeComponent(this.innerContainer.getComponentAt(0));
        }
        this.payingLabel.setVisible(false);
        if (this.mainContainer.contains(this.payingLabel)) {
            this.mainContainer.removeComponent(this.payingLabel);
        }
        Container content = new Container(new BoxLayout(2));
        if (resultInfo == null || downloadType == 28 && resultInfo.succ != -2) {
            Label failedLabel = new Label("\u652f\u4ed8\u5931\u8d25");
            content.addComponent(failedLabel);
            failedLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            failedLabel.getStyle().setFgColor(15492920);
            failedLabel.setPreferredW(350);
            failedLabel.setPreferredH(50);
            failedLabel.getStyle().setAlignment(4);
        }
        if (resultInfo != null && resultInfo.msg != null) {
            Label reasonLabel = new Label(resultInfo.msg);
            content.addComponent(reasonLabel);
            reasonLabel.getStyle().setFgColor(9084854);
            reasonLabel.getStyle().setAlignment(4);
        }
        ContentContainer contentContainer = new ContentContainer(content, 0, 15);
        this.innerContainer.addComponent(0, (Component)contentContainer);
        this.moreContainer.setEnabled(true);
        this.moreContainer.setVisible(true);
        this.repaint();
    }
}

