/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.connect.DataDownload;
import com.nuomi.data.Deal;
import com.nuomi.data.PostOrder;
import com.nuomi.data.PostOrderOption;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.AddressListPage;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.PhoneListPage;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.usercontrol.ItemButtonGroup;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TabControl;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class PostOrderDetailPage
extends BasePage {
    private static PostOrderDetailPage _PostOrderDetailPage = null;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private PostOrder _postOrder = null;
    private Deal _deal = null;
    private Label currentPriceLabel = null;
    private Label discountLabel = null;
    private Label marketPriceLabel = null;
    private Label saleCountLabel = null;
    private Container optionsContainer = null;
    private Container sampleContainer = null;
    private Container detailContainer = null;
    private final int labelWidthWithIcon;
    private final int labelWidth = 325 - UserImages.ICON_POINT_IMAGE.getWidth();
    private final int labelHeight;
    private DataDownload dealDownload = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            PostOrderDetailPage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof Deal) {
                BasePage.clientInfo.setDealDetail(((PostOrderDetailPage)PostOrderDetailPage.this)._postOrder.dealId, data);
                PostOrderDetailPage.this.showDeal((Deal)data);
                try {
                    Thread.sleep(800L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PostOrderDetailPage.this.self.repaint();
            }
            if (result != 3) {
                PostOrderDetailPage.this.showHint(hintString);
                PostOrderDetailPage.this.endRefresh();
            }
        }
    };

    public static void Show(BasePage parentPage, PostOrder postOrder) {
        if (_PostOrderDetailPage == null) {
            _PostOrderDetailPage = new PostOrderDetailPage();
        }
        _PostOrderDetailPage.setContent(postOrder);
        _PostOrderDetailPage.setParent(parentPage);
        _PostOrderDetailPage.show();
    }

    private PostOrderDetailPage() {
        this.labelWidthWithIcon = 330;
        this.labelHeight = 30;
        this.setTitle("\u6211\u7684\u90ae\u9012\u5355");
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        TabControl tabControl = new TabControl(UserImages.DETAIL_TAB_BG_IMAGE, UserImages.DETAIL_TABS_IMAGES, false);
        tabControl.setX(0);
        tabControl.setY(this.mainContainer.getPreferredH() - tabControl.getPreferredH());
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - tabControl.getClickHeight());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 10);
        this.optionsContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.optionsContainer);
        this.sampleContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.sampleContainer);
        this.detailContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.detailContainer);
        ItemButton serviceButton = new ItemButton(3, "\u7cef\u7c73\u5ba2\u670d:4006-888-887", UserImages.ICON_PHONE_IMAGE, false);
        serviceButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                PhoneFunction.callNuomiServicePhone();
            }
        });
        ItemButton[] itemButtons = new ItemButton[]{serviceButton};
        ItemButtonGroup serviceContainer = new ItemButtonGroup(itemButtons);
        this.innerContainer.addComponent(serviceContainer);
        serviceContainer.getStyle().setMargin(0, 5);
        this.mainContainer.addComponent(tabControl);
        tabControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                switch (index) {
                    case 0: {
                        PostOrderDetailPage.this.onPhoneClicked();
                        break;
                    }
                    case 1: {
                        PostOrderDetailPage.this.onAddressClicked();
                        break;
                    }
                    case 2: {
                        PostOrderDetailPage.this.onShareClicked();
                        break;
                    }
                }
            }
        });
    }

    private void setContent(PostOrder postOrder) {
        String otherString;
        Vector otherVector;
        this.scrollContainer.setScrollY(0);
        this._postOrder = postOrder;
        if (postOrder == null) {
            return;
        }
        this.optionsContainer.removeAll();
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        Container deliveryContentContainer = new Container(new BoxLayout(2));
        if (postOrder.options != null) {
            int i = 0;
            while (i < postOrder.options.size()) {
                PostOrderOption option = (PostOrderOption)postOrder.options.elementAt(i);
                Vector optionVector = Methods.splitString(option.toString(), UserInterface.FONT_NORMAL, 0, this.labelWidth - 5, "\r\n");
                if (optionVector != null) {
                    int j = 0;
                    while (j < optionVector.size()) {
                        Label optionLabel = this.createLabel(j == 0 ? UserImages.ICON_POINT_IMAGE : null, (String)optionVector.elementAt(j));
                        deliveryContentContainer.addComponent(optionLabel);
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((otherVector = Methods.splitString(otherString = String.valueOf(Methods.isNullOrWhitespace(postOrder.postAddress) ? "" : "\u90ae\u5bc4\u4fe1\u606f\uff1a\r\n" + postOrder.postAddress) + (postOrder.buyTimeCalendar == null ? "" : "\r\n\u8d2d\u4e70\u65f6\u95f4\uff1a" + CalendarFormat.toYMD(postOrder.buyTimeCalendar)) + (postOrder.postorderId == null ? "" : "\r\n\u8ba2\u5355\u7f16\u53f7\uff1a" + postOrder.postorderId) + (postOrder.deliveryPrice != null && postOrder.deliveryPrice > 0.0 ? "\r\n\u8ba2\u5355\u8fd0\u8d39\uff1a" + Methods.formatPrice(postOrder.deliveryPrice) + "\u5143" : "") + (postOrder.price == null ? "" : "\r\n\u4ed8\u6b3e\u603b\u989d\uff1a" + Methods.formatPrice(postOrder.price) + "\u5143"), UserInterface.FONT_NORMAL, 0, this.labelWidth - 5, "\r\n")) != null) {
            int i = 0;
            while (i < otherVector.size()) {
                Label otherLabel = this.createLabel(null, (String)otherVector.elementAt(i));
                if (i == 0) {
                    otherLabel.getStyle().setMargin(0, 10);
                }
                deliveryContentContainer.addComponent(otherLabel);
                ++i;
            }
        }
        if (postOrder.canEditAddress != null && postOrder.canEditAddress.booleanValue()) {
            Label spLabel = new Label();
            deliveryContentContainer.addComponent(spLabel);
            spLabel.getStyle().setBgColor(0x919191);
            spLabel.getStyle().setBgTransparency(128);
            spLabel.getStyle().setMargin(0, 15);
            spLabel.getStyle().setMargin(2, 15);
            spLabel.setPreferredW(348);
            spLabel.setPreferredH(1);
            Label editAddressHintLabel = new Label("\u60a8\u53ef\u4ee5\u5728\u4e3b\u7ad9\u4fee\u6539\u5feb\u9012\u5730\u5740");
            deliveryContentContainer.addComponent(editAddressHintLabel);
            editAddressHintLabel.getStyle().setFgColor(15492920);
            editAddressHintLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            editAddressHintLabel.getStyle().setAlignment(4);
        }
        ContentContainer deliveryContainer = new ContentContainer("\u914d\u9001\u4fe1\u606f", deliveryContentContainer);
        this.optionsContainer.addComponent(deliveryContainer);
        Container previewContainer = new Container(new BoxLayout(2));
        previewContainer.getStyle().setPadding(1, 10);
        previewContainer.getStyle().setPadding(3, 10);
        if (postOrder.middleTitle != null) {
            Vector middleTitleVector = Methods.splitString(postOrder.middleTitle, UserInterface.FONT_NORMAL, 0, 330);
            LabelGroup middleTitleGroup = new LabelGroup(middleTitleVector, UserInterface.FONT_NORMAL, 6453130, 330, 25);
            previewContainer.addComponent(middleTitleGroup);
            middleTitleGroup.getStyle().setMargin(1, 10);
            middleTitleGroup.getStyle().setMargin(0, 10);
        }
        int imagePriceWidth = 340;
        int imagePriceHeight = 99;
        Container imagePriceContainer = new Container(new CoordinateLayout(imagePriceWidth, imagePriceHeight));
        imagePriceContainer.setPreferredW(imagePriceWidth);
        imagePriceContainer.setPreferredH(imagePriceHeight);
        previewContainer.addComponent(imagePriceContainer);
        imagePriceContainer.getStyle().setMargin(0, 5);
        imagePriceContainer.getStyle().setMargin(1, 10);
        ImageControl image = new ImageControl(165, imagePriceHeight);
        imagePriceContainer.addComponent(image);
        image.setX(0);
        image.setY(0);
        image.setImage(postOrder.image, true);
        Container priceContainer = new Container(new CoordinateLayout(imagePriceWidth - image.getPreferredW() - 5, imagePriceHeight));
        priceContainer.setPreferredW(imagePriceWidth - image.getPreferredW() - 5);
        priceContainer.setPreferredH(imagePriceHeight);
        imagePriceContainer.addComponent(priceContainer);
        priceContainer.setX(image.getPreferredW() + 20);
        priceContainer.setY(0);
        this.currentPriceLabel = new Label();
        this.currentPriceLabel.setText("\uffe5");
        this.currentPriceLabel.getStyle().setFont(UserInterface.FONT_LARGE);
        priceContainer.addComponent(this.currentPriceLabel);
        this.currentPriceLabel.setX(0);
        this.currentPriceLabel.setY(0);
        this.currentPriceLabel.setEndsWith3Points(false);
        this.discountLabel = new Label();
        this.discountLabel.setText("\u6298\u6263:");
        this.discountLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(this.discountLabel);
        this.discountLabel.setX(0);
        this.discountLabel.setY(priceContainer.getPreferredH() - this.discountLabel.getPreferredH());
        this.discountLabel.setEndsWith3Points(false);
        this.marketPriceLabel = new Label();
        this.marketPriceLabel.setText("\u539f\u4ef7:\uffe5");
        this.marketPriceLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        priceContainer.addComponent(this.marketPriceLabel);
        this.marketPriceLabel.setX(0);
        this.marketPriceLabel.setY(priceContainer.getPreferredH() - this.discountLabel.getPreferredH() - this.marketPriceLabel.getPreferredH());
        this.marketPriceLabel.setEndsWith3Points(false);
        Container saleCountContainer = new Container();
        previewContainer.addComponent(saleCountContainer);
        saleCountContainer.setPreferredW(350);
        saleCountContainer.setPreferredH(30);
        saleCountContainer.setLayout(new CoordinateLayout(saleCountContainer.getPreferredW(), saleCountContainer.getPreferredH()));
        saleCountContainer.getStyle().setMargin(0, 5);
        this.saleCountLabel = new Label("\u4eba\u5df2\u8d2d\u4e70");
        this.saleCountLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        saleCountContainer.addComponent(this.saleCountLabel);
        this.saleCountLabel.setX((saleCountContainer.getPreferredW() - this.saleCountLabel.getPreferredW()) / 2);
        this.saleCountLabel.setY((saleCountContainer.getPreferredH() - this.saleCountLabel.getPreferredH()) / 2);
        this.saleCountLabel.setEndsWith3Points(false);
        Container endTimeContainer = new Container();
        previewContainer.addComponent(endTimeContainer);
        endTimeContainer.setPreferredW(350);
        endTimeContainer.setPreferredH(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getHeight());
        endTimeContainer.setLayout(new CoordinateLayout(endTimeContainer.getPreferredW(), endTimeContainer.getPreferredH()));
        endTimeContainer.getStyle().setMargin(0, 5);
        Label buyTimeLabel = new Label("\u8d2d\u4e70\u65f6\u95f4:" + CalendarFormat.toYMD(postOrder.buyTimeCalendar));
        endTimeContainer.addComponent(buyTimeLabel);
        buyTimeLabel.getStyle().setAlignment(4);
        buyTimeLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        buyTimeLabel.getStyle().setFgColor(0xFFFFFF);
        buyTimeLabel.setPreferredW(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getWidth());
        buyTimeLabel.setPreferredH(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getHeight());
        buyTimeLabel.getStyle().setBgImage(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE);
        buyTimeLabel.setX((endTimeContainer.getPreferredW() - buyTimeLabel.getPreferredW()) / 2);
        buyTimeLabel.setY(0);
        ContentContainer previewContentContainer = new ContentContainer(previewContainer, UserImages.USERCONTAINER_PREVIEW_BOTTOM_IMAGE, 0, 15);
        this.sampleContainer.addComponent(previewContentContainer);
        previewContentContainer.getStyle().setMargin(0, 5);
        Deal deal = BasePage.clientInfo.getDealDetail(postOrder.dealId);
        if (deal != null) {
            this.showDeal(deal);
        }
        this.onRefresh();
    }

    protected void onRefreshClicked() {
        this.onRefresh();
    }

    private void onRefresh() {
        if (this._postOrder != null && this._postOrder.dealId != null) {
            if (this.dealDownload == null) {
                this.dealDownload = new DataDownload();
                this.dealDownload.addDownloadListener(this.listener);
            } else {
                this.dealDownload.cancel();
            }
            this.dealDownload.postOrderDetail(this._postOrder.dealId);
        }
    }

    protected void onBack() {
        if (this.dealDownload != null) {
            this.dealDownload.cancel();
        }
        this.endRefresh();
        this.optionsContainer.removeAll();
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        this.currentPriceLabel = null;
        this.discountLabel = null;
        this.marketPriceLabel = null;
        this.saleCountLabel = null;
        System.gc();
        super.onBack();
    }

    private void showDeal(Deal deal) {
        if (deal == null) {
            return;
        }
        try {
            this._deal = deal;
            if (deal.currentPrice != null) {
                this.currentPriceLabel.setText("\uffe5" + Methods.formatPrice(deal.currentPrice));
            }
            if (deal.discount != null) {
                this.discountLabel.setText("\u6298\u6263:" + deal.discount + "\u6298");
            }
            if (deal.marketPrice != null) {
                this.marketPriceLabel.setText("\u539f\u4ef7:\uffe5" + Methods.formatPrice(deal.marketPrice));
            }
            if (deal.saleCount != null) {
                this.saleCountLabel.setText(deal.saleCount + "\u4eba\u5df2\u8d2d\u4e70");
                Container saleCountContainer = this.saleCountLabel.getParent();
                if (saleCountContainer != null) {
                    this.saleCountLabel.setX((saleCountContainer.getPreferredW() - this.saleCountLabel.getPreferredW()) / 2);
                }
            }
            this.repaint();
            this.detailContainer.removeAll();
            if (!Methods.isNullOrWhitespace(deal.setMeal)) {
                ContentContainer setMealContainer = new ContentContainer("\u5957\u9910\u5185\u5bb9", deal.setMeal);
                this.detailContainer.addComponent(setMealContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.highlights)) {
                ContentContainer highlightsContainer = new ContentContainer("\u7279\u8272\u4eae\u70b9", deal.highlights);
                this.detailContainer.addComponent(highlightsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.consumerTips)) {
                ContentContainer consumerTipsContainer = new ContentContainer("\u6d88\u8d39\u63d0\u793a", deal.consumerTips);
                this.detailContainer.addComponent(consumerTipsContainer);
                this.repaint();
            }
            if (!Methods.isNullOrWhitespace(deal.businessInfo)) {
                ContentContainer businessContainer = new ContentContainer("\u5546\u5bb6\u4fe1\u606f", deal.businessInfo);
                this.detailContainer.addComponent(businessContainer);
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onPhoneClicked() {
        if (this._deal == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else if (this._deal.business == null || this._deal.business.size() <= 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u7535\u8bdd\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            PhoneListPage.Show(this.self, this._deal.business);
        }
    }

    private void onAddressClicked() {
        if (this._deal == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else if (this._deal.business == null || this._deal.business.size() <= 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u5730\u5740\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            AddressListPage.Show(this.self, this._deal.business);
        }
    }

    private void onShareClicked() {
        if (this._postOrder != null && !Methods.isNullOrWhitespace(this._postOrder.share)) {
            PhoneFunction.callSendSMS(this._postOrder.share);
        }
    }

    private Label createLabel(Image icon, String text) {
        Label label = new Label(text);
        if (icon == null) {
            label.getStyle().setMargin(1, 15 + UserImages.ICON_POINT_IMAGE.getWidth());
            label.setPreferredW(330);
        } else {
            label.setIcon(icon);
            label.setGap(5);
            label.getStyle().setMargin(1, 10);
            label.setPreferredW(this.labelWidth);
        }
        label.setPreferredH(30);
        return label;
    }
}

