/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.connect.DataDownload;
import com.nuomi.data.RechargeUrl;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.RechargeResultPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;

public class RechargePage
extends BasePage {
    private static RechargePage _RechargePage = null;
    private Label balanceLabel = null;
    private TextBox amountTextBox = null;
    private Button payButton = null;
    private DataDownload dataDownload = null;

    public static void Show(BasePage parentPage) {
        if (_RechargePage == null) {
            _RechargePage = new RechargePage();
        }
        _RechargePage.setParent(parentPage);
        _RechargePage.initPage();
        _RechargePage.reset();
        _RechargePage.show();
    }

    private RechargePage() {
        this.setTitle("\u5145\u503c");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new BoxLayout(2));
        Container balanceContent = new Container(new BoxLayout(2));
        Label balanceTitleLabel = new Label("\u60a8\u76ee\u524d\u7684\u8d26\u6237\u4f59\u989d\u4e3a");
        balanceContent.addComponent(balanceTitleLabel);
        balanceTitleLabel.getStyle().setFont(UserInterface.FONT_FEEDBACK);
        balanceTitleLabel.getStyle().setAlignment(4);
        balanceTitleLabel.setPreferredW(340);
        balanceTitleLabel.setPreferredH(28);
        balanceTitleLabel.getStyle().setMargin(2, 5);
        balanceTitleLabel.getStyle().setMargin(1, 5);
        balanceTitleLabel.getStyle().setMargin(3, 5);
        this.balanceLabel = new Label(" ");
        balanceContent.addComponent(this.balanceLabel);
        this.balanceLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.balanceLabel.getStyle().setFgColor(15492920);
        this.balanceLabel.getStyle().setAlignment(4);
        this.balanceLabel.setPreferredW(340);
        this.balanceLabel.setPreferredH(28);
        this.balanceLabel.getStyle().setMargin(2, 5);
        this.balanceLabel.getStyle().setMargin(1, 5);
        this.balanceLabel.getStyle().setMargin(3, 5);
        Container inputContainer = new Container(new BorderLayout());
        balanceContent.addComponent(inputContainer);
        inputContainer.getStyle().setMargin(1, 5);
        inputContainer.getStyle().setMargin(3, 5);
        Label inputHintLabel = new Label("\u8bf7\u8f93\u5165\u5145\u503c\u91d1\u989d:");
        inputContainer.addComponent("West", (Component)inputHintLabel);
        inputHintLabel.getStyle().setFont(UserInterface.FONT_FEEDBACK);
        this.amountTextBox = new TextBox(5);
        inputContainer.addComponent("Center", (Component)this.amountTextBox);
        inputContainer.setPreferredW(340);
        inputContainer.setPreferredH(this.amountTextBox.getPreferredH());
        String[] hintStrings = new String[]{"\u63d0\u793a\uff1a\u5145\u503c\u91d1\u989d\u4e0d\u53ef\u8d85\u51fa\u94f6\u884c\u5355", "\u7b14\u652f\u4ed8\u989d\u5ea6\uff0c\u5efa\u8bae\u6bcf\u6b21\u5145\u503c\u5c0f\u4e8e", "499\u5143"};
        LabelGroup hintGroup = new LabelGroup(hintStrings, UserInterface.FONT_FEEDBACK, 9084854, 28);
        balanceContent.addComponent(hintGroup);
        hintGroup.getStyle().setMargin(0, 5);
        hintGroup.getStyle().setMargin(1, 5);
        hintGroup.getStyle().setMargin(3, 5);
        ContentContainer balanceContentContainer = new ContentContainer(balanceContent, 0, 0);
        this.mainContainer.addComponent(balanceContentContainer);
        balanceContentContainer.getStyle().setMargin(0, 5);
        Container payContent = new Container(new BoxLayout(2));
        Label payTitleLabel = new Label("\u652f\u4ed8\u5b9d\u624b\u673a\u5145\u503c");
        payContent.addComponent(payTitleLabel);
        payTitleLabel.getStyle().setFont(UserInterface.FONT_FEEDBACK);
        payTitleLabel.getStyle().setMargin(1, 5);
        Label spLabel = new Label();
        payContent.addComponent(spLabel);
        spLabel.getStyle().setBgColor(0x919191);
        spLabel.getStyle().setBgTransparency(128);
        spLabel.setPreferredW(348);
        spLabel.setPreferredH(1);
        String[] hintStrings2 = new String[]{"\u6ce8:\u76ee\u524d\u5ba2\u6237\u7aef\u4ec5\u652f\u6301\u652f\u4ed8\u5b9d\u4ed8\u6b3e"};
        LabelGroup hintGroup2 = new LabelGroup(hintStrings2, UserInterface.FONT_FEEDBACK, 9084854, 28);
        payContent.addComponent(hintGroup2);
        hintGroup2.getStyle().setMargin(0, 5);
        hintGroup2.getStyle().setMargin(1, 5);
        hintGroup2.getStyle().setMargin(3, 5);
        Container buttonContainer = new Container(new BoxLayout(1));
        payContent.addComponent(buttonContainer);
        this.payButton = UserInterface.createButton("\u53bb\u5145\u503c");
        buttonContainer.addComponent(this.payButton);
        this.payButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RechargePage.this.GoRecharge();
            }
        });
        buttonContainer.getStyle().setPadding(1, (350 - this.payButton.getPreferredW()) / 2);
        buttonContainer.getStyle().setMargin(0, 15);
        ContentContainer payContentContainer = new ContentContainer(payContent, 0, 15);
        this.mainContainer.addComponent(payContentContainer);
        payContentContainer.getStyle().setMargin(0, 5);
    }

    private void initPage() {
        if (BasePage.clientInfo.getUserInfo() != null && BasePage.clientInfo.getUserInfo().balance != null) {
            this.balanceLabel.setText("\uffe5" + Methods.formatPrice(BasePage.clientInfo.getUserInfo().balance));
        }
    }

    private void reset() {
        this.amountTextBox.setText(null);
        if (this.dataDownload != null && this.dataDownload.isDownloading()) {
            this.dataDownload.cancel();
        }
    }

    private void GoRecharge() {
        if (BasePage.clientInfo.getUserInfo() == null) {
            return;
        }
        String amount = this.amountTextBox.getText();
        if (Methods.isNullOrWhitespace(amount)) {
            this.showHint("\u8bf7\u8f93\u5165\u5145\u503c\u91d1\u989d");
            this.amountTextBox.setFocus(true);
            return;
        }
        if (this.dataDownload == null) {
            this.dataDownload = new DataDownload();
            this.dataDownload.addDownloadListener(new DataDownloadListener(){

                public void onDownloadStart(Object tag) {
                    RechargePage.this.startRefresh();
                    RechargePage.this.showRefreshIcon();
                    RechargePage.this.payButton.setEnabled(false);
                }

                public void onDownloadCompleted(int result, Object data, int type, Object tag) {
                    String hintString = DataDownload.ResultStrings[result];
                    boolean showHint = true;
                    if (result == 2 && data instanceof RechargeUrl) {
                        RechargeUrl rechargeUrl = (RechargeUrl)data;
                        if (rechargeUrl.resultInfo.isSucceed()) {
                            if (Methods.isNullOrWhitespace(rechargeUrl.url) || !rechargeUrl.url.startsWith("http://")) {
                                hintString = "\u652f\u4ed8\u94fe\u63a5\u751f\u6210\u5931\u8d25";
                            } else if (rechargeUrl.orderId == null) {
                                hintString = "\u8ba2\u5355\u751f\u6210\u5931\u8d25";
                            } else {
                                showHint = false;
                                PhoneFunction.callBrowser(rechargeUrl.url);
                                RechargeResultPage.Show(BasePage.MainPage, rechargeUrl.orderId, RechargePage.this.amountTextBox.getText());
                            }
                        } else if (rechargeUrl.resultInfo.isLogExpired()) {
                            if (RechargePage.this.getCurrentForm() == RechargePage.this.self && !MessageBox.isShow) {
                                if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                    LogPage.Show(RechargePage.this.self, true);
                                }
                                showHint = false;
                            }
                        } else {
                            hintString = rechargeUrl.resultInfo.msg;
                        }
                    }
                    if (showHint) {
                        RechargePage.this.showHint(hintString);
                    }
                    RechargePage.this.hideRefreshIcon();
                    RechargePage.this.endRefresh();
                    RechargePage.this.payButton.setEnabled(true);
                }
            });
        }
        this.dataDownload.rechargeUrl(BasePage.clientInfo.getUserInfo().userId, BasePage.clientInfo.getUserInfo().ticket, Double.parseDouble(amount));
    }
}

