/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.PayStatusResult;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.HomePage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;

public class RechargeResultPage
extends BasePage {
    private static RechargeResultPage _RechargeResultPage = null;
    private long orderId = -1L;
    private final int TOP_MARGIN;
    private Container innerContainer = null;
    private Label resultLabel = null;
    private Label rechargeLabel = null;
    private Label balanceLabel = null;
    private Button payStatusButton = null;
    private ContentContainer resultContentContainer = null;
    private DataDownload payStatusDataDownload = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            RechargeResultPage.this.startRefresh();
            RechargeResultPage.this.showRefreshIcon();
            if (RechargeResultPage.this.payStatusButton != null) {
                RechargeResultPage.this.payStatusButton.setEnabled(false);
            }
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof PayStatusResult) {
                PayStatusResult payStatusResult = (PayStatusResult)data;
                if (payStatusResult.result.isSucceed()) {
                    RechargeResultPage.this.payStatus(payStatusResult);
                } else if (payStatusResult.result.isLogExpired()) {
                    if (RechargeResultPage.this.getCurrentForm() == RechargeResultPage.this.self && !MessageBox.isShow) {
                        if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                            LogPage.Show(RechargeResultPage.this.self, true);
                        } else {
                            RechargeResultPage.this.showHint("\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f");
                        }
                    }
                } else {
                    RechargeResultPage.this.showHint(payStatusResult.result.msg);
                }
            } else {
                RechargeResultPage.this.showHint(hintString);
            }
            if (RechargeResultPage.this.payStatusButton != null) {
                RechargeResultPage.this.payStatusButton.setEnabled(true);
            }
            RechargeResultPage.this.hideRefreshIcon();
            RechargeResultPage.this.endRefresh();
            RechargeResultPage.this.repaint();
        }
    };

    public static void Show(BasePage parentPage, long orderId, String recharge) {
        if (_RechargeResultPage == null) {
            _RechargeResultPage = new RechargeResultPage();
        }
        RechargeResultPage._RechargeResultPage.orderId = orderId;
        if (RechargeResultPage._RechargeResultPage.rechargeLabel != null) {
            RechargeResultPage._RechargeResultPage.rechargeLabel.setText(String.valueOf(recharge) + "\u5143");
        }
        _RechargeResultPage.setParent(parentPage);
        _RechargeResultPage.reset();
        _RechargeResultPage.show();
    }

    private RechargeResultPage() {
        this.TOP_MARGIN = 15;
        this.setTitle("\u652f\u4ed8\u7ed3\u679c");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        Button moreButton = UserInterface.createBigButton("\u8fd4\u56de\u6211\u7684\u7cef\u7c73");
        moreButton.setPreferredW(176);
        moreButton.setPreferredH(55);
        moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (BasePage.MainPage != null) {
                    BasePage.MainPage.show();
                }
            }
        });
        Style[] moreButtonStyles = UserInterface.getComponentStyles(moreButton);
        int i = 0;
        while (i < moreButtonStyles.length) {
            moreButtonStyles[i].setMargin(0, 5);
            moreButtonStyles[i].setMargin(2, 5);
            ++i;
        }
        Container moreContainer = new Container();
        this.mainContainer.addComponent(moreContainer);
        moreContainer.setPreferredW(this.mainContainer.getPreferredW());
        moreContainer.setPreferredH(moreButton.getPreferredH() + 10);
        moreContainer.addComponent(moreButton);
        moreContainer.setLayout(new CoordinateLayout(moreContainer.getPreferredW(), moreContainer.getPreferredH()));
        moreButton.setX((moreContainer.getPreferredW() - moreButton.getPreferredW()) / 2);
        moreButton.setY(5);
        moreContainer.setX(0);
        moreContainer.setY(this.mainContainer.getPreferredH() - moreContainer.getPreferredH());
        moreContainer.getStyle().setBgImage(UserImages.NUOMI_TITLEBAR_BG_IMAGE);
        this.innerContainer = new Container(new BoxLayout(2));
        this.mainContainer.addComponent(this.innerContainer);
        this.innerContainer.setX(0);
        this.innerContainer.setY(0);
        Container resultContent = new Container(new BoxLayout(2));
        this.resultLabel = new Label("\u606d\u559c\u60a8\uff0c\u5145\u503c\u6210\u529f");
        resultContent.addComponent(this.resultLabel);
        this.resultLabel.getStyle().setFgColor(9084854);
        this.resultLabel.getStyle().setAlignment(4);
        this.resultLabel.getStyle().setFont(UserInterface.FONT_FEEDBACK);
        this.resultLabel.getStyle().setFgColor(6479476);
        Label spLabel = new Label();
        resultContent.addComponent(spLabel);
        spLabel.getStyle().setBgColor(0x919191);
        spLabel.getStyle().setBgTransparency(128);
        spLabel.getStyle().setMargin(0, 15);
        spLabel.getStyle().setMargin(2, 15);
        spLabel.setPreferredW(UserInterface.DISPLAY_WIDTH - 10);
        spLabel.setPreferredH(1);
        Container rechargeContainer = new Container(new BorderLayout());
        resultContent.addComponent(rechargeContainer);
        rechargeContainer.getStyle().setMargin(1, 15);
        rechargeContainer.getStyle().setMargin(3, 15);
        Label titleLabel = new Label("\u5145\u503c\u91d1\u989d\uff1a");
        titleLabel.getStyle().setFont(UserInterface.FONT_NORMAL);
        rechargeContainer.addComponent("West", (Component)titleLabel);
        this.rechargeLabel = new Label();
        this.rechargeLabel.getStyle().setFont(UserInterface.FONT_NORMAL);
        rechargeContainer.addComponent("East", (Component)this.rechargeLabel);
        Label spLabel1 = new Label();
        resultContent.addComponent(spLabel1);
        spLabel1.getStyle().setBgColor(0x919191);
        spLabel1.getStyle().setBgTransparency(128);
        spLabel1.getStyle().setMargin(15, 15, 15, 15);
        spLabel1.setPreferredW(UserInterface.DISPLAY_WIDTH - 10 - 30);
        spLabel1.setPreferredH(1);
        Container balanceContainer = new Container(new BorderLayout());
        resultContent.addComponent(balanceContainer);
        balanceContainer.getStyle().setMargin(1, 15);
        balanceContainer.getStyle().setMargin(3, 15);
        Label titleLabel2 = new Label("\u4f59\u989d\uff1a");
        titleLabel2.getStyle().setFont(UserInterface.FONT_NORMAL);
        balanceContainer.addComponent("West", (Component)titleLabel2);
        this.balanceLabel = new Label();
        this.balanceLabel.getStyle().setFont(UserInterface.FONT_NORMAL);
        balanceContainer.addComponent("East", (Component)this.balanceLabel);
        this.resultContentContainer = new ContentContainer(resultContent, 15, 15);
        this.resultContentContainer.getStyle().setMargin(0, 15);
        this.payStatusButton = UserInterface.createBigButton("\u67e5\u8be2\u5145\u503c\u7ed3\u679c");
        Container payStatusContainer = new Container(new CoordinateLayout(UserInterface.DISPLAY_WIDTH, this.payStatusButton.getPreferredH()));
        this.innerContainer.addComponent(payStatusContainer);
        payStatusContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        payStatusContainer.setPreferredH(this.payStatusButton.getPreferredH());
        payStatusContainer.getStyle().setMargin(0, 15);
        payStatusContainer.addComponent(this.payStatusButton);
        this.payStatusButton.setX((payStatusContainer.getPreferredW() - this.payStatusButton.getPreferredW()) / 2);
        this.payStatusButton.setY(0);
        this.payStatusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RechargeResultPage.this.onCheckPayStatus();
            }
        });
    }

    private void reset() {
        if (this.resultContentContainer != null && this.innerContainer.contains(this.resultContentContainer)) {
            this.innerContainer.removeComponent(this.resultContentContainer);
        }
        if (this.payStatusButton != null) {
            this.payStatusButton.setEnabled(true);
            this.payStatusButton.setVisible(true);
        }
    }

    private void onCheckPayStatus() {
        UserInfo userInfo;
        if (this.payStatusDataDownload == null) {
            this.payStatusDataDownload = new DataDownload();
            this.payStatusDataDownload.addDownloadListener(this.listener);
        }
        if ((userInfo = BasePage.clientInfo.getUserInfo()) != null && this.orderId > -1L) {
            this.payStatusDataDownload.payStatus(userInfo.userId, userInfo.ticket, this.orderId);
        }
    }

    private void payStatus(PayStatusResult payStatusResult) {
        if (this.resultContentContainer != null && !this.innerContainer.contains(this.resultContentContainer)) {
            this.innerContainer.addComponent(0, (Component)this.resultContentContainer);
        }
        if (payStatusResult != null && payStatusResult.balance != null) {
            this.balanceLabel.setText(payStatusResult.balance + "\u5143");
        }
        this.payStatusButton.setVisible(false);
        this.payStatusButton.setEnabled(false);
        ((HomePage)BasePage.MainPage).needRefreshUserInfo_MyNuomi = true;
    }
}

