/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.LoginInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.Login;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.ActivePage;
import com.nuomi.pages.BasePage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;

public class RegisterPage
extends BasePage {
    private static RegisterPage _RegisterPage = null;
    private final int TOP_MARGIN;
    private TextBox emailTextBox = null;
    private TextBox nicknameTextBox = null;
    private TextBox passwordTextBox = null;
    private TextBox passwordCheckTextBox = null;
    private Button registerButton = null;
    private Button cancelButton = null;
    private boolean isRegistering = false;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            RegisterPage.this.setRegistering(true);
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof Login) {
                Login login = (Login)data;
                if (login.result.succ == null || login.result.isSucceed()) {
                    BasePage.clientInfo.setLoginInfo(new LoginInfo(RegisterPage.this.emailTextBox.getText().trim(), RegisterPage.this.passwordTextBox.getText(), true));
                    UserInfo userInfo = login.userInfo;
                    userInfo.actived = new Boolean(false);
                    userInfo.name = RegisterPage.this.nicknameTextBox.getText().trim();
                    userInfo.avatar = "";
                    userInfo.phone = RegisterPage.this.emailTextBox.getText().trim();
                    userInfo.balance = new Double(0.0);
                    userInfo.moneySaved = new Double(0.0);
                    userInfo.couponCount = new Integer(0);
                    userInfo.postOrderCount = new Integer(0);
                    userInfo.lotteryCount = new Integer(0);
                    BasePage.clientInfo.setUserInfo(userInfo);
                    ActivePage.Show(RegisterPage.this.parentPage, true);
                } else {
                    hintString = login.result.msg;
                }
            }
            RegisterPage.this.setRegistering(false);
            RegisterPage.this.showHint(hintString);
        }
    };

    public static void Show(BasePage parentPage) {
        if (_RegisterPage == null) {
            _RegisterPage = new RegisterPage();
        }
        _RegisterPage.setParent(parentPage);
        RegisterPage._RegisterPage.emailTextBox.setText(null);
        RegisterPage._RegisterPage.nicknameTextBox.setText(null);
        RegisterPage._RegisterPage.passwordTextBox.setText(null);
        RegisterPage._RegisterPage.passwordCheckTextBox.setText(null);
        _RegisterPage.show();
    }

    private RegisterPage() {
        this.TOP_MARGIN = 10;
        this.self.setTitle("\u6ce8\u518c");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new BoxLayout(2));
        Container content = new Container(new BoxLayout(2));
        this.emailTextBox = new TextBox(2);
        content.addComponent(this.emailTextBox);
        this.emailTextBox.setHint("\u624b\u673a\u53f7");
        this.nicknameTextBox = new TextBox();
        content.addComponent(this.nicknameTextBox);
        this.nicknameTextBox.setHint("\u6635\u79f0");
        this.nicknameTextBox.getStyle().setMargin(0, 10);
        this.passwordTextBox = new TextBox(65536);
        content.addComponent(this.passwordTextBox);
        this.passwordTextBox.setHint("\u8bf7\u8f93\u5165\u5bc6\u7801");
        this.passwordTextBox.getStyle().setMargin(0, 10);
        this.passwordCheckTextBox = new TextBox(65536);
        content.addComponent(this.passwordCheckTextBox);
        this.passwordCheckTextBox.setHint("\u8bf7\u518d\u6b21\u8f93\u5165\u5bc6\u7801");
        this.passwordCheckTextBox.getStyle().setMargin(0, 10);
        this.registerButton = UserInterface.createButton("\u6ce8\u518c");
        this.registerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RegisterPage.this.onRegister();
            }
        });
        this.cancelButton = UserInterface.createButton("\u53d6\u6d88");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RegisterPage.this.onCancel();
            }
        });
        int margin = Math.max(0, (content.getPreferredW() - this.cancelButton.getPreferredW() - this.registerButton.getPreferredW()) / 3);
        int buttonContainerWidth = margin + this.cancelButton.getPreferredW() + this.registerButton.getPreferredW();
        int buttonContainerHeight = this.cancelButton.getPreferredH();
        Container buttonContainer = new Container(new CoordinateLayout(buttonContainerWidth, buttonContainerHeight));
        buttonContainer.setPreferredW(buttonContainerWidth);
        buttonContainer.setPreferredH(buttonContainerHeight);
        content.addComponent(buttonContainer);
        buttonContainer.addComponent(this.cancelButton);
        buttonContainer.addComponent(this.registerButton);
        buttonContainer.getStyle().setMargin(0, 20);
        this.registerButton.setX(0);
        this.registerButton.setY(0);
        this.cancelButton.setX(this.registerButton.getPreferredW() + margin);
        this.cancelButton.setY(0);
        ContentContainer contentContainer = new ContentContainer(content, 15, 15);
        this.mainContainer.addComponent(contentContainer);
        contentContainer.getStyle().setMargin(0, 5);
    }

    private void setRegistering(boolean isRegistering) {
        if (this.isRegistering != isRegistering) {
            this.isRegistering = isRegistering;
            this.emailTextBox.setEnabled(!isRegistering);
            this.nicknameTextBox.setEnabled(!isRegistering);
            this.passwordTextBox.setEnabled(!isRegistering);
            this.passwordCheckTextBox.setEnabled(!isRegistering);
            this.registerButton.setEnabled(!isRegistering);
            if (isRegistering) {
                this.showRefreshIcon();
            } else {
                this.hideRefreshIcon();
            }
            this.setRefresh(isRegistering);
        }
    }

    private void onRegister() {
        String email = this.emailTextBox.getText().trim();
        if (Methods.isNullOrEmpty(email)) {
            this.showHint("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.emailTextBox.setFocus(true);
            return;
        }
        if (!PhoneFunction.isPhoneNumber(email)) {
            this.showHint("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            this.emailTextBox.setFocus(true);
            return;
        }
        String nickname = this.nicknameTextBox.getText().trim();
        if (Methods.isNullOrEmpty(nickname)) {
            this.showHint("\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.nicknameTextBox.setFocus(true);
            return;
        }
        if (nickname.length() > 16) {
            this.showHint("\u6635\u79f0\u4e0d\u80fd\u8d85\u8fc716\u4e2a\u5b57\u7b26");
            this.nicknameTextBox.setFocus(true);
            return;
        }
        if (!Methods.checkNickNameValid(nickname)) {
            this.showHint("\u6635\u79f0\u7531\u4e2d\u6587/\u82f1\u6587/\u6570\u5b57\u7ec4\u6210");
            this.nicknameTextBox.setFocus(true);
            return;
        }
        String password = this.passwordTextBox.getText();
        if (Methods.isNullOrEmpty(password)) {
            this.showHint("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.passwordTextBox.setFocus(true);
            return;
        }
        if (password.length() < 8) {
            this.showHint("\u5bc6\u7801\u6700\u5c118\u4f4d");
            this.passwordTextBox.setFocus(true);
            return;
        }
        String passwordCheck = this.passwordCheckTextBox.getText();
        if (!Methods.equals(password, passwordCheck)) {
            this.showHint("\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4");
            this.passwordCheckTextBox.setFocus(true);
            return;
        }
        DataDownload dataDownload = new DataDownload();
        dataDownload.addDownloadListener(this.listener);
        dataDownload.register(email, password, nickname, BasePage.clientInfo.getCity().cityId);
    }

    private void onCancel() {
        if (this.isRegistering) {
            this.setRegistering(false);
        } else {
            this.onBack();
        }
    }
}

