/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.Voucher;
import com.nuomi.data.VoucherPreview;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.pages.ActivePage;
import com.nuomi.pages.AddressListPage;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.BusinessListPage;
import com.nuomi.pages.LogPage;
import com.nuomi.pages.PhoneListPage;
import com.nuomi.pages.TextPage;
import com.nuomi.pages.VoucherDownloadPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.usercontrol.ItemButtonGroup;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TabControl;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class VoucherDetailPage
extends BasePage {
    private static VoucherDetailPage _VoucherDetailPage = null;
    private final int labelWidthWithIcon;
    private final int labelWidth = 325 - UserImages.ICON_POINT_IMAGE.getWidth();
    private final int labelHeight;
    private Container scrollContainer = null;
    private Container innerContainer = null;
    private Label downloadLabel = null;
    private Button downloadButton = null;
    private Container sampleContainer = null;
    private Container detailContainer = null;
    private VoucherPreview _voucherPreview = null;
    private Voucher _voucher = null;
    private DataDownload voucherDownload = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            VoucherDetailPage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data != null && data instanceof Voucher) {
                BasePage.clientInfo.setDealDetail(((VoucherDetailPage)VoucherDetailPage.this)._voucherPreview.voucherId, data);
                VoucherDetailPage.this.showVoucher((Voucher)data);
            }
            if (result != 3) {
                VoucherDetailPage.this.showHint(hintString);
                VoucherDetailPage.this.endRefresh();
            }
        }
    };

    public static void Show(BasePage parentPage, VoucherPreview voucherPreview) {
        if (_VoucherDetailPage == null) {
            _VoucherDetailPage = new VoucherDetailPage();
        }
        _VoucherDetailPage.setContent(voucherPreview);
        _VoucherDetailPage.setParent(parentPage);
        _VoucherDetailPage.show();
    }

    private VoucherDetailPage() {
        this.labelWidthWithIcon = 330;
        this.labelHeight = 30;
        this.self.setTitle("\u4f18\u60e0\u5238");
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        TabControl tabControl = new TabControl(UserImages.DETAIL_TAB_BG_IMAGE, UserImages.DETAIL_TABS_IMAGES, false);
        tabControl.setX(0);
        tabControl.setY(this.mainContainer.getPreferredH() - tabControl.getPreferredH());
        this.scrollContainer = new Container();
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - tabControl.getClickHeight());
        this.scrollContainer.setLayout(new CoordinateLayout(this.scrollContainer.getPreferredW(), this.scrollContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setScrollableY(true);
        this.innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(this.innerContainer);
        this.innerContainer.getStyle().setPadding(2, 10);
        this.sampleContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.sampleContainer);
        this.detailContainer = new Container(new BoxLayout(2));
        this.innerContainer.addComponent(this.detailContainer);
        ItemButton supportShopButton = new ItemButton(0, "\u652f\u6301\u5e97\u9762", UserImages.ICON_SUPPORT_SHOP_IMAGE, true);
        supportShopButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                VoucherDetailPage.this.onSupportShopClicked();
            }
        });
        ItemButton disclaimerButton = new ItemButton(2, "\u514d\u8d23\u7533\u660e", UserImages.ICON_DISCLAIMER_IMAGE, true);
        disclaimerButton.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                VoucherDetailPage.this.onDisclaimerClicked();
            }
        });
        ItemButton[] itemButtons = new ItemButton[]{supportShopButton, disclaimerButton};
        ItemButtonGroup group = new ItemButtonGroup(itemButtons);
        this.innerContainer.addComponent(group);
        group.getStyle().setMargin(0, 5);
        this.mainContainer.addComponent(tabControl);
        tabControl.addChangedListener(new SelectionChangedListener(){

            public void onChanged(int index) {
                switch (index) {
                    case 0: {
                        VoucherDetailPage.this.onPhoneClicked();
                        break;
                    }
                    case 1: {
                        VoucherDetailPage.this.onAddressClicked();
                        break;
                    }
                    case 2: {
                        VoucherDetailPage.this.onShareClicked();
                        break;
                    }
                }
            }
        });
    }

    private void setContent(VoucherPreview voucherPreview) {
        this.scrollContainer.setScrollY(0);
        this._voucherPreview = voucherPreview;
        if (voucherPreview == null) {
            return;
        }
        this.sampleContainer.removeAll();
        this.detailContainer.removeAll();
        Container previewContainer = new Container(new BoxLayout(2));
        previewContainer.getStyle().setPadding(1, 10);
        previewContainer.getStyle().setPadding(3, 10);
        int imageTitleWidth = 340;
        int imageTitleHeight = 90;
        Container imageTitleContainer = new Container(new CoordinateLayout(imageTitleWidth, imageTitleHeight));
        imageTitleContainer.setPreferredW(imageTitleWidth);
        imageTitleContainer.setPreferredH(imageTitleHeight);
        previewContainer.addComponent(imageTitleContainer);
        imageTitleContainer.getStyle().setMargin(0, 5);
        imageTitleContainer.getStyle().setMargin(1, 10);
        ImageControl image = new ImageControl(150, imageTitleHeight);
        imageTitleContainer.addComponent(image);
        image.setX(0);
        image.setY(0);
        image.setImage(voucherPreview.image, true);
        if (voucherPreview.title != null) {
            Vector titleVector = Methods.splitString(voucherPreview.title, UserInterface.FONT_NORMAL, 0, imageTitleWidth - image.getPreferredW() - 15);
            String[] titleStrings = new String[Math.min(3, titleVector.size())];
            int i = 0;
            while (i < titleStrings.length) {
                titleStrings[i] = (String)titleVector.elementAt(i);
                if (i == 2 && titleVector.size() > 3) {
                    titleStrings[i] = String.valueOf(titleStrings[i].substring(0, titleStrings[i].length() - 1)) + "...";
                }
                ++i;
            }
            LabelGroup titleGroup = new LabelGroup(titleStrings, UserInterface.FONT_NORMAL, 6453130, 30);
            imageTitleContainer.addComponent(titleGroup);
            titleGroup.setX(image.getPreferredW() + 10);
            titleGroup.setY(0);
        }
        int blueWidth = UserImages.USERCONTAINER_LIGHTBLUE_IMAGE.getWidth();
        int blueHeight = 157;
        Container blueContainer = new Container(new CoordinateLayout(blueWidth, blueHeight));
        blueContainer.setPreferredW(blueWidth);
        blueContainer.setPreferredH(blueHeight);
        previewContainer.addComponent(blueContainer);
        blueContainer.getStyle().setMargin(0, 10);
        blueContainer.getStyle().setMargin(1, 5);
        blueContainer.getStyle().setMargin(3, 5);
        blueContainer.getStyle().setBgImage(UserImages.USERCONTAINER_LIGHTBLUE_IMAGE);
        if (voucherPreview.expireTimeCalendar != null) {
            String endtimeString = "\u6709\u6548\u65f6\u95f4:" + CalendarFormat.toYMD(voucherPreview.expireTimeCalendar);
            Label endtimeLabel = new Label(endtimeString);
            blueContainer.addComponent(endtimeLabel);
            endtimeLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            endtimeLabel.setX((blueWidth - endtimeLabel.getPreferredW()) / 2);
            endtimeLabel.setY(2);
            this.downloadLabel = UserInterface.createLongAreaLabel("\u4e0b\u8f7d\u6b21\u6570:" + voucherPreview.downloadCount, 230);
            this.downloadLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            blueContainer.addComponent(this.downloadLabel);
            this.downloadLabel.setX((blueWidth - this.downloadLabel.getPreferredW()) / 2);
            this.downloadLabel.setY(endtimeLabel.getY() + endtimeLabel.getPreferredH() + 2);
            Container dotlineContainer = new Container();
            dotlineContainer.setPreferredW(UserImages.VOUCHERDETAIL_DOTTED_LINE_IMAGE.getWidth());
            dotlineContainer.setPreferredH(UserImages.VOUCHERDETAIL_DOTTED_LINE_IMAGE.getHeight());
            dotlineContainer.getStyle().setBgImage(UserImages.VOUCHERDETAIL_DOTTED_LINE_IMAGE);
            blueContainer.addComponent(dotlineContainer);
            dotlineContainer.setX((blueWidth - dotlineContainer.getPreferredW()) / 2);
            dotlineContainer.setY(this.downloadLabel.getY() + this.downloadLabel.getPreferredH() + 5);
            if (voucherPreview.canSendSms == null || !voucherPreview.canSendSms.booleanValue()) {
                String[] strings = new String[]{"\u8be5\u5238\u4e0d\u652f\u6301\u77ed\u4fe1\u4e0b\u8f7d", " \u8bf7\u767b\u5f55\u7cef\u7c73\u7f51\u83b7\u53d6"};
                LabelGroup group = new LabelGroup(strings, UserInterface.FONT_MESSAGEBOX, 6453130, 28);
                blueContainer.addComponent(group);
                group.setX((blueWidth - group.getPreferredW()) / 2);
                group.setY(dotlineContainer.getY() + dotlineContainer.getPreferredH() + (blueHeight - group.getPreferredH() - (dotlineContainer.getY() + dotlineContainer.getPreferredH())) / 2);
            } else {
                long currentTime = System.currentTimeMillis() + ClientInfo.timeRelativeError;
                if (voucherPreview.expireTime == null || voucherPreview.expireTime < currentTime) {
                    Label label = new Label("\u8be5\u4f18\u60e0\u5238\u5df2\u7ecf\u4e0b\u7ebf");
                    label.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
                    blueContainer.addComponent(label);
                    label.setX((blueWidth - label.getPreferredW()) / 2);
                    label.setY(dotlineContainer.getY() + dotlineContainer.getPreferredH() + (blueHeight - label.getPreferredH() - (dotlineContainer.getY() + dotlineContainer.getPreferredH())) / 2);
                } else {
                    this.downloadButton = UserInterface.createIconOnlyButton(UserImages.VOUCHERDETAIL_DOWNLOAD_NORMAL_IMAGE, UserImages.VOUCHERDETAIL_DOWNLOAD_PRESSED_IMAGE);
                    blueContainer.addComponent(this.downloadButton);
                    this.downloadButton.setX((blueWidth - this.downloadButton.getPreferredW()) / 2);
                    this.downloadButton.setY(dotlineContainer.getY() + dotlineContainer.getPreferredH() + (blueHeight - this.downloadButton.getPreferredH() - (dotlineContainer.getY() + dotlineContainer.getPreferredH())) / 2);
                    this.downloadButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            VoucherDetailPage.this.onDownloadClicked();
                        }
                    });
                }
            }
        }
        ContentContainer previewContentContainer = new ContentContainer(previewContainer, UserImages.USERCONTAINER_PREVIEW_BOTTOM_IMAGE, 0, 0);
        this.sampleContainer.addComponent(previewContentContainer);
        previewContentContainer.getStyle().setMargin(0, 5);
        Voucher voucher = BasePage.clientInfo.getVoucherDetail(voucherPreview.voucherId);
        if (voucher != null) {
            this.showVoucher(voucher);
        } else {
            this.onRefresh();
        }
    }

    protected void onRefreshClicked() {
        this.onRefresh();
    }

    protected void onBack() {
        if (this.voucherDownload != null) {
            this.voucherDownload.cancel();
        }
        this.endRefresh();
        if (this.sampleContainer != null) {
            this.sampleContainer.removeAll();
        }
        if (this.detailContainer != null) {
            this.detailContainer.removeAll();
        }
        if (this.downloadButton != null && this.downloadButton.getListenerVector() != null) {
            this.downloadButton.getListenerVector().removeAllElements();
        }
        this.downloadButton = null;
        this.downloadLabel = null;
        System.gc();
        super.onBack();
    }

    private void onRefresh() {
        if (this.voucherDownload == null) {
            this.voucherDownload = new DataDownload();
            this.voucherDownload.addDownloadListener(this.listener);
        } else {
            this.voucherDownload.cancel();
        }
        this.voucherDownload.voucherDetail(this._voucherPreview.voucherId);
    }

    private void showVoucher(Voucher voucher) {
        int i;
        this._voucher = voucher;
        if (voucher == null) {
            return;
        }
        if (this.downloadLabel == null) {
            return;
        }
        this.downloadLabel.setText("\u4e0b\u8f7d\u6b21\u6570:" + voucher.downloadCount);
        if (this.detailContainer == null) {
            return;
        }
        this.detailContainer.removeAll();
        Container content = new Container(new BoxLayout(2));
        Label numberLabel = this.createLabel(UserImages.ICON_POINT_IMAGE, "\u7f16\u53f7:" + voucher.number);
        content.addComponent(numberLabel);
        String shopName = "\u5546\u5bb6\u540d\u79f0:" + this._voucherPreview.businessName;
        Vector shopNameVector = Methods.splitString(shopName, UserInterface.FONT_NORMAL, 0, this.labelWidth - 5);
        int i2 = 0;
        while (i2 < shopNameVector.size()) {
            Label shopNameLabel = this.createLabel(i2 == 0 ? UserImages.ICON_POINT_IMAGE : null, (String)shopNameVector.elementAt(i2));
            content.addComponent(shopNameLabel);
            ++i2;
        }
        Label countLabel = this.createLabel(UserImages.ICON_POINT_IMAGE, "\u4e0b\u8f7d\u6570:" + voucher.downloadCount);
        content.addComponent(countLabel);
        Label startTimeLabel = this.createLabel(UserImages.ICON_POINT_IMAGE, "\u6709\u6548\u671f\u9650:");
        content.addComponent(startTimeLabel);
        Label endTimeLabel = this.createLabel(null, String.valueOf(CalendarFormat.toYMD(voucher.startTimeCalendar)) + "---" + CalendarFormat.toYMD(this._voucherPreview.expireTimeCalendar));
        content.addComponent(endTimeLabel);
        Label businessCountLabel = this.createLabel(UserImages.ICON_POINT_IMAGE, "\u8be5\u5546\u5bb6\u603b\u4e0b\u8f7d\u6570:" + voucher.businessDownloadCount);
        content.addComponent(businessCountLabel);
        Label periodLabel = this.createLabel(UserImages.ICON_POINT_IMAGE, "\u671f\u6570:" + voucher.period);
        content.addComponent(periodLabel);
        if (voucher.description != null) {
            voucher.description = voucher.description.trim();
            voucher.description = Methods.replace(voucher.description, "<br>", "\r\n");
            Vector descriptionVector = Methods.splitString(voucher.description, UserInterface.FONT_NORMAL, 0, this.labelWidth - 5, "\r\n");
            if (descriptionVector != null) {
                i = 0;
                while (i < descriptionVector.size()) {
                    Label descriptionValueLabel = this.createLabel(i == 0 ? UserImages.ICON_POINT_IMAGE : null, ((String)descriptionVector.elementAt(i)).trim());
                    content.addComponent(descriptionValueLabel);
                    ++i;
                }
            }
        }
        if (voucher.hint != null) {
            Vector hintVector = Methods.splitString(voucher.hint.trim(), UserInterface.FONT_NORMAL, 0, this.labelWidth - 5);
            i = 0;
            while (i < hintVector.size()) {
                Label hintLabel = this.createLabel(i == 0 ? UserImages.ICON_POINT_IMAGE : null, (String)hintVector.elementAt(i));
                content.addComponent(hintLabel);
                ++i;
            }
        }
        ContentContainer contentContainer = new ContentContainer("\u4f18\u60e0\u5238\u4fe1\u606f", content);
        if (this.detailContainer == null) {
            return;
        }
        this.detailContainer.addComponent(contentContainer);
        this.repaint();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    private Label createLabel(Image icon, String text) {
        Label label = new Label(text);
        if (icon == null) {
            label.getStyle().setMargin(1, 15 + UserImages.ICON_POINT_IMAGE.getWidth());
            label.setPreferredW(330);
        } else {
            label.setIcon(icon);
            label.setGap(5);
            label.getStyle().setMargin(1, 10);
            label.setPreferredW(this.labelWidth);
        }
        label.setPreferredH(30);
        return label;
    }

    private void onPhoneClicked() {
        if (this._voucher == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else if (this._voucher.branchs == null || this._voucher.branchs.size() == 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u7535\u8bdd\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            PhoneListPage.Show(this.self, this._voucher.branchs);
        }
    }

    private void onAddressClicked() {
        if (this._voucher == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else if (this._voucher.branchs == null || this._voucher.branchs.size() == 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u5730\u5740\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            AddressListPage.Show(this.self, this._voucher.branchs);
        }
    }

    private void onShareClicked() {
        if (this._voucherPreview != null && !Methods.isNullOrWhitespace(this._voucherPreview.share)) {
            PhoneFunction.callSendSMS(this._voucherPreview.share);
        }
    }

    private void onDownloadClicked() {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                LogPage.Show(this.self);
            }
        } else if (userInfo.actived != null && userInfo.actived.booleanValue()) {
            VoucherDownloadPage.Show(this.self, this._voucherPreview);
        } else if (this.getCurrentForm() == this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u672a\u6fc0\u6d3b\u8d26\u53f7", "\u7acb\u5373\u6fc0\u6d3b", "\u53d6\u6d88") == MessageBox.OK) {
            ActivePage.Show(this.self);
        }
    }

    private void onSupportShopClicked() {
        if (this._voucher == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", "\u786e\u5b9a", null);
            }
        } else if (this._voucher.branchs == null || this._voucher.branchs.size() == 0) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow) {
                MessageBox.Show("\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u5e97\u9762\u4fe1\u606f", "\u786e\u5b9a", null);
            }
        } else {
            BusinessListPage.Show(this.self, this._voucher.branchs);
        }
    }

    private void onDisclaimerClicked() {
        TextPage.Show(this.self);
    }
}

