/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.ResultInfo;
import com.nuomi.data.VoucherPreview;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;

public class VoucherDownloadPage
extends BasePage {
    private static VoucherDownloadPage _VoucherDownloadPage = null;
    private TextArea smsContentTextArea = null;
    private TextBox phoneTextBox = null;
    private Button sendButton = null;
    private VoucherPreview _voucherPreview = null;
    private DataDownload sendDownload = null;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            VoucherDownloadPage.this.setSending(true);
            VoucherDownloadPage.this.startRefresh();
            VoucherDownloadPage.this.showRefreshIcon();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            if (result == 2 && data instanceof ResultInfo) {
                ResultInfo resultInfo = (ResultInfo)data;
                if (resultInfo.isSucceed()) {
                    if (VoucherDownloadPage.this.getCurrentForm() == VoucherDownloadPage.this.self && !MessageBox.isShow) {
                        MessageBox.Show("\u53d1\u9001\u6210\u529f", "\u786e\u5b9a", null);
                        VoucherDownloadPage.this.parentPage.show();
                    }
                } else if (resultInfo.isLogExpired()) {
                    if (VoucherDownloadPage.this.getCurrentForm() == VoucherDownloadPage.this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                        LogPage.Show(VoucherDownloadPage.this.self, true);
                    }
                } else {
                    hintString = resultInfo.msg;
                    VoucherDownloadPage.this.showHint(hintString);
                }
            }
            if (result != 3 && result != 2) {
                VoucherDownloadPage.this.showHint(hintString);
            }
            VoucherDownloadPage.this.setSending(false);
            VoucherDownloadPage.this.hideRefreshIcon();
            VoucherDownloadPage.this.endRefresh();
        }
    };

    public static void Show(BasePage parentPage, VoucherPreview voucherPreview) {
        if (_VoucherDownloadPage == null) {
            _VoucherDownloadPage = new VoucherDownloadPage();
        }
        _VoucherDownloadPage.setParent(parentPage);
        _VoucherDownloadPage.setContent(voucherPreview);
        _VoucherDownloadPage.show();
    }

    private VoucherDownloadPage() {
        this.setTitle("\u4f18\u60e0\u5238\u4e0b\u8f7d");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        Container content = new Container(new BoxLayout(2));
        Label smsTitle = new Label("\u77ed\u4fe1\u5185\u5bb9:");
        content.addComponent(smsTitle);
        smsTitle.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.smsContentTextArea = new TextArea();
        this.smsContentTextArea.setEditable(false);
        this.smsContentTextArea.setPreferredW(330);
        this.smsContentTextArea.setPreferredH(160);
        this.smsContentTextArea.setScrollVisible(true);
        Style[] styles = UserInterface.getComponentStyles(this.smsContentTextArea);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(Border.createRoundBorder(10, 10, 0x919191));
            style.setFgColor(0x919191);
            ++i;
        }
        content.addComponent(this.smsContentTextArea);
        Label sendToTitle = new Label("\u53d1\u9001\u5230:");
        content.addComponent(sendToTitle);
        sendToTitle.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        sendToTitle.getStyle().setMargin(0, 5);
        this.phoneTextBox = new TextBox(3);
        content.addComponent(this.phoneTextBox);
        this.phoneTextBox.setHint("\u8bf7\u8f93\u5165\u63a5\u6536\u77ed\u4fe1\u7684\u624b\u673a\u53f7");
        String[] hintStrings = new String[]{"\u540c\u4e00\u8d26\u6237\u6bcf\u5929\u9650\u5236\u4e0b\u8f7d", "2\u6761\u540c\u4e00\u5f20\u4f18\u60e0\u5238"};
        LabelGroup hintGroup = new LabelGroup(hintStrings, UserInterface.FONT_SMALL, 9084854, this.phoneTextBox.getPreferredW(), 25);
        content.addComponent(hintGroup);
        hintGroup.setAlignment(4);
        Container buttonContainer = new Container(new BorderLayout());
        this.sendButton = UserInterface.createButton("\u53d1\u9001");
        Button cancelButton = UserInterface.createButton("\u53d6\u6d88");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VoucherDownloadPage.this.onSend();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VoucherDownloadPage.this.onCancel();
            }
        });
        buttonContainer.addComponent("West", (Component)this.sendButton);
        buttonContainer.addComponent("East", (Component)cancelButton);
        content.addComponent(buttonContainer);
        buttonContainer.getStyle().setMargin(1, 5);
        buttonContainer.getStyle().setMargin(3, 5);
        buttonContainer.getStyle().setMargin(0, 30);
        ContentContainer contentContainer = new ContentContainer(content, 10, 25);
        this.mainContainer.addComponent(contentContainer);
        contentContainer.setY(5);
    }

    private void setContent(VoucherPreview voucherPreview) {
        this._voucherPreview = voucherPreview;
        if (voucherPreview != null) {
            this.smsContentTextArea.setText(voucherPreview.smsContent);
        }
        if (BasePage.clientInfo.getUserInfo() != null) {
            this.phoneTextBox.setText(BasePage.clientInfo.getUserInfo().phone);
        } else {
            this.phoneTextBox.setText("");
        }
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        if (newUserInfo == null) {
            this.phoneTextBox.setText("");
        } else {
            this.phoneTextBox.setText(newUserInfo.phone);
        }
    }

    protected void onBack() {
        if (this.sendDownload != null && this.sendDownload.isDownloading()) {
            this.sendDownload.cancel();
        }
        super.onBack();
    }

    private void onSend() {
        if (this._voucherPreview == null) {
            return;
        }
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo == null) {
            if (this.getCurrentForm() == this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55", "\u7acb\u5373\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                LogPage.Show(this.self);
            }
            return;
        }
        String phone = this.phoneTextBox.getText();
        if (Methods.isNullOrEmpty(phone)) {
            this.showHint("\u8bf7\u8f93\u5165\u63a5\u6536\u77ed\u4fe1\u7684\u624b\u673a\u53f7");
            this.phoneTextBox.setFocus(true);
            return;
        }
        if (!PhoneFunction.isPhoneNumber(phone)) {
            this.showHint("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            this.phoneTextBox.setFocus(true);
            return;
        }
        if (this.sendDownload == null) {
            this.sendDownload = new DataDownload();
            this.sendDownload.addDownloadListener(this.listener);
        }
        this.sendDownload.voucherSendSms(userInfo.userId, userInfo.ticket, this._voucherPreview.voucherId, phone);
    }

    private void onCancel() {
        if (this.sendDownload == null || !this.sendDownload.isDownloading()) {
            this.onBack();
        } else {
            this.sendDownload.cancel();
        }
    }

    private void setSending(boolean isSending) {
        this.phoneTextBox.setEnabled(!isSending);
        this.sendButton.setEnabled(!isSending);
        this.repaint();
    }
}

