/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.record;

import com.nuomi.data.Deal;
import com.nuomi.data.LotteryDeal;
import com.nuomi.data.Voucher;
import com.nuomi.record.RMSRecord;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStoreException;

public class DealDetailRecord
extends RMSRecord {
    private static DealDetailRecord _DealDetailRecord = null;
    private final String RMSName;
    private final int TYPE_LOTTERY_DEAL;
    private final int TYPE_DEAL;
    private final int TYPE_VOUCHER;
    private Hashtable hashtable = null;

    public DealDetailRecord() {
        this.RMSName = "NuomiDealDetailRMS";
        this.TYPE_LOTTERY_DEAL = 0;
        this.TYPE_DEAL = 1;
        this.TYPE_VOUCHER = 2;
        this.recordStoreName = "NuomiDealDetailRMS";
        try {
            this._open();
            int exsitCount = this.recordStore.getNumRecords();
            if (exsitCount > 0) {
                this.hashtable = new Hashtable();
                int i = 1;
                while (i <= exsitCount) {
                    int spIndex;
                    String string = this._getRecord(i);
                    if (string != null && (spIndex = string.indexOf(RMSRecord.spChar)) > -1) {
                        String key = string.substring(0, spIndex);
                        String jsonString = string.substring(spIndex + 1);
                        int spCatalogIndex = key.indexOf(RMSRecord.spCatalog);
                        if (spCatalogIndex > -1) {
                            String typeString = key.substring(0, spCatalogIndex);
                            this.hashtable.put(key, new DealDetail(i, Integer.parseInt(typeString), jsonString));
                        }
                    }
                    ++i;
                }
            }
            this._close();
        }
        catch (RecordStoreException e) {
            this.recordStore = null;
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void init() {
        if (_DealDetailRecord == null) {
            _DealDetailRecord = new DealDetailRecord();
        }
    }

    public static void clear() {
        if (_DealDetailRecord == null) {
            _DealDetailRecord = new DealDetailRecord();
        }
        _DealDetailRecord._clear();
        if (DealDetailRecord._DealDetailRecord.hashtable != null) {
            Enumeration e = DealDetailRecord._DealDetailRecord.hashtable.keys();
            while (e.hasMoreElements()) {
                DealDetailRecord._DealDetailRecord.hashtable.remove(e.nextElement());
            }
            DealDetailRecord._DealDetailRecord.hashtable = null;
        }
    }

    public static void close() {
        if (_DealDetailRecord != null) {
            _DealDetailRecord._close();
        }
    }

    public static int addDealDetail(Long id, Object dealDetail) {
        if (_DealDetailRecord == null) {
            _DealDetailRecord = new DealDetailRecord();
        }
        return _DealDetailRecord._addDealDetail(id, dealDetail);
    }

    public static Deal getDealDetail(Long dealId) {
        if (_DealDetailRecord == null) {
            _DealDetailRecord = new DealDetailRecord();
        }
        return _DealDetailRecord._getDealDetail(dealId);
    }

    public static LotteryDeal getLotteryDealDetail(Long dealId) {
        if (_DealDetailRecord == null) {
            _DealDetailRecord = new DealDetailRecord();
        }
        return _DealDetailRecord._getLotteryDealDetail(dealId);
    }

    public static Voucher getVoucherDetail(Long voucherId) {
        if (_DealDetailRecord == null) {
            _DealDetailRecord = new DealDetailRecord();
        }
        return _DealDetailRecord._getVoucherDetail(voucherId);
    }

    private int _addDealDetail(Long iD, Object dealDetail) {
        int type;
        String key;
        boolean existed;
        this._deleteOld();
        if (dealDetail == null || iD == null || !(dealDetail instanceof Deal) && !(dealDetail instanceof LotteryDeal) && !(dealDetail instanceof Voucher)) {
            return -1;
        }
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        if (existed = this.hashtable.containsKey(key = String.valueOf(type = dealDetail instanceof LotteryDeal ? 0 : (dealDetail instanceof Deal ? 1 : 2)) + RMSRecord.spCatalog + iD)) {
            DealDetail exsitDealDetail = (DealDetail)this.hashtable.get(key);
            DealDetail newDealDetail = new DealDetail(exsitDealDetail.index, dealDetail);
            this.hashtable.put(key, newDealDetail);
            return this._setRecord(newDealDetail.index, String.valueOf(key) + RMSRecord.spChar + dealDetail);
        }
        int index = this._addRecord(String.valueOf(key) + RMSRecord.spChar + dealDetail);
        if (index > 0) {
            this.hashtable.put(key, new DealDetail(index, dealDetail));
        }
        return index;
    }

    private Deal _getDealDetail(Long dealId) {
        String key = String.valueOf(1) + RMSRecord.spCatalog + dealId;
        if (dealId == null || this.hashtable == null || !this.hashtable.containsKey(key)) {
            return null;
        }
        Object o = this.hashtable.get(key);
        if (o == null || !(o instanceof DealDetail)) {
            return null;
        }
        return (Deal)((DealDetail)o).dealDetail;
    }

    private LotteryDeal _getLotteryDealDetail(Long dealId) {
        String key = String.valueOf(0) + RMSRecord.spCatalog + dealId;
        if (dealId == null || this.hashtable == null || !this.hashtable.containsKey(key)) {
            return null;
        }
        Object o = this.hashtable.get(key);
        if (o == null || !(o instanceof DealDetail)) {
            return null;
        }
        return (LotteryDeal)((DealDetail)o).dealDetail;
    }

    private Voucher _getVoucherDetail(Long voucherId) {
        String key = String.valueOf(2) + RMSRecord.spCatalog + voucherId;
        if (voucherId == null || this.hashtable == null || !this.hashtable.containsKey(key)) {
            return null;
        }
        Object o = this.hashtable.get(key);
        if (o == null || !(o instanceof DealDetail)) {
            return null;
        }
        return (Voucher)((DealDetail)o).dealDetail;
    }

    private void _deleteOld() {
        try {
            this._open();
            int exsitCount = this.recordStore.getNumRecords();
            this._close();
            if (exsitCount >= 30) {
                this._clear();
                if (this.hashtable != null) {
                    Enumeration e = this.hashtable.keys();
                    while (e.hasMoreElements()) {
                        this.hashtable.remove(e.nextElement());
                    }
                    this.hashtable = null;
                }
            }
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    private class DealDetail {
        public int index = -1;
        public Object dealDetail = null;

        public DealDetail(int index, int type, String jsonString) {
            this.index = index;
            switch (type) {
                case 1: {
                    this.dealDetail = Deal.create(jsonString);
                    break;
                }
                case 0: {
                    this.dealDetail = LotteryDeal.create(jsonString);
                    break;
                }
                case 2: {
                    this.dealDetail = Voucher.create(jsonString);
                    break;
                }
            }
        }

        public DealDetail(int index, Object dealDetail) {
            this.index = index;
            this.dealDetail = dealDetail;
        }
    }
}

