/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.record;

import com.nuomi.clientinfo.LoginInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.data.AccountAll;
import com.nuomi.data.City;
import com.nuomi.data.FindCitys;
import com.nuomi.data.FindMyNuomiInfo;
import com.nuomi.data.GetAddresses;
import com.nuomi.data.GiftCards;
import com.nuomi.record.RMSRecord;
import com.nuomi.utils.Methods;
import javax.microedition.rms.RecordStoreException;

public class NuomiRecord
extends RMSRecord {
    private static NuomiRecord _NuomiRecord = null;
    private static final String RMSName = "NuomiRMS2";
    public static final int ID_LOGIN_INFO = 1;
    public static final int ID_CITY = 2;
    public static final int ID_FINDCITYS = 3;
    public static final int ID_AUTOLOADIMAGE = 4;
    public static final int ID_ADDRESSES = 5;
    public static final int ID_COUPON_NEARLY_EXPIRED = 6;
    public static final int ID_COUPON_NEW_BUY = 7;
    public static final int ID_COUPON_USED = 8;
    public static final int ID_POSTEDORDER = 9;
    public static final int ID_LOTTERY_UNENDED = 10;
    public static final int ID_LOTTERY_ENDED = 11;
    public static final int ID_USERINFO = 12;
    public static final int ID_LOOKED_DEALS_ID = 13;
    public static final int ID_UNPOSTORDER = 14;
    public static final int ID_ACCOUNT_ALL = 15;
    public static final int ID_GIFTCARD_UNUSED = 16;
    public static final int ID_GIFTCARD_USED = 17;
    public static final int ID_GIFTCARD_EXPIRED = 18;
    public static final int[] ALL_IDS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    private LoginInfo loginInfo = null;
    private City city = null;
    private FindCitys findCitys = null;
    private boolean autoLoadImage = true;
    private GetAddresses getAddresses = null;
    private FindMyNuomiInfo couponNearlyExpiredInfo = null;
    private FindMyNuomiInfo couponNewBuyInfo = null;
    private FindMyNuomiInfo couponUsedInfo = null;
    private FindMyNuomiInfo postedOrderInfo = null;
    private FindMyNuomiInfo unpostOrderInfo = null;
    private FindMyNuomiInfo lotteryUnendedInfo = null;
    private FindMyNuomiInfo lotteryEndedInfo = null;
    private UserInfo userInfo = null;
    private String lookedDeals = null;
    private AccountAll accountAll = null;
    private GiftCards unusedGiftCards = null;
    private GiftCards usedGiftCards = null;
    private GiftCards expiredGiftCards = null;

    public NuomiRecord() {
        this.recordStoreName = RMSName;
        try {
            this._open();
            int exsitCount = this.recordStore.getNumRecords();
            if (exsitCount < ALL_IDS.length) {
                this.createRecord(exsitCount);
            }
            this.loginInfo = this._getLoginInfo();
            this.city = this._getCity();
            this.findCitys = this._getFindCitys();
            this.autoLoadImage = this._getAutoLoadImage();
            this.getAddresses = this._getAddresses();
            this.couponNearlyExpiredInfo = this._getInfo(6, 0);
            this.couponNewBuyInfo = this._getInfo(7, 0);
            this.couponUsedInfo = this._getInfo(8, 0);
            this.unpostOrderInfo = this._getInfo(14, 1);
            this.postedOrderInfo = this._getInfo(9, 1);
            this.lotteryUnendedInfo = this._getInfo(10, 2);
            this.lotteryEndedInfo = this._getInfo(11, 2);
            this.userInfo = this._getUserInfo();
            this.lookedDeals = this._getLookedDeals();
            this.accountAll = this._getAccountAll();
            this.unusedGiftCards = this._getGiftCards(16);
            this.usedGiftCards = this._getGiftCards(17);
            this.expiredGiftCards = this._getGiftCards(18);
            this._close();
        }
        catch (RecordStoreException e) {
            this.recordStore = null;
            e.printStackTrace();
        }
    }

    public static void init() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
    }

    public static void clear() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        _NuomiRecord._setRecord(3, null);
        NuomiRecord._NuomiRecord.findCitys = null;
        _NuomiRecord._setRecord(5, null);
        NuomiRecord._NuomiRecord.getAddresses = null;
        _NuomiRecord._setRecord(6, null);
        NuomiRecord._NuomiRecord.couponNearlyExpiredInfo = null;
        _NuomiRecord._setRecord(7, null);
        NuomiRecord._NuomiRecord.couponNewBuyInfo = null;
        _NuomiRecord._setRecord(8, null);
        NuomiRecord._NuomiRecord.couponUsedInfo = null;
        _NuomiRecord._setRecord(14, null);
        NuomiRecord._NuomiRecord.unpostOrderInfo = null;
        _NuomiRecord._setRecord(9, null);
        NuomiRecord._NuomiRecord.postedOrderInfo = null;
        _NuomiRecord._setRecord(10, null);
        NuomiRecord._NuomiRecord.lotteryUnendedInfo = null;
        _NuomiRecord._setRecord(11, null);
        NuomiRecord._NuomiRecord.lotteryEndedInfo = null;
        _NuomiRecord._setRecord(15, null);
        NuomiRecord._NuomiRecord.accountAll = null;
        _NuomiRecord._setRecord(16, null);
        NuomiRecord._NuomiRecord.unusedGiftCards = null;
        _NuomiRecord._setRecord(17, null);
        NuomiRecord._NuomiRecord.usedGiftCards = null;
        _NuomiRecord._setRecord(18, null);
        NuomiRecord._NuomiRecord.expiredGiftCards = null;
    }

    public static void close() {
        if (_NuomiRecord != null) {
            _NuomiRecord._close();
        }
    }

    public static LoginInfo getLoginInfo() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.loginInfo;
    }

    public static int saveLoginInfo(LoginInfo loginInfo) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveLoginInfo(loginInfo);
    }

    public static City getCity() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.city;
    }

    public static int saveCity(City city) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveCity(city);
    }

    public static FindCitys getFindCitys() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.findCitys;
    }

    public static int saveFindCitys(FindCitys findCitys) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveFindCitys(findCitys);
    }

    public static boolean getAutoLoadImage() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.autoLoadImage;
    }

    public static int saveAutoLoadImage(boolean autoLoadImage) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveAutoLoadImage(autoLoadImage);
    }

    public static GetAddresses getAddresses() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.getAddresses;
    }

    public static int saveAddresses(GetAddresses getAddresses) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveAddresses(getAddresses);
    }

    public static FindMyNuomiInfo getInfo(int id) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        switch (id) {
            case 6: {
                return NuomiRecord._NuomiRecord.couponNearlyExpiredInfo;
            }
            case 7: {
                return NuomiRecord._NuomiRecord.couponNewBuyInfo;
            }
            case 8: {
                return NuomiRecord._NuomiRecord.couponUsedInfo;
            }
            case 14: {
                return NuomiRecord._NuomiRecord.unpostOrderInfo;
            }
            case 9: {
                return NuomiRecord._NuomiRecord.postedOrderInfo;
            }
            case 10: {
                return NuomiRecord._NuomiRecord.lotteryUnendedInfo;
            }
            case 11: {
                return NuomiRecord._NuomiRecord.lotteryEndedInfo;
            }
        }
        return null;
    }

    public static int saveInfo(int id, FindMyNuomiInfo info) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveInfo(id, info);
    }

    public static UserInfo getUserInfo() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.userInfo;
    }

    public static int saveUserInfo(UserInfo info) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveUserInfo(info);
    }

    public static String getLookedDeals() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.lookedDeals;
    }

    public static int saveLookedDeals(String lookedDeals) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveLookedDeals(lookedDeals);
    }

    public static AccountAll getAccountAll() {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return NuomiRecord._NuomiRecord.accountAll;
    }

    public static int saveAccountAll(AccountAll accountAll) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveAccountAll(accountAll);
    }

    public static GiftCards getGiftCards(int id) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        switch (id) {
            case 16: {
                return NuomiRecord._NuomiRecord.unusedGiftCards;
            }
            case 17: {
                return NuomiRecord._NuomiRecord.usedGiftCards;
            }
            case 18: {
                return NuomiRecord._NuomiRecord.expiredGiftCards;
            }
        }
        return null;
    }

    public static int saveGiftcards(int id, GiftCards giftCards) {
        if (_NuomiRecord == null) {
            _NuomiRecord = new NuomiRecord();
        }
        return _NuomiRecord._saveGiftcards(id, giftCards);
    }

    private LoginInfo _getLoginInfo() {
        String string = this._getRecord(1);
        if (Methods.isNullOrEmpty(string)) {
            return null;
        }
        return LoginInfo.create(string);
    }

    private int _saveLoginInfo(LoginInfo loginInfo) {
        this.loginInfo = loginInfo;
        return this._setRecord(1, loginInfo);
    }

    private City _getCity() {
        String string = this._getRecord(2);
        if (Methods.isNullOrEmpty(string)) {
            return null;
        }
        return City.create(string);
    }

    private int _saveCity(City city) {
        this.city = city;
        return this._setRecord(2, city);
    }

    private FindCitys _getFindCitys() {
        String string = this._getRecord(3);
        if (Methods.isNullOrEmpty(string)) {
            return null;
        }
        return FindCitys.create(string);
    }

    private int _saveFindCitys(FindCitys findCitys) {
        this.findCitys = findCitys;
        return this._setRecord(3, findCitys);
    }

    private boolean _getAutoLoadImage() {
        String string = this._getRecord(4);
        return !"0".equals(string);
    }

    private int _saveAutoLoadImage(boolean autoLoadImage) {
        this.autoLoadImage = autoLoadImage;
        return this._setRecord(4, autoLoadImage ? "1" : "0");
    }

    private GetAddresses _getAddresses() {
        String string = this._getRecord(5);
        if (Methods.isNullOrEmpty(string)) {
            return null;
        }
        return GetAddresses.create(string);
    }

    private int _saveAddresses(GetAddresses getAddresses) {
        this.getAddresses = getAddresses;
        return this._setRecord(5, getAddresses);
    }

    private FindMyNuomiInfo _getInfo(int id, int infoType) {
        String string = this._getRecord(id);
        if (Methods.isNullOrEmpty(string)) {
            return null;
        }
        return FindMyNuomiInfo.create(string, infoType);
    }

    private int _saveInfo(int id, FindMyNuomiInfo info) {
        switch (id) {
            case 6: {
                this.couponNearlyExpiredInfo = info;
                break;
            }
            case 7: {
                this.couponNewBuyInfo = info;
                break;
            }
            case 8: {
                this.couponUsedInfo = info;
                break;
            }
            case 14: {
                this.unpostOrderInfo = info;
                break;
            }
            case 9: {
                this.postedOrderInfo = info;
                break;
            }
            case 10: {
                this.lotteryUnendedInfo = info;
                break;
            }
            case 11: {
                this.lotteryEndedInfo = info;
                break;
            }
        }
        return this._setRecord(id, info);
    }

    private UserInfo _getUserInfo() {
        String string = this._getRecord(12);
        return UserInfo.create(string);
    }

    private int _saveUserInfo(UserInfo info) {
        this.userInfo = info;
        return this._setRecord(12, info);
    }

    private String _getLookedDeals() {
        String lookedDeals = this._getRecord(13);
        if (lookedDeals == null || lookedDeals.length() <= 0) {
            return null;
        }
        return lookedDeals;
    }

    private int _saveLookedDeals(String lookedDeals) {
        this.lookedDeals = lookedDeals;
        return this._setRecord(13, lookedDeals);
    }

    private AccountAll _getAccountAll() {
        String accountAllString = this._getRecord(15);
        return AccountAll.create(accountAllString);
    }

    private int _saveAccountAll(AccountAll accountAll) {
        this.accountAll = accountAll;
        return this._setRecord(15, accountAll);
    }

    private GiftCards _getGiftCards(int id) {
        String giftcardsString = this._getRecord(id);
        return GiftCards.create(giftcardsString);
    }

    private int _saveGiftcards(int id, GiftCards giftCards) {
        switch (id) {
            case 16: {
                this.unusedGiftCards = giftCards;
                break;
            }
            case 17: {
                this.usedGiftCards = giftCards;
                break;
            }
            case 18: {
                this.expiredGiftCards = giftCards;
                break;
            }
        }
        return this._setRecord(id, giftCards);
    }

    private void createRecord(int exsitCount) throws RecordStoreException {
        if (this.recordStore != null) {
            int count = ALL_IDS.length;
            int i = exsitCount;
            while (i < count) {
                this._addRecord(null);
                ++i;
            }
        }
    }
}

