/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.dialogs.BaseDialog;
import com.nuomi.dialogs.CatalogMoreDialog;
import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.usercontrol.Button;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class CatalogSelectorControl
extends Container {
    private CatalogSelectorControl self = this;
    private int labelWidth;
    private int shownCount = 1;
    private Button[] shownButtons = null;
    private Label focusImageLabel = null;
    private String[] catalogNames = null;
    private boolean needShowMore = false;
    private Vector allListener = null;
    private int _index = -1;

    public CatalogSelectorControl(String[] catalogNames, int shownCount, Image bgImage, Image focusImage) {
        this.shownCount = shownCount;
        this.catalogNames = catalogNames;
        this.needShowMore = shownCount < catalogNames.length;
        int width = bgImage.getWidth();
        int height = bgImage.getHeight();
        this.self.setPreferredW(width);
        this.self.setPreferredH(height);
        this.self.setLayout(new CoordinateLayout(width, height));
        this.self.getStyle().setBgImage(bgImage);
        this.labelWidth = width / shownCount;
        int labelsCount = Math.min(shownCount, catalogNames.length);
        this.shownButtons = new Button[labelsCount];
        int i = 0;
        while (i < labelsCount) {
            this.shownButtons[i] = UserInterface.createEmptyButton(UserInterface.FONT_STATIC_WORD);
            this.shownButtons[i].setText(catalogNames[i]);
            this.self.addComponent(this.shownButtons[i]);
            if (i == shownCount - 1 && this.needShowMore) {
                this.shownButtons[i].setIcon(UserImages.NUOMI_DOWN_CLICK_DEEP_IMAGE);
                this.shownButtons[i].setTextPosition(1);
            }
            this.shownButtons[i].setPreferredW(this.labelWidth);
            this.shownButtons[i].setPreferredH(height);
            this.shownButtons[i].setX(i * this.labelWidth);
            this.shownButtons[i].setY(0);
            this.shownButtons[i].tag = new Integer(i);
            this.shownButtons[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Button button = (Button)evt.getSource();
                    Integer integer = (Integer)button.tag;
                    CatalogSelectorControl.this.clickedButton(integer);
                }
            });
            ++i;
        }
        this.focusImageLabel = new Label();
        this.self.addComponent(this.focusImageLabel);
        this.focusImageLabel.setPreferredW(this.labelWidth);
        this.focusImageLabel.setPreferredH(height);
        this.focusImageLabel.getStyle().setBgImage(focusImage);
        this.focusImageLabel.getStyle().setBgTransparency(128);
        this.focusImageLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.focusImageLabel.getStyle().setAlignment(4);
        this.focusImageLabel.setTextPosition(1);
        this.focusImageLabel.setY(0);
        this.focusImageLabel.setX(-this.labelWidth);
    }

    public CatalogSelectorControl(String[] catalogNames, int shownCount) {
        this(catalogNames, shownCount, UserImages.CATALOG_SELECTOR_BG_IMAGE, UserImages.CATALOG_SELECTOR_FOCUS_IMAGE);
    }

    private void clickedButton(int index) {
        if (this.needShowMore && index == this.shownCount - 1) {
            this.showMoreDialog();
        } else {
            this.setSelectedIndex(index);
        }
    }

    public int getSelectedIndex() {
        return this._index;
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public void setSelectedIndex(int index, boolean sendListener) {
        if (index < this.catalogNames.length && index >= 0 && index != this._index) {
            this._index = index;
            this.setFocusIndex(index);
            if (sendListener) {
                this.sendListener(index);
            }
        }
    }

    private void showMoreDialog() {
        if (!BaseDialog.isShown) {
            int selectedIndex;
            String[] moreStrings = this.makeMoreStrings();
            Form form = this.self.getComponentForm();
            int titleHeight = 0;
            if (form != null && form.getTitleArea() != null) {
                titleHeight = form.getTitleArea().getPreferredH();
            }
            Container parentContainer = this.self.getParent();
            int scrollY = 0;
            if (parentContainer != null) {
                scrollY = parentContainer.getAbsoluteY() - titleHeight;
            }
            if ((selectedIndex = CatalogMoreDialog.getSelectIndex(moreStrings, this.self.getY() + titleHeight + this.self.getPreferredH() + scrollY)) != -1) {
                int index = selectedIndex + this.shownCount - 1;
                this.setSelectedIndex(index);
            }
        }
    }

    private String[] makeMoreStrings() {
        int moreCount = this.catalogNames.length - (this.shownCount - 1);
        String[] moreString = new String[moreCount];
        int startIndex = this.shownCount - 1;
        int i = 0;
        while (i < moreCount) {
            moreString[i] = this.catalogNames[i + startIndex];
            ++i;
        }
        return moreString;
    }

    private void setFocusIndex(int index) {
        if (index >= 0 && index < this.catalogNames.length) {
            this.setMoreShownIndex(index);
            index = Math.min(Math.max(0, index), this.shownCount - 1);
            this.focusImageLabel.setX(index * this.labelWidth);
            this.repaint();
        }
    }

    public void setMoreShownIndex(int index) {
        this.focusImageLabel.setText(this.catalogNames[index]);
        if (index >= this.shownCount - 1 && index < this.catalogNames.length) {
            this.shownButtons[this.shownCount - 1].setText(this.catalogNames[index]);
            this.focusImageLabel.setIcon(UserImages.NUOMI_DOWN_CLICK_DEEP_IMAGE);
        } else {
            this.focusImageLabel.setIcon(null);
        }
    }

    public void addChangedListener(SelectionChangedListener listener) {
        if (this.allListener == null) {
            this.allListener = new Vector();
        }
        this.allListener.addElement(listener);
    }

    public void sendListener(int index) {
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object listener = this.allListener.elementAt(i);
                if (listener instanceof SelectionChangedListener) {
                    ((SelectionChangedListener)listener).onChanged(index);
                }
                ++i;
            }
        }
    }

    public void repaint() {
        Form form = this.self.getComponentForm();
        if (form != null) {
            form.repaint();
        }
    }
}

