/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.CoordinateLayout;

public class ContentContainer
extends Container {
    private ContentContainer self = this;
    private Container centerContainer = null;
    private Container bottomContainer = null;
    private int bottomMargin = 0;

    public ContentContainer(Component content, Image bottomImage, int topMargin, int bottomMargin) {
        this.self.bottomMargin = bottomMargin;
        int topHeight = Math.max(topMargin, UserImages.USERCONTAINER_TOP_IMAGE.getHeight());
        int bottomHeight = Math.max(bottomMargin, bottomImage.getHeight());
        int width = UserInterface.DISPLAY_WIDTH;
        int height = topHeight + (content == null ? 0 : content.getPreferredH()) + bottomHeight;
        this.self.setLayout(new CoordinateLayout(width, height));
        this.self.setPreferredW(width);
        this.self.setPreferredH(height);
        Container topContainer = new Container();
        this.self.addComponent(topContainer);
        topContainer.setPreferredW(UserImages.USERCONTAINER_TOP_IMAGE.getWidth());
        topContainer.setPreferredH(UserImages.USERCONTAINER_TOP_IMAGE.getHeight());
        topContainer.getStyle().setBgImage(UserImages.USERCONTAINER_TOP_IMAGE);
        topContainer.setX((width - topContainer.getPreferredW()) / 2);
        topContainer.setY(0);
        this.bottomContainer = new Container();
        this.self.addComponent(this.bottomContainer);
        this.bottomContainer.setPreferredW(bottomImage.getWidth());
        this.bottomContainer.setPreferredH(bottomImage.getHeight());
        this.bottomContainer.getStyle().setBgImage(bottomImage);
        this.bottomContainer.setX((width - this.bottomContainer.getPreferredW()) / 2);
        this.bottomContainer.setY(height - this.bottomContainer.getPreferredH());
        if (content != null) {
            this.centerContainer = new Container(new CoordinateLayout(UserImages.USERCONTAINER_CENTER_IMAGE.getWidth(), content.getPreferredH()));
            this.self.addComponent(this.centerContainer);
            this.centerContainer.setPreferredW(UserImages.USERCONTAINER_CENTER_IMAGE.getWidth());
            this.centerContainer.setPreferredH(height - topContainer.getPreferredH() - this.bottomContainer.getPreferredH());
            this.centerContainer.setX((width - this.centerContainer.getPreferredW()) / 2);
            this.centerContainer.setY(topContainer.getPreferredH());
            this.centerContainer.getStyle().setBgImage(UserImages.USERCONTAINER_CENTER_IMAGE);
            this.centerContainer.addComponent(content);
            content.setX((this.centerContainer.getPreferredW() - content.getPreferredW()) / 2);
            content.setY(Math.max(0, topHeight - topContainer.getPreferredH()));
        }
    }

    public ContentContainer(Component content, int topMargin, int bottomMargin) {
        this(content, UserImages.USERCONTAINER_BOTTOM_IMAGE, topMargin, bottomMargin);
    }

    public ContentContainer(String title, Component content) {
        int topHeight = UserImages.USERCONTAINER_TITLE_IMAGE.getHeight();
        int bottomHeight = UserImages.USERCONTAINER_BOTTOM_IMAGE.getHeight();
        int width = UserInterface.DISPLAY_WIDTH;
        int height = topHeight + (content == null ? 0 : content.getPreferredH() + 5) + bottomHeight;
        this.self.setLayout(new CoordinateLayout(width, height));
        this.self.setPreferredW(width);
        this.self.setPreferredH(height);
        Container topContainer = new Container();
        this.self.addComponent(topContainer);
        topContainer.setPreferredW(UserImages.USERCONTAINER_TITLE_IMAGE.getWidth());
        topContainer.setPreferredH(UserImages.USERCONTAINER_TITLE_IMAGE.getHeight());
        topContainer.getStyle().setBgImage(UserImages.USERCONTAINER_TITLE_IMAGE);
        topContainer.setX((width - topContainer.getPreferredW()) / 2);
        topContainer.setY(0);
        topContainer.setLayout(new CoordinateLayout(topContainer.getPreferredW(), topContainer.getPreferredH()));
        if (title != null) {
            Label titleLabel = new Label(title);
            topContainer.addComponent(titleLabel);
            titleLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
            titleLabel.setX(10);
            titleLabel.setY((topHeight - titleLabel.getPreferredH()) / 2);
        }
        this.bottomContainer = new Container();
        this.self.addComponent(this.bottomContainer);
        this.bottomContainer.setPreferredW(UserImages.USERCONTAINER_BOTTOM_IMAGE.getWidth());
        this.bottomContainer.setPreferredH(UserImages.USERCONTAINER_BOTTOM_IMAGE.getHeight());
        this.bottomContainer.getStyle().setBgImage(UserImages.USERCONTAINER_BOTTOM_IMAGE);
        this.bottomContainer.setX((width - this.bottomContainer.getPreferredW()) / 2);
        this.bottomContainer.setY(height - this.bottomContainer.getPreferredH());
        if (content != null) {
            this.centerContainer = new Container(new CoordinateLayout(UserImages.USERCONTAINER_CENTER_IMAGE.getWidth(), content.getPreferredH()));
            this.self.addComponent(this.centerContainer);
            this.centerContainer.setPreferredW(UserImages.USERCONTAINER_CENTER_IMAGE.getWidth());
            this.centerContainer.setPreferredH(height - topContainer.getPreferredH() - this.bottomContainer.getPreferredH());
            this.centerContainer.setX((width - this.centerContainer.getPreferredW()) / 2);
            this.centerContainer.setY(topContainer.getPreferredH());
            this.centerContainer.getStyle().setBgImage(UserImages.USERCONTAINER_CENTER_IMAGE);
            this.centerContainer.addComponent(content);
            content.setX((this.centerContainer.getPreferredW() - content.getPreferredW()) / 2);
            content.setY(5);
        }
        this.self.getStyle().setMargin(0, 5);
    }

    public ContentContainer(String title, String content) {
        this(title, new LabelGroup(Methods.splitString(Methods.replaceHtmlStrs(content), UserInterface.FONT_NORMAL, 0, 335, "\r\n"), UserInterface.FONT_NORMAL, 6453130, 340, 30));
        this.self.getStyle().setMargin(0, 5);
    }

    public void setCenterHeight(int height) {
        Form form;
        if (this.centerContainer != null) {
            int h = this.self.getPreferredH() + ((height += this.bottomMargin) - this.centerContainer.getPreferredH());
            this.self.setPreferredH(h);
            this.self.setLayout(new CoordinateLayout(this.self.getPreferredW(), h));
            this.centerContainer.setPreferredH(height);
            this.centerContainer.setLayout(new CoordinateLayout(UserImages.USERCONTAINER_CENTER_IMAGE.getWidth(), height));
            this.bottomContainer.setY(h - this.bottomContainer.getPreferredH());
        }
        if ((form = this.getComponentForm()) != null) {
            form.repaint();
        }
    }
}

