/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class DetailTitleContainer
extends Container {
    private Button clickButton = null;

    public DetailTitleContainer(String title, String content, int contentColor, String hint, boolean canClick, String clickHint) {
        int width = UserImages.NUOMI_DETAIL_TITLE_BG_IMAGE.getWidth();
        int height = UserImages.NUOMI_DETAIL_TITLE_BG_IMAGE.getHeight();
        this.setLayout(new CoordinateLayout(width, height));
        this.getStyle().setBgImage(UserImages.NUOMI_DETAIL_TITLE_BG_IMAGE);
        this.setPreferredW(width);
        this.setPreferredH(height);
        if (canClick) {
            this.clickButton = UserInterface.createEmptyButton();
            this.addComponent(this.clickButton);
            this.clickButton.setPreferredW(width);
            this.clickButton.setPreferredH(height);
            this.clickButton.setX(0);
            this.clickButton.setY(0);
        }
        String[] titleStrings = new String[3];
        int i = 0;
        while (i < titleStrings.length) {
            titleStrings[i] = title.length() - 1 < i ? "" : title.substring(i, i + 1);
            ++i;
        }
        LabelGroup titleGroup = new LabelGroup(titleStrings, UserInterface.FONT_MESSAGEBOX, 6059405, 25);
        this.addComponent(titleGroup);
        titleGroup.setX((44 - titleGroup.getPreferredW()) / 2);
        titleGroup.setY((height - titleGroup.getPreferredH()) / 2);
        int contentMaxRow = 3;
        Font contentFont = UserInterface.FONT_NORMAL;
        int hintHeight = 0;
        if (!Methods.isNullOrEmpty(hint)) {
            Label hintLabel = new Label("(" + hint + ")");
            this.addComponent(hintLabel);
            hintLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
            hintLabel.getStyle().setFgColor(9084854);
            hintLabel.setX(44 + (width - 44 - hintLabel.getPreferredW()) / 2);
            hintLabel.setY(height - hintLabel.getPreferredH());
            hintHeight = hintLabel.getPreferredH();
            contentMaxRow = 2;
        }
        int contentWidth = width - 44 - 10;
        String showContent = canClick ? clickHint : content;
        Vector contentVector = Methods.splitString(showContent, contentFont, 0, contentWidth, "\r\n");
        String[] contentString = new String[Math.min(contentMaxRow, contentVector.size())];
        int i2 = 0;
        while (i2 < contentString.length) {
            contentString[i2] = (String)contentVector.elementAt(i2);
            if (i2 == contentMaxRow - 1 && contentVector.size() > contentMaxRow) {
                contentString[i2] = String.valueOf(contentString[i2].substring(0, contentString[i2].length() - 1)) + "...";
            }
            ++i2;
        }
        int labelHeight = 0;
        labelHeight = UserInterface.FONT_LARGE.equals(contentFont) ? 40 : 25;
        LabelGroup contentGroup = new LabelGroup(contentString, contentFont, contentColor, labelHeight);
        this.addComponent(contentGroup);
        contentGroup.setX(44 + (width - 44 - contentGroup.getPreferredW()) / 2);
        contentGroup.setY((height - hintHeight - contentGroup.getPreferredH()) / 2);
    }

    public void addActionListener(ActionListener l) {
        if (this.clickButton != null) {
            this.clickButton.addActionListener(l);
        }
    }

    public void clearActionListener() {
        if (this.clickButton != null && this.clickButton.getListenerVector() != null) {
            this.clickButton.getListenerVector().removeAllElements();
        }
    }
}

