/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.Main;
import com.nuomi.connect.ImageCache;
import com.nuomi.connect.ImageHelper;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;

public class ImageControl
extends Container {
    private ImageControl self = this;
    private Label imageLabel = null;
    private int _transparency = 255;
    private String _url = null;
    private Image _image = null;
    private Image _defaultImage = null;
    private Button clickButton = null;
    private com.nuomi.utils.Thread downloadThread = null;

    public ImageControl(int width, int height) {
        this._transparency = 255;
        this._defaultImage = UserImages.NUOMI_DEFAULT_IMAGE;
        this.self.setPreferredW(width);
        this.self.setPreferredH(height);
        this.self.setLayout(new CoordinateLayout(width, height));
        this.self.getStyle().setBgImage(this._defaultImage.modifyAlpha((byte)this._transparency));
        this.imageLabel = new Label();
        this.self.addComponent(this.imageLabel);
        this.imageLabel.setX(0);
        this.imageLabel.setY(0);
        this.imageLabel.setPreferredW(width);
        this.imageLabel.setPreferredH(height);
        this.imageLabel.setVisible(false);
    }

    public ImageControl(int width, int height, Image defaultImage) {
        this._transparency = 255;
        this._defaultImage = defaultImage;
        this.self.setPreferredW(width);
        this.self.setPreferredH(height);
        this.self.setLayout(new CoordinateLayout(width, height));
        if (this._defaultImage != null) {
            this.self.getStyle().setBgImage(this._defaultImage.modifyAlpha((byte)this._transparency));
        }
        this.imageLabel = new Label();
        this.self.addComponent(this.imageLabel);
        this.imageLabel.setX(0);
        this.imageLabel.setY(0);
        this.imageLabel.setPreferredW(width);
        this.imageLabel.setPreferredH(height);
        this.imageLabel.setVisible(false);
    }

    public ImageControl(int width, int height, int transparency) {
        this._transparency = transparency;
        this._defaultImage = UserImages.NUOMI_DEFAULT_IMAGE;
        this.self.setPreferredW(width);
        this.self.setPreferredH(height);
        this.self.setLayout(new CoordinateLayout(width, height));
        this.self.getStyle().setBgImage(this._defaultImage.modifyAlpha((byte)this._transparency));
        this.imageLabel = new Label();
        this.self.addComponent(this.imageLabel);
        this.imageLabel.setX(0);
        this.imageLabel.setY(0);
        this.imageLabel.setPreferredW(width);
        this.imageLabel.setPreferredH(height);
        this.imageLabel.setVisible(false);
    }

    public void setTransparency(int transparency) {
        if (this._defaultImage != null) {
            this.self.getStyle().setBgImage(this._defaultImage.modifyAlpha((byte)this._transparency));
        }
        if (this._image != null) {
            this.imageLabel.getStyle().setBgImage(this._image.modifyAlpha((byte)this._transparency));
        }
        this.repaint();
    }

    public void setImage(String url, boolean downloadNow) {
        this._url = url;
        this._image = null;
        if (Methods.isNullOrEmpty(url)) {
            this.imageLabel.setVisible(false);
            this.repaint();
            return;
        }
        Image image = null;
        image = ImageCache.getImage(url);
        if (image != null) {
            this.setImage(image);
        } else {
            this.imageLabel.setVisible(false);
            if (downloadNow && Main.clientInfo.getAutoLoadImage()) {
                this.DownloadImage();
            } else {
                if (this.clickButton == null) {
                    this.clickButton = UserInterface.createEmptyButton();
                    this.self.addComponent(0, (Component)this.clickButton);
                    this.clickButton.setX(0);
                    this.clickButton.setY(0);
                    this.clickButton.setPreferredW(this.self.getPreferredW());
                    this.clickButton.setPreferredH(this.self.getPreferredH());
                    this.clickButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            ImageControl.this.clickButton.setEnabled(false);
                            ImageControl.this.DownloadImage();
                        }
                    });
                }
                this.clickButton.setEnabled(true);
            }
        }
    }

    public Image getImage() {
        return this._image;
    }

    public String getUrl() {
        return this._url;
    }

    public void setImage(Image image) {
        if (this.clickButton != null) {
            this.clickButton.setEnabled(false);
        }
        this._image = image;
        if (image == null) {
            this.imageLabel.setVisible(false);
        } else {
            this.imageLabel.getStyle().setBgImage(image.modifyAlpha((byte)this._transparency));
            this.imageLabel.setVisible(true);
        }
        this.repaint();
    }

    public void setSize(int width, int height) {
        this.self.setPreferredW(width);
        this.self.setPreferredH(height);
        this.self.setLayout(new CoordinateLayout(width, height));
        this.imageLabel.setPreferredW(width);
        this.imageLabel.setPreferredH(height);
        this.repaint();
    }

    public void repaint() {
        Form form = this.self.getComponentForm();
        if (form != null) {
            form.repaint();
        }
    }

    public void stop() {
        if (this.downloadThread != null) {
            this.downloadThread.interrupt();
            this.downloadThread = null;
        }
    }

    public void DownloadImage() {
        if (this.downloadThread != null) {
            this.downloadThread.interrupt();
            this.downloadThread = null;
        }
        this.downloadThread = new com.nuomi.utils.Thread(){
            boolean stoped = false;

            public void interrupt() {
                this.stoped = true;
            }

            public void run() {
                try {
                    int tryTimes = 0;
                    while (true) {
                        Image networkImage;
                        if ((networkImage = ImageHelper.getNetWorkImage(ImageControl.this._url, true)) != null) {
                            if (!this.stoped) {
                                ImageControl.this.self.setImage(networkImage);
                                Form form = ImageControl.this.self.getComponentForm();
                                if (form != null) {
                                    form.repaint();
                                }
                            }
                        } else if (++tryTimes <= 2 && !this.stoped) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.downloadThread.start();
    }

    public Container getContainerParent() {
        for (Container parentContainer = this.getParent(); parentContainer != null; parentContainer = parentContainer.getParent()) {
            if (parentContainer.getParent() != null) {
                continue;
            }
            return parentContainer;
        }
        return null;
    }

    public boolean needShowImage() {
        Container parentContainer = this.getContainerParent();
        return parentContainer != null && !(parentContainer instanceof ListBoxItem);
    }
}

