/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.usercontrol.Button;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;
import java.util.Vector;

public class ItemButton
extends Container {
    protected ItemButton self = null;
    public static final int TYPE_TOP = 0;
    public static final int TYPE_CENTER = 1;
    public static final int TYPE_BOTTOM = 2;
    public static final int TYPE_WHOLE = 3;
    private int width = UserInterface.DISPLAY_WIDTH;
    private int height = 50;
    private int buttonWidth = 350;
    private final int margin;
    private Button clickButton = null;
    private Label textLabel = null;
    private Label hintLabel = null;
    private Label valueLabel = null;
    private Vector allListener = null;

    public ItemButton(int type, String text, Image icon, boolean withNavigationIcon, String textHint, Font hintFont, String value) {
        this(type, UserInterface.FONT_STATIC_WORD, text, icon, withNavigationIcon, textHint, hintFont, value);
    }

    public ItemButton(int type, Font textFont, String text, Image icon, boolean withNavigationIcon, String textHint, Font hintFont, String value) {
        this.margin = 10;
        this.self = this;
        Image bgImage = null;
        Image bgPressedImage = null;
        if (type >= 0 && type <= 3) {
            bgImage = UserImages.ITEMBUTTON_BG_IMAGES[type];
            bgPressedImage = UserImages.ITEMBUTTON_PRESSED_BG_IMAGES[type];
            this.buttonWidth = bgImage.getWidth();
            this.height = bgImage.getHeight();
        }
        this.self.setLayout(new CoordinateLayout(this.width, this.height));
        this.self.setPreferredW(this.width);
        this.self.setPreferredH(this.height);
        this.self.getDisabledStyle().setBgTransparency(0);
        this.clickButton = new Button();
        this.self.addComponent(this.clickButton);
        Style[] styles = UserInterface.getComponentStyles(this.clickButton);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setBgImage(i == 4 ? bgPressedImage : bgImage);
            ++i;
        }
        this.clickButton.setPreferredW(this.buttonWidth);
        this.clickButton.setPreferredH(this.height);
        this.clickButton.setX((this.width - this.buttonWidth) / 2);
        this.clickButton.setY(0);
        this.clickButton.tag = this.self;
        this.clickButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ItemButton.this.sendListener();
            }
        });
        this.textLabel = new Label();
        this.self.addComponent(this.textLabel);
        if (text != null) {
            this.textLabel.setText(text);
        }
        if (icon != null) {
            this.textLabel.setIcon(icon);
        }
        this.textLabel.getStyle().setFont(textFont);
        this.textLabel.getStyle().setFgColor(6059405);
        this.textLabel.getDisabledStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.textLabel.getDisabledStyle().setFgColor(6059405);
        this.textLabel.getDisabledStyle().setBgTransparency(0);
        this.textLabel.setX(this.clickButton.getX() + 10);
        this.textLabel.setY((this.height - this.textLabel.getPreferredH()) / 2);
        this.textLabel.setGap(3);
        if (withNavigationIcon) {
            Label naviLabel = new Label();
            this.self.addComponent(naviLabel);
            naviLabel.setPreferredW(UserImages.ITEMBUTTON_NAVIGATION_ICON_IMAGE.getWidth());
            naviLabel.setPreferredH(UserImages.ITEMBUTTON_NAVIGATION_ICON_IMAGE.getHeight());
            naviLabel.getStyle().setBgImage(UserImages.ITEMBUTTON_NAVIGATION_ICON_IMAGE);
            naviLabel.getDisabledStyle().setBgImage(UserImages.ITEMBUTTON_NAVIGATION_ICON_IMAGE);
            naviLabel.setX(this.clickButton.getX() + this.buttonWidth - naviLabel.getPreferredW() - 10);
            naviLabel.setY((this.height - naviLabel.getPreferredH()) / 2);
        }
        if (textHint != null) {
            this.hintLabel = new Label(textHint);
            this.self.addComponent(this.hintLabel);
            this.hintLabel.getStyle().setFont(hintFont);
            this.hintLabel.getStyle().setFgColor(15492920);
            this.hintLabel.getDisabledStyle().setFont(hintFont);
            this.hintLabel.getDisabledStyle().setFgColor(15492920);
            this.hintLabel.getDisabledStyle().setBgTransparency(0);
            this.hintLabel.setX(this.textLabel.getX() + this.textLabel.getPreferredW() + 10);
            this.hintLabel.setY((this.height - this.hintLabel.getPreferredH()) / 2);
        }
        if (value != null) {
            this.valueLabel = new Label(value);
            this.self.addComponent(this.valueLabel);
            this.valueLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
            this.valueLabel.getStyle().setFgColor(6059405);
            this.valueLabel.getDisabledStyle().setFont(UserInterface.FONT_STATIC_WORD);
            this.valueLabel.getDisabledStyle().setFgColor(6059405);
            this.valueLabel.getDisabledStyle().setBgTransparency(0);
            this.valueLabel.setX(this.clickButton.getX() + this.buttonWidth - UserImages.ITEMBUTTON_NAVIGATION_ICON_IMAGE.getWidth() - 20 - this.valueLabel.getPreferredW());
            this.valueLabel.setY((this.height - this.valueLabel.getPreferredH()) / 2);
        }
    }

    public ItemButton(int type, String text, Image icon, boolean withNavigationIcon, String textHint, String value) {
        this(type, text, icon, withNavigationIcon, textHint, UserInterface.FONT_STATIC_WORD, value);
    }

    public ItemButton(int type, String text, Image icon, boolean withNavigationIcon, String textHint) {
        this(type, text, icon, withNavigationIcon, textHint, null);
    }

    public ItemButton(int type, String text, Image icon, boolean withNavigationIcon) {
        this(type, text, icon, withNavigationIcon, null);
    }

    public ItemButton(int type, String text, Image icon, int align) {
        this.margin = 10;
        this.self = this;
        Image bgImage = null;
        Image bgPressedImage = null;
        if (type >= 0 && type <= 3) {
            bgImage = UserImages.ITEMBUTTON_BG_IMAGES[type];
            bgPressedImage = UserImages.ITEMBUTTON_PRESSED_BG_IMAGES[type];
            this.buttonWidth = bgImage.getWidth();
            this.height = bgImage.getHeight();
        }
        this.self.setLayout(new CoordinateLayout(this.width, this.height));
        this.self.setPreferredW(this.width);
        this.self.setPreferredH(this.height);
        this.self.getDisabledStyle().setBgTransparency(0);
        this.clickButton = new Button();
        this.self.addComponent(this.clickButton);
        Style[] styles = UserInterface.getComponentStyles(this.clickButton);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setBgImage(i == 4 ? bgPressedImage : bgImage);
            ++i;
        }
        this.clickButton.setPreferredW(this.buttonWidth);
        this.clickButton.setPreferredH(this.height);
        this.clickButton.setX((this.width - this.buttonWidth) / 2);
        this.clickButton.setY(0);
        this.clickButton.tag = this.self;
        this.clickButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ItemButton.this.sendListener();
            }
        });
        this.textLabel = new Label();
        this.self.addComponent(this.textLabel);
        if (text != null) {
            this.textLabel.setText(text);
        }
        if (icon != null) {
            this.textLabel.setIcon(icon);
        }
        this.textLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.textLabel.getStyle().setFgColor(6059405);
        this.textLabel.getDisabledStyle().setFont(UserInterface.FONT_STATIC_WORD);
        this.textLabel.getDisabledStyle().setFgColor(6059405);
        this.textLabel.getDisabledStyle().setBgTransparency(0);
        this.textLabel.setX(this.clickButton.getX());
        this.textLabel.setY(this.clickButton.getY());
        this.textLabel.setPreferredW(this.clickButton.getPreferredW());
        this.textLabel.setPreferredH(this.clickButton.getPreferredH());
        this.textLabel.getStyle().setAlignment(align);
        this.textLabel.setGap(3);
    }

    protected void setIcon(Image icon) {
        boolean needMove = false;
        int moveDistance = 0;
        if (this.textLabel.getIcon() == null && icon != null) {
            needMove = true;
            moveDistance = icon.getWidth() + this.textLabel.getGap();
        } else if (this.textLabel.getIcon() != null && icon == null) {
            needMove = true;
            moveDistance = -(this.textLabel.getIcon().getWidth() + this.textLabel.getGap());
        } else if (this.textLabel.getIcon() != null && icon != null) {
            needMove = true;
            moveDistance = icon.getWidth() - this.textLabel.getIcon().getWidth();
        }
        this.textLabel.setIcon(icon);
        if (this.hintLabel != null && needMove) {
            this.hintLabel.setX(this.hintLabel.getX() + moveDistance);
        }
    }

    public Label getTextLabel() {
        return this.textLabel;
    }

    public void setHintText(String hintText) {
        if (this.hintLabel != null) {
            this.hintLabel.setText(hintText);
        }
    }

    public void setValue(String value) {
        if (this.valueLabel != null) {
            this.valueLabel.setText(value);
            this.valueLabel.setX(this.clickButton.getX() + this.buttonWidth - UserImages.ITEMBUTTON_NAVIGATION_ICON_IMAGE.getWidth() - 20 - this.valueLabel.getPreferredW());
        }
    }

    public void addClickedListener(ButtonClickedListener listener) {
        if (this.allListener == null) {
            this.allListener = new Vector();
        }
        this.allListener.addElement(listener);
    }

    public void clearClickedListener() {
        if (this.allListener != null) {
            this.allListener.removeAllElements();
        }
    }

    public void sendListener() {
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object o = this.allListener.elementAt(i);
                if (o != null && o instanceof ButtonClickedListener) {
                    ((ButtonClickedListener)o).onClicked(this.self);
                }
                ++i;
            }
        }
    }

    public void repaint() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.repaint();
        }
    }
}

