/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.CheckButtonCheckedListener;
import com.nuomi.usercontrol.ItemButton;
import com.nuomi.utils.UserImages;
import java.util.Vector;

public class ItemCheckButton
extends ItemButton {
    private boolean isChecked = false;
    private Vector checkAllListener = null;

    public ItemCheckButton(int type, String text, boolean defaultChecked) {
        super(type, text, defaultChecked ? UserImages.NUOMI_CHECKED_ICON_IMAGE : UserImages.NUOMI_UNCHECKED_ICON_IMAGE, false);
        this.isChecked = defaultChecked;
        this.self.addClickedListener(new ButtonClickedListener(){

            public void onClicked(Object sender) {
                ItemCheckButton.this.isChecked = !ItemCheckButton.this.isChecked;
                ((ItemButton)sender).setIcon(ItemCheckButton.this.isChecked ? UserImages.NUOMI_CHECKED_ICON_IMAGE : UserImages.NUOMI_UNCHECKED_ICON_IMAGE);
                ItemCheckButton.this.sendCheckedListener(ItemCheckButton.this.isChecked);
            }
        });
    }

    public ItemCheckButton(int type, String text) {
        this(type, text, false);
    }

    public void addCheckedListener(CheckButtonCheckedListener listener) {
        if (this.checkAllListener == null) {
            this.checkAllListener = new Vector();
        }
        this.checkAllListener.addElement(listener);
    }

    public void sendCheckedListener(boolean isChecked) {
        if (this.checkAllListener != null) {
            int i = 0;
            while (i < this.checkAllListener.size()) {
                Object o = this.checkAllListener.elementAt(i);
                if (o != null && o instanceof CheckButtonCheckedListener) {
                    ((CheckButtonCheckedListener)o).onChanged(isChecked);
                }
                ++i;
            }
        }
    }

    public void setChecked(boolean isChecked) {
        if (isChecked != this.isChecked) {
            this.isChecked = isChecked;
            this.sendCheckedListener(isChecked);
        }
    }

    public boolean isChecked() {
        return this.isChecked;
    }
}

