/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.utils.Methods;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class LabelGroup
extends Container {
    public LabelGroup(Label[] labels) {
        if (labels == null || labels.length <= 0) {
            return;
        }
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < labels.length) {
            if (labels[i] != null) {
                int x = 0;
                int y = height;
                width = Math.max(width, labels[i].getPreferredW());
                height += labels[i].getPreferredH();
                labels[i].setX(x);
                labels[i].setY(y);
                this.addComponent(labels[i]);
            }
            ++i;
        }
        this.setLayout(new CoordinateLayout(width, height));
        this.setPreferredW(width);
        this.setPreferredH(height);
    }

    public LabelGroup(String[] strings, Font font, int fgColor, int rowHeight) {
        this(strings, font, fgColor, -1, rowHeight);
    }

    public LabelGroup(String[] strings, Font font, int fgColor, int rowWidth, int rowHeight) {
        this(LabelGroup.createLabels(strings, font, fgColor, rowWidth, rowHeight));
    }

    public LabelGroup(Vector strings, Font font, int fgColor, int rowHeight) {
        this(strings, font, fgColor, -1, rowHeight);
    }

    public LabelGroup(Vector strings, Font font, int fgColor, int rowWidth, int rowHeight) {
        this(LabelGroup.createLabels(strings, font, fgColor, rowWidth, rowHeight));
    }

    public static Label[] createLabels(String[] strings, Font font, int fgColor, int rowWidth, int rowHeight) {
        if (strings == null || strings.length <= 0) {
            return null;
        }
        Label[] labels = new Label[strings.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = new Label(strings[i].trim());
            labels[i].getStyle().setFont(font);
            labels[i].getStyle().setFgColor(fgColor);
            labels[i].setPreferredW(rowWidth < 0 ? labels[i].getPreferredW() : rowWidth);
            labels[i].setPreferredH(rowHeight);
            labels[i].getStyle().setAlignment(1);
            labels[i].setEndsWith3Points(false);
            ++i;
        }
        return labels;
    }

    public static Label[] createLabels(Vector strings, Font font, int fgColor, int rowWidth, int rowHeight) {
        if (strings == null || strings.size() <= 0) {
            return null;
        }
        Label[] labels = new Label[strings.size()];
        int i = 0;
        while (i < labels.length) {
            String string = (String)strings.elementAt(i);
            if (!Methods.isNullOrWhitespace(string)) {
                labels[i] = new Label(string.trim());
                labels[i].getStyle().setFont(font);
                labels[i].getStyle().setFgColor(fgColor);
                labels[i].setPreferredW(rowWidth < 0 ? labels[i].getPreferredW() : rowWidth);
                labels[i].setPreferredH(rowHeight);
                labels[i].getStyle().setAlignment(1);
                labels[i].setEndsWith3Points(false);
            }
            ++i;
        }
        return labels;
    }

    public void setAlignment(int align) {
        int i = 0;
        while (i < this.getComponentCount()) {
            Component component = this.getComponentAt(i);
            if (component instanceof Label) {
                ((Label)component).getStyle().setAlignment(align);
            }
            ++i;
        }
    }
}

