/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.listener.ListBoxClickedListener;
import com.nuomi.listener.ListBoxItemClickedListener;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Vector;

public class ListBox
extends Container {
    private ListBox self = this;
    public Vector allListener = null;
    private Label hintLabel = null;
    private final int HintTop;

    public ListBox() {
        this.HintTop = 50;
        this.self.setLayout(new BoxLayout(2));
    }

    public void addItem(ListBoxItem item) {
        if (this.hintLabel != null && this.self.contains(this.hintLabel)) {
            this.self.removeComponent(this.hintLabel);
        }
        this.self.addComponent(item);
        item.addClickedListener(new ListBoxItemClickedListener(){

            public void onClicked(Object itemObject) {
                ListBox.this.self.sendListener(itemObject);
            }
        });
    }

    public void addItem(int index, ListBoxItem item) {
        if (this.hintLabel != null && this.self.contains(this.hintLabel)) {
            this.self.removeComponent(this.hintLabel);
        }
        this.self.addComponent(index, (Component)item);
        item.addClickedListener(new ListBoxItemClickedListener(){

            public void onClicked(Object itemObject) {
                ListBox.this.self.sendListener(itemObject);
            }
        });
    }

    public void addClickedListener(ListBoxClickedListener listener) {
        if (this.allListener == null) {
            this.allListener = new Vector();
        }
        this.allListener.addElement(listener);
    }

    protected void sendListener(Object itemObject) {
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object listener = this.allListener.elementAt(i);
                if (listener instanceof ListBoxClickedListener) {
                    ((ListBoxClickedListener)listener).onClicked(itemObject);
                }
                ++i;
            }
        }
    }

    public int getCount() {
        if (this.hintLabel != null && this.self.contains(this.hintLabel)) {
            return this.self.getComponentCount() - 1;
        }
        return this.self.getComponentCount();
    }

    public void removeAll() {
        int i = 0;
        while (i < this.self.getComponentCount()) {
            Component cmp = this.self.getComponentAt(i);
            if (cmp instanceof ListBoxItem) {
                ((ListBoxItem)cmp).clearClickedListener();
            }
            ++i;
        }
        super.removeAll();
        System.gc();
    }

    public void showHint(String hint) {
        if (this.hintLabel == null) {
            this.hintLabel = new Label();
            this.hintLabel.getStyle().setFgColor(9084854);
            this.hintLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            this.hintLabel.getStyle().setMargin(0, 50);
            this.hintLabel.getStyle().setAlignment(4);
            this.hintLabel.setPreferredW(UserInterface.DISPLAY_WIDTH - 4);
            this.hintLabel.setPreferredH(this.hintLabel.getStyle().getFont().getHeight() + 10);
        }
        this.hintLabel.setText(hint);
        if (!this.self.contains(this.hintLabel)) {
            this.self.addComponent(this.hintLabel);
        }
    }
}

