/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.dialogs.BaseDialog;
import com.nuomi.dialogs.ListPickerDialog;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;

public class ListPicker
extends Container {
    private ListPicker self = this;
    protected TextArea textArea = null;
    private String title = null;
    private String[] itemStrings = null;
    private int selectedIndex = -1;
    private Image bgImage = null;
    private Image focusedBgImage = null;
    private Image disabledBgImage = null;

    public ListPicker(String title, String[] itemStrings) {
        this(title, itemStrings, false);
    }

    public ListPicker(String title, String[] itemStrings, boolean isShort) {
        this.title = title;
        this.itemStrings = itemStrings;
        this.bgImage = isShort ? UserImages.NUOMI_TEXTBOX_SHORT_BG_IMAGE : UserImages.NUOMI_TEXTBOX_BG_IMAGE;
        this.focusedBgImage = isShort ? UserImages.NUOMI_TEXTBOX_SHORT_FOCUSED_BG_IMAGE : UserImages.NUOMI_TEXTBOX_FOCUSED_BG_IMAGE;
        this.disabledBgImage = isShort ? UserImages.NUOMI_TEXTBOX_SHORT_DISABLED_BG_IMAGE : UserImages.NUOMI_TEXTBOX_DISABLED_BG_IMAGE;
        this.setPreferredW(this.bgImage.getWidth());
        this.setPreferredH(this.bgImage.getHeight());
        this.setLayout(new CoordinateLayout(this.getPreferredW(), this.getPreferredH()));
        this.getStyle().setBgImage(this.bgImage);
        this.getDisabledStyle().setBgImage(this.disabledBgImage);
        this.textArea = new TextArea(){

            public boolean isScrollableY() {
                return false;
            }

            protected void onClick() {
                ListPicker.this.showDialog();
            }

            public void setText(String t) {
                Font font = this.getStyle().getFont();
                int width = this.getPreferredW();
                if (font.stringWidth(t) > width) {
                    int i = 0;
                    while (i < t.length()) {
                        if (font.stringWidth(t.substring(0, i)) > width) {
                            t = String.valueOf(t.substring(0, i - 1)) + "...";
                            break;
                        }
                        ++i;
                    }
                }
                super.setText(t);
            }
        };
        this.addComponent(this.textArea);
        this.textArea.setScrollVisible(false);
        this.textArea.setWrapBySpace(false);
        Style[] styles = UserInterface.getComponentStyles(this.textArea);
        int i = 0;
        while (i < styles.length) {
            styles[i].setBorder(null);
            styles[i].setBgTransparency(0);
            if (i == 3) {
                styles[i].setFgColor(0x919191);
            } else {
                styles[i].setFgColor(6453130);
            }
            styles[i].setFont(UserInterface.FONT_BUTTONTEXT);
            ++i;
        }
        this.textArea.setPreferredW(this.getPreferredW() - 5);
        this.textArea.setPreferredH(this.textArea.getPreferredH() - 2);
        this.textArea.setX(5);
        this.textArea.setY((this.getPreferredH() - this.textArea.getPreferredH()) / 2);
        this.textArea.addFocusListener(new FocusListener(){

            public void focusLost(Component cmp) {
                ListPicker.this.self.getStyle().setBgImage(ListPicker.this.bgImage);
                Form form = ListPicker.this.self.getComponentForm();
                if (form != null) {
                    form.repaint();
                }
            }

            public void focusGained(Component cmp) {
                ListPicker.this.self.getStyle().setBgImage(ListPicker.this.focusedBgImage);
                Form form = ListPicker.this.self.getComponentForm();
                if (form != null) {
                    form.repaint();
                }
            }
        });
    }

    private void showDialog() {
        if (!BaseDialog.isShown) {
            Form form;
            int index = ListPickerDialog.getSelectIndex(this.title, this.itemStrings);
            if (index != -1) {
                this.setSelectedIndex(index);
            }
            if ((form = this.getComponentForm()) != null) {
                form.repaint();
            }
        }
    }

    public void setSelectedIndex(int index) {
        try {
            this.textArea.setText(this.itemStrings[index]);
            this.selectedIndex = index;
        }
        catch (Exception e) {
            this.textArea.setText(null);
            this.selectedIndex = -1;
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedString() {
        return this.itemStrings[this.selectedIndex];
    }

    public void resetWidth(int width) {
        this.setPreferredW(width);
        this.textArea.setPreferredW(this.getPreferredW() - 5);
    }

    public void setFocus(boolean focused) {
        Form form = this.getComponentForm();
        if (form != null && focused) {
            form.setFocused(this.textArea);
            form.repaint();
        }
    }
}

