/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.usercontrol.Button;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;

public class MoreTopButton
extends Container {
    private MoreTopButton self = null;
    private Button topButton = null;
    private Button moreButton = null;
    int width = UserImages.NUOMI_MORE_TOP_BG_IMAGE.getWidth();
    int height = UserImages.NUOMI_MORE_TOP_BG_IMAGE.getHeight();
    private int buttonWidth = UserImages.NUOMI_MORE_TOP_PRESSED_IMAGE.getWidth();
    private int buttonHeight = UserImages.NUOMI_MORE_TOP_PRESSED_IMAGE.getHeight();

    public MoreTopButton() {
        this.self = this;
        this.self.setPreferredW(this.width);
        this.self.setPreferredH(this.height);
        this.self.getStyle().setBgImage(UserImages.NUOMI_MORE_TOP_BG_IMAGE);
        this.self.setLayout(new CoordinateLayout(this.width, this.height));
        this.topButton = this.createButton(UserImages.ICON_TOP_IMAGE, "\u56de\u5230\u9876\u90e8");
        this.moreButton = this.createButton(UserImages.ICON_MORE_IMAGE, "\u67e5\u770b\u66f4\u591a");
    }

    private Button createButton(Image icon, String text) {
        Button button = UserInterface.createEmptyButton();
        if (icon != null) {
            button.setIcon(icon);
        }
        if (text != null) {
            button.setText(text);
        }
        button.setPreferredW(this.buttonWidth);
        button.setPreferredH(this.buttonHeight);
        button.getPressedStyle().setBgTransparency(255);
        button.getPressedStyle().setBgImage(UserImages.NUOMI_MORE_TOP_PRESSED_IMAGE);
        button.setY((this.height - this.buttonHeight) / 2);
        button.setGap(10);
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            styles[i].setFgColor(6059405);
            styles[i].setFont(UserInterface.FONT_STATIC_WORD);
            ++i;
        }
        return button;
    }

    public void showButton(boolean showTop, boolean showMore) {
        this.self.removeAll();
        if (showTop) {
            this.self.addComponent(this.topButton);
        }
        if (showMore) {
            this.self.addComponent(this.moreButton);
        }
        if (this.self.getComponentCount() > 1) {
            int topX = (this.width - this.buttonWidth * 2) / 2;
            this.topButton.setX(topX);
            this.moreButton.setX(topX + this.buttonWidth);
        } else {
            int x = (this.width - this.buttonWidth) / 2;
            if (showMore) {
                this.moreButton.setX(x);
            }
            if (showTop) {
                this.topButton.setX(x);
            }
        }
    }

    public void setIsLoading(boolean isloading) {
        this.moreButton.setEnabled(!isloading);
        if (isloading) {
            this.moreButton.setIcon(UserImages.NUOMI_LOADING_ICON_IMAGE);
            this.moreButton.setText("\u6b63\u5728\u8f7d\u5165...");
        } else {
            this.moreButton.setIcon(UserImages.ICON_MORE_IMAGE);
            this.moreButton.setText("\u67e5\u770b\u66f4\u591a");
        }
        this.repaint();
    }

    public void addTopListener(ActionListener l) {
        this.topButton.addActionListener(l);
    }

    public void addMoreListener(ActionListener l) {
        this.moreButton.addActionListener(l);
    }

    public void repaint() {
        Form form = this.self.getComponentForm();
        if (form != null) {
            form.repaint();
        }
    }
}

