/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public abstract class MultiRowButton
extends Container {
    private final int titleRowHeight;
    private final int width;
    protected Label iconLabel = null;
    protected Button clickButton = null;
    protected Container content = null;
    public int index = -1;
    private Vector allListeners = null;

    public MultiRowButton(Image icon, String title, Container content) {
        this.titleRowHeight = 30;
        this.width = 340;
        this.content = content;
        int iconWidth = icon.getWidth();
        this.iconLabel = new Label(icon);
        Vector titleVector = Methods.splitString(title, UserInterface.FONT_NORMAL, 0, 340 - iconWidth - 10, "\r\n");
        LabelGroup titleGroup = new LabelGroup(titleVector, UserInterface.FONT_NORMAL, 6453130, 30);
        int height = titleGroup.getPreferredH() + (content == null ? 0 : content.getPreferredH()) + 20;
        this.setPreferredW(340);
        this.setPreferredH(height);
        this.setLayout(new CoordinateLayout(340, height));
        this.clickButton = UserInterface.createEmptyButton();
        this.addComponent(this.clickButton);
        this.clickButton.setPreferredW(340);
        this.clickButton.setPreferredH(height);
        this.clickButton.setX(0);
        this.clickButton.setY(0);
        this.clickButton.getPressedStyle().setBgTransparency(128);
        this.clickButton.getPressedStyle().setBgColor(9084854);
        this.clickButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiRowButton.this.onClicked();
                MultiRowButton.this.sendClickListener();
            }
        });
        this.addComponent(this.iconLabel);
        this.iconLabel.setX(0);
        this.iconLabel.setY(10);
        this.addComponent(titleGroup);
        titleGroup.setX(this.iconLabel.getPreferredW() + 5);
        titleGroup.setY(10);
        if (content != null) {
            this.addComponent(content);
            content.setX(titleGroup.getX());
            content.setY(titleGroup.getPreferredH() + 10);
        }
    }

    public void addClickListener(ButtonClickedListener l) {
        if (this.allListeners == null) {
            this.allListeners = new Vector();
        }
        if (!this.allListeners.contains(l)) {
            this.allListeners.addElement(l);
        }
    }

    private void sendClickListener() {
        if (this.allListeners != null) {
            int i = 0;
            while (i < this.allListeners.size()) {
                ((ButtonClickedListener)this.allListeners.elementAt(i)).onClicked(this);
                ++i;
            }
        }
    }

    protected void onClicked() {
    }
}

