/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.listener.ButtonClickedListener;
import com.nuomi.listener.MoreListener;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.MultiRowButton;
import com.nuomi.usercontrol.MultiRowCheckButton;
import com.nuomi.usercontrol.MultiRowRadioButton;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Vector;

public class MultiRowButtonGroup
extends Container {
    private MultiRowButton[] _buttons = null;
    private Container moreButtonContainer = null;
    private boolean isMultiSelect = false;
    private final int one_page_count;
    private int selectedIndex = -1;
    private Vector allListeners = null;
    private ButtonClickedListener listener = new ButtonClickedListener(){

        public void onClicked(Object sender) {
            int newIndex;
            if (!MultiRowButtonGroup.this.isMultiSelect && (newIndex = ((MultiRowRadioButton)sender).index) != MultiRowButtonGroup.this.selectedIndex) {
                if (MultiRowButtonGroup.this.selectedIndex != -1) {
                    ((MultiRowRadioButton)MultiRowButtonGroup.this._buttons[MultiRowButtonGroup.this.selectedIndex]).setSelected(false);
                }
                MultiRowButtonGroup.this.selectedIndex = newIndex;
            }
        }
    };

    public MultiRowButtonGroup(MultiRowButton[] buttons, boolean needMultiPage) {
        this.one_page_count = 10;
        this._buttons = buttons;
        this.isMultiSelect = buttons instanceof MultiRowCheckButton[];
        this.setLayout(new BoxLayout(2));
        int showCount = needMultiPage ? Math.min(10, buttons.length) : buttons.length;
        int i = 0;
        while (i < showCount) {
            buttons[i].index = i;
            this.addComponent(buttons[i]);
            buttons[i].addClickListener(this.listener);
            ++i;
        }
        if (needMultiPage && buttons.length > 10) {
            this.moreButtonContainer = new Container(new BoxLayout(1));
            this.addComponent(this.moreButtonContainer);
            Button moreButton = UserInterface.createButton("\u66f4\u591a");
            this.moreButtonContainer.addComponent(moreButton);
            moreButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MultiRowButtonGroup.this.onMore();
                }
            });
        }
    }

    public MultiRowButtonGroup(MultiRowButton[] buttons) {
        this(buttons, false);
    }

    public boolean[] getCheckedState() {
        if (this.isMultiSelect) {
            boolean[] result = new boolean[this._buttons.length];
            int i = 0;
            while (i < result.length) {
                result[i] = ((MultiRowCheckButton)this._buttons[i]).isChecked();
                ++i;
            }
            return result;
        }
        return null;
    }

    public int getSelectedIndex() {
        if (this.isMultiSelect) {
            return -1;
        }
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        try {
            if (!this.isMultiSelect && index != this.selectedIndex) {
                if (this.selectedIndex != -1) {
                    ((MultiRowRadioButton)this._buttons[this.selectedIndex]).setSelected(false);
                }
                ((MultiRowRadioButton)this._buttons[index]).setSelected(true);
                this.selectedIndex = index;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onMore() {
        if (this.moreButtonContainer != null && this.contains(this.moreButtonContainer)) {
            this.removeComponent(this.moreButtonContainer);
        }
        if (this._buttons == null) {
            return;
        }
        int start = this.getComponentCount();
        int end = Math.min(start + 10, this._buttons.length);
        int i = start;
        while (i < end) {
            MultiRowButton button = this._buttons[i];
            if (button != null && !this.contains(button)) {
                this.addComponent(button);
            }
            ++i;
        }
        if (this.getComponentCount() < this._buttons.length && this.moreButtonContainer != null && !this.contains(this.moreButtonContainer)) {
            this.addComponent(this.moreButtonContainer);
        }
        this.sendMoreListener();
        this.repaint();
    }

    public void addMoreListener(MoreListener listener) {
        if (this.allListeners == null) {
            this.allListeners = new Vector();
        }
        if (!this.allListeners.contains(listener)) {
            this.allListeners.addElement(listener);
        }
    }

    public void clearMoreListener() {
        if (this.allListeners != null) {
            this.allListeners.removeAllElements();
        }
    }

    private void sendMoreListener() {
        if (this.allListeners != null) {
            int i = 0;
            while (i < this.allListeners.size()) {
                Object o = this.allListeners.elementAt(i);
                if (o != null && o instanceof MoreListener) {
                    ((MoreListener)o).onMore(this);
                }
                ++i;
            }
        }
    }

    public void repaint() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.repaint();
        }
    }
}

