/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.listener.SelectionChangedListener;
import com.nuomi.usercontrol.Button;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class TabControl
extends Container {
    private TabControl self = this;
    private int clickHeight = 0;
    private Button[] tabButton = null;
    private int _index = 0;
    private Vector allListener = null;
    private boolean clickOnce = false;

    public TabControl(Image bgImage, Image[] tabImages, boolean clickOnce) {
        this.self.clickOnce = clickOnce;
        int tabRealHeight = bgImage.getHeight();
        int tabWidth = bgImage.getWidth();
        this.clickHeight = tabImages[0].getHeight();
        this.self.setLayout(new CoordinateLayout(tabWidth, tabRealHeight));
        this.self.setPreferredW(tabWidth);
        this.self.setPreferredH(tabRealHeight);
        this.self.getStyle().setBgImage(bgImage);
        this.tabButton = new Button[tabImages.length];
        int x = 0;
        int i = 0;
        while (i < tabImages.length) {
            this.tabButton[i] = UserInterface.createEmptyButton();
            this.self.addComponent(this.tabButton[i]);
            if (clickOnce) {
                this.tabButton[i].getDisabledStyle().setBgImage(tabImages[i]);
            } else {
                this.tabButton[i].getPressedStyle().setBgImage(tabImages[i]);
            }
            this.tabButton[i].setPreferredW(tabImages[i].getWidth());
            this.tabButton[i].setPreferredH(this.clickHeight);
            this.tabButton[i].setX(x);
            x += this.tabButton[i].getPreferredW();
            this.tabButton[i].setY(tabRealHeight - this.tabButton[i].getPreferredH());
            this.tabButton[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Button btn = (Button)evt.getSource();
                    int index = TabControl.this.self.getComponentIndex(btn);
                    TabControl.this.sendListener(index);
                    if (TabControl.this.self.clickOnce) {
                        int j = 0;
                        while (j < TabControl.this.tabButton.length) {
                            TabControl.this.tabButton[j].setEnabled(index != j);
                            ++j;
                        }
                    }
                    TabControl.this.self.repaint();
                }
            });
            ++i;
        }
        if (clickOnce) {
            this.tabButton[0].setEnabled(false);
        }
    }

    public void setDisabledImage(int index, Image disabledImage) {
        if (!this.clickOnce) {
            this.tabButton[index].getDisabledStyle().setBgImage(disabledImage);
        }
    }

    public void setTabEnabled(int index, boolean enabled) {
        if (!this.clickOnce) {
            this.tabButton[index].setEnabled(enabled);
        }
    }

    public int getClickHeight() {
        return this.clickHeight;
    }

    public void setSelectedIndex(int index) {
        if (this.clickOnce) {
            if (index >= 0 && index < this.tabButton.length && index != this._index) {
                this._index = index;
                int i = 0;
                while (i < this.tabButton.length) {
                    this.tabButton[i].setEnabled(index != i);
                    ++i;
                }
                this.sendListener(index);
            }
        } else {
            this._index = index;
            this.sendListener(index);
        }
    }

    public int getSelectedIndex() {
        return this._index;
    }

    public void repaint() {
        Form form = this.self.getComponentForm();
        if (form != null) {
            form.repaint();
        }
    }

    public void addChangedListener(SelectionChangedListener listener) {
        if (this.allListener == null) {
            this.allListener = new Vector();
        }
        this.allListener.addElement(listener);
    }

    public void sendListener(int index) {
        this._index = index;
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object listener = this.allListener.elementAt(i);
                if (listener instanceof SelectionChangedListener) {
                    ((SelectionChangedListener)listener).onChanged(index);
                }
                ++i;
            }
        }
    }
}

