/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol;

import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Style;

public class TextBox
extends Container {
    private TextBox self = this;
    protected TextArea textArea = null;
    private Image bgImage = null;
    private Image focusedBgImage = null;
    private Image disabledBgImage = null;

    public TextBox() {
        this(false);
    }

    public TextBox(boolean isShort) {
        this.bgImage = isShort ? UserImages.NUOMI_TEXTBOX_SHORT_BG_IMAGE : UserImages.NUOMI_TEXTBOX_BG_IMAGE;
        this.focusedBgImage = isShort ? UserImages.NUOMI_TEXTBOX_SHORT_FOCUSED_BG_IMAGE : UserImages.NUOMI_TEXTBOX_FOCUSED_BG_IMAGE;
        this.disabledBgImage = isShort ? UserImages.NUOMI_TEXTBOX_SHORT_DISABLED_BG_IMAGE : UserImages.NUOMI_TEXTBOX_DISABLED_BG_IMAGE;
        this.self.setPreferredW(this.bgImage.getWidth());
        this.self.setPreferredH(this.bgImage.getHeight());
        this.self.setLayout(new CoordinateLayout(this.getPreferredW(), this.getPreferredH()));
        this.self.getStyle().setBgImage(this.bgImage);
        this.self.getDisabledStyle().setBgImage(this.disabledBgImage);
        this.textArea = UserInterface.createTextArea();
        this.self.addComponent(this.textArea);
        this.textArea.setPreferredW(this.getPreferredW() - 5);
        this.textArea.setX(5);
        this.textArea.setY((this.getPreferredH() - this.textArea.getPreferredH()) / 2);
        this.textArea.addFocusListener(new FocusListener(){

            public void focusLost(Component cmp) {
                TextBox.this.self.getStyle().setBgImage(TextBox.this.bgImage);
                Form form = TextBox.this.self.getComponentForm();
                if (form != null) {
                    form.repaint();
                }
            }

            public void focusGained(Component cmp) {
                TextBox.this.self.getStyle().setBgImage(TextBox.this.focusedBgImage);
                Form form = TextBox.this.self.getComponentForm();
                if (form != null) {
                    form.repaint();
                }
            }
        });
    }

    public TextBox(int constraint) {
        this();
        this.self.setConstraint(constraint);
    }

    public TextBox(boolean isShort, int constraint) {
        this(isShort);
        this.self.setConstraint(constraint);
    }

    public void setHint(String hint) {
        this.textArea.setHint(hint);
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setConstraint(int constraint) {
        this.textArea.setConstraint(constraint);
    }

    public void setFgColor(int fgColor) {
        Style[] styles = UserInterface.getComponentStyles(this.textArea);
        int i = 0;
        while (i < styles.length) {
            styles[i].setFgColor(fgColor);
            ++i;
        }
    }

    public void setFocus(boolean focused) {
        Form form = this.self.getComponentForm();
        if (form != null && focused) {
            form.setFocused(this.textArea);
            form.repaint();
        }
    }
}

