/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.account;

import com.nuomi.data.Account;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.BoxLayout;

public class AccountListBoxItem
extends ListBoxItem {
    private final int Height;
    private final int Horizontal_Margin;

    public AccountListBoxItem(Account account) {
        this.Height = 200;
        this.Horizontal_Margin = 10;
        this.self.setPreferredW(ListBoxItem.Width);
        this.self.setPreferredH(200);
        this.self.setLayout(new BoxLayout(2));
        if (account == null) {
            return;
        }
        this.self.getStyle().setBgImage(UserImages.NUOMI_LISTBOXITEM_BG_IMAGE);
        if (!Methods.isNullOrWhitespace(account.consume)) {
            Container cousumeContainer = this.createContainer("\u6d88\u8d39:", account.consume, UserInterface.FONT_NORMAL);
            this.self.addComponent(cousumeContainer);
            cousumeContainer.getStyle().setMargin(10, 0, 10, 10);
        }
        if (account.payTimeCalendar != null) {
            Container payTimeContainer = this.createContainer("\u65f6\u95f4:", CalendarFormat.toYMDHMS(account.payTimeCalendar), UserInterface.FONT_FEEDBACK);
            this.self.addComponent(payTimeContainer);
            payTimeContainer.getStyle().setMargin(0, 0, 10, 10);
        }
        if (account.typeString != null) {
            Container typeContainer = this.createContainer("\u6536\u652f:", account.typeString, UserInterface.FONT_FEEDBACK);
            this.self.addComponent(typeContainer);
            typeContainer.getStyle().setMargin(0, 0, 10, 10);
        }
        if (account.amount != null) {
            Container amountContainer = this.createContainer("\u91d1\u989d:", "\uffe5" + Methods.formatPrice(account.amount), UserInterface.FONT_FEEDBACK);
            this.self.addComponent(amountContainer);
            amountContainer.getStyle().setMargin(0, 0, 10, 10);
        }
        if (account.balance != null) {
            Container balanceContainer = this.createContainer("\u4f59\u989d:", "\uffe5" + Methods.formatPrice(account.balance), UserInterface.FONT_FEEDBACK);
            this.self.addComponent(balanceContainer);
            balanceContainer.getStyle().setMargin(0, 0, 10, 10);
        }
    }

    private Container createContainer(String title, String content, Font contentFont) {
        Container container = new Container(new BoxLayout(1));
        Label titleLabel = new Label(title);
        container.addComponent(titleLabel);
        titleLabel.getStyle().setFgColor(6453130);
        titleLabel.getStyle().setFont(UserInterface.FONT_FEEDBACK);
        titleLabel.setPreferredW(64);
        titleLabel.setPreferredH(31);
        Label contentLabel = new Label(content);
        container.addComponent(contentLabel);
        contentLabel.getStyle().setFgColor(6453130);
        contentLabel.getStyle().setFont(contentFont);
        contentLabel.setEndsWith3Points(true);
        contentLabel.setPreferredW(272);
        contentLabel.setPreferredH(31);
        return container;
    }
}

