/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.addressespage;

import com.nuomi.data.PostAddress;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class AddressListBoxItem
extends ListBoxItem {
    private int Height = 0;
    private final int Horizontal_Margin;

    public AddressListBoxItem(PostAddress address) {
        this.Horizontal_Margin = 10;
        if (address == null) {
            return;
        }
        this.self.getStyle().setBgImage(UserImages.NUOMI_LISTBOXITEM_BG_IMAGE);
        if (address.title != null) {
            Label titleLabel = new Label(address.title);
            this.self.addComponent(titleLabel);
            titleLabel.setX(10);
            titleLabel.setY(5);
            this.Height += titleLabel.getY() + titleLabel.getPreferredH();
        }
        if (address.isDefault != null && address.isDefault.booleanValue()) {
            Label isDefaultLabel = new Label("(\u5df2\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u5730\u5740)");
            this.self.addComponent(isDefaultLabel);
            isDefaultLabel.getStyle().setFont(UserInterface.FONT_SMALL);
            isDefaultLabel.setPreferredH(20);
            isDefaultLabel.setX(10);
            isDefaultLabel.setY(this.Height + 5);
            isDefaultLabel.getStyle().setFgColor(9084854);
            this.Height += isDefaultLabel.getPreferredH() + 5;
        }
        if (address.name != null || address.address != null) {
            String addressString = String.valueOf(address.name == null ? "" : String.valueOf(address.name) + " ") + (address.address == null ? "" : address.address);
            Vector addressVector = Methods.splitString(addressString, UserInterface.FONT_NORMAL, 0, ListBoxItem.Width - 20);
            int addressRow = Math.min(2, addressVector.size());
            String[] addressStrings = new String[addressRow];
            int i = 0;
            while (i < addressRow) {
                addressStrings[i] = (String)addressVector.elementAt(i);
                if (i == 1 && addressVector.size() > 2) {
                    addressStrings[i] = String.valueOf(addressStrings[i].substring(0, addressStrings[i].length() - 1)) + "...";
                }
                ++i;
            }
            LabelGroup nameContainer = new LabelGroup(addressStrings, UserInterface.FONT_NORMAL, 6453130, 30);
            this.self.addComponent(nameContainer);
            nameContainer.setX(10);
            nameContainer.setY(this.Height + 5);
            if (addressRow > 0) {
                this.Height += 5 + nameContainer.getPreferredH();
            }
        }
        if (address.phone != null || address.postcode != null) {
            String phoneString = String.valueOf(address.phone == null ? "" : String.valueOf(address.phone) + " ") + (address.postcode == null ? "" : address.postcode);
            Label phoneLabel = new Label(phoneString);
            this.self.addComponent(phoneLabel);
            phoneLabel.setX(10);
            phoneLabel.setY(this.Height + 5);
            this.Height += 5 + phoneLabel.getPreferredH();
        }
        this.Height += 5;
        this.self.setPreferredW(ListBoxItem.Width);
        this.self.setPreferredH(this.Height);
        this.self.setLayout(new CoordinateLayout(ListBoxItem.Width, this.Height));
    }
}

