/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.couponlistpage;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.data.Coupon;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class UnusedCouponListBoxItem
extends ListBoxItem {
    private final int Height;
    private final int Hor_Margin;
    private final int Ver_Margin;

    public UnusedCouponListBoxItem(final Coupon coupon, int type) {
        long remainTime;
        this.Height = 270;
        this.Hor_Margin = 10;
        this.Ver_Margin = 15;
        if (coupon == null) {
            return;
        }
        this.self.setPreferredW(ListBoxItem.Width);
        this.self.setPreferredH(270);
        this.self.setLayout(new CoordinateLayout(ListBoxItem.Width, 270));
        Button itemButton = UserInterface.createListBoxItemButton();
        this.self.addComponent(itemButton);
        itemButton.setX(0);
        itemButton.setY(0);
        itemButton.setPreferredW(ListBoxItem.Width);
        itemButton.setPreferredH(270);
        itemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnusedCouponListBoxItem.this.sendListener(coupon);
            }
        });
        int remainWidth = UserImages.COUPON_REMAIN_TIME_BG_IMAGE.getWidth();
        int remainHeight = UserImages.COUPON_REMAIN_TIME_BG_IMAGE.getHeight();
        Container remainContainer = new Container(new CoordinateLayout(remainWidth, remainHeight));
        remainContainer.setPreferredW(remainWidth);
        remainContainer.setPreferredH(remainHeight);
        this.self.addComponent(remainContainer);
        remainContainer.setX(10);
        remainContainer.setY(15);
        remainContainer.getStyle().setBgImage(UserImages.COUPON_REMAIN_TIME_BG_IMAGE);
        Label remainTitleLabel = new Label(type == 0 ? "\u5df2\u8d2d\u4e70" : "\u79bb\u5230\u671f");
        remainContainer.addComponent(remainTitleLabel);
        remainTitleLabel.setPreferredW(remainWidth);
        remainTitleLabel.setPreferredH(35);
        remainTitleLabel.setX(0);
        remainTitleLabel.setY(0);
        remainTitleLabel.getStyle().setFgColor(0xFFFFFF);
        remainTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        remainTitleLabel.getStyle().setAlignment(4);
        long currentTime = System.currentTimeMillis() + ClientInfo.timeRelativeError;
        long remainDay = -1L;
        long dayToMillisecond = 86400000L;
        if (coupon.expireTime != null && type == 1) {
            remainTime = coupon.expireTime - currentTime;
            remainDay = remainTime / dayToMillisecond;
        }
        if (coupon.buyTime != null && type == 0) {
            remainTime = currentTime - coupon.buyTime;
            remainDay = remainTime / dayToMillisecond;
        }
        if (remainDay > -1L) {
            if (remainDay > 99L) {
                Label remainDayLabel = new Label("99");
                remainContainer.addComponent(remainDayLabel);
                remainDayLabel.getStyle().setFgColor(5535643);
                remainDayLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
                Label addLabel = new Label("+");
                remainContainer.addComponent(addLabel);
                addLabel.getStyle().setFgColor(5535643);
                addLabel.getStyle().setFont(UserInterface.FONT_SMALL);
                Label dayLabel = new Label("\u5929");
                remainContainer.addComponent(dayLabel);
                dayLabel.getStyle().setFgColor(5535643);
                dayLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
                remainDayLabel.setX(15);
                remainDayLabel.setY(remainTitleLabel.getPreferredH() + 10);
                addLabel.setX(38);
                addLabel.setY(remainDayLabel.getY() - 6);
                dayLabel.setX(50);
                dayLabel.setY(remainDayLabel.getY());
            } else {
                Label remainDayLabel = new Label(String.valueOf(remainDay) + "\u5929");
                remainContainer.addComponent(remainDayLabel);
                remainDayLabel.setPreferredW(remainWidth);
                remainDayLabel.setPreferredH(remainHeight - remainTitleLabel.getPreferredH());
                remainDayLabel.setX(0);
                remainDayLabel.setY(remainTitleLabel.getPreferredH());
                remainDayLabel.getStyle().setFgColor(5535643);
                remainDayLabel.getStyle().setFont(UserInterface.FONT_STATIC_WORD);
                remainDayLabel.getStyle().setAlignment(4);
            }
        }
        if (!Methods.isNullOrEmpty(coupon.middleTitle)) {
            int titleWidth = ListBoxItem.Width - 30 - remainContainer.getPreferredW();
            Vector titleVector = Methods.splitString(coupon.middleTitle, UserInterface.FONT_NORMAL, 0, titleWidth);
            String[] strings = new String[Math.min(3, titleVector.size())];
            int i = 0;
            while (i < strings.length) {
                strings[i] = (String)titleVector.elementAt(i);
                if (i == 2 && titleVector.size() > 3) {
                    strings[i] = String.valueOf(strings[i].substring(0, strings[i].length() - 1)) + "...";
                }
                ++i;
            }
            LabelGroup titleGroup = new LabelGroup(strings, UserInterface.FONT_NORMAL, 6453130, 30);
            this.self.addComponent(titleGroup);
            titleGroup.setX(remainContainer.getX() + remainWidth + 10);
            titleGroup.setY(15);
        }
        Label passwordTitleLabel = new Label("\u6d88\u8d39\u7801:");
        this.self.addComponent(passwordTitleLabel);
        passwordTitleLabel.setX(10);
        passwordTitleLabel.setY(remainContainer.getY() + remainHeight);
        passwordTitleLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        int passwordY = passwordTitleLabel.getY() + passwordTitleLabel.getPreferredH();
        int passwordHeight = 0;
        if (coupon.password != null) {
            Label passwordLabel = new Label(coupon.password);
            this.self.addComponent(passwordLabel);
            passwordLabel.setX(10);
            passwordLabel.setY(passwordY);
            passwordLabel.setPreferredW(ListBoxItem.Width - 20);
            passwordLabel.setPreferredH(40);
            passwordLabel.getStyle().setFont(UserInterface.FONT_TITLEBAR);
            passwordHeight = passwordLabel.getPreferredH();
            passwordLabel.setEndsWith3Points(true);
            passwordLabel.setTickerEnabled(false);
        }
        int buyTimeY = passwordY + passwordHeight;
        int buyTimeHeight = 0;
        if (coupon.buyTimeCalendar != null) {
            Label buyTimeLabel = new Label("\u8d2d\u4e70\u65f6\u95f4:" + CalendarFormat.toYMD(coupon.buyTimeCalendar));
            this.self.addComponent(buyTimeLabel);
            buyTimeLabel.setX(10);
            buyTimeLabel.setY(buyTimeY);
            buyTimeLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
            buyTimeHeight = buyTimeLabel.getPreferredH();
        }
        int expireTimeY = buyTimeY + buyTimeHeight;
        if (coupon.expireTimeCalendar != null) {
            Label expireTimeLabel = new Label("\u5230\u671f\u65f6\u95f4:" + CalendarFormat.toYMD(coupon.expireTimeCalendar));
            this.self.addComponent(expireTimeLabel);
            expireTimeLabel.setX(10);
            expireTimeLabel.setY(expireTimeY);
            expireTimeLabel.getStyle().setFont(UserInterface.FONT_MESSAGEBOX);
        }
    }
}

