/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.couponlistpage;

import com.nuomi.data.Coupon;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class UsedCouponListBoxItem
extends ListBoxItem {
    private final int Label_Height;
    private final int Hor_Margin;
    private final int Ver_Margin;
    private final int Label_Width = ListBoxItem.Width - 20;

    public UsedCouponListBoxItem(final Coupon coupon) {
        this.Label_Height = 30;
        this.Hor_Margin = 10;
        this.Ver_Margin = 15;
        if (coupon == null) {
            return;
        }
        Vector titleVector = Methods.splitString(coupon.minTitle, UserInterface.FONT_NORMAL, 0, this.Label_Width);
        String[] strings = new String[(titleVector == null ? 0 : titleVector.size()) + (coupon.usedTimeCalendar == null ? 0 : 1) + (coupon.buyTimeCalendar == null ? 0 : 1)];
        if (titleVector != null) {
            int i = 0;
            while (i < titleVector.size()) {
                strings[i] = (String)titleVector.elementAt(i);
                ++i;
            }
        }
        if (coupon.usedTimeCalendar != null) {
            strings[titleVector == null ? 0 : titleVector.size()] = "\u4f7f\u7528\u65f6\u95f4:" + CalendarFormat.toYMD(coupon.usedTimeCalendar);
        }
        if (coupon.buyTimeCalendar != null) {
            strings[strings.length - 1] = "\u8d2d\u4e70\u65f6\u95f4:" + CalendarFormat.toYMD(coupon.buyTimeCalendar);
        }
        int Height = 30 + strings.length * 30;
        this.self.setPreferredW(ListBoxItem.Width);
        this.self.setPreferredH(Height);
        this.self.setLayout(new CoordinateLayout(ListBoxItem.Width, Height));
        Button itemButton = UserInterface.createListBoxItemButton();
        this.self.addComponent(itemButton);
        itemButton.setX(0);
        itemButton.setY(0);
        itemButton.setPreferredW(ListBoxItem.Width);
        itemButton.setPreferredH(Height);
        itemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsedCouponListBoxItem.this.sendListener(coupon);
            }
        });
        LabelGroup labelGroup = new LabelGroup(strings, UserInterface.FONT_NORMAL, 6453130, 30);
        this.self.addComponent(labelGroup);
        labelGroup.setX(10);
        labelGroup.setY(15);
    }
}

