/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.dealdetail;

import com.nuomi.clientinfo.ClientInfo;
import com.nuomi.listener.CountDownEndListener;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class CountDownLabel
extends Container {
    private final long SECOND_MILLIS;
    private final long MINUTE_MILLIS;
    private final long HOUR_MILLIS;
    private final long DAY_MILLIS;
    private long lEndTime = 0L;
    private Container mainContainer = null;
    private MyLabel dayMyLabel = null;
    private MyLabel hourMyLabel = null;
    private MyLabel minuteMyLabel = null;
    private MyLabel secondMyLabel = null;
    private Label endLabel = null;
    private com.nuomi.utils.Thread countDownThread = null;
    private boolean isExpire = false;
    private Vector allListener = null;

    public CountDownLabel() {
        this.SECOND_MILLIS = 1000L;
        this.MINUTE_MILLIS = 60000L;
        this.HOUR_MILLIS = 3600000L;
        this.DAY_MILLIS = 86400000L;
        int width = UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getWidth();
        int height = UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE.getHeight();
        this.setLayout(new CoordinateLayout(width, height));
        this.setPreferredW(width);
        this.setPreferredH(height);
        this.getStyle().setBgImage(UserImages.DEALDETAIL_COUNT_DOWN_BG_IMAGE);
        this.mainContainer = new Container(new BoxLayout(1));
        this.addComponent(this.mainContainer);
        this.dayMyLabel = new MyLabel("\u5929");
        this.mainContainer.addComponent(this.dayMyLabel);
        this.hourMyLabel = new MyLabel("\u65f6");
        this.mainContainer.addComponent(this.hourMyLabel);
        this.minuteMyLabel = new MyLabel("\u5206");
        this.mainContainer.addComponent(this.minuteMyLabel);
        this.secondMyLabel = new MyLabel("\u79d2");
        this.mainContainer.addComponent(this.secondMyLabel);
        this.mainContainer.setX(Math.max(0, (width - this.mainContainer.getPreferredW()) / 2));
        this.mainContainer.setY(Math.max(0, (height - this.mainContainer.getPreferredH()) / 2));
        this.endLabel = new Label("\u5df2\u7ed3\u675f");
        this.endLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        this.endLabel.getStyle().setFgColor(0xFFFFFF);
        this.endLabel.setX(Math.max(0, (width - this.endLabel.getPreferredW()) / 2));
        this.endLabel.setY(Math.max(0, (height - this.endLabel.getPreferredH()) / 2));
    }

    public void setText(Long endTime) {
        if (this.contains(this.endLabel)) {
            this.removeComponent(this.endLabel);
        }
        if (!this.contains(this.mainContainer)) {
            this.addComponent(this.mainContainer);
        }
        if (endTime == null || endTime <= 0L) {
            this.sendEndListener(false);
            return;
        }
        this.lEndTime = endTime;
        long currentTime = System.currentTimeMillis() + ClientInfo.timeRelativeError;
        if (currentTime > this.lEndTime) {
            this.sendEndListener(false);
        } else {
            if (!this.contains(this.mainContainer)) {
                this.removeAll();
                this.addComponent(this.mainContainer);
            }
            this.isExpire = false;
            if (this.countDownThread == null) {
                this.countDownThread = new com.nuomi.utils.Thread(){

                    public void run() {
                        while (!CountDownLabel.this.isExpire && !this.isStoped) {
                            Form form = CountDownLabel.this.getComponentForm();
                            if (form != null && form == Display.getInstance().getCurrent() && CountDownLabel.this.isVisible()) {
                                long currentTime = System.currentTimeMillis() + ClientInfo.timeRelativeError;
                                if (currentTime > CountDownLabel.this.lEndTime) {
                                    CountDownLabel.this.sendEndListener(true);
                                    break;
                                }
                                CountDownLabel.this.showRemainTime(Math.max(0L, CountDownLabel.this.lEndTime - currentTime));
                                form.repaint(CountDownLabel.this.getAbsoluteX(), CountDownLabel.this.getAbsoluteY(), CountDownLabel.this.getPreferredW(), CountDownLabel.this.getPreferredW());
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                this.countDownThread.start();
                this.sendStartListener();
            }
        }
    }

    public void clear() {
        if (this.countDownThread != null) {
            this.countDownThread.interrupt();
            this.countDownThread = null;
        }
        if (!this.isExpire) {
            Form form;
            if (this.dayMyLabel != null) {
                this.dayMyLabel.setValue(0L);
            }
            if (this.hourMyLabel != null) {
                this.hourMyLabel.setValue(0L);
            }
            if (this.minuteMyLabel != null) {
                this.minuteMyLabel.setValue(0L);
            }
            if (this.secondMyLabel != null) {
                this.secondMyLabel.setValue(0L);
            }
            if ((form = this.getComponentForm()) != null && form == Display.getInstance().getCurrent()) {
                form.repaint(this.getAbsoluteX(), this.getAbsoluteY(), this.getPreferredW(), this.getPreferredW());
            }
        }
    }

    public void addEndListener(CountDownEndListener l) {
        if (this.allListener == null) {
            this.allListener = new Vector();
        }
        this.allListener.addElement(l);
    }

    public void clearEndListener() {
        if (this.allListener != null) {
            this.allListener.removeAllElements();
        }
    }

    private void sendStartListener() {
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object o = this.allListener.elementAt(i);
                if (o != null && o instanceof CountDownEndListener) {
                    ((CountDownEndListener)o).onStart();
                }
                ++i;
            }
        }
    }

    private void sendEndListener(boolean isTimeEnd) {
        this.isExpire = true;
        this.clear();
        if (this.contains(this.mainContainer)) {
            this.removeComponent(this.mainContainer);
        }
        if (!this.contains(this.endLabel)) {
            this.addComponent(this.endLabel);
        }
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object o = this.allListener.elementAt(i);
                if (o != null && o instanceof CountDownEndListener) {
                    ((CountDownEndListener)o).onEnd(isTimeEnd);
                }
                ++i;
            }
        }
    }

    private void showRemainTime(long lRemainTime) {
        RemainTime remainTime = this.parserRemainTime(lRemainTime);
        this.dayMyLabel.setValue(remainTime.day);
        this.hourMyLabel.setValue(remainTime.hour);
        this.minuteMyLabel.setValue(remainTime.minute);
        this.secondMyLabel.setValue(remainTime.second);
    }

    private RemainTime parserRemainTime(long lRemainTime) {
        RemainTime remainTime = new RemainTime();
        remainTime.day = lRemainTime / 86400000L;
        long temp = lRemainTime % 86400000L;
        remainTime.hour = temp / 3600000L;
        remainTime.minute = (temp %= 3600000L) / 60000L;
        remainTime.second = (temp %= 60000L) / 1000L;
        return remainTime;
    }

    private class MyLabel
    extends Container {
        Label label1 = null;
        Label label2 = null;
        Label label = null;

        public MyLabel(String unitsString) {
            boolean isDay = "\u5929".equals(unitsString);
            int numberWidth = 18;
            int unitWidth = 25;
            int height = 25;
            int width = (isDay ? 0 : numberWidth) + numberWidth + unitWidth;
            this.setLayout(new CoordinateLayout(width, height));
            this.setPreferredW(width);
            this.setPreferredH(height);
            this.label1 = new Label("0");
            if (!isDay) {
                this.addComponent(this.label1);
                this.label1.setX(0);
            }
            this.label1.setY(0);
            this.label1.setPreferredW(numberWidth);
            this.label1.setPreferredH(height);
            this.label1.getStyle().setFont(UserInterface.FONT_SMALL);
            this.label1.getStyle().setFgColor(0xFFFFFF);
            this.label1.setEndsWith3Points(false);
            this.label2 = new Label("0");
            this.addComponent(this.label2);
            this.label2.setX(isDay ? 0 : numberWidth);
            this.label2.setY(0);
            this.label2.setPreferredW(numberWidth);
            this.label2.setPreferredH(height);
            this.label2.getStyle().setFont(UserInterface.FONT_SMALL);
            this.label2.getStyle().setFgColor(0xFFFFFF);
            this.label2.setEndsWith3Points(false);
            this.label = new Label(unitsString);
            this.addComponent(this.label);
            this.label.setX(isDay ? numberWidth : numberWidth * 2);
            this.label.setY(0);
            this.label.setPreferredW(unitWidth);
            this.label.setPreferredH(height);
            this.label.getStyle().setFont(UserInterface.FONT_SMALL);
            this.label.getStyle().setFgColor(0xFFFFFF);
            this.label.setEndsWith3Points(false);
        }

        public void setValue(long value) {
            String valueString = String.valueOf(value %= 100L);
            if (valueString.length() == 1) {
                valueString = "0" + valueString;
            }
            this.label1.setText(valueString.substring(0, 1));
            this.label2.setText(valueString.substring(1, 2));
        }
    }

    private class RemainTime {
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;

        private RemainTime() {
        }
    }
}

