/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.homepage;

import com.nuomi.Main;
import com.nuomi.data.DealPreview;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class DealListBoxItem
extends ListBoxItem {
    private final int Height;
    private final int Vertical_Margin;
    private final int Horizontal_Margin;
    private ImageControl tinyImageControl = null;
    private Label lookedLabel = null;

    public DealListBoxItem(final DealPreview dealPreview) {
        this.Height = 145;
        this.Vertical_Margin = 10;
        this.Horizontal_Margin = 5;
        this.self.setPreferredW(ListBoxItem.Width);
        this.self.setPreferredH(145);
        this.self.setLayout(new CoordinateLayout(ListBoxItem.Width, 145));
        if (dealPreview == null) {
            return;
        }
        Button itemButton = UserInterface.createListBoxItemButton();
        this.self.addComponent(itemButton);
        itemButton.setX(0);
        itemButton.setY(0);
        itemButton.setPreferredW(ListBoxItem.Width);
        itemButton.setPreferredH(145);
        itemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DealListBoxItem.this.sendListener(dealPreview);
            }
        });
        this.tinyImageControl = new ImageControl(150, 90);
        this.self.addComponent(this.tinyImageControl);
        this.tinyImageControl.setX(7);
        this.tinyImageControl.setY(10);
        if (dealPreview.tinyImage != null) {
            this.tinyImageControl.setImage(dealPreview.tinyImage, false);
        }
        int rightPartX = 5 + this.tinyImageControl.getPreferredW() + this.tinyImageControl.getX();
        int labelHeight = UserInterface.FONT_NORMAL.getHeight();
        if (dealPreview.middleTitle != null) {
            Vector middleTitleVector = Methods.splitString(dealPreview.middleTitle, UserInterface.FONT_NORMAL, 0, ListBoxItem.Width - this.tinyImageControl.getPreferredW() - 15);
            int middleTitleRowCount = Math.min(2, middleTitleVector.size());
            int i = 0;
            while (i < middleTitleRowCount) {
                String string = (String)middleTitleVector.elementAt(i);
                if (i == 1 && middleTitleVector.size() > 2) {
                    string = String.valueOf(string.substring(0, string.length() - 1)) + "...";
                }
                Label label = new Label(string);
                this.self.addComponent(label);
                label.setX(rightPartX);
                label.setY(10 + i * labelHeight);
                ++i;
            }
        }
        Label currentPriceLabel = null;
        if (dealPreview.currentPrice != null) {
            currentPriceLabel = new Label("\uffe5" + Methods.formatPrice((double)dealPreview.currentPrice));
            this.self.addComponent(currentPriceLabel);
            currentPriceLabel.setX(rightPartX);
            currentPriceLabel.setY(10 + this.tinyImageControl.getPreferredH() - UserInterface.FONT_LARGE.getHeight());
            currentPriceLabel.getStyle().setFont(UserInterface.FONT_LARGE);
            currentPriceLabel.getStyle().setFgColor(5535643);
        }
        if (dealPreview.marketPrice != null) {
            Label marketPriceLabel = new Label("/ \uffe5" + Methods.formatPrice((double)dealPreview.marketPrice));
            this.self.addComponent(marketPriceLabel);
            marketPriceLabel.setX(rightPartX + (currentPriceLabel == null ? 0 : currentPriceLabel.getPreferredW() + 5));
            marketPriceLabel.setY(10 + this.tinyImageControl.getPreferredH() - UserInterface.FONT_LARGE.getHeight() + (UserInterface.FONT_LARGE.getHeight() - UserInterface.FONT_SMALL.getHeight()) / 2);
            marketPriceLabel.getStyle().setFont(UserInterface.FONT_SMALL);
            marketPriceLabel.getStyle().setFgColor(9084854);
            Label deleteLineLabel = new Label();
            this.self.addComponent(deleteLineLabel);
            deleteLineLabel.getStyle().setBgTransparency(255);
            deleteLineLabel.getStyle().setBgColor(marketPriceLabel.getStyle().getFgColor());
            deleteLineLabel.setPreferredW(marketPriceLabel.getPreferredW() - UserInterface.FONT_NORMAL.stringWidth("/ "));
            deleteLineLabel.setPreferredH(1);
            deleteLineLabel.setX(marketPriceLabel.getX() + UserInterface.FONT_NORMAL.stringWidth("/ "));
            deleteLineLabel.setY(marketPriceLabel.getY() + marketPriceLabel.getPreferredH() / 2);
            deleteLineLabel.getStyle().setFgColor(9084854);
        }
        int bottomPartY = 10 + this.tinyImageControl.getPreferredH() + 5;
        if (dealPreview.saleCount != null) {
            Label saleCountLabel = new Label(dealPreview.saleCount + "\u4eba\u8d2d\u4e70");
            this.self.addComponent(saleCountLabel);
            saleCountLabel.setX(this.tinyImageControl.getX());
            saleCountLabel.setY(bottomPartY);
            saleCountLabel.getStyle().setFont(UserInterface.FONT_NORMAL);
            saleCountLabel.getStyle().setFgColor(9084854);
        }
        if (!Methods.isNullOrEmpty(dealPreview.area)) {
            int x = rightPartX + 10;
            Label areaLabel = UserInterface.createAreaLabel(dealPreview.area, ListBoxItem.Width - x - 5);
            this.self.addComponent(areaLabel);
            areaLabel.setX(x);
            areaLabel.setY(bottomPartY);
        }
        if (Main.clientInfo.hadLookedDeal(dealPreview.dealId)) {
            this.lookedLabel = new Label();
            this.self.addComponent(this.lookedLabel);
            this.lookedLabel.getStyle().setBgImage(UserImages.HOMEPAGE_LOOKED_IMAGE);
            this.lookedLabel.setPreferredW(UserImages.HOMEPAGE_LOOKED_IMAGE.getWidth());
            this.lookedLabel.setPreferredH(60);
            this.lookedLabel.setX(0);
            this.lookedLabel.setY(10 + (90 - this.lookedLabel.getPreferredH()) / 2);
        }
        Image statusImage = null;
        if (dealPreview.onlyPhone != null && dealPreview.onlyPhone.booleanValue()) {
            statusImage = dealPreview.soldOut != null && dealPreview.soldOut.booleanValue() ? UserImages.HOMEPAGE_SOLDOUT_PHONE_IMAGE : UserImages.HOMEPAGE_PHONE_IMAGE;
        } else if (dealPreview.soldOut != null && dealPreview.soldOut.booleanValue()) {
            statusImage = UserImages.HOMEPAGE_SOLDOUT_IMAGE;
        } else if (dealPreview.isNew != null && dealPreview.isNew.booleanValue()) {
            statusImage = UserImages.HOMEPAGE_NEW_IMAGE;
        }
        if (statusImage != null) {
            Label statusLabel = new Label();
            this.self.addComponent(statusLabel);
            statusLabel.getStyle().setBgImage(statusImage);
            statusLabel.setPreferredW(statusImage.getWidth());
            statusLabel.setPreferredH(statusImage.getHeight());
            statusLabel.setX(ListBoxItem.Width - statusLabel.getPreferredW());
            statusLabel.setY(0);
        }
    }

    public ImageControl getImageControl() {
        return this.tinyImageControl;
    }

    public void showLookedLabel(boolean isShow) {
        if (isShow) {
            if (this.lookedLabel == null) {
                this.lookedLabel = new Label();
                this.lookedLabel.getStyle().setBgImage(UserImages.HOMEPAGE_LOOKED_IMAGE);
                this.lookedLabel.setPreferredW(UserImages.HOMEPAGE_LOOKED_IMAGE.getWidth());
                this.lookedLabel.setPreferredH(60);
                this.lookedLabel.setX(0);
                this.lookedLabel.setY(10 + (90 - this.lookedLabel.getPreferredH()) / 2);
            }
            if (!this.self.contains(this.lookedLabel)) {
                this.self.addComponent(this.lookedLabel);
            }
        } else if (this.lookedLabel != null && this.self.contains(this.lookedLabel)) {
            this.self.removeComponent(this.lookedLabel);
        }
        this.repaint();
    }
}

