/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.homepage;

import com.nuomi.data.VoucherPreview;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ImageControl;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class VoucherListBoxItem
extends ListBoxItem {
    private final int Height;
    private final int Vertical_Margin;
    private final int Horizontal_Margin;
    private ImageControl imageControl = null;

    public VoucherListBoxItem(final VoucherPreview voucherPreview) {
        this.Height = 182;
        this.Vertical_Margin = 10;
        this.Horizontal_Margin = 5;
        this.self.setPreferredW(ListBoxItem.Width);
        this.self.setPreferredH(182);
        this.self.setLayout(new CoordinateLayout(ListBoxItem.Width, 182));
        if (voucherPreview == null) {
            return;
        }
        Button itemButton = UserInterface.createListBoxItemButton();
        this.self.addComponent(itemButton);
        itemButton.setX(0);
        itemButton.setY(0);
        itemButton.setPreferredW(ListBoxItem.Width);
        itemButton.setPreferredH(182);
        itemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VoucherListBoxItem.this.sendListener(voucherPreview);
            }
        });
        this.imageControl = new ImageControl(150, 90);
        this.self.addComponent(this.imageControl);
        this.imageControl.setX(5);
        this.imageControl.setY(10);
        if (voucherPreview.image != null) {
            this.imageControl.setImage(voucherPreview.image, false);
        }
        int rightPartX = 10 + this.imageControl.getPreferredW();
        int labelHeight = this.imageControl.getPreferredH() / 3;
        if (voucherPreview.title != null) {
            Vector titleVector = Methods.splitString(voucherPreview.title, UserInterface.FONT_NORMAL, 0, ListBoxItem.Width - this.imageControl.getPreferredW() - 15);
            int titleRowCount = Math.min(3, titleVector.size());
            int i = 0;
            while (i < titleRowCount) {
                String string = (String)titleVector.elementAt(i);
                if (i == 2 && titleVector.size() > 3) {
                    string = String.valueOf(string.substring(0, string.length() - 1)) + "...";
                }
                Label label = new Label(string);
                this.self.addComponent(label);
                label.setX(rightPartX);
                label.setY(10 + i * labelHeight);
                ++i;
            }
        }
        int bottomPartY = 10 + this.imageControl.getPreferredH() + 5;
        Component expireTimeLabel = null;
        if (voucherPreview.expireTime != null) {
            String expireTimeString = "\u6709\u6548\u65f6\u95f4\uff1a" + CalendarFormat.toYMD(voucherPreview.expireTimeCalendar);
            expireTimeLabel = new Label(expireTimeString);
            this.self.addComponent(expireTimeLabel);
            expireTimeLabel.setX(5);
            expireTimeLabel.setY(bottomPartY);
            expireTimeLabel.getStyle().setFont(UserInterface.FONT_NORMAL);
            expireTimeLabel.getStyle().setFgColor(9084854);
        }
        if (voucherPreview.downloadCount != null) {
            int y = bottomPartY + (expireTimeLabel == null ? 0 : expireTimeLabel.getPreferredH() + 5);
            Label downloadLabel = UserInterface.createLongAreaLabel("\u4e0b\u8f7d\u6b21\u6570\uff1a" + voucherPreview.downloadCount, 230);
            this.self.addComponent(downloadLabel);
            downloadLabel.setX(5);
            downloadLabel.setY(y);
        }
        if (voucherPreview.canSendSms != null && voucherPreview.canSendSms.booleanValue()) {
            Label canSendSmsLabel = new Label();
            this.self.addComponent(canSendSmsLabel);
            canSendSmsLabel.getStyle().setBgImage(UserImages.HOMEPAGE_VOUCHER_SMS_IMAGE);
            canSendSmsLabel.setPreferredW(UserImages.HOMEPAGE_VOUCHER_SMS_IMAGE.getWidth());
            canSendSmsLabel.setPreferredH(UserImages.HOMEPAGE_VOUCHER_SMS_IMAGE.getHeight());
            canSendSmsLabel.setX(ListBoxItem.Width - canSendSmsLabel.getPreferredW());
            canSendSmsLabel.setY(182 - canSendSmsLabel.getPreferredH());
        }
    }

    public ImageControl getImageControl() {
        return this.imageControl;
    }
}

