/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.usercontrol.postorderlistpage;

import com.nuomi.data.PostOrder;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.ListBoxItem;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class PostOrderListBoxItem
extends ListBoxItem {
    private final int Label_Height;
    private final int Hor_Margin;
    private final int Ver_Margin;
    private final int Label_Width = ListBoxItem.Width - 20;

    public PostOrderListBoxItem(final PostOrder postOrder) {
        this.Label_Height = 30;
        this.Hor_Margin = 10;
        this.Ver_Margin = 15;
        if (postOrder == null) {
            return;
        }
        Vector titleVector = Methods.splitString(postOrder.minTitle, UserInterface.FONT_NORMAL, 0, this.Label_Width);
        int titleRows = titleVector == null ? 0 : titleVector.size();
        Vector addressVector = Methods.splitString(postOrder.postAddress, UserInterface.FONT_NORMAL, 0, this.Label_Width, "\r\n");
        int addressRows = addressVector == null ? 0 : addressVector.size();
        int buyCountRow = postOrder.buyCount == null ? 0 : 1;
        int buyTimeRow = postOrder.buyTimeCalendar == null ? 0 : 1;
        String[] strings = new String[titleRows + addressRows + buyCountRow + buyTimeRow];
        int i = 0;
        while (i < strings.length) {
            strings[i] = i < titleRows ? (String)titleVector.elementAt(i) : (i < titleRows + addressRows ? (String)addressVector.elementAt(i - titleRows) : (i < titleRows + addressRows + buyCountRow ? "\u8d2d\u4e70\u6570\u91cf:" + postOrder.buyCount : "\u8d2d\u4e70\u65f6\u95f4:" + CalendarFormat.toYMD(postOrder.buyTimeCalendar)));
            ++i;
        }
        int Height = 30 + strings.length * 30;
        this.self.setPreferredW(ListBoxItem.Width);
        this.self.setPreferredH(Height);
        this.self.setLayout(new CoordinateLayout(ListBoxItem.Width, Height));
        Button itemButton = UserInterface.createListBoxItemButton();
        this.self.addComponent(itemButton);
        itemButton.setX(0);
        itemButton.setY(0);
        itemButton.setPreferredW(ListBoxItem.Width);
        itemButton.setPreferredH(Height);
        itemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostOrderListBoxItem.this.sendListener(postOrder);
            }
        });
        LabelGroup labelGroup = new LabelGroup(strings, UserInterface.FONT_NORMAL, 6453130, 30);
        this.self.addComponent(labelGroup);
        labelGroup.setX(10);
        labelGroup.setY(15);
    }
}

