/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.utils;

import com.nuomi.utils.PhoneFunction;
import com.sun.lwuit.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Methods {
    private static final String[] oldHtmlStrs = new String[]{"&mdash;", "&ldquo;", "&rdquo;", "&lt;", "&gt;", "&middot;"};
    private static final String[] newHtmlStrs = new String[]{"\u2014\u2014", "\u201c", "\u201d", "<", ">", "\u00b7"};

    public static String bytesToString(byte[] rec) {
        ByteArrayInputStream bais = new ByteArrayInputStream(rec);
        DataInputStream dis = new DataInputStream(bais);
        String BTS = null;
        try {
            BTS = new String(rec, "UTF-8");
            bais.close();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BTS;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() <= 0;
    }

    public static boolean isNullOrWhitespace(String string) {
        return string == null || string.trim().length() <= 0;
    }

    public static Calendar createCalendar(long milliseconds) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = new Date(milliseconds);
            calendar.setTime(date);
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String byte2String(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            String s = dis.readUTF();
            dis.close();
            bais.close();
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] string2Byte(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream bos = new DataOutputStream(baos);
            bos.writeUTF(s);
            byte[] bytes = baos.toByteArray();
            bos.close();
            baos.close();
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatPrice(double price) {
        long lPrice = (long)(price * 1000.0);
        long l1 = lPrice % 100L / 10L;
        long l2 = lPrice % 1000L / 100L;
        if (l2 != 0L) {
            return String.valueOf((double)lPrice / 1000.0);
        }
        if (l1 != 0L) {
            return String.valueOf((double)lPrice / 1000.0);
        }
        return String.valueOf(lPrice / 1000L);
    }

    public static String formatPrice(Double price) {
        if (price == null) {
            return null;
        }
        return Methods.formatPrice((double)price);
    }

    public static boolean checkNickNameValid(String nickName) {
        if (nickName == null) {
            return false;
        }
        int length = nickName.length();
        int i = 0;
        while (i < length) {
            char ch = nickName.charAt(i);
            if (!(ch < '\u0000' || ch > '\u007f' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean canActive(String userName) {
        if (PhoneFunction.isPhoneNumber(userName)) {
            return true;
        }
        return userName.length() == 11 + "@nm.com".length() && PhoneFunction.isPhoneNumber(userName.substring(0, 11)) && userName.substring(12).equals("@nm.com");
    }

    public static boolean checkHasNewVersion(String curVersion, String serverVersion) {
        String serRemain;
        String curRemain;
        int serVer1;
        int curVer1;
        int serPointIndex;
        int curPointIndex;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        try {
                                            curPointIndex = curVersion.indexOf(46);
                                            if (curPointIndex != -1) break block10;
                                            return false;
                                        }
                                        catch (Exception e) {
                                            return false;
                                        }
                                    }
                                    serPointIndex = serverVersion.indexOf(46);
                                    if (serPointIndex != -1) break block11;
                                    return false;
                                }
                                curVer1 = Integer.parseInt(curVersion.substring(0, curPointIndex));
                                serVer1 = Integer.parseInt(serverVersion.substring(0, serPointIndex));
                                if (serVer1 <= curVer1) break block12;
                                return true;
                            }
                            if (serVer1 >= curVer1) break block13;
                            return false;
                        }
                        curRemain = curVersion.substring(curPointIndex + 1);
                        serRemain = serverVersion.substring(serPointIndex + 1);
                        curPointIndex = curRemain.indexOf(46);
                        if (curPointIndex != -1) break block14;
                        return false;
                    }
                    serPointIndex = serRemain.indexOf(46);
                    if (serPointIndex != -1) break block15;
                    return false;
                }
                curVer1 = Integer.parseInt(curRemain.substring(0, curPointIndex));
                serVer1 = Integer.parseInt(serRemain.substring(0, serPointIndex));
                if (serVer1 <= curVer1) break block16;
                return true;
            }
            if (serVer1 >= curVer1) break block17;
            return false;
        }
        curRemain = curRemain.substring(curPointIndex + 1);
        serRemain = serRemain.substring(serPointIndex + 1);
        curVer1 = Integer.parseInt(curRemain);
        serVer1 = Integer.parseInt(serRemain);
        return serVer1 > curVer1;
    }

    public static String replace(String str, String oldStr, String newStr) {
        int index;
        if (str == null || oldStr == null || str.length() <= oldStr.length()) {
            return str;
        }
        if (newStr == null) {
            newStr = "";
        }
        if ((index = str.indexOf(oldStr)) == -1) {
            return str;
        }
        String left = str.substring(0, index);
        String right = str.substring(index + oldStr.length(), str.length());
        return String.valueOf(left) + newStr + Methods.replace(right, oldStr, newStr);
    }

    public static String replaceHtmlStrs(String str) {
        if (str == null) {
            return null;
        }
        String result = str;
        int i = 0;
        while (i < oldHtmlStrs.length) {
            result = Methods.replace(result, oldHtmlStrs[i], newHtmlStrs[i]);
            ++i;
        }
        return result;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static Vector splitString(String string, Font font, int iconWidth, int width) {
        int length;
        if (string == null || (length = string.length()) <= 0) {
            return null;
        }
        Vector<String> strVector = new Vector<String>();
        int splitIndex = 0;
        int i = 0;
        while (i < length) {
            if (iconWidth + font.stringWidth(string.substring(0, i + 1)) > width) {
                splitIndex = Math.max(0, i);
                break;
            }
            if (i == length - 1) {
                splitIndex = length;
                break;
            }
            ++i;
        }
        if (splitIndex > 0) {
            strVector.addElement(string.substring(0, splitIndex));
        }
        if (splitIndex < length) {
            int count;
            Vector vector = Methods.splitString(string.substring(splitIndex), font, 0, width);
            if (vector != null && (count = vector.size()) > 0) {
                int i2 = 0;
                while (i2 < count) {
                    strVector.addElement((String)vector.elementAt(i2));
                    ++i2;
                }
            }
            vector = null;
        }
        return strVector;
    }

    public static Vector splitString(String string, Font font, int iconWidth, int width, String spString) {
        Vector vector1 = Methods.splitString(string, spString);
        if (vector1 == null || vector1.size() == 0) {
            return null;
        }
        Vector result = new Vector();
        int i = 0;
        while (i < vector1.size()) {
            Vector vector = Methods.splitString((String)vector1.elementAt(i), font, iconWidth, width);
            if (vector != null) {
                int j = 0;
                while (j < vector.size()) {
                    result.addElement(vector.elementAt(j));
                    ++j;
                }
            }
            vector = null;
            ++i;
        }
        vector1 = null;
        return result;
    }

    public static Vector splitString(String string, String spString) {
        if (Methods.isNullOrEmpty(string)) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        if (Methods.isNullOrEmpty(spString)) {
            result.addElement(string);
            return result;
        }
        int spIndex = string.indexOf(spString);
        if (spIndex <= -1) {
            result.addElement(string);
            return result;
        }
        if (spIndex == 0) {
            return Methods.splitString(string.substring(spString.length()), spString);
        }
        String left = string.substring(0, spIndex);
        result.addElement(left);
        String right = string.substring(spIndex + spString.length());
        Vector rightVector = Methods.splitString(right, spString);
        if (rightVector != null) {
            int i = 0;
            while (i < rightVector.size()) {
                result.addElement((String)rightVector.elementAt(i));
                ++i;
            }
        }
        rightVector = null;
        return result;
    }

    public static String getJOString(JSONObject jsonO, String key) {
        try {
            return jsonO.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Boolean getJOBoolean(JSONObject jsonO, String key) {
        try {
            return new Boolean(jsonO.getBoolean(key));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Integer getJOInt(JSONObject jsonO, String key) {
        try {
            return new Integer(jsonO.getInt(key));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Long getJOLong(JSONObject jsonO, String key) {
        try {
            return new Long(jsonO.getLong(key));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Double getJODouble(JSONObject jsonO, String key) {
        try {
            return new Double(jsonO.getDouble(key));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static JSONArray getJOArray(JSONObject jsonO, String key) {
        try {
            return jsonO.getJSONArray(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static JSONObject getJOObject(JSONObject jsonO, String key) {
        try {
            return jsonO.getJSONObject(key);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

